<?php
session_start();
require_once '../config/config.php';

header('Content-Type: application/json');

if (!isset($_SESSION['user_id']) || !isset($_POST['score'])) {
    echo json_encode(['success' => false, 'message' => 'Invalid request']);
    exit;
}

$user_id = $_SESSION['user_id'];
$username = $_SESSION['username'];
$score = intval($_POST['score']);

// Ambil 3 skor tertinggi saat ini
$query = "SELECT id, username, score 
          FROM snake_scores 
          ORDER BY score DESC 
          LIMIT 3";
$result = mysqli_query($conn, $query);
$top_scores = [];
$min_top_score = 0;
$lowest_score_id = null;

if (mysqli_num_rows($result) > 0) {
    while ($row = mysqli_fetch_assoc($result)) {
        $top_scores[] = $row;
    }
    // Jika sudah ada 3 skor, ambil yang terendah
    if (count($top_scores) == 3) {
        $min_top_score = $top_scores[2]['score'];
        $lowest_score_id = $top_scores[2]['id'];
    }
}

// Cek apakah skor baru layak masuk top 3
if (count($top_scores) < 3 || $score > $min_top_score) {
    // Jika sudah ada 3 skor, hapus yang terendah
    if (count($top_scores) == 3) {
        $delete_query = "DELETE FROM snake_scores WHERE id = ?";
        $stmt = mysqli_prepare($conn, $delete_query);
        mysqli_stmt_bind_param($stmt, "i", $lowest_score_id);
        mysqli_stmt_execute($stmt);
    }

    // Simpan skor baru
    $insert_query = "INSERT INTO snake_scores (user_id, username, score) VALUES (?, ?, ?)";
    $stmt = mysqli_prepare($conn, $insert_query);
    mysqli_stmt_bind_param($stmt, "isi", $user_id, $username, $score);
    
    if (mysqli_stmt_execute($stmt)) {
        echo json_encode([
            'success' => true,
            'message' => 'Selamat! Skor Anda masuk ke dalam Top 3!'
        ]);
    } else {
        echo json_encode([
            'success' => false,
            'message' => 'Gagal menyimpan skor'
        ]);
    }
} else {
    echo json_encode([
        'success' => true,
        'message' => 'Skor Anda belum cukup untuk masuk Top 3'
    ]);
}

// Bersihkan skor-skor lama yang tidak masuk top 3
$cleanup_query = "DELETE FROM s1 
                 FROM snake_scores s1 
                 LEFT JOIN (
                     SELECT id 
                     FROM snake_scores 
                     ORDER BY score DESC 
                     LIMIT 3
                 ) s2 ON s1.id = s2.id 
                 WHERE s2.id IS NULL";
mysqli_query($conn, $cleanup_query);