<?php
// Pastikan sudah ada koneksi database dan session dimulai
session_start();
require_once 'koneksi.php';

if(isset($_GET['id'])) {
    $id_surat = $_GET['id'];
    
    try {
        // Mulai transaksi database
        $conn->begin_transaction();

        // 1. Hapus data dari tabel detail rincian
        $query_delete_rincian = "DELETE FROM detail_rincian WHERE id_surat = ?";
        $stmt_rincian = $conn->prepare($query_delete_rincian);
        $stmt_rincian->bind_param("i", $id_surat);
        $stmt_rincian->execute();

        // 2. Hapus data dari tabel sppd_muka
        $query_delete_sppd = "DELETE FROM sppd_muka WHERE id_surat = ?";
        $stmt_sppd = $conn->prepare($query_delete_sppd);
        $stmt_sppd->bind_param("i", $id_surat);
        $stmt_sppd->execute();

        // 3. Hapus data dari tabel surat_tugas
        $query_delete_surat = "DELETE FROM surat_tugas WHERE id = ?";
        $stmt_surat = $conn->prepare($query_delete_surat);
        $stmt_surat->bind_param("i", $id_surat);
        $stmt_surat->execute();

        // Commit transaksi jika semua query berhasil
        $conn->commit();

        $_SESSION['alert'] = [
            'type' => 'success',
            'message' => 'Surat tugas dan semua data terkait berhasil dihapus!'
        ];

    } catch (Exception $e) {
        // Rollback jika terjadi kesalahan
        $conn->rollback();
        
        $_SESSION['alert'] = [
            'type' => 'danger',
            'message' => 'Terjadi kesalahan saat menghapus data: ' . $e->getMessage()
        ];
    }
} else {
    $_SESSION['alert'] = [
        'type' => 'danger',
        'message' => 'ID Surat tidak ditemukan!'
    ];
}

// Redirect kembali ke halaman sebelumnya
header('Location: lihat_surat.php');
exit;
?> 