<?php
// Debug information
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Check session status
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Include required files
require_once $_SERVER['DOCUMENT_ROOT'] . '/sppd/config/config.php';
require_once $_SERVER['DOCUMENT_ROOT'] . '/sppd/includes/sidebar.php';

// Debug session and function
echo "<!-- Debug Info:
Session ID: " . session_id() . "
User ID: " . (isset($_SESSION['user_id']) ? $_SESSION['user_id'] : 'Not set') . "
User Level: " . (isset($_SESSION['level']) ? $_SESSION['level'] : 'Not set') . "
hasMenuAccess function exists: " . (function_exists('hasMenuAccess') ? 'Yes' : 'No') . "
Base URL: " . BASE_URL . "
Document Root: " . $_SERVER['DOCUMENT_ROOT'] . "
-->";

// Pastikan user sudah login
if (!isset($_SESSION['user_id'])) {
    header("Location: " . BASE_URL . "/login.php");
    exit();
}

// Use BASE_URL from config instead of hardcoded value
$base_url = BASE_URL;

// Get current role
$current_role = isset($_SESSION['level']) ? $_SESSION['level'] : '';

// Menu access configuration from sidebar.php
$menu_access = [
    'admin' => [
        'dashboard' => true,
        'informasi' => true,
        'pegawai' => true,
        'absensi' => true,
        'pejabat' => true,
        'surat_tugas' => true,
        'rincian_biaya' => true,
        'rincian_biaya_per_pegawai' => true,
        'cetak_sppd' => true,
        'laporan_perjalanan' => true,
        'rekap_sppd'=> true,
        'upload_berkas' => true,
        'profil' => true,
        'verifikasi_user' => true,
        'backup' => true,
        'restore' => true,
        'pengaturan' => true,
        'telaah_staf' => true
    ],
    'bandahara' => [
        'dashboard' => true,
        'informasi' => true,
        'pegawai' => true,
        'absensi' => true,
        'pejabat' => true,
        'surat_tugas' => true,
        'rincian_biaya' => true,
        'rincian_biaya_per_pegawai' => true,
        'cetak_sppd' => true,
        'laporan_perjalanan' => true,
        'rekap_sppd'=> true,
        'upload_berkas' => false,
        'profil' => true,
        'verifikasi_user' => false,
        'backup' => false,
        'restore' => false,
        'pengaturan' => false,
        'telaah_staf' => true
    ],
    'pimpinan' => [
        'dashboard' => true,
        'informasi' => false,
        'pegawai' => true,
        'absensi' => true,
        'pejabat' => true,
        'surat_tugas' => true,
        'rincian_biaya' => false,
        'rincian_biaya_per_pegawai' => true,
        'cetak_sppd' => false,
        'rekap_sppd'=> true,
        'laporan_perjalanan' => true,
        'upload_berkas' => false,
        'profil' => true,
        'verifikasi_user' => false,
        'backup' => false,
        'restore' => false,
        'pengaturan' => false,
        'telaah_staf' => true
    ],
    'admin_sppd' => [
        'dashboard' => true,
        'informasi' => false,
        'pegawai' => true,
        'absensi' => true,
        'pejabat' => false,
        'surat_tugas' => true,
        'rincian_biaya' => true,
        'rincian_biaya_per_pegawai' => false,
        'cetak_sppd' => true,
        'rekap_sppd'=> true,
        'laporan_perjalanan' => true,
        'upload_berkas' => false,
        'profil' => true,
        'verifikasi_user' => false,
        'backup' => false,
        'restore' => false,
        'pengaturan' => false,
        'telaah_staf' => true
    ]
];

// Note: hasMenuAccess() function is already defined in sidebar.php
?>

<!-- Tombol Toggle Mobile Menu -->
<button class="mobile-menu-toggle d-md-none">
    <i class="bi bi-list" style="font-size: 24px;"></i>
</button>

<!-- Mobile Menu -->
<div class="mobile-menu">
    <div class="mobile-menu-header">
        <h5>Menu</h5>
        <button class="mobile-menu-close">
            <i class="bi bi-x"></i>
        </button>
    </div>
    <div class="mobile-menu-body">
        <!-- Dashboard -->
        <a href="<?= $base_url ?>/dashboard.php" class="mobile-menu-item">
            <i class="bi bi-speedometer2"></i>
            Dashboard
        </a>

        <?php if (hasMenuAccess('informasi')): ?>
        <a href="<?= $base_url ?>/informasi/index.php" class="mobile-menu-item">
            <i class="bi bi-megaphone-fill"></i>
            Informasi
        </a>
        <?php endif; ?>

        <?php if (hasMenuAccess('pegawai')): ?>
        <a href="<?= $base_url ?>/pegawai/pegawai.php" class="mobile-menu-item">
            <i class="bi bi-people-fill"></i>
            Pegawai
        </a>
        <?php endif; ?>

        <?php if (hasMenuAccess('absensi')): ?>
        <a href="<?= $base_url ?>/absensi/index.php" class="mobile-menu-item">
            <i class="bi bi-calendar-check-fill"></i>
            QR Code Daftar Hadir
        </a>
        <?php endif; ?>

        <?php if (hasMenuAccess('pejabat')): ?>
        <a href="<?= $base_url ?>/pejabat/index.php" class="mobile-menu-item">
            <i class="bi bi-person-badge-fill"></i>
            Pejabat
        </a>
        <?php endif; ?>

        <!-- Perjalanan Dinas Section -->
        <div class="menu-label">PERJALANAN DINAS</div>

        <?php if (hasMenuAccess('telaah_staf')): ?>
        <a href="<?= $base_url ?>/telaah_staf/index.php" class="mobile-menu-item">
            <i class="bi bi-file-text-fill"></i>
            Telaah Staf
        </a>
        <?php endif; ?>

        <?php if (hasMenuAccess('surat_tugas')): ?>
        <a href="<?= $base_url ?>/surat_tugas/surat_tugas.php" class="mobile-menu-item">
            <i class="bi bi-file-earmark-text-fill"></i>
            Surat Tugas
        </a>
        <?php endif; ?>

        <?php if (hasMenuAccess('rincian_biaya')): ?>
        <a href="<?= $base_url ?>/rincian_biaya/index.php" class="mobile-menu-item">
            <i class="bi bi-cash-stack"></i>
            Rincian Biaya
        </a>
        <?php endif; ?>

        <?php if (hasMenuAccess('rincian_biaya_per_pegawai')): ?>
        <a href="<?= $base_url ?>/rincian_biaya_per_pegawai.php" class="mobile-menu-item">
            <i class="bi bi-person-lines-fill"></i>
            Rincian Biaya Per Pegawai
        </a>
        <?php endif; ?>

        <?php if (hasMenuAccess('cetak_sppd')): ?>
        <a href="<?= $base_url ?>/sppd_muka/sppd_muka.php" class="mobile-menu-item">
            <i class="bi bi-printer-fill"></i>
            Cetak SPPD
        </a>
        <?php endif; ?>

        <?php if (hasMenuAccess('rekap_sppd')): ?>
        <a href="<?= $base_url ?>/rekap_sppd/index.php" class="mobile-menu-item">
            <i class="bi bi-file-text-fill"></i>
            Rekap SPPD
        </a>
        <?php endif; ?>

        <?php if (hasMenuAccess('upload_berkas')): ?>
        <a href="<?= $base_url ?>/upload.php" class="mobile-menu-item">
            <i class="bi bi-upload"></i>
            Upload Berkas
        </a>
        <?php endif; ?>

        <!-- Laporan Section -->
        <div class="menu-label">LAPORAN</div>

        <?php if (hasMenuAccess('laporan_perjalanan')): ?>
        <a href="<?= $base_url ?>/laporan/laporan.php" class="mobile-menu-item">
            <i class="bi bi-journal-text"></i>
            Laporan Perjalanan Dinas
        </a>
        <?php endif; ?>

        <!-- Pengaturan Section -->
        <div class="menu-label">PENGATURAN</div>

        <?php if ($current_role === 'admin'): ?>
        <a href="<?= $base_url ?>/admin/verifikasi_user.php" class="mobile-menu-item">
            <i class="bi bi-person-check-fill"></i>
            Verifikasi User
        </a>

        <a href="<?= $base_url ?>/backup.php" class="mobile-menu-item">
            <i class="bi bi-download"></i>
            Backup Database
        </a>

        <a href="<?= $base_url ?>/admin/restore.php" class="mobile-menu-item">
            <i class="bi bi-upload"></i>
            Restore Database
        </a>

        <a href="<?= $base_url ?>/admin/pengaturan.php" class="mobile-menu-item">
            <i class="bi bi-gear-fill"></i>
            Pengaturan Sistem
        </a>
        <?php endif; ?>

        <a href="<?= $base_url ?>/profile.php" class="mobile-menu-item">
            <i class="bi bi-person-circle"></i>
            Profil
        </a>

        <a href="<?= $base_url ?>/logout.php" class="mobile-menu-item text-danger">
            <i class="bi bi-box-arrow-right"></i>
            Logout
        </a>
    </div>
</div>

<!-- Mobile Overlay -->
<div class="mobile-overlay"></div> 