document.addEventListener('DOMContentLoaded', function() {
    const mobileMenuToggle = document.querySelector('.mobile-menu-toggle');
    const mobileMenu = document.querySelector('.mobile-menu');
    const mobileOverlay = document.querySelector('.mobile-overlay');
    const mobileMenuClose = document.querySelector('.mobile-menu-close');
    const submenuToggles = document.querySelectorAll('.mobile-menu-toggle-sub');

    // Fungsi untuk membuka menu mobile
    function openMobileMenu() {
        mobileMenu.classList.add('show');
        mobileOverlay.classList.add('show');
        document.body.style.overflow = 'hidden';
    }

    // Fungsi untuk menutup menu mobile
    function closeMobileMenu() {
        mobileMenu.classList.remove('show');
        mobileOverlay.classList.remove('show');
        document.body.style.overflow = '';
    }

    // Toggle menu saat tombol di klik
    mobileMenuToggle.addEventListener('click', openMobileMenu);

    // Tutup menu saat tombol close di klik
    mobileMenuClose.addEventListener('click', closeMobileMenu);

    // Tutup menu saat overlay di klik
    mobileOverlay.addEventListener('click', closeMobileMenu);

    // Toggle submenu
    submenuToggles.forEach(toggle => {
        toggle.addEventListener('click', function(e) {
            e.preventDefault();
            const submenu = this.nextElementSibling;
            const icon = this.querySelector('.bi-chevron-down');
            
            // Tutup submenu lain
            submenuToggles.forEach(otherToggle => {
                if (otherToggle !== this) {
                    const otherSubmenu = otherToggle.nextElementSibling;
                    const otherIcon = otherToggle.querySelector('.bi-chevron-down');
                    otherSubmenu.classList.remove('show');
                    otherIcon.style.transform = '';
                }
            });
            
            submenu.classList.toggle('show');
            icon.style.transform = submenu.classList.contains('show') ? 'rotate(180deg)' : '';
        });
    });

    // Tutup menu saat link menu di klik (kecuali untuk submenu toggle)
    const menuLinks = document.querySelectorAll('.mobile-menu-item:not(.mobile-menu-toggle-sub)');
    menuLinks.forEach(link => {
        link.addEventListener('click', function() {
            if (!this.classList.contains('mobile-menu-toggle-sub')) {
                closeMobileMenu();
            }
        });
    });

    // Handle swipe to close
    let touchStartX = 0;
    
    mobileMenu.addEventListener('touchstart', function(e) {
        touchStartX = e.touches[0].clientX;
    });

    mobileMenu.addEventListener('touchmove', function(e) {
        if (!touchStartX) return;

        const touchX = e.touches[0].clientX;
        const diff = touchStartX - touchX;

        if (diff > 50) {
            closeMobileMenu();
            touchStartX = null;
        }
    });

    mobileMenu.addEventListener('touchend', function() {
        touchStartX = null;
    });

    // Set active menu berdasarkan halaman saat ini
    const currentPage = window.location.pathname.split('/').pop() || 'dashboard.php';
    const activeMenuItem = document.querySelector(`.mobile-menu-item[href="${currentPage}"]`);
    
    if (activeMenuItem) {
        activeMenuItem.classList.add('active');
        
        // Jika item aktif ada dalam submenu, buka submenu tersebut
        const parentSubmenu = activeMenuItem.closest('.mobile-submenu');
        if (parentSubmenu) {
            parentSubmenu.classList.add('show');
            const parentToggle = parentSubmenu.previousElementSibling;
            const icon = parentToggle.querySelector('.bi-chevron-down');
            icon.style.transform = 'rotate(180deg)';
        }
    }
}); 