<?php
require_once $_SERVER['DOCUMENT_ROOT'] . '/sppd/config/config.php';
?>

<nav class="top-navbar">
    <div class="nav-items">
        <a href="<?= $base_url ?>/dashboard.php" class="nav-item" title="Home">
            <i class="bi bi-house-fill"></i>
        </a>
        <a href="#" class="nav-item" title="Link">
            <i class="bi bi-link-45deg"></i>
            <span class="badge">11</span>
        </a>
        <a href="#" class="nav-item" title="Menu">
            <i class="bi bi-list"></i>
            <span class="badge">13</span>
        </a>
    </div>
    <div class="nav-items right">
        <div class="nav-item" title="Next">
            <i class="bi bi-arrow-right-circle-fill"></i>
            <span class="badge">11</span>
        </div>
        <div class="nav-item" title="Test">
            <i class="bi bi-check-circle-fill"></i>
            <span class="badge">31</span>
        </div>
        <div class="nav-search">
            <input type="text" placeholder="Search" class="search-input">
            <button class="search-button">Search</button>
        </div>
    </div>
</nav>

<style>
:root {
    --navbar-height: 40px;
}

.top-navbar {
    position: fixed;
    top: 0;
    left: var(--sidebar-width);
    right: 0;
    height: var(--navbar-height);
    background: #2d2d2d;
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 0 15px;
    z-index: 1000;
    border-bottom: 1px solid rgba(255,255,255,0.1);
}

.nav-items {
    display: flex;
    align-items: center;
    gap: 5px;
}

.nav-items.right {
    margin-left: auto;
}

.nav-item {
    position: relative;
    width: 32px;
    height: 32px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: #fff;
    font-size: 1rem;
    border-radius: 4px;
    cursor: pointer;
    text-decoration: none;
    transition: background-color 0.2s;
}

.nav-item:hover {
    background: rgba(255, 255, 255, 0.1);
    color: #fff;
}

.badge {
    position: absolute;
    top: -2px;
    right: -2px;
    background: #dc3545;
    color: white;
    font-size: 0.65rem;
    padding: 1px 4px;
    border-radius: 10px;
    min-width: 14px;
    height: 14px;
    display: flex;
    align-items: center;
    justify-content: center;
}

.nav-search {
    display: flex;
    align-items: center;
    margin-left: 10px;
}

.search-input {
    padding: 4px 8px;
    border: none;
    border-radius: 4px 0 0 4px;
    background: #3d3d3d;
    color: #fff;
    width: 180px;
    height: 28px;
    font-size: 0.875rem;
}

.search-button {
    padding: 4px 12px;
    border: none;
    border-radius: 0 4px 4px 0;
    background: #45a049;
    color: white;
    cursor: pointer;
    transition: background-color 0.2s;
    height: 28px;
    font-size: 0.875rem;
    line-height: 1;
}

.search-button:hover {
    background: #3d8b40;
}

/* Adjust main content to accommodate navbar */
.content-wrapper {
    margin-top: var(--navbar-height);
    margin-left: var(--sidebar-width);
}

/* Responsive adjustments */
@media (max-width: 768px) {
    .top-navbar {
        left: 0;
    }
    
    .search-input {
        width: 120px;
    }
}
</style>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Add dropdown functionality if needed
    const dropdowns = document.querySelectorAll('.dropdown');
    dropdowns.forEach(dropdown => {
        dropdown.addEventListener('click', function() {
            // Add your dropdown logic here
        });
    });
});
</script> 