<?php
require_once $_SERVER['DOCUMENT_ROOT'] . '/sppd/config/config.php';

// Deteksi current page untuk active state
$current_page = basename($_SERVER['PHP_SELF']);
$current_dir = basename(dirname($_SERVER['PHP_SELF']));

// Base URL untuk asset
$base_url = '/sppd';

// Pastikan session sudah dimulai
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Definisi akses menu berdasarkan role
$menu_access = [
    'admin' => [
        'dashboard' => true,
        'informasi' => true,
        'pegawai' => true,
        'absensi' => true,
        'pejabat' => true,
        'surat_tugas' => true,
        'rincian_biaya' => true,
        'rincian_biaya_per_pegawai' => true,
        'cetak_sppd' => true,
        'laporan_perjalanan' => true,
        'rekap_sppd'=> true,
        'upload_berkas' => true,
        'profil' => true,
        'verifikasi_user' => true,
        'backup' => true,
        'restore' => true,
        'pengaturan' => true,
        'telaah_staf' => true
    ],
    'bandahara' => [
        'dashboard' => true,
        'informasi' => true,
        'pegawai' => true,
        'absensi' => true,
        'pejabat' => true,
        'surat_tugas' => true,
        'rincian_biaya' => true,
        'rincian_biaya_per_pegawai' => true,
        'cetak_sppd' => true,
        'laporan_perjalanan' => true,
        'rekap_sppd'=> true,
        'upload_berkas' => false,
        'profil' => true,
        'verifikasi_user' => false,
        'backup' => false,
        'restore' => false,
        'pengaturan' => false,
        'telaah_staf' => true
    ],
    'pimpinan' => [
        'dashboard' => true,
        'informasi' => false,
        'pegawai' => true,
        'absensi' => true,
        'pejabat' => true,
        'surat_tugas' => true,
        'rincian_biaya' => false,
        'rincian_biaya_per_pegawai' => true,
        'cetak_sppd' => false,
        'rekap_sppd'=> true,
        'laporan_perjalanan' => true,
        'upload_berkas' => false,
        'profil' => true,
        'verifikasi_user' => false,
        'backup' => false,
        'restore' => false,
        'pengaturan' => false,
        'telaah_staf' => true
    ],
    'admin_sppd' => [
        'dashboard' => true,
        'informasi' => false,
        'pegawai' => true,
        'absensi' => true,
        'pejabat' => false,
        'surat_tugas' => true,
        'rincian_biaya' => true,
        'rincian_biaya_per_pegawai' => true,
        'cetak_sppd' => true,
        'rekap_sppd'=> true,
        'laporan_perjalanan' => true,
        'upload_berkas' => false,
        'profil' => true,
        'verifikasi_user' => false,
        'backup' => false,
        'restore' => false,
        'pengaturan' => false,
        'telaah_staf' => true
    ]
];

// Pastikan role valid
$current_role = isset($_SESSION['level']) ? $_SESSION['level'] : '';
if (!array_key_exists($current_role, $menu_access)) {
    $current_role = ''; // Set default jika role tidak valid
}

// Function untuk mengecek akses menu
function hasMenuAccess($menu) {
    global $menu_access, $current_role;
    // Admin selalu memiliki akses ke semua menu
    if ($current_role === 'admin') {
        return true;
    }
    return isset($menu_access[$current_role][$menu]) && $menu_access[$current_role][$menu] === true;
}
?>

<!-- Sidebar -->
<div class="sidebar-wrapper" id="sidebarWrapper">
    <div class="sidebar" id="sidebar">
        <!-- Toggle Button -->
        <?php 
        $allowed_pages = ['surat_tugas.php', 'pegawai.php', 'index.php', 'detail.php', 'scan.php','konfirmasi_cetak.php',
    'lihat_surat.php', 'edit.php','rincian_biaya_per_pegawai.php'];
        if (in_array($current_page, $allowed_pages)): 
        ?>
        <button id="sidebarToggle" class="sidebar-toggle">
            <i class="bi bi-chevron-left"></i>
        </button>
        <?php endif; ?>

        <!-- Logo & Toggle -->
        <div class="sidebar-header">
            <div class="d-flex align-items-center">
                <img src="<?= BASE_URL ?>/assets/img/logo.png" alt="SPPD Logo" class="sidebar-logo">
                <div class="logo-text">
                    <div class="logo-title">SPPD System</div>
                    <div class="logo-subtitle">SPPD instan, administrasi siap jalan! <br> status apk | ujicoba</div>
                </div>
            </div>
        </div>

        <!-- User Profile -->
        <div class="sidebar-user">
            <div class="profile-section">
                <?php
                // Ambil foto profil dari database
                $user_id = $_SESSION['user_id'];
                $query_user = "SELECT foto FROM users WHERE id = ?";
                $stmt = mysqli_prepare($conn, $query_user);
                mysqli_stmt_bind_param($stmt, "i", $user_id);
                mysqli_stmt_execute($stmt);
                $result_user = mysqli_stmt_get_result($stmt);
                $user_data = mysqli_fetch_assoc($result_user);
                
                // Set foto default jika tidak ada
                $foto = 'default.png';
                if ($user_data && !empty($user_data['foto'])) {
                    $foto = $user_data['foto'];
                }
                
                // Cek apakah file foto ada
                $foto_path = BASE_URL . '/assets/img/users/' . $foto;
                $server_path = $_SERVER['DOCUMENT_ROOT'] . '/sppd/assets/img/users/' . $foto;
                
                if (!file_exists($server_path)) {
                    $foto_path = BASE_URL . '/assets/img/users/default.png';
                }
                ?>
                
                <div class="d-flex align-items-center">
                    <img src="<?= $foto_path ?>" alt="Profile" class="profile-img rounded-circle">
                    <div class="profile-info ms-3">
                        <h6 class="mb-1 text-white"><?= htmlspecialchars($_SESSION['nama_lengkap'] ?? 'User') ?></h6>
                        <small class="text-white-50"><?= htmlspecialchars($_SESSION['level'] ?? 'Guest') ?></small>
                    </div>
                </div>
            </div>
        </div>

        <!-- Navigation -->
        <nav class="sidebar-nav">
            <div class="menu-label">MAIN MENU</div>
            
            <a href="<?= BASE_URL ?>/dashboard.php" class="nav-link <?= isActive('dashboard.php') ?>">
                <i class="bi bi-speedometer2"></i>
                <span>Dashboard</span>
            </a>

            <?php if (hasMenuAccess('informasi')): ?>
            <a href="<?= BASE_URL ?>/informasi/index.php" class="nav-link <?= isActive('informasi') ?>">
                <i class="bi bi-megaphone-fill"></i>
                <span>Informasi</span>
            </a>
            <?php endif; ?>

            <?php if (hasMenuAccess('pegawai')): ?>
            <a href="<?= BASE_URL ?>/pegawai/pegawai.php" class="nav-link <?= isActive('pegawai') ?>">
                <i class="bi bi-people-fill"></i>
                <span>Pegawai</span>
            </a>
            <?php endif; ?>

            <?php if (hasMenuAccess('absensi')): ?>
            <a href="<?= BASE_URL ?>/absensi/index.php" class="nav-link <?= isActive('absensi') ?>">
                <i class="bi bi-calendar-check-fill"></i>
                <span>QR Code Daftar Hadir</span>
            </a>
            <?php endif; ?>

            <?php if (hasMenuAccess('pejabat')): ?>
            <a href="<?= BASE_URL ?>/pejabat/index.php" class="nav-link <?= isActive('pejabat') ?>">
                <i class="bi bi-person-badge-fill"></i>
                <span>Pejabat</span>
            </a>
            <?php endif; ?>

            <div class="menu-label">PERJALANAN DINAS</div>
            <?php if (hasMenuAccess('telaah_staf')): ?>
            <a href="<?= BASE_URL ?>/telaah_staf/index.php" class="nav-link <?= isActive('telaah_staf') ?>">
                <i class="bi bi-file-text-fill"></i>
                <span>Telaah Staf</span>
            </a>
            <?php endif; ?>
            <?php if (hasMenuAccess('surat_tugas')): ?>
            <a href="<?= BASE_URL ?>/surat_tugas/surat_tugas.php" class="nav-link <?= isActive('surat_tugas') ?>">
                <i class="bi bi-file-earmark-text-fill"></i>
                <span>Surat Tugas</span>
            </a>
            <?php endif; ?>

            <?php if (hasMenuAccess('rincian_biaya')): ?>
            <a href="<?= BASE_URL ?>/rincian_biaya/index.php" class="nav-link <?= isActive('rincian_biaya') ?>">
                <i class="bi bi-cash-stack"></i>
                <span>Rincian Biaya</span>
            </a>
            <?php endif; ?>

            <?php if (hasMenuAccess('rincian_biaya_per_pegawai')): ?>
            <a href="<?= BASE_URL ?>/rincian_biaya/rincian_biaya_per_pegawai.php" class="nav-link <?= isActive('rincian_biaya_per_pegawai.php') ?>">
                <i class="bi bi-person-lines-fill"></i>
                <span>Rincian Biaya Per Pegawai</span>
            </a>
            <?php endif; ?>

            <?php if (hasMenuAccess('cetak_sppd')): ?>
            <a href="<?= BASE_URL ?>/sppd_muka/sppd_muka.php" class="nav-link <?= isActive('sppd_muka') ?>">
                <i class="bi bi-printer-fill"></i>
                <span>Cetak SPPD</span>
            </a>
            <?php endif; ?>

            <?php if (hasMenuAccess('rekap_sppd')): ?>
            <a href="<?= BASE_URL ?>/rekap_sppd/index.php" class="nav-link <?= isActive('rekap_sppd') ?>">
                <i class="bi bi-file-text-fill"></i>
                <span>Rekap SPPD</span>
            </a>
            <?php endif; ?>

            <?php if (hasMenuAccess('upload_berkas')): ?>
            <a href="<?= BASE_URL ?>/upload.php" class="nav-link <?= isActive('upload.php') ?>">
                <i class="bi bi-upload"></i>
                <span>Upload Berkas</span>
            </a>
            <?php endif; ?>

            <div class="menu-label">LAPORAN</div>
            
            <?php if (hasMenuAccess('laporan_perjalanan')): ?>
            <a href="<?= BASE_URL ?>/laporan/laporan.php" class="nav-link <?= isActive('laporan') ?>">
                <i class="bi bi-journal-text"></i>
                <span>Laporan Perjalanan Dinas</span>
            </a>
            <?php endif; ?>

           

            <!-- Settings & Logout -->
            <div class="menu-label">PENGATURAN</div>
            
            <?php if ($current_role === 'admin'): ?>
            <a href="<?= BASE_URL ?>/admin/verifikasi_user.php" class="nav-link <?= isActive('verifikasi_user.php') ?>">
                <i class="bi bi-person-check-fill"></i>
                <span>Verifikasi User</span>
            </a>

            <a href="<?= BASE_URL ?>/backup.php" class="nav-link <?= isActive('backup.php') ?>">
                <i class="bi bi-download"></i>
                <span>Backup Database</span>
            </a>

            <a href="<?= BASE_URL ?>/admin/restore.php" class="nav-link <?= isActive('restore.php') ?>">
                <i class="bi bi-upload"></i>
                <span>Restore Database</span>
            </a>

            <a href="<?= BASE_URL ?>/admin/pengaturan.php" class="nav-link <?= isActive('pengaturan.php') ?>">
                <i class="bi bi-gear-fill"></i>
                <span>Pengaturan Sistem</span>
            </a>
            <?php endif; ?>

            <a href="<?= BASE_URL ?>/profile.php" class="nav-link <?= isActive('profile.php') ?>">
                <i class="bi bi-person-circle"></i>
                <span>Profil</span>
            </a>

            <a href="<?= BASE_URL ?>/logout.php" class="nav-link text-danger">
                <i class="bi bi-box-arrow-right"></i>
                <span>Logout</span>
            </a>
        </nav>

        <!-- Footer -->
        <div class="sidebar-footer">
            <div class="footer-content">
                <div class="footer-text">
                    <div class="single-line">Copyright &copy; <a href="<?= BASE_URL ?>/clark-master/index.html" class="footer-link">Yhyirfd_ 2025</a></div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
:root {
    --header-height: 80px;
    --profile-height: 65px;
    --sidebar-width: 280px;
    --font-logo-title: 1.1rem;
    --font-logo-subtitle: 0.75rem;
    --font-profile-name: 0.85rem;
    --font-profile-role: 0.75rem;
    --font-menu-label: 0.75rem;
    --font-nav-link: 0.9rem;
    --font-nav-icon: 1.1rem;
    --transition-speed: 0.3s;
    --bg-primary: #f8f9fa;
    --bg-secondary: #ffffff;
    --text-primary: #212529;
    --text-secondary: #6c757d;
    --border-color: #dee2e6;
    --footer-height: 60px; /* Define footer height */
}

/* Sidebar Wrapper */
.sidebar-wrapper {
    width: var(--sidebar-width);
    min-width: var(--sidebar-width);
    max-width: var(--sidebar-width);
    position: fixed;
    top: 0;
    left: 0;
    height: 100vh;
    z-index: 1000;
}

/* Sidebar */
.sidebar {
    width: var(--sidebar-width);
    height: 100vh;
    background: linear-gradient(135deg, var(--secondary-color) 0%, var(--primary-color) 100%);
    color: #fff;
    transition: var(--transition);
    overflow: hidden;
    box-shadow: var(--shadow);
    display: flex;
    flex-direction: column;
}

/* Main Content */
.main-content {
    margin-left: var(--sidebar-width);
    width: calc(100% - var(--sidebar-width));
    min-height: 100vh;
    padding: 20px;
}

/* Content Wrapper */
.content-wrapper {
    margin-left: var(--sidebar-width);
    width: calc(100% - var(--sidebar-width));
}

/* Responsive */
@media (max-width: 768px) {
    .sidebar-wrapper {
        transform: translateX(-100%);
    }
    
    .sidebar-wrapper.show {
        transform: translateX(0);
    }
    
    .main-content {
        margin-left: 0;
        width: 100%;
    }
}

/* Root Variables */
:root {
    --header-height: 70px;
    --profile-height: 60px; /* Ensure correct profile height */
    --sidebar-width: 280px;
    --sidebar-mini-width: 70px;
    --primary-color: #224abe ;
    --secondary-color: #2C3E50;
    --text-light: rgba(255,255,255,0.8);
    --text-muted: rgba(255,255,255,0.6);
    --hover-bg: rgba(255,255,255,0.1);
    --transition: all 0.3s ease;
    --shadow: 4px 0 10px rgba(0,0,0,0.1);
    --footer-height: 60px; /* Define footer height */
}

/* Base Styles */
.sidebar {
    width: var(--sidebar-width);
    height: 100%;
    background: linear-gradient(135deg, var(--secondary-color) 0%, var(--primary-color) 100%);
    color: #fff;
    transition: var(--transition);
    overflow: hidden;
    box-shadow: var(--shadow);
}

/* Header Section - Fixed */
.sidebar-header {
    top: 0;
    left: 0;
    width: 100%;
    height: var(--header-height);
    background: linear-gradient(135deg,rgb(21, 35, 80) 0%, #224abe 100%);
    z-index: 1000;
    padding: 0.5rem;
    border-bottom: 1px solid rgba(255, 255, 255, 0.1);
    display: flex;
    align-items: center;
    flex-shrink: 0;
}

.sidebar-logo {
    width: 49px;
    height: 50px;
    min-width: 49px;
    min-height: 50px;
    object-fit: contain;
}

.logo-text {
    overflow: hidden;
}

.logo-title {
    font-size: var(--font-logo-title) !important;
    line-height: 1.2 !important;
    font-weight: 600 !important;
}

.logo-subtitle {
    font-size: var(--font-logo-subtitle) !important;
    line-height: 1.2 !important;
}

/* User Profile Section - Fixed */
.sidebar-user {
    top: var(--header-height);
    left: 0;
    width: 100%;
    height: var(--profile-height);
    background: linear-gradient(135deg,rgb(21, 35, 80) 0%, #224abe 100%);
    z-index: 999;
    padding: 0;
    border-bottom: 1px solid rgba(255, 255, 255, 0.1);
    flex-shrink: 0;
}

.profile-section {
    height: 100%;
    padding: 8px;
    background: rgba(255,255,255,0.05);
    border-radius: 8px;
    display: flex;
    align-items: center;
    overflow: hidden;
}

.profile-img {
    width: 32px;
    height: 32px;
    min-width: 32px;
    border-radius: 50%;
    object-fit: cover;
}

.profile-info {
    margin-left: 0.75rem;
    overflow: hidden;
}

.profile-info h6 {
    font-size: var(--font-profile-name) !important;
    line-height: 1.2 !important;
    font-weight: 600 !important;
}

.profile-info small {
    font-size: var(--font-profile-role) !important;
    line-height: 1.2 !important;
}

/* Navigation Container - Scrollable (Adjust for flex layout) */
.sidebar-nav {
    margin-top: 0; /* Remove margin-top */
    padding: 0;
    height: auto; /* Allow flex to determine height */
    overflow-y: auto; /* Make this section scrollable */
    overflow-x: hidden;
    padding-bottom: 3px; /* Adjusted padding at the bottom */
    flex-grow: 1; /* Allow this section to grow and take available space */
}

/* Scrollbar Styling for Navigation */
.sidebar-nav::-webkit-scrollbar {
    width: 6px;
}

.sidebar-nav::-webkit-scrollbar-track {
    background: rgba(255, 255, 255, 0.1);
}

.sidebar-nav::-webkit-scrollbar-thumb {
    background: rgba(255, 255, 255, 0.2);
    border-radius: 3px;
}

.sidebar-nav::-webkit-scrollbar-thumb:hover {
    background: rgba(255, 255, 255, 0.3);
}

/* Collapsed State Adjustments */
.sidebar-wrapper.collapsed .sidebar-header {
    width: var(--sidebar-mini-width);
}

.sidebar-wrapper.collapsed .sidebar-user {
    width: var(--sidebar-mini-width);
}

.sidebar-wrapper.collapsed .sidebar {
    width: var(--sidebar-mini-width);
}

.sidebar-wrapper.collapsed .sidebar-nav {
    width: var(--sidebar-mini-width);
    padding: 1rem 0.25rem;
}

/* Menu Label Enhancement */
.menu-label {
    font-size: var(--font-menu-label);
    font-weight: 600;
    text-transform: uppercase;
    letter-spacing: 1px;
    color: var(--text-muted);
    margin: 0.3rem 0 0.3rem;
    padding: 0 0.5rem;
    position: relative;
    display: flex;
    align-items: center;
    white-space: nowrap;
}

.menu-label::after {
    content: '';
    flex: 1;
    height: 1px;
    background: var(--border-color);
    margin-left: 0.5rem;
}

/* Navigation Links */
.nav-link {
    padding: 0.35rem 1rem;
    margin: 0.1rem 0;
    white-space: nowrap;
    display: flex;
    align-items: center;
    color: var(--text-light);
    text-decoration: none;
    border-radius: 8px;
    transition: var(--transition);
}

.nav-link {
    font-size: var(--font-nav-link) !important;
    line-height: 1.2 !important;
    display: flex;
    align-items: center;
    padding: 0.5rem 1rem;
    color: var(--text-light);
    text-decoration: none;
    border-radius: 8px;
    margin: 0.1rem 0;
    transition: var(--transition);
    position: relative;
    animation: slideIn 0.3s ease;
}

.nav-link:hover {
    background: var(--hover-bg);
    color: #fff;
    transform: translateX(5px);
}

.nav-link.active {
    background: rgba(255, 255, 255, 0.1);
    color: #fff;
    font-weight: 600;
    border-left: 4px solid #fff;
    animation: activeIndicator 0.3s ease forwards;
}

.nav-link.active::before {
    content: '';
    position: absolute;
    left: 0;
    top: 0;
    height: 100%;
    width: 4px;
    background: #fff;
    border-radius: 0 4px 4px 0;
}

.nav-link.active i {
    color: #fff;
}

.nav-link i {
    font-size: var(--font-nav-icon) !important;
    margin-right: 1rem;
    width: 20px;
    text-align: center;
}

/* Scrollbar Styling */
.sidebar::-webkit-scrollbar {
    width: 5px;
}

.sidebar::-webkit-scrollbar-track {
    background: var(--hover-bg);
}

.sidebar::-webkit-scrollbar-thumb {
    background: var(--border-color);
    border-radius: 5px;
}

/* Collapsed State */
.sidebar-collapsed .sidebar-wrapper {
    width: var(--sidebar-mini-width);
}

.sidebar-collapsed .sidebar {
    width: var(--sidebar-mini-width);
}

.sidebar-collapsed .main-content {
    margin-left: var(--sidebar-mini-width);
    width: calc(100% - var(--sidebar-mini-width));
}

.sidebar-collapsed .logo-text,
.sidebar-collapsed .profile-info,
.sidebar-collapsed .menu-label,
.sidebar-collapsed .nav-link span {
    display: none;
}

.sidebar-collapsed .nav-link {
    justify-content: center;
    padding: 0.8rem;
}

.sidebar-collapsed .nav-link i {
    margin: 0;
    font-size: 1.2rem;
}

.sidebar-collapsed .sidebar-toggle i {
    transform: rotate(180deg);
}

/* Tooltip for Collapsed State */
.sidebar-tooltip {
    position: fixed;
    background: rgba(0,0,0,0.9);
    color: #fff;
    padding: 0.5rem 1rem;
    border-radius: 4px;
    font-size: 0.875rem;
    z-index: 1060;
    pointer-events: none;
    white-space: nowrap;
    box-shadow: 0 2px 8px rgba(0,0,0,0.2);
    backdrop-filter: blur(4px);
}

.sidebar-tooltip::before {
    content: '';
    position: absolute;
    left: -6px;
    top: 50%;
    transform: translateY(-50%);
    border-style: solid;
    border-width: 6px 6px 6px 0;
    border-color: transparent rgba(0,0,0,0.9) transparent transparent;
}

/* Animation */
@keyframes slideIn {
    from {
        transform: translateX(-20px);
        opacity: 0;
    }
    to {
        transform: translateX(0);
        opacity: 1;
    }
}

.sidebar {
    animation: none;
}

/* Responsive Adjustments */
@media (max-width: 768px) {
    .main-content {
        margin-left: 0;
        width: 100%;
    }
    
    .sidebar-wrapper {
        left: calc(-1 * var(--sidebar-width));
    }
    
    .sidebar-collapsed .sidebar-wrapper {
        left: 0;
    }
}

/* Main Content Adjustment */
body {
    padding-left: var(--sidebar-width);
    transition: var(--transition);
    background: var(--bg-primary);
    color: var(--text-primary);
}

body.sidebar-collapsed {
    padding-left: var(--sidebar-mini-width);
}

/* Current Page Title Styling */
.current-page-title {
    padding: 1rem 1.5rem;
    font-size: 1.25rem;
    font-weight: 600;
    color: #fff;
    background: rgba(0,0,0,0.1);
    border-bottom: 1px solid var(--border-color);
    display: flex;
    align-items: center;
    gap: 0.5rem;
}

/* Modified Navigation Link Styling */
.nav-link {
    display: flex;
    align-items: center;
    padding: 0.8rem 1rem;
    color: var(--text-light);
    text-decoration: none;
    border-radius: 8px;
    margin: 0.2rem 0;
    transition: var(--transition);
    position: relative;
}

.nav-link:hover {
    background: var(--hover-bg);
    color: #fff;
    transform: translateX(5px);
}

.nav-link.active {
    background: rgba(255, 255, 255, 0.1);
    color: #fff;
    font-weight: 600;
    border-left: 4px solid #fff;
}

.nav-link.active::before {
    content: '';
    position: absolute;
    left: 0;
    top: 0;
    height: 100%;
    width: 4px;
    background: #fff;
    border-radius: 0 4px 4px 0;
}

.nav-link.active i {
    color: #fff;
}

/* Menu Label Enhancement */
.menu-label {
    font-size: var(--font-menu-label) !important;
    font-weight: 600;
    text-transform: uppercase;
    letter-spacing: 1px;
    color: var(--text-muted);
    margin: 0.3rem 0 0.3rem;
    padding: 0 0.5rem;
    position: relative;
    display: flex;
    align-items: center;
}

.menu-label::after {
    content: '';
    flex: 1;
    height: 1px;
    background: var(--border-color);
    margin-left: 0.5rem;
}

/* Hover Effect Enhancement */
.nav-link:hover i {
    transform: scale(1.1);
    transition: transform 0.2s ease;
}

/* Active Menu Indicator */
.nav-link.active::after {
    content: '';
    position: absolute;
    right: 1rem;
    top: 50%;
    transform: translateY(-50%);
    width: 6px;
    height: 6px;
    background: #fff;
    border-radius: 50%;
    opacity: 0.8;
}

/* Collapsed State Modifications */
.sidebar-collapsed .current-page-title {
    padding: 1rem;
    justify-content: center;
    font-size: 0;
}

.sidebar-collapsed .current-page-title::before {
    content: '•';
    font-size: 1.5rem;
    color: #fff;
}

.sidebar-collapsed .nav-link.active::before {
    width: 3px;
}

/* Animation for Active State */
@keyframes activeIndicator {
    from { 
        opacity: 0; 
        transform: translateX(-10px); 
    }
    to { 
        opacity: 1; 
        transform: translateX(0); 
    }
}

/* Hover Tooltip Enhancement */
.sidebar-tooltip {
    position: fixed;
    background: rgba(0,0,0,0.9);
    color: #fff;
    padding: 0.5rem 1rem;
    border-radius: 4px;
    font-size: 0.875rem;
    z-index: 1060;
    pointer-events: none;
    white-space: nowrap;
    box-shadow: 0 2px 8px rgba(0,0,0,0.2);
    backdrop-filter: blur(4px);
}

.sidebar-tooltip::before {
    content: '';
    position: absolute;
    left: -6px;
    top: 50%;
    transform: translateY(-50%);
    border-style: solid;
    border-width: 6px 6px 6px 0;
    border-color: transparent rgba(0,0,0,0.9) transparent transparent;
}

/* Container untuk konten */
.content-container {
    width: 100%;
    padding: 15px;
}

/* Fix untuk chart dan grafik */
.chart-container {
    width: 100% !important;
    height: auto !important;
    position: relative;
}

.chart-wrapper {
    position: relative;
    width: 100%;
    overflow: hidden;
}

/* Memastikan semua konten tetap terlihat */
.row {
    width: 100%;
    margin: 0;
}

.card {
    width: 100%;
    margin-bottom: 1rem;
    background: var(--bg-secondary);
    border-color: var(--border-color);
}

/* Container untuk konten */
.container-fluid {
    width: 100%;
    padding-right: 15px;
    padding-left: 15px;
    margin-right: auto;
    margin-left: auto;
}

/* Fix untuk grafik dan tabel */
.card {
    width: 100%;
    margin-bottom: 1.5rem;
}

.chart-container {
    width: 100%;
    position: relative;
}

/* Memastikan tabel responsive */
.table-responsive {
    width: 100%;
    overflow-x: auto;
}

/* Styling untuk theme switcher */
.theme-switch-wrapper {
    position: fixed;
    bottom: 20px;
    left: 20px;
    z-index: 1000;
}

.theme-switch {
    display: inline-block;
    height: 34px;
    position: relative;
    width: 60px;
}

.theme-switch input {
    display: none;
}

.slider {
    background: linear-gradient(135deg, #4e73df 0%, #224abe 100%);
    bottom: 0;
    cursor: pointer;
    left: 0;
    position: absolute;
    right: 0;
    top: 0;
    transition: .4s;
    border-radius: 34px;
}

.slider:before {
    background-color: #fff;
    bottom: 4px;
    content: "";
    height: 26px;
    left: 4px;
    position: absolute;
    transition: .4s;
    width: 26px;
    border-radius: 50%;
}

input:checked + .slider {
    background: #2c3e50;
}

input:checked + .slider:before {
    transform: translateX(26px);
}

.slider.round {
    border-radius: 34px;
    display: flex;
    align-items: center;
    justify-content: space-between;
    padding: 0 10px;
}

.sun-icon, .moon-icon {
    color: #fff;
    font-size: 14px;
    transition: .4s;
}

/* Dark mode styles untuk semua tabel */
[data-theme="dark"] {
    /* Warna dasar untuk mode gelap */
    --bg-primary: #1a1a1a;
    --bg-secondary: #2d2d2d;
    --text-primary: #ffffff;
    --text-secondary: #e0e0e0;
    --border-color: #404040;
    
    /* Warna khusus untuk tabel */
    --table-header-bg: #2c3e50;
    --table-row-bg: #2d2d2d;
    --table-row-hover: #3d3d3d;
    --table-text: #ffffff;
    --table-border: rgba(255, 255, 255, 0.1);
}

/* Perbaikan untuk tabel */
[data-theme="dark"] .table {
    color: var(--table-text);
    background-color: var(--bg-secondary);
    border-color: var(--table-border);
}

[data-theme="dark"] .table thead th {
    background: var(--table-header-bg) !important;
    color: #ffffff;
    border-bottom: 1px solid var(--table-border);
    font-weight: 500;
}

[data-theme="dark"] .table tbody td {
    background-color: var(--table-row-bg);
    color: var(--text-primary);
    border-bottom: 1px solid var(--table-border);
}

[data-theme="dark"] .table-hover tbody tr:hover {
    background-color: var(--table-row-hover);
}

/* Perbaikan untuk header gradien */
[data-theme="dark"] .header-wrapper {
    background: linear-gradient(135deg, #2c3e50 0%, #3498db 100%) !important;
    border: 1px solid var(--border-color);
}

/* Perbaikan untuk card */
[data-theme="dark"] .card {
    background-color: var(--bg-secondary);
    border: 1px solid var(--border-color);
}

/* Perbaikan untuk status badges */
[data-theme="dark"] .badge.bg-soft-success {
    background-color: rgba(40, 167, 69, 0.2) !important;
    color: #2ecc71 !important;
}

[data-theme="dark"] .badge.bg-soft-warning {
    background-color: rgba(255, 193, 7, 0.2) !important;
    color: #ffd43b !important;
}

/* Perbaikan untuk tombol-tombol */
[data-theme="dark"] .btn-soft-info {
    background-color: rgba(23, 162, 184, 0.2);
    color: #5bc0de;
    border: 1px solid rgba(23, 162, 184, 0.3);
}

[data-theme="dark"] .btn-soft-warning {
    background-color: rgba(255, 193, 7, 0.2);
    color: #ffd43b;
    border: 1px solid rgba(255, 193, 7, 0.3);
}

[data-theme="dark"] .btn-soft-danger {
    background-color: rgba(220, 53, 69, 0.2);
    color: #ff6b6b;
    border: 1px solid rgba(220, 53, 69, 0.3);
}

/* Perbaikan untuk form elements */
[data-theme="dark"] input,
[data-theme="dark"] select,
[data-theme="dark"] textarea {
    background-color: #333333 !important;
    color: #ffffff !important;
    border-color: var(--border-color) !important;
}

[data-theme="dark"] input::placeholder {
    color: #888888 !important;
}

/* Perbaikan untuk DataTables */
[data-theme="dark"] .dataTables_wrapper .dataTables_length,
[data-theme="dark"] .dataTables_wrapper .dataTables_filter,
[data-theme="dark"] .dataTables_wrapper .dataTables_info,
[data-theme="dark"] .dataTables_wrapper .dataTables_processing,
[data-theme="dark"] .dataTables_wrapper .dataTables_paginate {
    color: var(--text-primary) !important;
}

/* Perbaikan untuk link dan text */
[data-theme="dark"] a {
    color: #5bc0de;
}

[data-theme="dark"] .text-muted {
    color: #a0a0a0 !important;
}

/* Perbaikan untuk laporan perjalanan dinas */
[data-theme="dark"] .laporan-table {
    background-color: var(--bg-secondary);
}

[data-theme="dark"] .laporan-table th,
[data-theme="dark"] .laporan-table td {
    border-color: var(--table-border);
    color: var(--text-primary);
}

/* Perbaikan untuk container gradien */
[data-theme="dark"] .gradient-container {
    background: linear-gradient(135deg, #2c3e50 0%, #3498db 100%) !important;
}

/* Perbaikan untuk tombol eye dan action container */
[data-theme="dark"] .btn-eye {
    color: #5bc0de;
    background-color: rgba(23, 162, 184, 0.1);
}

[data-theme="dark"] .btn-eye:hover {
    background-color: rgba(23, 162, 184, 0.2);
}

[data-theme="dark"] .action-container {
    background-color: var(--bg-secondary);
    border: 1px solid var(--border-color);
}

/* Perbaikan untuk status badges di rincian biaya */
[data-theme="dark"] .status-badge {
    padding: 6px 12px;
    border-radius: 4px;
    font-weight: 500;
}

[data-theme="dark"] .status-badge.sudah-dibuat {
    background-color: rgba(40, 167, 69, 0.2);
    color: #2ecc71;
}

[data-theme="dark"] .status-badge.belum-dibuat {
    background-color: rgba(255, 193, 7, 0.2);
    color: #ffd43b;
}

/* Force consistent text rendering */
.sidebar * {
    -webkit-font-smoothing: antialiased;
    -moz-osx-font-smoothing: grayscale;
    text-rendering: optimizeLegibility;
}

/* Reset khusus untuk sidebar untuk mencegah pengaruh CSS dari halaman lain */
.sidebar-wrapper *,
.sidebar-wrapper *::before,
.sidebar-wrapper *::after {
    font-size: inherit !important;
    line-height: inherit !important;
    font-weight: inherit !important;
    text-size-adjust: none !important;
    -webkit-text-size-adjust: none !important;
}

/* Pengaturan font yang lebih ketat */
.sidebar {
    font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Helvetica Neue", Arial, sans-serif !important;
    text-size-adjust: none !important;
    -webkit-text-size-adjust: none !important;
}

/* Logo dan Header */
.logo-title {
    font-size: 1.1rem !important;
    line-height: 1.2 !important;
    font-weight: 600 !important;
    transform: none !important;
    letter-spacing: normal !important;
}

.logo-subtitle {
    font-size: 0.75rem !important;
    line-height: 1.2 !important;
    font-weight: normal !important;
    transform: none !important;
    letter-spacing: normal !important;
}

/* Profile Section */
.profile-info h6 {
    font-size: 0.85rem !important;
    line-height: 1.2 !important;
    font-weight: 600 !important;
    transform: none !important;
    letter-spacing: normal !important;
}

.profile-info small {
    font-size: 0.75rem !important;
    line-height: 1.2 !important;
    font-weight: normal !important;
    transform: none !important;
    letter-spacing: normal !important;
}

/* Navigation */
.menu-label {
    font-size: 0.75rem !important;
    line-height: 1.2 !important;
    font-weight: 600 !important;
    transform: none !important;
    letter-spacing: 1px !important;
}

.nav-link,
.nav-link:hover,
.nav-link:active,
.nav-link.active,
.nav-link:focus {
    font-size: 0.9rem !important;
    line-height: 1.2 !important;
    font-weight: normal !important;
    transform: none !important;
    letter-spacing: normal !important;
}

.nav-link i,
.nav-link:hover i,
.nav-link:active i,
.nav-link.active i,
.nav-link:focus i {
    font-size: 1.1rem !important;
    line-height: 1.2 !important;
    transform: none !important;
}

/* Prevent any zoom or scaling */
.sidebar-wrapper {
    zoom: 100% !important;
    transform: none !important;
    transform-origin: 0 0 !important;
}

/* Force hardware acceleration and prevent any transformations */
.sidebar-wrapper,
.sidebar,
.sidebar * {
    -webkit-font-smoothing: antialiased !important;
    -moz-osx-font-smoothing: grayscale !important;
    text-rendering: optimizeLegibility !important;
    backface-visibility: hidden !important;
    -webkit-backface-visibility: hidden !important;
    transform: translateZ(0) !important;
    -webkit-transform: translateZ(0) !important;
    perspective: 1000 !important;
    -webkit-perspective: 1000 !important;
}

/* Main Content and Form Adjustments */
.main-content {
    margin-left: var(--sidebar-width);
    transition: all 0.3s ease;
    width: calc(100% - var(--sidebar-width));
    min-height: 100vh;
    padding: 20px;
}

.main-content.collapsed {
    margin-left: 70px;
    width: calc(100% - 70px);
}

/* Form and Content Container Adjustments */
.container-fluid,
.card,
.card-body,
.table-responsive,
form,
.row,
.col,
.col-md-12,
.col-lg-12 {
    width: 100%;
    max-width: 100%;
    transition: all 0.3s ease;
}

/* Card Adjustments */
.card {
    margin-bottom: 1.5rem;
}

/* Table Adjustments */
.table-responsive {
    overflow-x: auto;
}

.table {
    width: 100% !important;
}

/* Form Group Adjustments */
.form-group,
.input-group {
    width: 100%;
    transition: all 0.3s ease;
}

/* Modal Adjustments */
.modal-dialog {
    max-width: 90%;
    margin: 1.75rem auto;
    transition: all 0.3s ease;
}

@media (min-width: 992px) {
    .modal-dialog {
        max-width: 800px;
    }
    
    .modal-lg {
        max-width: 900px;
    }
    
    .modal-xl {
        max-width: 1140px;
    }
}

/* Grid System Adjustments */
.row {
    margin-right: -15px;
    margin-left: -15px;
    display: flex;
    flex-wrap: wrap;
}

[class*="col-"] {
    padding-right: 15px;
    padding-left: 15px;
    transition: all 0.3s ease;
}

/* Header Wrapper Adjustment */
.header-wrapper {
    width: 100%;
    margin-bottom: 2rem;
    transition: all 0.3s ease;
}

/* Chart Container Adjustment */
.chart-container {
    width: 100% !important;
    height: auto !important;
    transition: all 0.3s ease;
}

/* DataTables Adjustment */
.dataTables_wrapper {
    width: 100% !important;
    transition: all 0.3s ease;
}

/* Custom Container Classes */
.content-container {
    width: 100%;
    transition: all 0.3s ease;
}

/* Ensure all flex containers adjust properly */
.d-flex,
.flex-row,
.flex-column {
    width: 100%;
    transition: all 0.3s ease;
}

/* Action buttons container */
.action-container {
    width: 100%;
    transition: all 0.3s ease;
}

/* Print section adjustments */
@media print {
    .main-content {
        margin-left: 0 !important;
        width: 100% !important;
    }
}

/* Content Wrapper Adjustment */
.content-wrapper {
    margin-left: var(--sidebar-width);
    width: calc(100% - var(--sidebar-width));
    transition: all 0.3s ease;
}

.content-wrapper.collapsed {
    margin-left: var(--sidebar-mini-width);
    width: calc(100% - var(--sidebar-mini-width));
}

/* Toggle Button Styles */
.sidebar-toggle {
    position: fixed;
    right: -15px;
    top: 70px; /* Sesuaikan dengan header height */
    width: 30px;
    height: 30px;
    background: #224abe;
    border: 2px solid #ffffff;
    border-radius: 50%;
    color: white;
    display: flex;
    align-items: center;
    justify-content: center;
    cursor: pointer;
    z-index: 1050;
    transition: all 0.3s ease;
    box-shadow: 0 2px 5px rgba(0,0,0,0.2);
}

.sidebar-toggle:hover {
    background: #1a3997;
    transform: scale(1.1);
}

.sidebar-toggle i {
    font-size: 18px;
    transition: transform 0.3s ease;
}

.sidebar-wrapper.collapsed .sidebar-toggle {
    right: -15px;
}

.sidebar-wrapper.collapsed .sidebar-toggle i {
    transform: rotate(180deg);
}

/* Adjust sidebar header for toggle button */
.sidebar-header {
    position: relative;
    padding-right: 30px;
}

/* Make sure the toggle button is visible on top of other elements */
#sidebarToggle {
    opacity: 1;
    visibility: visible;
}

/* Collapsed Sidebar Styles */
.sidebar-wrapper.collapsed {
    width: 70px;
}

.sidebar-wrapper.collapsed .sidebar {
    width: 70px;
}

.sidebar-wrapper.collapsed .logo-text,
.sidebar-wrapper.collapsed .logo-subtitle,
.sidebar-wrapper.collapsed .menu-label,
.sidebar-wrapper.collapsed .nav-link span,
.sidebar-wrapper.collapsed .profile-info {
    display: none;
}

.sidebar-wrapper.collapsed .sidebar-toggle i {
    transform: rotate(180deg);
}

.sidebar-wrapper.collapsed .nav-link {
    padding: 0.8rem;
    justify-content: center;
}

.sidebar-wrapper.collapsed .nav-link i {
    margin-right: 0;
}

.sidebar-wrapper.collapsed .sidebar-logo {
    margin: 0 auto;
}

.sidebar-wrapper.collapsed .profile-img {
    margin: 0 auto;
}

/* Adjust main content when sidebar is collapsed */
.content-wrapper {
    margin-left: var(--sidebar-width);
    transition: margin-left 0.3s ease;
    width: calc(100% - var(--sidebar-width));
}

.content-wrapper.collapsed {
    margin-left: 70px;
    width: calc(100% - 70px);
}

/* Tooltip for collapsed sidebar */
.sidebar-wrapper.collapsed .nav-link {
    position: relative;
}

.sidebar-wrapper.collapsed .nav-link:hover::after {
    content: attr(data-title);
    position: absolute;
    left: 100%;
    top: 50%;
    transform: translateY(-50%);
    background: rgba(0, 0, 0, 0.8);
    color: white;
    padding: 5px 10px;
    border-radius: 4px;
    font-size: 12px;
    white-space: nowrap;
    margin-left: 10px;
    z-index: 1000;
}

/* Collapsed State Modifications */
.sidebar-wrapper.collapsed .nav-link {
    justify-content: center;
    padding: 0.8rem;
}

.sidebar-wrapper.collapsed .nav-link i {
    margin: 0;
    font-size: 1.2rem;
}

.sidebar-wrapper.collapsed .nav-link span,
.sidebar-wrapper.collapsed .menu-label {
    display: none;
}

/* Tooltip styling */
.nav-tooltip {
    position: fixed;
    background: rgba(0, 0, 0, 0.8);
    color: white;
    padding: 8px 12px;
    border-radius: 6px;
    font-size: 0.85rem;
    z-index: 1070;
    display: none;
    pointer-events: none;
    white-space: nowrap;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.2);
    backdrop-filter: blur(4px);
}

.nav-tooltip::before {
    content: '';
    position: absolute;
    left: -6px;
    top: 50%;
    transform: translateY(-50%);
    border-style: solid;
    border-width: 6px 6px 6px 0;
    border-color: transparent rgba(0, 0, 0, 0.8) transparent transparent;
}

/* Enhanced Footer Styles */
.sidebar-footer {
    bottom: 0;
    left: 0;
    width: 100%;
    padding: 3px;
    background: linear-gradient(135deg, rgba(21, 35, 80, 0.95) 0%, rgba(34, 74, 190, 0.95) 100%);
    border-top: 1px solid rgba(255, 255, 255, 0.1);
    backdrop-filter: blur(5px);
    z-index: 1000;
    display: flex;
    align-items: center;
    justify-content: center;
    transition: all 0.3s ease;
    flex-shrink: 0;
    box-shadow: 0 -2px 10px rgba(0, 0, 0, 0.1);
}

.footer-content {
    text-align: center;
    width: 100%;
    padding: 0;
}

.footer-text {
    display: flex;
    align-items: center;
    justify-content: center;
}

.single-line {
    color: rgba(255, 255, 255, 0.9);
    font-size: 0.2rem;
    white-space: nowrap;
    letter-spacing: 0.1px;
}

.footer-link {
    color: #fff;
    text-decoration: none;
    font-weight: 500;
    transition: all 0.3s ease;
    padding: 0 1px;
}

.footer-link:hover {
    color: #fff;
    background: rgba(255, 255, 255, 0.1);
    text-decoration: none;
}

/* Collapsed Sidebar Footer Adjustments */
.sidebar-wrapper.collapsed .sidebar-footer {
    padding: 2px;
}

.sidebar-wrapper.collapsed .single-line {
    font-size: 0.15rem;
}
</style>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const sidebarWrapper = document.querySelector('.sidebar-wrapper');
    const contentWrapper = document.querySelector('.content-wrapper');
    const sidebarToggle = document.querySelector('#sidebarToggle');
    const navLinks = document.querySelectorAll('.nav-link');

    // Create tooltip element
    const tooltip = document.createElement('div');
    tooltip.className = 'nav-tooltip';
    document.body.appendChild(tooltip);

    // Handle tooltip display
    navLinks.forEach(link => {
        link.addEventListener('mouseenter', function(e) {
            if (!sidebarWrapper.classList.contains('collapsed')) return;
            
            const text = this.querySelector('span').textContent;
            tooltip.textContent = text;
            tooltip.style.display = 'block';
            
            // Position tooltip
            const rect = this.getBoundingClientRect();
            tooltip.style.top = rect.top + (rect.height/2) - (tooltip.offsetHeight/2) + 'px';
            tooltip.style.left = rect.right + 10 + 'px';
        });

        link.addEventListener('mouseleave', function() {
            tooltip.style.display = 'none';
        });
    });

    // Toggle sidebar
    sidebarToggle.addEventListener('click', function() {
        sidebarWrapper.classList.toggle('collapsed');
        contentWrapper.classList.toggle('collapsed');
        tooltip.style.display = 'none';
        
        // Store sidebar state in localStorage
        localStorage.setItem('sidebarCollapsed', sidebarWrapper.classList.contains('collapsed'));
    });

    // Check localStorage for saved sidebar state
    const sidebarCollapsed = localStorage.getItem('sidebarCollapsed') === 'true';
    if (sidebarCollapsed) {
        sidebarWrapper.classList.add('collapsed');
        contentWrapper.classList.add('collapsed');
    }

    // Handle window resize
    window.addEventListener('resize', function() {
        if (window.innerWidth <= 768) {
            sidebarWrapper.classList.add('collapsed');
            contentWrapper.classList.add('collapsed');
        }
        tooltip.style.display = 'none';
    });

    // Hide tooltip when scrolling
    document.addEventListener('scroll', function() {
        tooltip.style.display = 'none';
    });
});
</script> 