<?php
session_start();
require_once '../config/config.php';

// Cek login dan level
if (!isset($_SESSION['user_id']) || !in_array($_SESSION['level'], ['admin', 'pimpinan'])) {
    header("Location: ../login.php");
    exit();
}

// Ambil daftar informasi
$query = "SELECT i.*, u.username, u.nama_lengkap 
          FROM informasi i 
          LEFT JOIN users u ON i.created_by = u.id 
          WHERE i.status = 'aktif'";

// Get user's bidang if pimpinan
$user_bidang = '';
if ($_SESSION['level'] === 'pimpinan') {
    $user_id = $_SESSION['user_id'];
    $stmt = mysqli_prepare($conn, "SELECT bidang FROM users WHERE id = ?");
    if ($stmt) {
        mysqli_stmt_bind_param($stmt, "i", $user_id);
        mysqli_stmt_execute($stmt);
        $result_user = mysqli_stmt_get_result($stmt);
        if ($user_data = mysqli_fetch_assoc($result_user)) {
            $user_bidang = $user_data['bidang'];
        }
        mysqli_stmt_close($stmt);
    }
}

// Add bidang filter for pimpinan
if ($_SESSION['level'] === 'pimpinan' && !empty($user_bidang)) {
    $query .= " AND u.bidang = ?";
    $query .= " ORDER BY i.prioritas DESC, i.created_at DESC";
    
    $stmt = mysqli_prepare($conn, $query);
    mysqli_stmt_bind_param($stmt, "s", $user_bidang);
    mysqli_stmt_execute($stmt);
    $result = mysqli_stmt_get_result($stmt);
} else {
    $query .= " ORDER BY i.prioritas DESC, i.created_at DESC";
    $result = mysqli_query($conn, $query);
}

if (!$result) {
    die("Error in query: " . mysqli_error($conn));
}

// Tambahkan variabel untuk menyimpan level user
$user_level = $_SESSION['level'];
$user_id = $_SESSION['user_id'];
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Kelola Informasi - SPPD</title>
    <link rel="icon" type="image/svg+xml" href="data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAyNCAyNCI+PHBhdGggZmlsbD0iIzRlNzNkZiIgZD0iTTIwLDhINFY2aDIwdjJIMjB6IE0xNSwxMEg0djJoMTFWMTB6IE00LDE2aDd2Mkg0VjE2eiBNMjEuNywxMy4zTDIwLjMsMTJsMS40LTEuNEMyMi4xLDEwLjIsMjIuMSw5LjgsMjEuNyw5LjRsLTEuMS0xLjFDMjAuMiw3LjksMTkuOCw3LjksMTkuNCw4LjNMMTgsMTBsLTEuNC0xLjRjLTAuNC0wLjQtMS0wLjQtMS40LDBsLTcuNSw3LjVjLTAuMiwwLjItMC4zLDAuNC0wLjMsMC43djIuOWMwLDAuNSwwLjQsMC45LDAuOSwwLjloMi45YzAuMywwLDAuNS0wLjEsMC43LTAuM2w3LjUtNy41QzIyLjEsMTQuMywyMi4xLDEzLjcsMjEuNywxMy4zeiIvPjwvc3ZnPg==">
    
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.8.1/font/bootstrap-icons.css">
    
    <!-- SweetAlert2 CSS -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css">
    
    <!-- Custom CSS -->
    <link rel="stylesheet" href="../assets/css/style.css">
    <style>
        :root {
            --primary-color: #4e73df;
            --primary-dark: #2e59d9;
            --secondary-color: #858796;
            --success-color: #1cc88a;
            --info-color: #36b9cc;
            --warning-color: #f6c23e;
            --danger-color: #e74a3b;
            --light-color: #f8f9fc;
            --dark-color: #5a5c69;
            --body-bg: #f8f9fc;
            --card-border-radius: 0.35rem;
            --grid-gutter-width: 1.5rem;
            --header-height: 4.375rem;
            --sidebar-width: 280px;
            --sidebar-mini-width: 70px;
        }

        body {
            background-color: var(--body-bg);
            font-family: "Nunito", -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Helvetica Neue", Arial, sans-serif;
            font-size: 0.875rem;
            line-height: 1.5;
            color: #858796;
        }

        /* Content Wrapper */
        .content-wrapper {
            margin-left: var(--sidebar-width);
            padding: 0;
            transition: margin .15s ease-in-out;
            min-height: 100vh;
            background: #f8f9fc;
        }

        .content-wrapper.collapsed {
            margin-left: var(--sidebar-mini-width);
        }

        /* Page Header */
        .page-header {
            margin: 0;
            padding: 1.5rem;
            background: white;
            border-bottom: 1px solid #e3e6f0;
        }

        .page-header h4 {
            color: var(--dark-color);
            font-weight: 700;
            font-size: 1.25rem;
            margin: 0;
        }

        .breadcrumb {
            padding: 0;
            margin-top: 0.5rem;
            background: transparent;
            font-size: 0.85rem;
        }

        .breadcrumb-item a {
            color: var(--primary-color);
            text-decoration: none;
        }

        .breadcrumb-item.active {
            color: var(--secondary-color);
        }

        /* Card */
        .card {
            box-shadow: none;
            border-radius: 0;
            margin: 0;
            background: white;
        }

        .card-header {
            background-color: white;
            padding: 1rem 1.5rem;
            border-bottom: 1px solid #e3e6f0;
        }

        .card-header h5 {
            color: var(--dark-color);
            font-weight: 600;
            font-size: 1rem;
            margin: 0;
        }

        /* Table */
        .table {
            margin: 0;
        }

        .table th {
            background-color: #f8f9fc;
            font-weight: 600;
            text-transform: uppercase;
            font-size: 0.75rem;
            letter-spacing: 0.05em;
            color: var(--dark-color);
            padding: 1rem 1.5rem;
            border-top: none;
        }

        .table td {
            padding: 1rem 1.5rem;
            vertical-align: middle;
            border-color: #e3e6f0;
            color: var(--secondary-color);
        }

        .table tr:hover {
            background-color: #f8f9fc;
        }

        /* Buttons */
        .btn {
            font-weight: 600;
            padding: 0.375rem 0.75rem;
            font-size: 0.875rem;
            border-radius: 0.25rem;
        }

        .btn-primary {
            background-color: var(--primary-color);
            border-color: var(--primary-color);
        }

        .btn-primary:hover {
            background-color: var(--primary-dark);
            border-color: var(--primary-dark);
        }

        .btn-sm {
            padding: 0.25rem 0.5rem;
            font-size: 0.75rem;
        }

        /* Badges */
        .badge {
            padding: 0.35em 0.65em;
            font-size: 0.75em;
            font-weight: 600;
        }

        .badge.bg-danger {
            background-color: var(--danger-color) !important;
        }

        /* Form Controls */
        .form-select {
            padding: 0.375rem 2rem 0.375rem 0.75rem;
            font-size: 0.875rem;
            border: 1px solid #d1d3e2;
            border-radius: 0.25rem;
        }

        .form-select:focus {
            border-color: #bac8f3;
            box-shadow: 0 0 0 0.25rem rgba(78, 115, 223, 0.25);
        }

        /* Card Footer */
        .card-footer {
            background-color: #fff;
            padding: 1rem 1.5rem;
            border-top: 1px solid #e3e6f0;
        }

        /* Pagination */
        .pagination {
            margin: 0;
        }

        .page-link {
            padding: 0.375rem 0.75rem;
            font-size: 0.875rem;
            color: var(--primary-color);
            background-color: #fff;
            border: 1px solid #dddfeb;
        }

        .page-item.active .page-link {
            background-color: var(--primary-color);
            border-color: var(--primary-color);
        }

        .page-item.disabled .page-link {
            color: var(--secondary-color);
        }

        /* Alert */
        .alert {
            margin: 0;
            border-radius: 0;
        }

        .alert-success {
            color: #0f5132;
            background-color: #d1e7dd;
        }

        /* Add spacing between sections */
        .content-section {
            margin-bottom: 1.5rem;
        }

        /* Responsive */
        @media (max-width: 768px) {
            .content-wrapper {
                margin-left: 0;
            }

            .page-header,
            .card-header,
            .card-body,
            .card-footer {
                padding: 1rem;
            }

            .table th,
            .table td {
                padding: 0.75rem 1rem;
            }
        }
    </style>
</head>
<body>
    <?php include '../includes/sidebar.php'; ?>
    
    <div class="content-wrapper">
        <!-- Page Header -->
        <div class="page-header">
            <div class="d-flex justify-content-between align-items-center">
                <div>
                    <h4 class="mb-0">Kelola Informasi</h4>
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb mb-0">
                            <li class="breadcrumb-item"><a href="../dashboard.php">Dashboard</a></li>
                            <li class="breadcrumb-item active" aria-current="page">Informasi</li>
                        </ol>
                    </nav>
                </div>
                <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addInfoModal">
                    <i class="bi bi-plus-circle"></i>
                    Tambah Informasi
                </button>
            </div>
        </div>

        <?php if (isset($_SESSION['flash_message'])): ?>
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <?= $_SESSION['flash_message'] ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
            <?php unset($_SESSION['flash_message']); ?>
        <?php endif; ?>

        <!-- Main Content -->
        <div class="card">
            <div class="card-header">
                <div class="d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">Daftar Informasi</h5>
                    <div class="d-flex align-items-center">
                        <label class="me-2 text-nowrap">Show</label>
                        <select class="form-select form-select-sm w-auto">
                            <option value="10">10</option>
                            <option value="25">25</option>
                            <option value="50">50</option>
                            <option value="100">100</option>
                        </select>
                        <label class="ms-2">entries</label>
                    </div>
                </div>
            </div>
            <div class="table-responsive">
                <table class="table table-hover align-middle mb-0">
                    <thead>
                        <tr>
                            <th width="5%">NO</th>
                            <th width="25%">JUDUL</th>
                            <th width="35%">ISI</th>
                            <th width="15%">DIBUAT OLEH</th>
                            <th width="10%">TANGGAL</th>
                            <th width="10%" class="text-center">AKSI</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php 
                        $no = 1;
                        while ($row = mysqli_fetch_assoc($result)): 
                        ?>
                        <tr>
                            <td><?= $no++ ?></td>
                            <td>
                                <?php if ($row['prioritas'] == 'tinggi'): ?>
                                    <div class="badge bg-danger mb-1">PRIORITAS TINGGI</div>
                                <?php endif; ?>
                                <div class="fw-medium"><?= htmlspecialchars($row['judul']) ?></div>
                            </td>
                            <td class="text-muted"><?= htmlspecialchars($row['isi']) ?></td>
                            <td><?= htmlspecialchars($row['nama_lengkap'] ?: $row['username']) ?></td>
                            <td><?= date('d/m/Y', strtotime($row['created_at'])) ?></td>
                            <td>
                                <div class="d-flex justify-content-center gap-1">
                                    <?php if ($user_level == 'admin' || $user_id == $row['created_by']): ?>
                                    <button class="btn btn-warning btn-sm" onclick="editInfo(<?= $row['id_info'] ?>)">
                                        <i class="bi bi-pencil-fill"></i>
                                    </button>
                                    <button class="btn btn-danger btn-sm" onclick="deleteInfo(<?= $row['id_info'] ?>)">
                                        <i class="bi bi-trash-fill"></i>
                                    </button>
                                    <?php endif; ?>
                                </div>
                            </td>
                        </tr>
                        <?php endwhile; ?>
                    </tbody>
                </table>
            </div>
            <div class="card-footer">
                <div class="d-flex justify-content-between align-items-center">
                    <div class="text-muted small">
                        Showing 1 to <?= mysqli_num_rows($result) ?> of <?= mysqli_num_rows($result) ?> entries
                    </div>
                    <nav aria-label="Page navigation">
                        <ul class="pagination pagination-sm mb-0">
                            <li class="page-item disabled">
                                <span class="page-link">Previous</span>
                            </li>
                            <li class="page-item active">
                                <span class="page-link">1</span>
                            </li>
                            <li class="page-item disabled">
                                <span class="page-link">Next</span>
                            </li>
                        </ul>
                    </nav>
                </div>
            </div>
        </div>
    </div>
    
    <?php include '../includes/footer.php'; ?>

    <!-- Modal Tambah Informasi -->
    <div class="modal fade" id="addInfoModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">
                        <i class="bi bi-plus-circle me-2"></i>
                        Tambah Informasi Baru
                    </h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <form action="../actions/add_info.php" method="POST">
                    <div class="modal-body">
                        <div class="mb-3">
                            <label class="form-label">Judul</label>
                            <input type="text" class="form-control" name="judul" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Isi Informasi</label>
                            <textarea class="form-control" name="isi" rows="4" required></textarea>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Prioritas</label>
                            <select class="form-select" name="prioritas">
                                <option value="normal">Normal</option>
                                <option value="tinggi">Tinggi</option>
                            </select>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                            <i class="bi bi-x-circle me-2"></i>Batal
                        </button>
                        <button type="submit" class="btn btn-primary">
                            <i class="bi bi-save me-2"></i>Simpan
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Modal Edit Informasi -->
    <div class="modal fade" id="editInfoModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">
                        <i class="bi bi-pencil-square me-2"></i>
                        Edit Informasi
                    </h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <form id="editInfoForm" onsubmit="handleEditSubmit(event)">
                    <div class="modal-body">
                        <input type="hidden" id="edit_id_info" name="id_info">
                        <div class="mb-3">
                            <label class="form-label">Judul</label>
                            <input type="text" class="form-control" id="edit_judul" name="judul" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Isi Informasi</label>
                            <textarea class="form-control" id="edit_isi" name="isi" rows="4" required></textarea>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Prioritas</label>
                            <select class="form-select" id="edit_prioritas" name="prioritas">
                                <option value="normal">Normal</option>
                                <option value="tinggi">Tinggi</option>
                            </select>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                            <i class="bi bi-x-circle me-2"></i>Batal
                        </button>
                        <button type="submit" class="btn btn-primary">
                            <i class="bi bi-save me-2"></i>Simpan Perubahan
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <!-- SweetAlert2 JS -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script>
    // Add loading spinner to button
    function setLoading(button, isLoading) {
        if (isLoading) {
            button.setAttribute('disabled', 'disabled');
            button.innerHTML = '<span class="spinner-border spinner-border-sm me-2"></span>Loading...';
        } else {
            button.removeAttribute('disabled');
            button.innerHTML = button.getAttribute('data-original-html');
        }
    }

    // Show toast notification
    function showToast(message, type = 'success') {
        const toastDiv = document.createElement('div');
        toastDiv.className = `toast align-items-center text-white bg-${type} border-0 position-fixed bottom-0 end-0 m-3`;
        toastDiv.setAttribute('role', 'alert');
        toastDiv.innerHTML = `
            <div class="d-flex">
                <div class="toast-body">${message}</div>
                <button type="button" class="btn-close btn-close-white me-2 m-auto" data-bs-dismiss="toast"></button>
            </div>
        `;
        document.body.appendChild(toastDiv);
        const toast = new bootstrap.Toast(toastDiv);
        toast.show();
        setTimeout(() => toastDiv.remove(), 5000);
    }

    function editInfo(id) {
        const editButton = event.target.closest('button');
        editButton.setAttribute('data-original-html', editButton.innerHTML);
        setLoading(editButton, true);

        fetch(`../actions/get_info.php?id=${id}`)
            .then(response => response.json())
            .then(data => {
                if (data.id_info) {
                    document.getElementById('edit_id_info').value = data.id_info;
                    document.getElementById('edit_judul').value = data.judul;
                    document.getElementById('edit_isi').value = data.isi;
                    document.getElementById('edit_prioritas').value = data.prioritas;
                    
                    new bootstrap.Modal(document.getElementById('editInfoModal')).show();
                } else {
                    throw new Error(data.message || 'Data informasi tidak ditemukan');
                }
            })
            .catch(error => {
                console.error('Error:', error);
                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    text: error.message || 'Terjadi kesalahan saat mengambil data'
                });
            })
            .finally(() => {
                setLoading(editButton, false);
            });
    }

    function handleEditSubmit(event) {
        event.preventDefault();
        
        const form = event.target;
        const submitButton = form.querySelector('button[type="submit"]');
        submitButton.setAttribute('data-original-html', submitButton.innerHTML);
        setLoading(submitButton, true);

        // Basic client-side validation
        const judul = form.querySelector('[name="judul"]').value.trim();
        const isi = form.querySelector('[name="isi"]').value.trim();

        if (judul.length < 3) {
            showToast('Judul harus minimal 3 karakter', 'warning');
            setLoading(submitButton, false);
            return;
        }

        if (isi.length < 10) {
            showToast('Isi informasi harus minimal 10 karakter', 'warning');
            setLoading(submitButton, false);
            return;
        }
        
        const formData = new FormData(form);
        
        fetch('../actions/edit_info.php', {
            method: 'POST',
            body: formData
        })
        .then(response => response.json().then(data => {
            if (!response.ok) {
                throw new Error(data.message || 'Network response was not ok');
            }
            return data;
        }))
        .then(data => {
            if (data.success) {
                Swal.fire({
                    icon: 'success',
                    title: 'Berhasil!',
                    text: 'Informasi berhasil diperbarui',
                    timer: 1500
                }).then(() => {
                    location.reload();
                });
            } else {
                throw new Error(data.message || 'Gagal mengubah informasi');
            }
        })
        .catch(error => {
            console.error('Error:', error);
            Swal.fire({
                icon: 'error',
                title: 'Oops...',
                text: error.message || 'Terjadi kesalahan saat menyimpan perubahan'
            });
        })
        .finally(() => {
            setLoading(submitButton, false);
        });
    }

    function deleteInfo(id) {
        Swal.fire({
            title: 'Konfirmasi Hapus',
            text: 'Apakah Anda yakin ingin menghapus informasi ini?',
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#dc3545',
            cancelButtonColor: '#6c757d',
            confirmButtonText: 'Ya, Hapus',
            cancelButtonText: 'Batal'
        }).then((result) => {
            if (result.isConfirmed) {
                fetch(`../actions/delete_info.php?id=${id}`, {
                    method: 'POST'
                })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        Swal.fire({
                            icon: 'success',
                            title: 'Berhasil',
                            text: 'Informasi berhasil dihapus',
                            timer: 1500
                        }).then(() => {
                            location.reload();
                        });
                    } else {
                        throw new Error(data.message || 'Gagal menghapus informasi');
                    }
                })
                .catch(error => {
                    console.error('Error:', error);
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: error.message || 'Terjadi kesalahan saat menghapus data'
                    });
                });
            }
        });
    }

    // Auto-dismiss alerts after 5 seconds
    document.addEventListener('DOMContentLoaded', function() {
        setTimeout(function() {
            const alerts = document.querySelectorAll('.alert');
            alerts.forEach(function(alert) {
                const bsAlert = new bootstrap.Alert(alert);
                bsAlert.close();
            });
        }, 5000);
    });
    </script>
</body>
</html> 