<?php
session_start();
require_once '../config/config.php';

// Cek login dan level
if (!isset($_SESSION['user_id']) || !in_array($_SESSION['level'], ['admin', 'pimpinan', 'bandahara'])) {
    header("Location: ../login.php");
    exit();
}

// Ambil daftar informasi
$query = "SELECT i.*, u.username, u.nama_lengkap, u.bidang,
          DATEDIFF(DATE_ADD(i.created_at, INTERVAL 7 DAY), CURRENT_DATE()) as sisa_hari,
          CASE 
            WHEN DATEDIFF(DATE_ADD(i.created_at, INTERVAL 7 DAY), CURRENT_DATE()) < 0 THEN 'nonaktif'
            ELSE 'aktif'
          END as status_aktif
          FROM informasi i 
          LEFT JOIN users u ON i.created_by = u.id
          WHERE DATEDIFF(DATE_ADD(i.created_at, INTERVAL 7 DAY), CURRENT_DATE()) >= 0";

// Get user's bidang if pimpinan
$user_bidang = '';
if ($_SESSION['level'] === 'pimpinan') {
    $user_id = $_SESSION['user_id'];
    $stmt = mysqli_prepare($conn, "SELECT bidang FROM users WHERE id = ?");
    if ($stmt) {
        mysqli_stmt_bind_param($stmt, "i", $user_id);
        mysqli_stmt_execute($stmt);
        $result_user = mysqli_stmt_get_result($stmt);
        if ($user_data = mysqli_fetch_assoc($result_user)) {
            $user_bidang = $user_data['bidang'];
        }
        mysqli_stmt_close($stmt);
    }
}

// Tambahkan filter berdasarkan level dan bidang
if ($_SESSION['level'] === 'admin') {
    // Admin dapat melihat semua informasi
    $query .= " ORDER BY i.prioritas DESC, i.created_at DESC";
    $result = mysqli_query($conn, $query);
} else {
    // Pengguna lain bisa melihat:
    // 1. Informasi dari bidangnya sendiri
    // 2. Informasi yang dia buat
    // 3. Informasi dari bandahara
    $query .= " AND (u.bidang = ? OR i.created_by = ? OR u.level = 'bandahara')";
    $query .= " ORDER BY i.prioritas DESC, i.created_at DESC";
    
    $stmt = mysqli_prepare($conn, $query);
    mysqli_stmt_bind_param($stmt, "si", $_SESSION['bidang'], $_SESSION['user_id']);
    mysqli_stmt_execute($stmt);
    $result = mysqli_stmt_get_result($stmt);
}

if (!$result) {
    die("Error in query: " . mysqli_error($conn));
}

// Tambahkan variabel untuk menyimpan level user
$user_level = $_SESSION['level'];
$user_id = $_SESSION['user_id'];
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Kelola Informasi - SPPD</title>
    <link rel="icon" type="image/svg+xml" href="data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAyNCAyNCI+PHBhdGggZmlsbD0iIzRlNzNkZiIgZD0iTTIwLDhINFY2aDIwdjJIMjB6IE0xNSwxMEg0djJoMTFWMTB6IE00LDE2aDd2Mkg0VjE2eiBNMjEuNywxMy4zTDIwLjMsMTJsMS40LTEuNEMyMi4xLDEwLjIsMjIuMSw5LjgsMjEuNyw5LjRsLTEuMS0xLjFDMjAuMiw3LjksMTkuOCw3LjksMTkuNCw4LjNMMTgsMTBsLTEuNC0xLjRjLTAuNC0wLjQtMS0wLjQtMS40LDBsLTcuNSw3LjVjLTAuMiwwLjItMC4zLDAuNC0wLjMsMC43djIuOWMwLDAuNSwwLjQsMC45LDAuOSwwLjhoMi45YzAuMywwLDAuNS0wLjEsMC43LTAuM2w3LjUtNy41QzIyLjEsMTQuMywyMi4xLDEzLjcsMjEuNywxMy4zeiIvPjwvc3ZnPg==">
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.8.1/font/bootstrap-icons.css">
    
    <!-- DataTables CSS -->
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.11.5/css/dataTables.bootstrap5.min.css">
    
    <!-- SweetAlert2 CSS -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css">
    
    <!-- jQuery -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    
    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    
    <!-- DataTables JS -->
    <script type="text/javascript" src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/1.11.5/js/dataTables.bootstrap5.min.js"></script>
    
    <!-- SweetAlert2 JS -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    
    <!-- Custom CSS -->
    <link rel="stylesheet" href="../assets/css/style.css">
    <style>
        /* Root variables */
        :root {
            --sidebar-width: 280px;
            --sidebar-mini-width: 70px;
            --content-padding: 2rem;
            --primary-gradient: linear-gradient(135deg, #0ea5e9 0%, #2dd4bf 100%);
            --bg-gradient: linear-gradient(135deg, rgb(245, 255, 254) 0%, rgb(153, 224, 238) 100%);
        }

        body {
            background: var(--bg-gradient) !important;
            font-family: 'Segoe UI', system-ui, -apple-system, sans-serif;
            margin: 0;
            padding: 0;
            min-height: 100vh;
            overflow-x: hidden;
        }

        /* Main Content Layout */
        .content-wrapper {
            position: relative;
            margin-left: var(--sidebar-width);
            width: calc(100% - var(--sidebar-width));
            min-height: 100vh;
            padding: var(--content-padding);
            transition: all 0.3s ease;
            background: var(--bg-gradient);
        }

        .content-wrapper.expanded {
            margin-left: var(--sidebar-mini-width);
            width: calc(100% - var(--sidebar-mini-width));
        }

        /* Container Modifications */
        .container {
            width: 100%;
            padding: 0;
            margin: 0;
            transition: all 0.3s ease;
        }

        /* Card Styles */
        .card {
            background: white;
            border-radius: 15px;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.05);
            margin-bottom: 1.5rem;
            transition: all 0.3s ease;
            display: flex;
            flex-direction: column;
            flex: 1;
        }

        .card-header {
            background: var(--primary-gradient);
            color: white;
            padding: 1.5rem;
            border-radius: 15px 15px 0 0;
            border: none;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .card-body {
            padding: 1.5rem;
            flex: 1;
        }

        /* Table container */
        .table-responsive {
            width: 100%;
            overflow-x: auto;
            -webkit-overflow-scrolling: touch;
        }

        /* Responsive Adjustments */
        @media (min-width: 992px) {
            .content-wrapper {
                padding: var(--content-padding);
            }

            body.sidebar-collapsed .content-wrapper {
                margin-left: var(--sidebar-mini-width);
                width: calc(100% - var(--sidebar-mini-width));
                padding: var(--content-padding);
            }
        }

        @media (max-width: 991px) {
            :root {
                --content-padding: 1rem;
            }

            .content-wrapper {
                margin-left: 0;
                width: 100%;
                padding: var(--content-padding);
            }

            body.sidebar-collapsed .content-wrapper {
                margin-left: var(--sidebar-mini-width);
                width: calc(100% - var(--sidebar-mini-width));
            }

            .card-body {
                padding: 1rem;
            }
        }

        /* Animation for content expansion */
        .content-wrapper,
        .container,
        .card,
        .card-body,
        .table-responsive {
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        }

        /* Ensure DataTables wrapper expands properly */
        .dataTables_wrapper {
            width: 100%;
        }

        /* Remove any fixed widths on collapse */
        body.sidebar-collapsed .table th,
        body.sidebar-collapsed .table td {
            width: auto !important;
        }

        /* Ensure table takes available space */
        .table {
            width: 100% !important;
            margin-bottom: 0;
        }

        /* Table container adjustments */
        .table-responsive {
            width: 100%;
            transition: all 0.3s ease;
        }

        /* Responsive adjustments */
        @media (min-width: 769px) {
            .content-wrapper {
                padding: var(--content-padding);
            }

            body.sidebar-collapsed .content-wrapper {
                padding: var(--content-padding);
            }

            .table-responsive {
                width: 100%;
            }
        }

        @media (max-width: 768px) {
            .content-wrapper {
                margin-left: 0;
                width: 100%;
                padding: var(--content-padding);
            }

            body.sidebar-collapsed .content-wrapper {
                margin-left: var(--sidebar-mini-width);
                width: calc(100% - var(--sidebar-mini-width));
            }

            .card-body {
                padding: 1rem;
            }
        }

        /* DataTable adjustments */
        .dataTables_wrapper {
            width: 100%;
            transition: all 0.3s ease;
        }

        /* Make sure content expands properly */
        .card, 
        .card-body, 
        .table-responsive, 
        .dataTables_wrapper {
            min-width: 0;
            flex: 1;
        }

        /* Search and length menu positioning */
        .dataTables_length, 
        .dataTables_filter {
            margin-bottom: 1rem;
        }

        body.sidebar-collapsed .dataTables_wrapper {
            width: 100%;
        }

        .card-header {
            background: var(--primary-gradient);
            color: white;
            padding: 1rem;
            border-radius: 15px 15px 0 0 !important;
            border: none;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .card-header h5 {
            color: white;
            font-weight: 600;
            margin: 0;
            font-size: 1.25rem;
        }

        .table thead th {
            background: var(--primary-gradient);
            color: #fff;
            font-weight: 500;
            padding: 0.8rem 1rem;
            font-size: 0.85rem;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            border: none;
            vertical-align: middle;
        }

        .table td {
            padding: 1.2rem 1.5rem;
            vertical-align: middle;
            border-bottom: 1px solid #e9ecef;
            font-size: 1rem;
            color: #495057;
            word-wrap: break-word;
            min-width: 0;
        }

        /* Fixed column widths */
        .table th:nth-child(1), 
        .table td:nth-child(1) {
            width: 50px;
            text-align: center;
        }

        .table th:nth-child(2), 
        .table td:nth-child(2) {
            width: 22%;
        }

        .table th:nth-child(3), 
        .table td:nth-child(3) {
            width: 35%;
        }

        .table th:nth-child(4), 
        .table td:nth-child(4) {
            width: 15%;
        }

        .table th:nth-child(5), 
        .table td:nth-child(5) {
            width: 100px;
        }

        .table th:nth-child(6), 
        .table td:nth-child(6) {
            width: 100px;
            text-align: center;
        }

        /* Text handling */
        .table td {
            overflow: hidden;
            text-overflow: ellipsis;
        }

        .table td .long-content {
            max-width: 100%;
            display: -webkit-box;
            -webkit-line-clamp: 2;
            -webkit-box-orient: vertical;
            overflow: hidden;
            text-overflow: ellipsis;
        }

        /* Badge styling */
        .badge {
            padding: 0.5em 1em;
            font-weight: 500;
            font-size: 0.75rem;
            border-radius: 20px;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            white-space: normal;
            text-align: center;
            line-height: 1.2;
        }

        .badge.bg-success {
            background: linear-gradient(135deg, #10b981 0%, #059669 100%) !important;
        }

        .badge.bg-warning {
            background: linear-gradient(135deg, #f59e0b 0%, #d97706 100%) !important;
            color: white !important;
        }

        .badge.bg-danger {
            background: linear-gradient(135deg, #ef4444 0%, #dc2626 100%) !important;
        }

        /* Animation for expiring soon */
        @keyframes pulse {
            0% { transform: scale(1); }
            50% { transform: scale(1.05); }
            100% { transform: scale(1); }
        }

        .badge.bg-danger {
            animation: pulse 1s infinite;
        }

        /* Table cell alignments */
        .table td.text-center {
            vertical-align: middle;
        }

        /* Button styling */
        .btn-group {
            display: flex;
            gap: 0.25rem;
            justify-content: center;
        }

        .btn-group .btn {
            padding: 0.5rem 1rem;
            font-size: 0.9rem;
        }

        .btn-primary {
            background: var(--primary-gradient);
            border: none;
            color: white;
            transition: all 0.3s ease;
        }
        
        .btn-primary:hover {
            background: linear-gradient(135deg, #0891cf 0%, #26bba8 100%);
            transform: translateY(-1px);
            box-shadow: 0 4px 15px rgba(14, 165, 233, 0.2);
        }

        .btn-custom-edit {
            background: linear-gradient(135deg, #f59e0b 0%, #f97316 100%);
            border: none;
            color: white;
        }

        .btn-custom-edit:hover {
            background: linear-gradient(135deg, #d97706 0%, #ea580c 100%);
            color: white;
        }

        .btn-custom-delete {
            background: linear-gradient(135deg, #ef4444 0%, #dc2626 100%);
            border: none;
            color: white;
        }

        .btn-custom-delete:hover {
            background: linear-gradient(135deg, #dc2626 0%, #b91c1c 100%);
            color: white;
        }

        .modal-content {
            border: none;
            border-radius: 8px;
            box-shadow: 0 0 20px rgba(0,0,0,0.1);
        }

        .modal-header {
            border-radius: 8px 8px 0 0;
            padding: 1.5rem 2rem;
        }

        .btn-close {
            opacity: 0.8;
        }

        .btn-close:hover {
            opacity: 1;
        }

        .form-control:focus, 
        .form-select:focus {
            border-color: #0d6efd;
            box-shadow: 0 0 0 0.2rem rgba(13, 110, 253, 0.15);
        }

        .btn:hover {
            opacity: 0.9;
        }

        /* Container and Spacing */
        .container {
            padding: 2rem;
            max-width: 1400px;
        }

        .table-responsive {
            padding: 1rem;
            border-radius: 12px;
        }

        /* Modal styling */
        .modal-content {
            border: none;
            border-radius: 15px;
            box-shadow: 0 0 30px rgba(0,0,0,0.15);
        }

        .modal-header {
            border-radius: 15px 15px 0 0;
            padding: 1.5rem 2rem;
        }

        .modal-title {
            font-size: 1.4rem;
            font-weight: 600;
        }

        .form-control, .form-select {
            padding: 0.8rem 1rem;
            font-size: 1rem;
            border-radius: 8px;
            border: 2px solid #e2e8f0;
        }

        .form-control:focus, .form-select:focus {
            border-color: #0ea5e9;
            box-shadow: 0 0 0 0.2rem rgba(14, 165, 233, 0.15);
        }

        .form-control-lg, .form-select-lg {
            font-size: 1.1rem;
        }

        .form-label {
            font-size: 1rem;
            margin-bottom: 0.5rem;
            color: #1e293b;
        }

        textarea.form-control {
            line-height: 1.6;
        }

        .btn-lg {
            padding: 0.8rem 1.5rem;
            font-size: 1rem;
        }

        .modal .btn-primary {
            background: var(--primary-gradient);
            border: none;
            padding: 0.8rem 2rem;
        }

        .modal .btn-primary:hover {
            background: linear-gradient(135deg, #0891cf 0%, #26bba8 100%);
            transform: translateY(-1px);
        }

        .modal .btn-secondary {
            background: #e2e8f0;
            border: none;
            color: #475569;
        }

        .modal .btn-secondary:hover {
            background: #cbd5e1;
            color: #1e293b;
        }

        @media (max-width: 768px) {
            .modal-dialog {
                margin: 0.5rem;
            }
            
            .modal-content {
                border-radius: 10px;
            }
            
            .modal-header {
                padding: 1rem 1.5rem;
            }
            
            .modal-body {
                padding: 1rem !important;
            }
            
            .modal-footer {
                padding: 1rem !important;
            }
            
            .form-control-lg, .form-select-lg, .btn-lg {
                font-size: 1rem;
                padding: 0.6rem 1rem;
            }
            
            .modal-title {
                font-size: 1.2rem;
            }
        }

        .modal-dialog.modal-lg {
            max-width: 800px;
            margin: 1.75rem auto;
        }
        .modal-content {
            border-radius: 15px;
            box-shadow: 0 0 20px rgba(0,0,0,0.1);
        }
        .modal-header {
            border-radius: 15px 15px 0 0;
            padding: 1.5rem 2rem;
        }
        .modal-body {
            padding: 2rem;
        }
        .modal-footer {
            padding: 1.5rem 2rem;
            border-radius: 0 0 15px 15px;
        }
        .form-label {
            margin-bottom: 0.75rem;
            font-weight: 600;
            font-size: 1rem;
        }
        .form-control, .form-select {
            padding: 0.75rem 1rem;
            border-radius: 8px;
            border: 1px solid #ddd;
            font-size: 1rem;
        }
        textarea.form-control {
            min-height: 150px;
        }
        .btn {
            padding: 0.75rem 1.5rem;
            font-size: 1rem;
        }

        /* Styling untuk Modal Tambah */
        #modalTambahInfo .modal-dialog {
            max-width: 800px;
            margin: 1.75rem auto;
        }
        #modalTambahInfo .modal-body {
            padding: 1.75rem;
        }
        #modalTambahInfo .modal-header,
        #modalTambahInfo .modal-footer {
            padding: 1.5rem 1.75rem;
        }

        /* Styling untuk Modal Edit */
        #editInfoModal .modal-dialog {
            max-width: 600px;
            margin: 1.75rem auto;
        }
        #editInfoModal .modal-body {
            padding: 1.5rem;
        }
        #editInfoModal .modal-header,
        #editInfoModal .modal-footer {
            padding: 1.25rem 1.5rem;
        }

        /* Styling umum untuk modal */
        .modal-content {
            border-radius: 15px;
            box-shadow: 0 0 20px rgba(0,0,0,0.1);
        }
        .modal-header {
            border-radius: 15px 15px 0 0;
        }
        .modal-footer {
            border-radius: 0 0 15px 15px;
        }
        .form-label {
            margin-bottom: 0.75rem;
            font-weight: 500;
            font-size: 1rem;
        }
        .form-control, .form-select {
            padding: 0.75rem 1rem;
            border-radius: 8px;
            border: 1px solid #ddd;
            font-size: 1rem;
        }
        textarea.form-control {
            min-height: 120px;
        }
        .btn {
            padding: 0.75rem 1.5rem;
            font-size: 1rem;
        }

        @media (max-width: 768px) {
            #modalTambahInfo .modal-dialog,
            #editInfoModal .modal-dialog {
                max-width: 95%;
                margin: 1rem auto;
            }
            .modal-body {
                padding: 1rem;
            }
            .modal-header,
            .modal-footer {
                padding: 1rem;
            }
        }

        /* Chart container adjustments */
        .chart-container {
            width: 100% !important;
            transition: all 0.3s ease;
        }

        /* Row and Column Adjustments */
        .row {
            width: 100%;
            margin: 0;
            transition: all 0.3s ease;
        }

        .col-md-4,
        .col-md-6,
        .col-md-8,
        .col-xl-6 {
            padding: 0.5rem;
            transition: all 0.3s ease;
        }

        /* Modal responsive styles */
        .modal-dialog {
            transition: all 0.3s ease !important;
            margin: 1.75rem auto;
        }

        /* Adjust modal width based on sidebar state */
        body:not(.sidebar-collapsed) .modal-dialog {
            max-width: calc(100% - var(--sidebar-width));
            width: 800px;
        }

        body.sidebar-collapsed .modal-dialog {
            max-width: calc(100% - var(--sidebar-mini-width));
            width: 1000px;
        }

        @media (max-width: 768px) {
            .modal-dialog {
                max-width: 95% !important;
                width: 95% !important;
                margin: 1rem auto;
            }

        }

        /* Smooth transition for modal content */
        .modal-content {
            transition: all 0.3s ease;
        }

        /* Adjust form controls for better spacing */
        .modal .form-control,
        .modal .form-select {
            transition: all 0.3s ease;
        }

        /* Responsive padding for modal sections */
        .modal-header,
        .modal-body,
        .modal-footer {
            transition: padding 0.3s ease;
        }

        @media (min-width: 769px) {
            body.sidebar-collapsed .modal-body {
                padding: 2rem 2.5rem;
            }

            body.sidebar-collapsed .modal-header,
            body.sidebar-collapsed .modal-footer {
                padding: 1.5rem 2.5rem;
            }
        }

        /* Ensure content expands when sidebar is collapsed */
        body.sidebar-collapsed .container,
        body.sidebar-collapsed .card,
        body.sidebar-collapsed .card-body,
        body.sidebar-collapsed .table-responsive {
            width: 100% !important;
            max-width: 100% !important;
        }

        /* Remove any fixed widths when sidebar is collapsed */
        body.sidebar-collapsed .table th,
        body.sidebar-collapsed .table td {
            width: auto !important;
        }

        /* Ensure smooth transitions */
        .container,
        .card,
        .card-body,
        .table-responsive,
        .table,
        .table th,
        .table td {
            transition: all 0.3s ease !important;
        }

        /* Force table layout to adjust */
        body.sidebar-collapsed .table {
            table-layout: auto !important;
        }

        /* Ensure DataTables adjusts properly */
        body.sidebar-collapsed .dataTables_wrapper {
            width: 100% !important;
            max-width: none !important;
        }

        /* Modal styling */
        .modal-dialog {
            max-width: 600px;
            margin: 1.75rem auto;
        }

        .modal-dialog-centered {
            display: flex;
            align-items: center;
            min-height: calc(100% - 3.5rem);
        }

        .modal-content {
            border: none;
            border-radius: 15px;
            box-shadow: 0 0 20px rgba(0,0,0,0.15);
        }

        .modal-header {
            padding: 1.5rem;
            border-radius: 15px 15px 0 0;
        }

        .modal-body {
            padding: 1.5rem;
        }

        .modal-footer {
            padding: 1.5rem;
            border-top: 1px solid #dee2e6;
        }

        /* Form controls */
        .form-control, .form-select {
            padding: 0.75rem 1rem;
            border-radius: 8px;
            border: 1px solid #dee2e6;
            font-size: 1rem;
        }

        .form-control:focus, .form-select:focus {
            border-color: #0ea5e9;
            box-shadow: 0 0 0 0.2rem rgba(14, 165, 233, 0.15);
        }

        /* Responsive adjustments */
        @media (max-width: 768px) {
            .modal-dialog {
                max-width: 95%;
                margin: 1rem auto;
            }

            .modal-header,
            .modal-body,
            .modal-footer {
                padding: 1rem;
            }
        }
    </style>
</head>
<body>
    <?php include '../includes/sidebar.php' ?>
    
    <section class="home-section">
        <div class="container mt-4">
            <div class="card mb-4">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">Kelola Informasi</h5>
                    <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#modalTambahInfo">
                        <i class="bi bi-plus-circle"></i>
                        Tambah Informasi
                    </button>
                </div>
                <div class="card-body">
                        <?php if (isset($_SESSION['flash_message'])): ?>
                        <div class="alert alert-success alert-dismissible fade show" role="alert">
                            <?= $_SESSION['flash_message'] ?>
                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                        <?php unset($_SESSION['flash_message']); ?>
                    <?php endif; ?>
                                
                                <div class="table-responsive">
                        <table id="infoTable" class="table table-striped">
                                        <thead>
                                            <tr>
                                    <th width="5%">NO</th>
                                    <th width="15%">JUDUL</th>
                                    <th width="25%">ISI</th>
                                    <th width="15%">DIBUAT OLEH</th>
                                    <th width="15%">TANGGAL</th>
                                    <th width="10%">SISA HARI</th>
                                    <th width="15%">AKSI</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php 
                                            $no = 1;
                                            while ($row = mysqli_fetch_assoc($result)): 
                                            ?>
                                            <tr>
                                    <td class="text-center"><?= $no++ ?></td>
                                                <td>
                                                    <?php if ($row['prioritas'] == 'tinggi'): ?>
                                            <span class="badge bg-danger">PRIORITAS TINGGI</span><br>
                                                    <?php endif; ?>
                                                    <?= htmlspecialchars($row['judul']) ?>
                                                </td>
                                                <td><?= htmlspecialchars($row['isi']) ?></td>
                                                <td>
                                                    <?= htmlspecialchars($row['nama_lengkap'] ?: $row['username']) ?>
                                                    <?php if ($row['bidang']): ?>
                                                        <br><small class="text-muted"><?= htmlspecialchars($row['bidang']) ?></small>
                                                    <?php endif; ?>
                                                </td>
                                                <td><?= date('d/m/Y', strtotime($row['created_at'])) ?></td>
                                                <td class="text-center">
                                                    <?php
                                                    $sisa_hari = (int)$row['sisa_hari'];
                                                    if ($sisa_hari <= 1) {
                                                        $badge_class = 'bg-danger';
                                                    } else if ($sisa_hari <= 3) {
                                                        $badge_class = 'bg-warning';
                                                    } else {
                                                        $badge_class = 'bg-success';
                                                    }
                                                    ?>
                                                    <span class="badge <?= $badge_class ?>">
                                                        <?= $sisa_hari ?> Hari
                                                    </span>
                                                </td>
                                                <td class="text-center">
                                                    <?php if ($user_level == 'admin' || $user_id == $row['created_by']): ?>
                                            <div class="btn-group">
                                                <button type="button" class="btn btn-sm btn-custom-edit" onclick="editInfo(<?= $row['id_info'] ?>)">
                                                    <i class="bi bi-pencil-fill"></i>
                                                </button>
                                                <button type="button" class="btn btn-sm btn-custom-delete" onclick="deleteInfo(<?= $row['id_info'] ?>)">
                                                    <i class="bi bi-trash-fill"></i>
                                                </button>
                                            </div>
                                                    <?php endif; ?>
                                                </td>
                                            </tr>
                                            <?php endwhile; ?>
                                        </tbody>
                                    </table>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Modal Tambah Informasi -->
    <div class="modal fade" id="modalTambahInfo" tabindex="-1" aria-labelledby="modalTambahInfoLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header" style="background: var(--primary-gradient); color: white;">
                    <h5 class="modal-title" id="modalTambahInfoLabel" style="font-size: 1.25rem;">
                        <i class="bi bi-plus-circle me-2"></i>Tambah Informasi Baru
                    </h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form id="formTambahInfo" action="../actions/add_info.php" method="POST">
                    <div class="modal-body">
                        <div class="mb-4">
                            <label for="judul" class="form-label">Judul</label>
                            <input type="text" class="form-control form-control-lg" id="judul" name="judul" required>
                        </div>
                        <div class="mb-4">
                            <label for="isi" class="form-label">Isi Informasi</label>
                            <textarea class="form-control" id="isi" name="isi" rows="6" required></textarea>
                        </div>
                        <div class="mb-4">
                            <label for="prioritas" class="form-label">Prioritas</label>
                            <select class="form-select form-select-lg" id="prioritas" name="prioritas">
                                <option value="normal">Normal</option>
                                <option value="tinggi">Tinggi</option>
                            </select>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                            <i class="bi bi-x-circle me-2"></i>Batal
                        </button>
                        <button type="submit" class="btn btn-primary">
                            <i class="bi bi-save me-2"></i>Simpan
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Modal Edit Informasi -->
    <div class="modal fade" id="editInfoModal" tabindex="-1" aria-labelledby="editInfoModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header" style="background: var(--primary-gradient); color: white;">
                    <h5 class="modal-title" id="editInfoModalLabel" style="font-size: 1.25rem;">
                        <i class="bi bi-pencil-square me-2"></i>
                        Edit Informasi
                    </h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form id="editInfoForm">
                    <div class="modal-body">
                        <input type="hidden" id="edit_id_info" name="id_info">
                        <div class="mb-4">
                            <label for="edit_judul" class="form-label">Judul</label>
                            <input type="text" class="form-control form-control-lg" id="edit_judul" name="judul" required>
                        </div>
                        <div class="mb-4">
                            <label for="edit_isi" class="form-label">Isi Informasi</label>
                            <textarea class="form-control" id="edit_isi" name="isi" rows="6" required></textarea>
                        </div>
                        <div class="mb-4">
                            <label for="edit_prioritas" class="form-label">Prioritas</label>
                            <select class="form-select form-select-lg" id="edit_prioritas" name="prioritas">
                                <option value="normal">Normal</option>
                                <option value="tinggi">Tinggi</option>
                            </select>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                            <i class="bi bi-x-circle me-2"></i>Batal
                        </button>
                        <button type="submit" class="btn btn-primary">
                            <i class="bi bi-save me-2"></i>Simpan Perubahan
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <?php include '../includes/footer.php' ?>

    <script>
    // Add loading spinner to button
    function setLoading(button, isLoading) {
        if (isLoading) {
            button.setAttribute('disabled', 'disabled');
            button.innerHTML = '<span class="spinner-border spinner-border-sm me-2"></span>Loading...';
        } else {
            button.removeAttribute('disabled');
            button.innerHTML = button.getAttribute('data-original-html');
        }
    }

    // Show toast notification
    function showToast(message, type = 'success') {
        const toastDiv = document.createElement('div');
        toastDiv.className = `toast align-items-center text-white bg-${type} border-0 position-fixed bottom-0 end-0 m-3`;
        toastDiv.setAttribute('role', 'alert');
        toastDiv.innerHTML = `
            <div class="d-flex">
                <div class="toast-body">${message}</div>
                <button type="button" class="btn-close btn-close-white me-2 m-auto" data-bs-dismiss="toast"></button>
            </div>
        `;
        document.body.appendChild(toastDiv);
        const toast = new bootstrap.Toast(toastDiv);
        toast.show();
        setTimeout(() => toastDiv.remove(), 5000);
    }

    // Form validation
    (function () {
        'use strict'
        var forms = document.querySelectorAll('.needs-validation')
        Array.prototype.slice.call(forms).forEach(function (form) {
            form.addEventListener('submit', function (event) {
                if (!form.checkValidity()) {
                    event.preventDefault()
                    event.stopPropagation()
                }
                form.classList.add('was-validated')
            }, false)
        })
    })()

    // Handle form submissions
    document.addEventListener('DOMContentLoaded', function() {
        const form = document.getElementById('formTambahInfo');
        form.addEventListener('submit', function(e) {
            e.preventDefault();
            
            const submitBtn = form.querySelector('button[type="submit"]');
            submitBtn.setAttribute('data-original-html', submitBtn.innerHTML);
            setLoading(submitBtn, true);

            // Basic validation
            const judul = form.querySelector('[name="judul"]').value.trim();
            const isi = form.querySelector('[name="isi"]').value.trim();

            if (judul.length < 3) {
                showToast('Judul harus minimal 3 karakter', 'warning');
                setLoading(submitBtn, false);
                return;
            }

            if (isi.length < 10) {
                showToast('Isi informasi harus minimal 10 karakter', 'warning');
                setLoading(submitBtn, false);
                return;
            }

            const formData = new FormData(form);
            
            fetch('../actions/add_info.php', {
                method: 'POST',
                body: formData
            })
            .then(response => response.json().then(data => {
                if (!response.ok) throw new Error(data.message || 'Network response was not ok');
                return data;
            }))
            .then(data => {
                if (data.success) {
                    Swal.fire({
                        icon: 'success',
                        title: 'Berhasil!',
                        text: 'Informasi berhasil ditambahkan',
                        timer: 1500
                    }).then(() => {
                        location.reload();
                    });
                } else {
                    throw new Error(data.message || 'Gagal menambah informasi');
                }
            })
            .catch(error => {
                console.error('Error:', error);
                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    text: error.message || 'Terjadi kesalahan saat menambah informasi'
                });
            })
            .finally(() => {
                setLoading(submitBtn, false);
            });
        });
    });

    // Edit Info Function
    function editInfo(id) {
        const editButton = event.target.closest('button');
        editButton.setAttribute('data-original-html', editButton.innerHTML);
        editButton.disabled = true;
        editButton.innerHTML = '<span class="spinner-border spinner-border-sm"></span>';

        fetch(`../actions/get_info.php?id=${id}`)
            .then(response => response.json())
            .then(data => {
                if (data.id_info) {
                    document.getElementById('edit_id_info').value = data.id_info;
                    document.getElementById('edit_judul').value = data.judul;
                    document.getElementById('edit_isi').value = data.isi;
                    document.getElementById('edit_prioritas').value = data.prioritas;
                    
                    new bootstrap.Modal(document.getElementById('editInfoModal')).show();
                } else {
                    throw new Error(data.message || 'Data informasi tidak ditemukan');
                }
            })
            .catch(error => {
                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    text: error.message || 'Terjadi kesalahan saat mengambil data'
                });
            })
            .finally(() => {
                editButton.disabled = false;
                editButton.innerHTML = editButton.getAttribute('data-original-html');
            });
    }

    // Handle Edit Form Submit
    document.getElementById('editInfoForm').addEventListener('submit', function(event) {
        event.preventDefault();
        
        const form = event.target;
        const submitBtn = form.querySelector('button[type="submit"]');
        const originalHtml = submitBtn.innerHTML;
        
        submitBtn.disabled = true;
        submitBtn.innerHTML = '<span class="spinner-border spinner-border-sm me-2"></span>Loading...';

        const formData = new FormData(form);
        
        fetch('../actions/edit_info.php', {
            method: 'POST',
            body: formData
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                Swal.fire({
                    icon: 'success',
                    title: 'Berhasil!',
                    text: 'Informasi berhasil diperbarui',
                    timer: 1500
                }).then(() => {
                    location.reload();
                });
            } else {
                throw new Error(data.message || 'Gagal mengubah informasi');
            }
        })
        .catch(error => {
            Swal.fire({
                icon: 'error',
                title: 'Error',
                text: error.message || 'Terjadi kesalahan saat menyimpan perubahan'
            });
        })
        .finally(() => {
            submitBtn.disabled = false;
            submitBtn.innerHTML = originalHtml;
        });
    });

    // Delete Info Function
    function deleteInfo(id) {
        Swal.fire({
            title: 'Konfirmasi Hapus',
            text: 'Apakah Anda yakin ingin menghapus informasi ini?',
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#dc3545',
            cancelButtonColor: '#6c757d',
            confirmButtonText: 'Ya, Hapus',
            cancelButtonText: 'Batal'
        }).then((result) => {
            if (result.isConfirmed) {
                const deleteButton = event.target.closest('button');
                const originalHtml = deleteButton.innerHTML;
                
                deleteButton.disabled = true;
                deleteButton.innerHTML = '<span class="spinner-border spinner-border-sm"></span>';

                fetch(`../actions/delete_info.php?id=${id}`, {
                    method: 'POST'
                })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        Swal.fire({
                            icon: 'success',
                            title: 'Berhasil',
                            text: 'Informasi berhasil dihapus',
                            timer: 1500
                        }).then(() => {
                            location.reload();
                        });
                    } else {
                        throw new Error(data.message || 'Gagal menghapus informasi');
                    }
                })
                .catch(error => {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: error.message || 'Terjadi kesalahan saat menghapus data'
                    });
                })
                .finally(() => {
                    deleteButton.disabled = false;
                    deleteButton.innerHTML = originalHtml;
                });
            }
        });
    }

    // Auto-dismiss alerts after 5 seconds
    document.addEventListener('DOMContentLoaded', function() {
        setTimeout(function() {
            const alerts = document.querySelectorAll('.alert');
            alerts.forEach(function(alert) {
                const bsAlert = new bootstrap.Alert(alert);
                bsAlert.close();
            });
        }, 5000);
    });

    // Animasi smooth saat modal muncul
    $('#modalTambahInfo').on('show.bs.modal', function (e) {
        $(this).find('.modal-content')
            .css({
                transform: 'scale(0.7)',
                opacity: 0
            })
            .animate({
                transform: 'scale(1)',
                opacity: 1
            }, 300);
    });

    // Handle sidebar toggle effect on content
    document.addEventListener('DOMContentLoaded', function() {
        const contentWrapper = document.querySelector('.content-wrapper');
        const sidebarWrapper = document.querySelector('.sidebar-wrapper');

        // Check initial state
        if (localStorage.getItem('sidebarCollapsed') === 'true') {
            contentWrapper.classList.add('expanded');
            document.body.classList.add('sidebar-collapsed');
        }

        // Listen for sidebar toggle
        document.addEventListener('click', function(e) {
            if (e.target.closest('.sidebar-toggle')) {
                contentWrapper.classList.toggle('expanded');
                document.body.classList.toggle('sidebar-collapsed');
                
                // Trigger resize event to adjust any responsive elements
                window.dispatchEvent(new Event('resize'));
            }
        });

        // Handle responsive behavior
        function handleResponsive() {
            if (window.innerWidth <= 991) {
                contentWrapper.classList.remove('expanded');
                document.body.classList.remove('sidebar-collapsed');
            } else {
                if (localStorage.getItem('sidebarCollapsed') === 'true') {
                    contentWrapper.classList.add('expanded');
                    document.body.classList.add('sidebar-collapsed');
                }
            }
        }

        // Initial check and listen for window resize
        handleResponsive();
        window.addEventListener('resize', handleResponsive);
    });
    </script>
</body>
</html> 