<?php
session_start();
require_once '../config/config.php';

if (!isset($_GET['id'])) {
    $_SESSION['alert'] = [
        'type' => 'danger',
        'message' => 'ID Laporan tidak ditemukan!'
    ];
    header('Location: laporan.php');
    exit();
}

$id_laporan = $_GET['id'];

// Query untuk mengambil data laporan
$query = "SELECT l.*, st.maksud, st.jenis_surat, st.tujuan, st.tempat_kegiatan, st.dasar_surat,
          GROUP_CONCAT(DISTINCT CONCAT_WS('|', 
              p.nama_pegawai, 
              p.nip,
              COALESCE(dst.tujuan_pegawai, ''),
              p.jabatan,
              p.golongan
          ) ORDER BY 
            CASE 
                WHEN p.jabatan LIKE '%Kepala Dinas%' THEN 1
                WHEN p.jabatan LIKE '%Sekretaris%' THEN 2
                WHEN p.jabatan LIKE '%Kepala Bidang%' OR p.jabatan LIKE '%Kabid%' THEN 3
                WHEN p.jabatan LIKE '%Kepala Sub Bagian%' OR p.jabatan LIKE '%Kasubbag%' THEN 4
                WHEN p.jabatan LIKE '%Kepala Seksi%' OR p.jabatan LIKE '%Kasi%' THEN 5
                WHEN p.jabatan LIKE '%Pengawas%' THEN 6
                ELSE 7
            END,
            CASE p.golongan
                WHEN 'PEMBINA UTAMA MUDA (IV/C)' THEN 1
                WHEN 'PEMBINA TK I (IV/B)' THEN 2
                WHEN 'PEMBINA (IV/A)' THEN 3
                WHEN 'PENATA TK I (III/D)' THEN 4
                WHEN 'PENATA (III/C)' THEN 5
                WHEN 'PENATA MUDA TK I (III/B)' THEN 6
                WHEN 'PENATA MUDA (III/A)' THEN 7
                WHEN 'PENGATUR TK I (II/D)' THEN 8
                WHEN 'PENGATUR (II/C)' THEN 9
                WHEN 'PENGATUR MUDA TK I (II/B)' THEN 10
                WHEN 'PENGATUR MUDA (II/A)' THEN 11
                ELSE 12
            END ASC SEPARATOR ';;') as pegawai_data
          FROM laporan l 
          JOIN surat_tugas st ON l.id_surat = st.id_surat 
          JOIN detail_surat_tugas dst ON st.id_surat = dst.id_surat
          JOIN pegawai p ON dst.id_pegawai = p.id_pegawai
          WHERE l.id = ?
          GROUP BY l.id";

$stmt = mysqli_prepare($conn, $query);
mysqli_stmt_bind_param($stmt, "i", $id_laporan);
mysqli_stmt_execute($stmt);
$result = mysqli_stmt_get_result($stmt);
$laporan = mysqli_fetch_assoc($result);

if (!$laporan) {
    $_SESSION['alert'] = [
        'type' => 'danger',
        'message' => 'Data laporan tidak ditemukan!'
    ];
    header('Location: laporan.php');
    exit();
}

// Decode dokumentasi JSON
$dokumentasi = !empty($laporan['dokumentasi']) ? json_decode($laporan['dokumentasi'], true) : [];

// Pastikan $dokumentasi adalah array
if (!is_array($dokumentasi)) {
    $dokumentasi = [];
}

function tanggal_indo($tanggal) {
    $bulan = array(
        1 => 'Januari', 'Februari', 'Maret', 'April', 'Mei', 'Juni',
        'Juli', 'Agustus', 'September', 'Oktober', 'November', 'Desember'
    );
    $split = explode('-', $tanggal);
    return $split[2] . ' ' . $bulan[(int)$split[1]] . ' ' . $split[0];
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Cetak Laporan Perjalanan Dinas - SPPD</title>
    <style>
        @page {
            size: 215.9mm 330mm; /* F4 size */
            margin: 8mm 8mm 8mm 8mm;
        }
        body {
            font-family: Times New Roman, serif;
            line-height: 1.5;
            font-size: 12pt;
            margin: 0;
            padding: 0;
            width: 100%;
        }
        .header {
            text-align: center;
            margin-bottom: 20px;
        }
        .header h2 {
            margin: 0;
            font-size: 14pt;
            text-transform: uppercase;
            font-weight: bold;
        }
        .content {
            margin-bottom: 20px;
        }
        .field-row {
            display: flex;
            align-items: flex-start;
            margin-bottom: 8px;
        }
        .field-label {
            width: 180px;
            padding-right: 5px;
        }
        .field-content {
            flex: 1;
            display: flex;
            align-items: flex-start;
        }
        .colon {
            display: inline-block;
            width: 20px;
            text-align: left;
        }
        .content-value {
            display: inline-block;
            text-align: justify;
            flex: 1;
        }
        .dokumentasi {
            break-inside: avoid;
            margin-top: 20px;
        }
        .dokumentasi img {
            max-width: 300px;
            height: auto;
            margin: 8mm;
            border: 1px solid #ddd;
        }
        .dokumentasi-title {
            font-weight: bold;
            margin-top: 20px;
            margin-bottom: 10px;
        }
        .ttd {
            margin-top: 30px;
            text-align: right;
        }
        .ttd-content {
            display: inline-block;
            text-align: left;
            margin-right: 40px;
        }
        @media print {
            .no-print {
                display: none;
            }
            body {
                width: 215.9mm;
                min-height: 330mm;
            }
        }
    </style>
</head>
<body>
   

    <div class="header">
        <h2>LAPORAN PERJALANAN DINAS</h2>
    </div>

    <div class="content">
        <?php if (empty($laporan['dasar_surat'])): ?>
        <div class="field-row">
            <div class="field-label">Nomor SPPD</div>
            <div class="field-content">
                <span class="colon">:</span>
                <span class="content-value"><?= htmlspecialchars($laporan['no_sppd']) ?></span>
            </div>
        </div>
        <?php else: ?>
        <div class="field-row">
            <div class="field-label">Dasar</div>
            <div class="field-content">
                <span class="colon">:</span>
                <div class="content-value" style="white-space: pre-line;"><?= nl2br(htmlspecialchars($laporan['dasar_surat'])) ?></div>
            </div>
        </div>
        <?php endif; ?>
      
        <div class="field-row">
            <div class="field-label">Tempat Kegiatan</div>
            <div class="field-content">
                <span class="colon">:</span>
                <div class="content-value">
                <?php 
                    if ($laporan['jenis_surat'] === 'Dalam Daerah Dalam Provinsi') {
                        $tujuan_list = [];
                        $tujuan_count = [];
                        if (!empty($laporan['pegawai_data'])) {
                            $pegawai_array = explode(';;', $laporan['pegawai_data']);
                            foreach ($pegawai_array as $pegawai) {
                                $pegawai_info = explode('|', $pegawai);
                                $tujuan_pegawai = isset($pegawai_info[2]) ? trim($pegawai_info[2]) : '';
                                if (!empty($tujuan_pegawai)) {
                                    if (!isset($tujuan_count[$tujuan_pegawai])) {
                                        $tujuan_count[$tujuan_pegawai] = 1;
                                        $tujuan_list[] = $tujuan_pegawai;
                                    } else {
                                        $tujuan_count[$tujuan_pegawai]++;
                                    }
                                }
                            }
                        }
                        if (!empty($tujuan_list)) {
                            echo "<div class='list-container'>";
                            foreach ($tujuan_list as $index => $tujuan) {
                                echo "<div class='list-item'>" . ($index + 1) . ". " . htmlspecialchars($tujuan) . "</div>";
                            }
                            echo "</div>";
                        } else {
                            echo '-';
                        }
                    } else {
                        if (!empty($laporan['tempat_kegiatan'])) {
                            echo htmlspecialchars($laporan['tempat_kegiatan']);
                        } else if (!empty($laporan['tujuan'])) {
                            echo htmlspecialchars($laporan['tujuan']);
                        } else {
                            echo '-';
                        }
                    }
                ?>
                </div>
            </div>
        </div>
        <div class="field-row">
            <div class="field-label">Maksud Perjalanan Dinas</div>
            <div class="field-content">
                <span class="colon">:</span>
                <div class="content-value" style="white-space: pre-line;"><?= htmlspecialchars($laporan['maksud']) ?></div>
            </div>
        </div>
        <div class="field-row">
            <div class="field-label">Tanggal Berangkat</div>
            <div class="field-content">
                <span class="colon">:</span>
                <span class="content-value"><?= tanggal_indo($laporan['tanggal_berangkat']) ?></span>
            </div>
        </div>
        <div class="field-row">
            <div class="field-label">Tanggal Kembali</div>
            <div class="field-content">
                <span class="colon">:</span>
                <span class="content-value"><?= tanggal_indo($laporan['tanggal_kembali']) ?></span>
            </div>
        </div>

        <div style="margin-top: 20px;">
            <strong>HASIL PERJALANAN DINAS:</strong>
            <div style="margin-top: 10px; text-align: justify;">
                <?= nl2br(htmlspecialchars($laporan['isi_laporan'])) ?>
            </div>
        </div>

        <?php if (!empty($dokumentasi)): ?>
        <div class="dokumentasi">
            <div class="dokumentasi-title">DOKUMENTASI KEGIATAN:</div>
            <div style="display: flex; flex-wrap: wrap; justify-content: center;">
                <?php foreach ($dokumentasi as $foto): ?>
                    <img src="../uploads/dokumentasi/<?= htmlspecialchars($foto) ?>" alt="Dokumentasi">
                <?php endforeach; ?>
            </div>
        </div>
        <?php endif; ?>

        <div class="ttd">
            <div style="text-align: center; margin-bottom: 20px;">
                Paringin, <?= tanggal_indo($laporan['tanggal_kembali']) ?><br>
                Yang Membuat Laporan,
            </div>
            
            <table style="width: 100%; margin-top: 30px; border-collapse: collapse;">
                <?php 
                if (!empty($laporan['pegawai_data'])) {
                    $pegawai_array = explode(';;', $laporan['pegawai_data']);
                    foreach ($pegawai_array as $index => $pegawai) {
                        $pegawai_info = explode('|', $pegawai);
                        $nama = $pegawai_info[0];
                        $nip = $pegawai_info[1];
                ?>
                <tr style="height: 40px;">
                    <td style="width: 60%; text-align: left; padding-left: 100px;">
                        <?= ($index + 1) . ". " . htmlspecialchars($nama) ?><br>
                        <span style="margin-left: 15px;">NIP. <?= htmlspecialchars($nip) ?></span>
                        <?php if (!empty($jabatan) && !empty($golongan)): ?>
                        <br><span style="margin-left: 15px; font-size: 11pt; color: #666;"><?= htmlspecialchars($jabatan) ?> - <?= htmlspecialchars($golongan) ?></span>
                        <?php endif; ?>
                    </td>
                    <td style="width: 40%; text-align: center;">
                        (.................................)
                    </td>
                </tr>
                <?php 
                    }
                }
                ?>
            </table>
        </div>
    </div>

    <script>
       window.onload = function() {
            }, 500);
        }
    </script>
</body>
</html> 