<?php
session_start();
require_once '../config/config.php';

// Get user's bidang if admin_sppd or pimpinan
$user_bidang = '';
if ($_SESSION['level'] === 'admin_sppd' || $_SESSION['level'] === 'pimpinan') {
    $user_id = $_SESSION['user_id'];
    $stmt = mysqli_prepare($conn, "SELECT bidang FROM users WHERE id = ?");
    if ($stmt) {
        mysqli_stmt_bind_param($stmt, "i", $user_id);
        mysqli_stmt_execute($stmt);
        $result_user = mysqli_stmt_get_result($stmt);
        if ($user_data = mysqli_fetch_assoc($result_user)) {
            $user_bidang = $user_data['bidang'];
        }
        mysqli_stmt_close($stmt);
    }
}

// Base query
$base_query = "SELECT 
            st.id_surat,
            st.no_sppd,
            st.maksud,
            st.tujuan,
            st.tanggal_berangkat,
            st.tanggal_kembali,
            l.id as id_laporan,
            l.isi_laporan,
            l.dokumentasi
          FROM surat_tugas st
          LEFT JOIN laporan l ON st.id_surat = l.id_surat
          LEFT JOIN users u ON st.created_by = u.id";

// Add WHERE clause for admin_sppd and pimpinan
if (($_SESSION['level'] === 'admin_sppd' || $_SESSION['level'] === 'pimpinan') && !empty($user_bidang)) {
    $query = $base_query . " WHERE u.bidang = ? GROUP BY st.id_surat ORDER BY st.tanggal_surat DESC";
    $stmt = mysqli_prepare($conn, $query);
    if ($stmt) {
        mysqli_stmt_bind_param($stmt, "s", $user_bidang);
        mysqli_stmt_execute($stmt);
        $result = mysqli_stmt_get_result($stmt);
    } else {
        die("Error preparing statement: " . mysqli_error($conn));
    }
} else {
    $query = $base_query . " GROUP BY st.id_surat ORDER BY st.tanggal_surat DESC";
    $result = mysqli_query($conn, $query);
}

if (!$result) {
    die("Error in query: " . mysqli_error($conn));
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Laporan Perjalanan Dinas - SPPD</title>
    <link rel="icon" type="image/svg+xml" href="data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAyNCAyNCI+PHBhdGggZmlsbD0iIzRlNzNkZiIgZD0iTTIwLDhINFY2aDIwdjJIMjB6IE0xNSwxMEg0djJoMTFWMTB6IE00LDE2aDd2Mkg0VjE2eiBNMjEuNywxMy4zTDIwLjMsMTJsMS40LTEuNEMyMi4xLDEwLjIsMjIuMSw5LjgsMjEuNyw5LjRsLTEuMS0xLjFDMjAuMiw3LjksMTkuOCw3LjksMTkuNCw4LjNMMTgsMTBsLTEuNC0xLjRjLTAuNC0wLjQtMS0wLjQtMS40LDBsLTcuNSw3LjVjLTAuMiwwLjItMC4zLDAuNC0wLjMsMC43djIuOWMwLDAuNSwwLjQsMC45LDAuOSwwLjloMi45YzAuMywwLDAuNS0wLjEsMC43LTAuM2w3LjUtNy41QzIyLjEsMTQuMywyMi4xLDEzLjcsMjEuNywxMy4zeiIvPjwvc3ZnPg==">
    <?php include '../includes/header.php' ?>
    <link href='https://unpkg.com/boxicons@2.0.7/css/boxicons.min.css' rel='stylesheet'>
    <style>
        /* Root variables */
        :root {
            --primary-gradient: linear-gradient(135deg, #0ea5e9 0%, #2dd4bf 100%);
            --bg-gradient: linear-gradient(135deg, rgb(245, 255, 254) 0%, rgb(153, 224, 238) 100%);
        }

        .card {
            border: none;
            border-radius: 15px;
            box-shadow: 0 0 20px rgba(0,0,0,0.05);
        }
        
        .card-header {
            background: linear-gradient(135deg, #0ea5e9 0%, #2dd4bf 100%);
            border-radius: 15px 15px 0 0 !important;
            padding: 20px;
            border: none;
        }
        
        .card-header h5 {
            color: white;
            font-weight: 600;
            margin: 0;
            font-size: 1.25rem;
        }

        .table {
            margin-bottom: 0;
            width: 100%;
            table-layout: fixed;
        }

        .table thead th {
            background: linear-gradient(135deg, #0ea5e9 0%, #2dd4bf 100%) !important;
            color: white;
            font-weight: 500;
            padding: 0.8rem 1rem;
            font-size: 0.85rem;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            white-space: nowrap;
            border: none;
        }

        .table tbody td {
            padding: 0.8rem 1rem;
            vertical-align: middle;
            font-size: 0.9rem;
        }

        .table-hover tbody tr:hover {
            background-color: rgba(14, 165, 233, 0.05);
        }

        /* Status badges */
        .badge {
            padding: 8px 12px;
            font-weight: 500;
            border-radius: 8px;
            display: inline-block;
        }

        .badge-success {
            background: linear-gradient(135deg, #0ea5e9 0%, #2dd4bf 100%) !important;
            color: white;
        }

        .badge-warning {
            background: linear-gradient(135deg, #0ea5e9 0%, #2dd4bf 100%) !important;
            color: white;
            opacity: 0.8;
        }

        /* Button styling */
        .btn {
            padding: 8px 16px;
            border-radius: 8px;
            font-weight: 500;
            transition: all 0.3s ease;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            margin: 0 2px;
            white-space: nowrap;
        }

        .btn-sm {
            padding: 6px 12px;
            font-size: 0.875rem;
            min-width: 70px;
        }

        .btn-soft-info,
        .btn-soft-success,
        .btn-soft-danger,
        .btn-soft-primary {
            background: linear-gradient(135deg, #0ea5e9 0%, #2dd4bf 100%);
            color: white;
            border: none;
            transition: all 0.3s ease;
        }

        .btn-soft-info:hover,
        .btn-soft-success:hover,
        .btn-soft-danger:hover,
        .btn-soft-primary:hover {
            background: linear-gradient(135deg, #0891ce 0%, #20b4a3 100%);
            color: white;
            transform: translateY(-2px);
            box-shadow: 0 4px 12px rgba(14, 165, 233, 0.2);
        }

        /* Search and length menu styling */
        .dataTables_wrapper .dataTables_length select,
        .dataTables_wrapper .dataTables_filter input {
            border: 1px solid #e9ecef;
            border-radius: 8px;
            padding: 8px;
        }

        .dataTables_wrapper .dataTables_filter input {
            background-color: #f8f9fa;
            min-width: 250px;
        }

        .dataTables_wrapper .dataTables_filter input:focus {
            border-color: #0ea5e9;
            box-shadow: 0 0 0 0.2rem rgba(14, 165, 233, 0.25);
        }

        /* Action buttons container */
        .action-buttons {
            display: flex;
            gap: 4px;
            justify-content: center;
            flex-wrap: nowrap;
            min-width: 220px;
        }

        .btn i {
            margin-right: 5px;
            font-size: 0.875rem;
            vertical-align: middle;
        }

        /* Table responsive container */
        .table-responsive {
            padding: 1rem;
            border-radius: 12px;
            overflow-x: auto;
            position: relative;
            margin-bottom: 1rem;
            width: 100%;
        }

        /* Sticky action column */
        .table td:last-child,
        .table th:last-child {
            position: sticky;
            right: 0;
            background-color: #fff;
            z-index: 2;
            width: 220px;
            box-shadow: -5px 0 5px rgba(0,0,0,0.05);
        }

        .table thead th:last-child {
            z-index: 3;
            background-color: #f8f9fa;
        }

        /* Styling untuk toggle switch */
        .form-switch {
            padding-left: 2.5em;
        }

        .form-check-input {
            cursor: pointer;
            width: 2em;
        }

        .form-switch .form-check-input {
            background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='-4 -4 8 8'%3e%3ccircle r='3' fill='rgba%28255, 255, 255, 1%29'/%3e%3c/svg%3e");
            background-position: left center;
            border-radius: 2em;
            transition: background-position .15s ease-in-out;
        }

        .form-switch .form-check-input:checked {
            background-position: right center;
            background-color: #4e73df;
            border-color: #4e73df;
        }

        .form-switch .form-check-input:focus {
            box-shadow: 0 0 0 0.2rem rgba(78, 115, 223, 0.25);
        }

        /* Action Toggle Switch Styling */
        .action-toggle {
            position: relative;
            display: inline-block;
            margin-left: 8px;
        }

        .action-toggle-input {
            display: none;
        }

        .action-toggle-label {
            display: block;
            width: 48px;
            height: 24px;
            background: #e9ecef;
            border-radius: 12px;
            cursor: pointer;
            position: relative;
            transition: all 0.3s ease;
        }

        .action-toggle-label:before {
            content: '';
            position: absolute;
            width: 100%;
            height: 100%;
            border-radius: 12px;
            background: linear-gradient(135deg, #4e73df 0%, #224abe 100%);
            opacity: 0;
            transition: all 0.3s ease;
        }

        .action-toggle-handle {
            position: absolute;
            top: 3px;
            left: 3px;
            width: 18px;
            height: 18px;
            background: #fff;
            border-radius: 50%;
            transition: all 0.3s cubic-bezier(0.68, -0.55, 0.265, 1.55);
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
        }

        .action-toggle-input:checked + .action-toggle-label {
            background: rgba(78, 115, 223, 0.2);
        }

        .action-toggle-input:checked + .action-toggle-label:before {
            opacity: 1;
        }

        .action-toggle-input:checked + .action-toggle-label .action-toggle-handle {
            left: 27px;
            background: #fff;
        }

        /* Action buttons animation */
        .action-buttons {
            display: flex;
            gap: 4px;
            justify-content: center;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            opacity: 1;
            transform: scale(1);
            transform-origin: center;
        }

        .action-buttons.hidden {
            opacity: 0;
            transform: scale(0.95);
            pointer-events: none;
        }

        /* Hover effects for toggle */
        .action-toggle-label:hover .action-toggle-handle {
            box-shadow: 0 4px 8px rgba(78, 115, 223, 0.2);
        }

        .action-toggle-label:active .action-toggle-handle {
            width: 22px;
        }

        /* Gaya untuk tombol toggle yang lebih minimalis */
        .btn-toggle {
            background: none;
            border: none;
            color: #4e73df;
            padding: 0;
            width: 24px;
            height: 24px;
            display: flex;
            align-items: center;
            justify-content: center;
            cursor: pointer;
            transition: all 0.3s ease;
            opacity: 0.7;
            margin-left: 8px;
        }

        .btn-toggle:hover {
            opacity: 1;
            transform: scale(1.1);
        }

        .btn-toggle i {
            font-size: 16px;
            transition: all 0.3s ease;
        }

        .btn-toggle.active i {
            transform: scale(1.1);
        }

        .btn-toggle.active i.bi-eye::before {
            content: "\f340";  /* Mengubah ke ikon eye-slash */
        }

        /* Tooltip for toggle button */
        .btn-toggle::after {
            content: "Sembunyikan Aksi";
            position: absolute;
            background: rgba(0,0,0,0.8);
            color: white;
            padding: 4px 8px;
            border-radius: 4px;
            font-size: 12px;
            bottom: -30px;
            right: 0;
            white-space: nowrap;
            opacity: 0;
            visibility: hidden;
            transition: all 0.2s ease;
        }

        .btn-toggle:hover::after {
            opacity: 1;
            visibility: visible;
        }

        .btn-toggle.active::after {
            content: "Tampilkan Aksi";
        }

        /* Styling untuk tombol eye */
        .btn-eye {
            background: none;
            border: none;
            color: #0ea5e9;
            padding: 0;
            width: 24px;
            height: 24px;
            display: flex;
            align-items: center;
            justify-content: center;
            cursor: pointer;
            transition: all 0.3s ease;
            opacity: 0.7;
        }

        .btn-eye:hover {
            opacity: 1;
            transform: scale(1.1);
        }

        .btn-eye.active {
            color: #224abe;
            opacity: 1;
        }

        .btn-eye.active i::before {
            content: "\f340";
        }

        /* Styling untuk container aksi */
        .action-container {
            padding: 12px;
            background: white;
            border-radius: 10px;
            display: flex;
            gap: 8px;
            align-items: center;
            border: 1px solid rgba(14, 165, 233, 0.1);
            box-shadow: 0 2px 8px rgba(14, 165, 233, 0.1);
        }

        /* Animation untuk row aksi */
        @keyframes slideDown {
            from {
                opacity: 0;
                transform: translateY(-10px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        /* Styling untuk row yang aktif */
        .main-row.active {
            background-color: rgba(14, 165, 233, 0.08) !important;
        }

        /* Styling untuk DataTable */
        .dataTables_wrapper .dataTables_filter input {
            border: 1px solid #e9ecef;
            border-radius: 8px;
            padding: 8px 12px;
        }

        .dataTables_wrapper .dataTables_length select {
            border: 1px solid #e9ecef;
            border-radius: 6px;
            padding: 6px 24px 6px 12px;
        }

        /* Status dot styling */
        .status-dot {
            width: 8px;
            height: 8px;
            border-radius: 50%;
            margin-right: 8px;
            position: relative;
            display: inline-block;
        }

        .status-dot::after {
            content: '';
            position: absolute;
            width: 100%;
            height: 100%;
            border-radius: 50%;
            animation: pulse 2s infinite;
            opacity: 0.5;
        }

        .status-done {
            background-color: #198754;
        }

        .status-done::after {
            background-color: #198754;
        }

        .status-pending {
            background-color: #ffc107;
        }

        .status-pending::after {
            background-color: #ffc107;
        }

        @keyframes pulse {
            0% {
                transform: scale(1);
                opacity: 0.5;
            }
            70% {
                transform: scale(1.5);
                opacity: 0;
            }
            100% {
                transform: scale(1);
                opacity: 0;
            }
        }

        /* Tooltip for status dots */
        .status-dot:hover::before {
            content: attr(title);
            position: absolute;
            background: rgba(0, 0, 0, 0.8);
            color: white;
            padding: 4px 8px;
            border-radius: 4px;
            font-size: 12px;
            white-space: nowrap;
            top: -30px;
            left: 50%;
            transform: translateX(-50%);
            z-index: 1000;
        }

        /* Ganti background untuk card body (area di belakang tabel) */
        .card-body {
            background: linear-gradient(135deg, #f6f9ff 0%, #f8f9fa 100%);
            padding: 20px;
            border-radius: 0 0 15px 15px;
        }

        /* Ganti background untuk tabel */
        .table {
            background-color: transparent;
            border-radius: 10px;
            box-shadow: 0 0 15px rgba(0,0,0,0.05);
        }

        /* Ganti background untuk header tabel */
        .table thead th {
            background: linear-gradient(135deg, #0ea5e9 0%, #2dd4bf 100%);
            color: white;
            font-weight: 500;
            padding: 15px;
            white-space: nowrap;
            border: none;
        }

        /* Ganti background untuk baris tabel yang di-hover */
        .table-hover tbody tr:hover {
            background-color: rgba(78, 115, 223, 0.05);
        }

        /* Ganti background untuk container aksi */
        .action-container {
            background: white;
            border: 1px solid #e3e6f0;
            box-shadow: 0 2px 8px rgba(0,0,0,0.05);
        }

        /* Ganti background untuk sticky column */
        .table td:last-child,
        .table th:last-child {
            background-color: white;
        }

        /* Pastikan background tetap konsisten saat hover pada sticky column */
        .table-hover tbody tr:hover td:last-child {
            background-color: rgba(78, 115, 223, 0.05);
        }

        /* Ganti background untuk header sticky column */
        .table thead th:last-child {
            background: linear-gradient(135deg, #0ea5e9 0%, #2dd4bf 100%);
            color: white;
        }

        /* Tambahkan background gradient untuk seluruh halaman */
        .home-section {
            background: linear-gradient(135deg,rgb(231, 255, 255) 0%,rgb(236, 255, 246) 100%);
            min-height: 100vh;
            padding: 20px;
        }

        /* Styling untuk judul halaman */
        .home-section h1 {
            color: white;
            margin-bottom: 0.5rem;
        }

        .home-section p {
            color: rgba(255, 255, 255, 0.8);
        }

        /* Column widths */
        .table th:nth-child(1),
        .table td:nth-child(1) {
            width: 5%;
            text-align: center;
        }

        .table th:nth-child(2),
        .table td:nth-child(2) {
            width: 20%;
        }

        .table th:nth-child(3),
        .table td:nth-child(3) {
            width: 35%;
        }

        .table th:nth-child(4),
        .table td:nth-child(4) {
            width: 15%;
        }

        .table th:nth-child(5),
        .table td:nth-child(5) {
            width: 15%;
        }

        .table th:nth-child(6),
        .table td:nth-child(6) {
            width: 10%;
        }

        @media (max-width: 768px) {
            .table thead th {
                padding: 0.7rem;
                font-size: 0.8rem;
            }
            
            .table tbody td {
                padding: 0.7rem;
                font-size: 0.85rem;
            }
        }
    </style>
</head>
<body>
    <?php include '../includes/sidebar.php' ?>
    
    <section class="home-section">
        <div class="container mt-4">
            <div class="card mb-4">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <div>
                        <h1 class="mb-0">Laporan Perjalanan Dinas</h1>
                        <p class="mb-0">Daftar laporan perjalanan dinas pegawai</p>
                    </div>
                </div>
                <div class="card-body">
                    <?php if (isset($_SESSION['alert'])) : ?>
                        <div class="alert alert-<?= $_SESSION['alert']['type'] ?> alert-dismissible fade show" role="alert">
                            <?= $_SESSION['alert']['message'] ?>
                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                        <?php unset($_SESSION['alert']); ?>
                    <?php endif; ?>

                    <div class="table-responsive">
                        <table class="table table-hover" id="dataLaporan">
                            <thead>
                                <tr>
                                    <th style="width: 5%">No.</th>
                                    <th style="width: 20%">No. SPPD</th>
                                    <th style="width: 35%">Maksud</th>
                                    <th style="width: 15%">Tujuan</th>
                                    <th style="width: 15%">Tanggal Pelaksanaan</th>
                                    <th style="width: 10%">Status</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php 
                                $no = 1;
                                while ($row = mysqli_fetch_assoc($result)) : 
                                ?>
                                <tr class="main-row">
                                    <td class="text-center">
                                        <div class="d-flex align-items-center gap-2">
                                            <span><?= $no++ ?></span>
                                            <div class="d-flex align-items-center">
                                                <button class="btn-eye" onclick="toggleActions(this)" type="button">
                                                    <i class="bi bi-eye"></i>
                                                </button>
                                            </div>
                                        </div>
                                    </td>
                                    <td><?= htmlspecialchars($row['no_sppd']) ?></td>
                                    <td><?= htmlspecialchars($row['maksud']) ?></td>
                                    <td><?= htmlspecialchars($row['tujuan']) ?></td>
                                    <td>
                                        <?= date('d-m-Y', strtotime($row['tanggal_berangkat'])) ?> s/d 
                                        <?= date('d-m-Y', strtotime($row['tanggal_kembali'])) ?>
                                    </td>
                                    <td>
                                        <?php if ($row['id_laporan']): ?>
                                            <span class="badge bg-success">Sudah dibuat</span>
                                        <?php else: ?>
                                            <span class="badge bg-warning">Belum dibuat</span>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                                <tr class="action-row" style="display: none;">
                                    <td colspan="7">
                                        <div class="action-container">
                                            <?php if ($row['id_laporan']): ?>
                                                <a href="edit_laporan.php?id=<?= $row['id_laporan'] ?>" class="btn btn-soft-info btn-sm">
                                                    <i class="bi bi-pencil"></i> Edit
                                                </a>
                                                
                                                <a href="cetak_laporan.php?id=<?= $row['id_laporan'] ?>" class="btn btn-soft-success btn-sm" target="_blank">
                                                    <i class="bi bi-printer"></i> Cetak
                                                </a>
                                            
                                            <?php else: ?>
                                                <a href="tambah_laporan.php?id_surat=<?= $row['id_surat'] ?>" class="btn btn-soft-success btn-sm">
                                                    <i class="bi bi-plus-circle"></i> Buat Laporan
                                                </a>
                                            <?php endif; ?>
                                        </div>
                                    </td>
                                </tr>
                                <?php endwhile; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <?php include '../includes/footer.php' ?>

    <script>
        function toggleActions(button) {
            const mainRow = button.closest('tr');
            const actionRow = mainRow.nextElementSibling;
            const icon = button.querySelector('i');
            
            // Toggle active state for button and row
            button.classList.toggle('active');
            mainRow.classList.toggle('active');
            
            // Show/hide action row with animation
            if (actionRow.style.display === 'none') {
                actionRow.style.display = 'table-row';
                actionRow.querySelector('.action-container').style.animation = 'slideDown 0.3s ease-out';
            } else {
                const container = actionRow.querySelector('.action-container');
                container.style.animation = 'slideDown 0.3s ease-out reverse';
                setTimeout(() => {
                    actionRow.style.display = 'none';
                }, 280);
            }
        }

        $(document).ready(function() {
            $('#dataLaporan').DataTable({
                "responsive": true,
                "language": {
                    "url": "//cdn.datatables.net/plug-ins/1.10.24/i18n/Indonesian.json"
                },
                "order": [[2, "desc"]], // Urutkan berdasarkan tanggal surat (kolom ke-3) secara descending
                "pageLength": 10,
                "lengthMenu": [[10, 25, 50, -1], [10, 25, 50, "Semua"]]
            });
        });

        function hapusLaporan(id) {
            Swal.fire({
                title: 'Apakah Anda yakin?',
                text: "Laporan yang dihapus tidak dapat dikembalikan!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#dc3545',
                cancelButtonColor: '#6c757d',
                confirmButtonText: 'Ya, hapus!',
                cancelButtonText: 'Batal',
                reverseButtons: true
            }).then((result) => {
                if (result.isConfirmed) {
                    window.location.href = 'hapus_laporan.php?id=' + id;
                }
            });
        }
    </script>
</body>
</html> 