<?php
session_start();
require_once '../config/config.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        // Validasi input
        if (empty($_POST['id_surat'])) throw new Exception("ID Surat tidak ditemukan");
        if (empty($_POST['isi_laporan'])) throw new Exception("Isi laporan wajib diisi");

        $id_surat = $_POST['id_surat'];
        $no_sppd = $_POST['no_sppd'];
        $isi_laporan = $_POST['isi_laporan'];
        
        // Ambil data surat tugas
        $query_surat = "SELECT tempat_kegiatan, tanggal_berangkat, tanggal_kembali FROM surat_tugas WHERE id_surat = ?";
        $stmt = mysqli_prepare($conn, $query_surat);
        mysqli_stmt_bind_param($stmt, "i", $id_surat);
        mysqli_stmt_execute($stmt);
        $result = mysqli_stmt_get_result($stmt);
        $surat = mysqli_fetch_assoc($result);

        // Ambil nama pegawai
        $query_pegawai = "SELECT GROUP_CONCAT(p.nama_pegawai ORDER BY 
            CASE 
                WHEN p.jabatan LIKE '%Kepala%' THEN 1
                WHEN p.jabatan LIKE '%Sekretaris%' THEN 2
                WHEN p.jabatan LIKE '%Kabid%' THEN 3
                WHEN p.jabatan LIKE '%Kasubbag%' THEN 4
                WHEN p.jabatan LIKE '%Kasi%' THEN 5
                ELSE 6
            END,
            CASE 
                WHEN p.golongan LIKE 'IV/%' THEN 1
                WHEN p.golongan LIKE 'III/%' THEN 2
                WHEN p.golongan LIKE 'II/%' THEN 3
                WHEN p.golongan LIKE 'I/%' THEN 4
                ELSE 5
            END ASC
            SEPARATOR ', ') as nama_pegawai
            FROM detail_surat_tugas dst 
            JOIN pegawai p ON dst.id_pegawai = p.id_pegawai 
            WHERE dst.id_surat = ?";
        
        $stmt = mysqli_prepare($conn, $query_pegawai);
        mysqli_stmt_bind_param($stmt, "i", $id_surat);
        mysqli_stmt_execute($stmt);
        $result = mysqli_stmt_get_result($stmt);
        $pegawai = mysqli_fetch_assoc($result);

        // Proses upload dokumentasi
        $dokumentasi = [];
        if (!empty($_FILES['dokumentasi']['name'][0])) {
            $upload_dir = '../uploads/dokumentasi/';
            $max_size = 2 * 1024 * 1024; // 2MB in bytes
            
            // Buat direktori jika belum ada
            if (!file_exists($upload_dir)) {
                mkdir($upload_dir, 0777, true);
            }

            foreach ($_FILES['dokumentasi']['tmp_name'] as $key => $tmp_name) {
                $file_name = $_FILES['dokumentasi']['name'][$key];
                $file_size = $_FILES['dokumentasi']['size'][$key];
                $file_ext = strtolower(pathinfo($file_name, PATHINFO_EXTENSION));
                
                // Validasi ukuran file
                if ($file_size > $max_size) {
                    throw new Exception("File {$file_name} melebihi batas ukuran maksimal (2MB)");
                }

                // Validasi ekstensi file
                $allowed_ext = ['jpg', 'jpeg', 'png'];
                if (!in_array($file_ext, $allowed_ext)) {
                    throw new Exception("File {$file_name} harus berformat jpg, jpeg, atau png");
                }

                // Generate nama file unik
                $unique_name = date('YmdHis') . '_' . uniqid() . '.' . $file_ext;
                $destination = $upload_dir . $unique_name;

                if (move_uploaded_file($tmp_name, $destination)) {
                    $dokumentasi[] = $unique_name;
                } else {
                    throw new Exception("Gagal mengupload file {$file_name}");
                }
            }
        }

        mysqli_begin_transaction($conn);

        // Simpan data laporan
        $query = "INSERT INTO laporan (id_surat, no_sppd, nama_pegawai, tempat_kegiatan, 
                                     tanggal_berangkat, tanggal_kembali, isi_laporan, dokumentasi) 
                  VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
        
        $stmt = mysqli_prepare($conn, $query);
        $dokumentasi_json = !empty($dokumentasi) ? json_encode($dokumentasi) : null;
        
        mysqli_stmt_bind_param($stmt, "ssssssss", 
            $id_surat,
            $no_sppd,
            $pegawai['nama_pegawai'],
            $surat['tempat_kegiatan'],
            $surat['tanggal_berangkat'],
            $surat['tanggal_kembali'],
            $isi_laporan,
            $dokumentasi_json
        );

        if (!mysqli_stmt_execute($stmt)) {
            throw new Exception("Gagal menyimpan laporan: " . mysqli_error($conn));
        }

        mysqli_commit($conn);

        $_SESSION['alert'] = [
            'type' => 'success',
            'message' => 'Laporan berhasil disimpan'
        ];

        header('Location: laporan.php');
        exit();

    } catch (Exception $e) {
        mysqli_rollback($conn);
        
        // Hapus file yang sudah diupload jika ada error
        if (!empty($dokumentasi)) {
            foreach ($dokumentasi as $file) {
                $file_path = $upload_dir . $file;
                if (file_exists($file_path)) {
                    unlink($file_path);
                }
            }
        }

        $_SESSION['alert'] = [
            'type' => 'danger',
            'message' => 'Error: ' . $e->getMessage()
        ];
        
        header('Location: tambah_laporan.php?id_surat=' . $id_surat);
        exit();
    }
} else {
    header('Location: laporan.php');
    exit();
} 