<?php
session_start();
require_once '../config/config.php';
require_once '../config/koneksi.php';

// Add this after session_start()
define('MAX_FILE_SIZE', 16 * 1024 * 1024); // 16MB in bytes

// Fungsi untuk membersihkan tag HTML
function cleanHTML($text) {
    // Hapus semua tag HTML dan decode entities
    $text = html_entity_decode($text, ENT_QUOTES | ENT_HTML5, 'UTF-8');
    $text = strip_tags($text);
    // Konversi baris baru menjadi format yang sesuai
    $text = str_replace(["\r\n", "\r", "\n"], "\n", $text);
    // Hapus multiple baris kosong
    $text = preg_replace("/\n\s+\n/", "\n\n", $text);
    // Trim whitespace
    $text = trim($text);
    return $text;
}

// Cek apakah ini mode edit (ada no_sppd yang dikirim)
$is_edit = isset($_GET['no_sppd']);
$no_sppd = $is_edit ? $_GET['no_sppd'] : '';

// Jika mode edit, ambil data yang ada
if ($is_edit) {
    $query = "SELECT l.*, st.no_surat, st.no_sppd, st.tanggal_surat, st.tanggal_berangkat, st.tanggal_kembali, 
              st.maksud, st.tujuan, p.nama_pegawai, p.nip 
              FROM surat_tugas st
              LEFT JOIN laporan l ON st.id_surat = l.id_surat
              JOIN detail_surat_tugas dst ON st.id_surat = dst.id_surat
              JOIN pegawai p ON dst.id_pegawai = p.id_pegawai
              WHERE st.no_sppd = ?";

    $stmt = mysqli_prepare($conn, $query);
    mysqli_stmt_bind_param($stmt, "s", $no_sppd);
    mysqli_stmt_execute($stmt);
    $result = mysqli_stmt_get_result($stmt);
    
    if (!$result) {
        die("Error in query: " . mysqli_error($conn));
    }
    
    $data = mysqli_fetch_assoc($result);
    
    if (!$data) {
        echo "<script>
                alert('Data tidak ditemukan!');
                window.location.href = 'laporan.php';
              </script>";
        exit;
    }
}

// Jika form disubmit
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $no_sppd = $_POST['no_sppd'];
    $tempat_kegiatan = $_POST['tempat_kegiatan'];
    $isi_laporan = cleanHTML($_POST['isi_laporan']);
    $dokumentasi = [];
    $upload_error = false;

    // Process file uploads with size validation
    if (!empty($_FILES['dokumentasi']['name'][0])) {
        $upload_dir = "../uploads/dokumentasi/";
        
        foreach ($_FILES['dokumentasi']['tmp_name'] as $key => $tmp_name) {
            if ($_FILES['dokumentasi']['error'][$key] == 0) {
                // Check file size
                if ($_FILES['dokumentasi']['size'][$key] > MAX_FILE_SIZE) {
                    $_SESSION['alert'] = [
                        'type' => 'danger',
                        'message' => 'File ' . $_FILES['dokumentasi']['name'][$key] . ' melebihi batas ukuran 16MB'
                    ];
                    $upload_error = true;
                    break;
                }

                $file_extension = pathinfo($_FILES['dokumentasi']['name'][$key], PATHINFO_EXTENSION);
                $file_name = date('YmdHis') . '_' . uniqid() . '.' . $file_extension;
                
                if (move_uploaded_file($tmp_name, $upload_dir . $file_name)) {
                    $dokumentasi[] = $file_name;
                }
            }
        }
    }

    if ($upload_error) {
        // If there was an upload error, don't proceed with saving
        header('Location: ' . $_SERVER['PHP_SELF'] . '?id_surat=' . $id_surat);
        exit();
    }

    // Dapatkan id_surat dari no_sppd
    $query_id = "SELECT id_surat FROM surat_tugas WHERE no_sppd = ?";
    $stmt = mysqli_prepare($conn, $query_id);
    mysqli_stmt_bind_param($stmt, "s", $no_sppd);
    mysqli_stmt_execute($stmt);
    $result_id = mysqli_stmt_get_result($stmt);
    $row_id = mysqli_fetch_assoc($result_id);
    $id_surat = $row_id['id_surat'];

    if ($is_edit) {
        // Mode Update
        $query = "UPDATE laporan SET 
                  tempat_kegiatan = ?,
                  isi_laporan = ?,
                  dokumentasi = ?
                  WHERE id_surat = ?";
        
        $stmt = mysqli_prepare($conn, $query);
        mysqli_stmt_bind_param($stmt, "sssi", $tempat_kegiatan, $isi_laporan, implode(',', $dokumentasi), $id_surat);
    } else {
        // Mode Insert
        $query = "INSERT INTO laporan (id_surat, tempat_kegiatan, isi_laporan, dokumentasi) 
                  VALUES (?, ?, ?, ?)";
        
        $stmt = mysqli_prepare($conn, $query);
        mysqli_stmt_bind_param($stmt, "isss", $id_surat, $tempat_kegiatan, $isi_laporan, implode(',', $dokumentasi));
    }

    if (mysqli_stmt_execute($stmt)) {
        echo "<script>
                alert('Data berhasil " . ($is_edit ? "diupdate!" : "disimpan!") . "');
                window.location.href = 'laporan.php';
              </script>";
    } else {
        echo "<script>
                alert('Gagal " . ($is_edit ? "mengupdate" : "menyimpan") . " data: " . mysqli_error($conn) . "');
              </script>";
    }
}

// Cek apakah ada parameter id_surat
if (!isset($_GET['id_surat'])) {
    $_SESSION['alert'] = [
        'type' => 'danger',
        'message' => 'ID Surat tidak ditemukan!'
    ];
    header('Location: laporan.php');
    exit();
}

$id_surat = $_GET['id_surat'];

// Query untuk mengambil data surat tugas
$query = "SELECT 
            st.*, 
            GROUP_CONCAT(DISTINCT CONCAT_WS('|', 
                p.nama_pegawai,
                COALESCE(dst.tujuan_pegawai, ''),
                p.jabatan,
                p.golongan
            ) ORDER BY 
                CASE p.golongan
                    WHEN 'PEMBINA UTAMA MUDA (IV/C)' THEN 1
                    WHEN 'PEMBINA TK I (IV/B)' THEN 2
                    WHEN 'PEMBINA (IV/A)' THEN 3
                    WHEN 'PENATA TK I (III/D)' THEN 4
                    WHEN 'PENATA (III/C)' THEN 5
                    WHEN 'PENATA MUDA TK I (III/B)' THEN 6
                    WHEN 'PENATA MUDA (III/A)' THEN 7
                    WHEN 'PENGATUR TK I (II/D)' THEN 8
                    WHEN 'PENGATUR (II/C)' THEN 9
                    WHEN 'PENGATUR MUDA TK I (II/B)' THEN 10
                    WHEN 'PENGATUR MUDA (II/A)' THEN 11
                    ELSE 12
                END ASC SEPARATOR ';;') as pegawai_data
          FROM surat_tugas st
          LEFT JOIN detail_surat_tugas dst ON st.id_surat = dst.id_surat
          LEFT JOIN pegawai p ON dst.id_pegawai = p.id_pegawai
          WHERE st.id_surat = ?
          GROUP BY st.id_surat";

$stmt = mysqli_prepare($conn, $query);
mysqli_stmt_bind_param($stmt, "i", $id_surat);
mysqli_stmt_execute($stmt);
$result = mysqli_stmt_get_result($stmt);
$surat = mysqli_fetch_assoc($result);

if (!$surat) {
    $_SESSION['alert'] = [
        'type' => 'danger',
        'message' => 'Data surat tugas tidak ditemukan!'
    ];
    header('Location: laporan.php');
    exit();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Tambah Laporan Perjalanan Dinas - SPPD</title>
    <link rel="icon" type="image/svg+xml" href="data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAyNCAyNCI+PHBhdGggZmlsbD0iIzRlNzNkZiIgZD0iTTIwLDhINFY2aDIwdjJIMjB6IE0xNSwxMEg0djJoMTFWMTB6IE00LDE2aDd2Mkg0VjE2eiBNMjEuNywxMy4zTDIwLjMsMTJsMS40LTEuNEMyMi4xLDEwLjIsMjIuMSw5LjgsMjEuNyw5LjRsLTEuMS0xLjFDMjAuMiw3LjksMTkuOCw3LjksMTkuNCw4LjNMMTgsMTBsLTEuNC0xLjRjLTAuNC0wLjQtMS0wLjQtMS40LDBsLTcuNSw3LjVjLTAuMiwwLjItMC4zLDAuNC0wLjMsMC43djIuOWMwLDAuNSwwLjQsMC45LDAuOSwwLjloMi45YzAuMywwLDAuNS0wLjEsMC43LTAuM2w3LjUtNy41QzIyLjEsMTQuMywyMi4xLDEzLjcsMjEuNywxMy4zeiIvPjwvc3ZnPg==">
    
    <?php include '../includes/header.php' ?>
    <!-- Include Bootstrap 4 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        :root {
            --primary-color: #2D3748;
            --secondary-color: #4A5568;
            --accent-color: #3182CE;
            --background-color: #F7FAFC;
            --border-color: #E2E8F0;
            --success-color: #48BB78;
            --danger-color: #F56565;
            --card-shadow: 0 1px 3px 0 rgba(0, 0, 0, 0.1), 0 1px 2px 0 rgba(0, 0, 0, 0.06);
        }

        body {
            background-color: var(--background-color);
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, 'Helvetica Neue', Arial, sans-serif;
            color: var(--primary-color);
            line-height: 1.5;
        }

        .card {
            border: 1px solid var(--border-color);
            border-radius: 8px;
            box-shadow: var(--card-shadow);
            background: white;
            margin-bottom: 2rem;
        }

        .card-header {
            background: white;
            border-bottom: 1px solid var(--border-color);
            padding: 1.25rem;
            border-radius: 8px 8px 0 0;
        }

        .card-header h5 {
            color: var(--primary-color);
            font-weight: 600;
            font-size: 1.25rem;
            margin: 0;
        }

        .card-body {
            padding: 1.5rem;
        }

        .form-control {
            border: 1px solid var(--border-color);
            border-radius: 6px;
            padding: 0.5rem 0.75rem;
            font-size: 0.875rem;
            transition: all 0.2s ease;
        }

        .form-control:focus {
            border-color: var(--accent-color);
            box-shadow: 0 0 0 3px rgba(49, 130, 206, 0.1);
            outline: none;
        }

        .form-group label {
            color: var(--secondary-color);
            font-weight: 500;
            font-size: 0.875rem;
            margin-bottom: 0.5rem;
        }

        .btn {
            font-weight: 500;
            padding: 0.5rem 1rem;
            border-radius: 6px;
            font-size: 0.875rem;
            transition: all 0.2s ease;
        }

        .btn-primary {
            background-color: var(--accent-color);
            border-color: var(--accent-color);
        }

        .btn-primary:hover {
            background-color: #2C5282;
            border-color: #2C5282;
        }

        .btn-secondary {
            background-color: #718096;
            border-color: #718096;
        }

        .btn-secondary:hover {
            background-color: #4A5568;
            border-color: #4A5568;
        }

        .table {
            margin-bottom: 0;
        }

        .table th {
            background-color: var(--background-color);
            color: var(--secondary-color);
            font-weight: 600;
            border-bottom: 2px solid var(--border-color);
            padding: 0.75rem;
        }

        .table td {
            padding: 0.75rem;
            color: var(--primary-color);
            border-top: 1px solid var(--border-color);
        }

        .note-editor {
            border-radius: 6px;
            border-color: var(--border-color) !important;
        }

        .note-editor.note-frame {
            border: 1px solid var(--border-color);
        }

        .note-editor.note-frame .note-editing-area {
            background-color: white;
        }

        .alert {
            border-radius: 6px;
            border: none;
            padding: 1rem;
            margin-bottom: 1rem;
        }

        .alert-success {
            background-color: #F0FFF4;
            color: #2F855A;
        }

        .alert-danger {
            background-color: #FFF5F5;
            color: #C53030;
        }

        /* Custom styles for documentation section */
        .dokumentasi-container {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(200px, 1fr));
            gap: 1rem;
            margin-top: 1rem;
        }

        .dokumentasi-item {
            position: relative;
            border-radius: 8px;
            overflow: hidden;
            box-shadow: var(--card-shadow);
            aspect-ratio: 16/9;
            background: #f8f9fa;
        }

        .dokumentasi-item img {
            width: 100%;
            height: 100%;
            object-fit: cover;
            transition: transform 0.3s ease;
        }

        .dokumentasi-item:hover img {
            transform: scale(1.05);
        }

        .dokumentasi-item .remove-btn {
            position: absolute;
            top: 8px;
            right: 8px;
            background: rgba(0, 0, 0, 0.6);
            color: white;
            border: none;
            border-radius: 50%;
            width: 28px;
            height: 28px;
            display: flex;
            align-items: center;
            justify-content: center;
            cursor: pointer;
            transition: all 0.2s ease;
            font-size: 18px;
            z-index: 2;
        }

        .dokumentasi-item .remove-btn:hover {
            background: rgba(220, 53, 69, 0.9);
            transform: scale(1.1);
        }

        #image-preview {
            margin-top: 1rem;
        }

        /* Minimalist textarea styles */
        .form-control.minimal-textarea {
            min-height: 200px;
            font-size: 14px;
            line-height: 1.6;
            padding: 12px;
            resize: vertical;
            background-color: #FAFAFA;
            border: 1px solid var(--border-color);
            transition: all 0.2s ease;
        }

        .form-control.minimal-textarea:focus {
            background-color: white;
            border-color: var(--accent-color);
            box-shadow: 0 0 0 2px rgba(49, 130, 206, 0.1);
        }

        .form-control.minimal-textarea::placeholder {
            color: #A0AEC0;
        }

        .table-pegawai {
            width: 100%;
            border-collapse: collapse;
            background-color: white;
            border-radius: 8px;
            overflow: hidden;
        }

        .table-pegawai th {
            background-color: #F7FAFC;
            padding: 12px;
            text-align: left;
            font-weight: 600;
            color: #4A5568;
            border-bottom: 2px solid #E2E8F0;
        }

        .table-pegawai td {
            padding: 12px;
            border-bottom: 1px solid #E2E8F0;
            color: #2D3748;
        }

        .table-pegawai tr:last-child td {
            border-bottom: none;
        }

        .table-pegawai tr:hover {
            background-color: #F7FAFC;
        }
    </style>
</head>
<body>
    
    <div class="container mt-4">
        <div class="card mb-5">
            <div class="card-header">
                <h5 class="card-title">
                    <i class="bi bi-file-earmark-text me-2"></i>
                    Tambah Laporan Perjalanan Dinas
                </h5>
            </div>
            <div class="card-body">
                <form action="proses_tambah_laporan.php" method="post" enctype="multipart/form-data">
                    <input type="hidden" name="id_surat" value="<?= $id_surat ?>">
                    <input type="hidden" name="no_sppd" value="<?= $surat['no_sppd'] ?>">
                    
                    <div class="row mb-3">
                        <label class="col-sm-2 col-form-label">No. SPPD</label>
                        <div class="col-sm-10">
                            <input type="text" class="form-control" value="<?= htmlspecialchars($surat['no_sppd']) ?>" readonly>
                        </div>
                    </div>

                    <div class="row mb-3">
                        <label class="col-sm-2 col-form-label">Tempat Kegiatan</label>
                        <div class="col-sm-10">
                            <?php if ($surat['jenis_surat'] === 'Dalam Daerah Dalam Provinsi'): ?>
                                <div class="form-control" style="height: auto;" readonly>
                                    <?php 
                                    if (!empty($surat['pegawai_data'])) {
                                        $pegawai_array = explode(';;', $surat['pegawai_data']);
                                        foreach ($pegawai_array as $index => $pegawai) {
                                            $pegawai_info = explode('|', $pegawai);
                                            $tujuan_pegawai = isset($pegawai_info[1]) ? $pegawai_info[1] : '';
                                            if (!empty($tujuan_pegawai)) {
                                                echo ($index + 1) . ". " . htmlspecialchars($tujuan_pegawai) . "<br>";
                                            }
                                        }
                                    } else {
                                        echo '<span class="text-secondary">-</span>';
                                    }
                                    ?>
                                </div>
                            <?php else: ?>
                                <input type="text" class="form-control" value="<?= !empty($surat['tempat_kegiatan']) ? htmlspecialchars($surat['tempat_kegiatan']) : htmlspecialchars($surat['tujuan']) ?>" readonly>
                            <?php endif; ?>
                        </div>
                    </div>

                    <div class="row mb-3">
                        <label class="col-sm-2 col-form-label">Nama Pegawai</label>
                        <div class="col-sm-10">
                            <div class="table-responsive">
                                <table class="table-pegawai">
                                    <thead>
                                        <tr>
                                            <th width="5%">No</th>
                                            <th width="35%">Nama Pegawai</th>
                                            <th width="30%">Jabatan</th>
                                            <th width="30%">Golongan</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php 
                                        if (!empty($surat['pegawai_data'])) {
                                            $pegawai_array = explode(';;', $surat['pegawai_data']);
                                            foreach ($pegawai_array as $index => $pegawai) {
                                                $pegawai_info = explode('|', $pegawai);
                                                $nama_pegawai = $pegawai_info[0];
                                                $jabatan = isset($pegawai_info[2]) ? $pegawai_info[2] : '-';
                                                $golongan = isset($pegawai_info[3]) ? $pegawai_info[3] : '-';
                                                ?>
                                                <tr>
                                                    <td><?= $index + 1 ?></td>
                                                    <td><?= htmlspecialchars($nama_pegawai) ?></td>
                                                    <td><?= htmlspecialchars($jabatan) ?></td>
                                                    <td><?= htmlspecialchars($golongan) ?></td>
                                                </tr>
                                                <?php
                                            }
                                        } else {
                                            echo '<tr><td colspan="4" class="text-center text-muted py-3">Tidak ada data pegawai</td></tr>';
                                        }
                                        ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>

                    <div class="row mb-3">
                        <label class="col-sm-2 col-form-label">Tanggal Berangkat</label>
                        <div class="col-sm-10">
                            <input type="text" class="form-control" value="<?= date('d-m-Y', strtotime($surat['tanggal_berangkat'])) ?>" readonly>
                        </div>
                    </div>

                    <div class="row mb-3">
                        <label class="col-sm-2 col-form-label">Tanggal Kembali</label>
                        <div class="col-sm-10">
                            <input type="text" class="form-control" value="<?= date('d-m-Y', strtotime($surat['tanggal_kembali'])) ?>" readonly>
                        </div>
                    </div>

                    <div class="row mb-3">
                        <label class="col-sm-2 col-form-label">Isi Laporan <span class="text-danger">*</span></label>
                        <div class="col-sm-10">
                            <textarea class="form-control minimal-textarea" id="isi_laporan" name="isi_laporan" rows="10" placeholder="Tuliskan isi laporan perjalanan dinas di sini..."><?= isset($data['isi_laporan']) ? cleanHTML($data['isi_laporan']) : '' ?></textarea>
                        </div>
                    </div>

                    <div class="row mb-3">
                        <label class="col-sm-2 col-form-label">Dokumentasi</label>
                        <div class="col-sm-10">
                            <input type="file" class="form-control" name="dokumentasi[]" accept="image/*" multiple onchange="previewImages(this)">
                            <small class="text-muted">
                                Upload foto dokumentasi kegiatan:<br>
                                - Bisa upload lebih dari satu foto<br>
                                - Format yang diperbolehkan: jpg, jpeg, png<br>
                                - Maksimal ukuran per file: 16MB
                            </small>
                            <div id="image-preview" class="dokumentasi-container"></div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-sm-10 offset-sm-2">
                            <button type="submit" class="btn btn-primary">
                                <i class="bi bi-save"></i> Simpan Laporan
                            </button>
                            <a href="laporan.php" class="btn btn-secondary">
                                <i class="bi bi-arrow-left"></i> Kembali
                            </a>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <?php include '../includes/footer.php' ?>
    
    <!-- Include jQuery -->
    <script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
    <!-- Include Bootstrap 4 Bundle JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.0/dist/js/bootstrap.bundle.min.js"></script>

    <script>
        // File size validation (16MB limit)
        const MAX_FILE_SIZE = 16 * 1024 * 1024; // 16MB in bytes

        function validateFileSize(input) {
            const files = input.files;
            let totalSize = 0;
            let oversizedFiles = [];

            for (let i = 0; i < files.length; i++) {
                totalSize += files[i].size;
                if (files[i].size > MAX_FILE_SIZE) {
                    oversizedFiles.push(files[i].name);
                }
            }

            if (oversizedFiles.length > 0) {
                alert('File berikut melebihi batas 16MB:\n' + oversizedFiles.join('\n'));
                input.value = '';
                return false;
            }

            return true;
        }

        // Preview images before upload with validation
        function previewImages(input) {
            if (!validateFileSize(input)) {
                return;
            }

            const preview = document.getElementById('image-preview');
            preview.innerHTML = '';
            
            for (let i = 0; i < input.files.length; i++) {
                const file = input.files[i];
                if (!file.type.startsWith('image/')) {
                    continue;
                }

                const reader = new FileReader();
                reader.onload = function(e) {
                    const div = document.createElement('div');
                    div.className = 'preview-item';
                    
                    const img = document.createElement('img');
                    img.src = e.target.result;
                    img.className = 'preview-image';
                    
                    const removeBtn = document.createElement('button');
                    removeBtn.type = 'button';
                    removeBtn.className = 'preview-remove';
                    removeBtn.innerHTML = '×';
                    removeBtn.onclick = function() {
                        div.remove();
                        // Reset file input if all previews are removed
                        if (preview.children.length === 0) {
                            input.value = '';
                        }
                    };
                    
                    div.appendChild(img);
                    div.appendChild(removeBtn);
                    preview.appendChild(div);
                };
                reader.readAsDataURL(file);
            }
        }
    </script>
</body>
</html> 