<?php
session_start();
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login SPPD</title>
    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="assets/img/pemkab.png">
    <link rel="shortcut icon" type="image/x-icon" href="assets/img/pemkab.png">
    
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.8.1/font/bootstrap-icons.css">
    <style>
        body {
            font-family: 'Poppins', sans-serif;
            background-image: url('assets/img/peta.png') !important;
            background-size: cover !important;
            background-position: center !important;
            background-repeat: no-repeat !important;
            background-attachment: fixed !important;
            min-height: 100vh;
        }
        .login-card {
            background: rgba(255, 255, 255, 0.9);
            border-radius: 20px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
            backdrop-filter: blur(10px);
            border: 1px solid rgba(255, 255, 255, 0.3);
            padding: 3rem;
            animation: fadeIn 0.5s ease-out;
        }
        .system-title {
            color: white;
            text-shadow: 0 4px 6px rgba(0, 0, 0, 0.2);
            animation: slideDown 0.5s ease-out;
        }
        .form-control {
            border-radius: 10px;
            padding: 1rem 1.25rem;
            border: 1px solid #e1e1e1;
            transition: all 0.3s ease;
        }
        .form-control:focus {
            box-shadow: 0 0 0 0.25rem rgba(78, 115, 223, 0.25);
            border-color: #86b7fe;
        }
        .btn-login {
            border-radius: 10px;
            padding: 1rem;
            font-weight: 600;
            transition: all 0.3s ease;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border: none;
        }
        .btn-login:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 20px rgba(102, 126, 234, 0.3);
        }
        .input-group-text {
            border-radius: 10px 0 0 10px;
            border: 1px solid #e1e1e1;
            background-color: #f8f9fc;
        }
        .password-toggle {
            position: absolute;
            right: 10px;
            top: 50%;
            transform: translateY(-50%);
            cursor: pointer;
            color: #64748b;
            padding: 5px;
            z-index: 10;
        }
        
        .password-toggle:hover {
            color: #667eea;
        }
        
        .password-field-container {
            position: relative;
        }

        .input-group input[type="password"] {
            padding-right: 40px;
        }
        .register-link {
            color: #667eea;
            text-decoration: none;
            font-weight: 500;
            transition: all 0.3s ease;
        }
        .register-link:hover {
            color: #764ba2;
            text-decoration: underline;
        }
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(20px); }
            to { opacity: 1; transform: translateY(0); }
        }
        @keyframes slideDown {
            from { opacity: 0; transform: translateY(-20px); }
            to { opacity: 1; transform: translateY(0); }
        }
        .logo-container {
            width: 80px;
            height: 80px;
            margin: 0 auto 1.5rem;
            background: white;
            border-radius: 50%;
            padding: 15px;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
        }
        .logo-container img {
            width: 100%;
            height: 100%;
            object-fit: contain;
        }
        .divider {
            margin: 2rem 0;
            border-top: 1px solid rgba(0, 0, 0, 0.1);
            position: relative;
        }
        
        .divider-text {
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            background: white;
            padding: 0 1rem;
            color: #64748b;
        }

        .btn-print-card {
            background: linear-gradient(135deg, #34d399 0%, #059669 100%);
            border: none;
            border-radius: 10px;
            padding: 1rem;
            font-weight: 600;
            transition: all 0.3s ease;
        }

        .btn-print-card:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 20px rgba(52, 211, 153, 0.3);
        }
    </style>
</head>
<body class="d-flex align-items-center">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-5">
                <div class="text-center mb-4">
                    <h1 class="system-title mb-2">SPPD System</h1>
                    <p class="text-white mb-5">Sistem Informasi Perjalanan Dinas</p>
                </div>
                <div class="login-card">
                    <div class="logo-container">
                        <img src="assets/img/logo.png" alt="Logo SPPD">
                    </div>
                    <h3 class="text-center mb-4">Login</h3>
                    
                    <?php if(isset($_SESSION['error'])): ?>
                        <div class="alert alert-danger alert-dismissible fade show" role="alert">
                            <?php 
                                echo $_SESSION['error'];
                                unset($_SESSION['error']);
                            ?>
                            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                        </div>
                    <?php endif; ?>

                    <form action="process_login.php" method="POST">
                        <div class="mb-4">
                            <div class="input-group">
                                <span class="input-group-text">
                                    <i class="bi bi-person"></i>
                                </span>
                                <input type="text" class="form-control" name="username" 
                                       placeholder="Username" required>
                            </div>
                        </div>
                        <div class="mb-4">
                            <div class="input-group password-field-container">
                                <span class="input-group-text">
                                    <i class="bi bi-lock"></i>
                                </span>
                                <input type="password" class="form-control" name="password" id="password" 
                                       placeholder="Password" required>
                                <i class="bi bi-eye-slash password-toggle" data-target="password"></i>
                            </div>
                        </div>
                        <button type="submit" class="btn btn-login btn-primary w-100 mb-4">
                            <i class="bi bi-box-arrow-in-right me-2"></i>Login
                        </button>
                        <p class="text-center mb-0">
                            Belum punya akun? 
                            <a href="register.php" class="register-link">Daftar disini</a>
                        </p>
                    </form>

                    <div class="divider">
                        <span class="divider-text">atau</span>
                    </div>

                    <!-- Form Cetak ID Card -->
                    <form action="absensi/cetak_id_card_public.php" method="POST" target="_blank">
                        <h5 class="text-center mb-4">Cetak ID Card Absensi Peserta <br><small class="text-muted">Bimtek/Pelatihan/FGD/Sejenisnya</small></h5>
                        
                        <div class="mb-4">
                            <div class="input-group">
                                <span class="input-group-text">
                                    <i class="bi bi-person-badge"></i>
                                </span>
                                <input type="text" class="form-control" name="nip" id="nipInput"
                                       placeholder="Contoh: 12345678 123456 1 002" required
                                       maxlength="21">
                            </div>
                           
                        </div>
                        <button type="submit" class="btn btn-print-card btn-success w-100">
                            <i class="bi bi-printer me-2"></i>Cetak ID Card
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script>
        $(document).ready(function() {
            // Password Toggle Visibility
            $('.password-toggle').on('click', function() {
                const target = $(this).data('target');
                const input = $(`#${target}`);
                const type = input.attr('type');
                
                if (type === 'password') {
                    input.attr('type', 'text');
                    $(this).removeClass('bi-eye-slash').addClass('bi-eye');
                } else {
                    input.attr('type', 'password');
                    $(this).removeClass('bi-eye').addClass('bi-eye-slash');
                }
            });

            // Format NIP input
            $('#nipInput').on('input', function(e) {
                let input = $(this).val().replace(/[^0-9]/g, ''); // Hanya ambil angka
                
                if (input.length > 18) {
                    input = input.substr(0, 18);
                }

                let formatted = '';
                
                if (input.length > 0) {
                    // Format: XXXXXXXX XXXXXX X XXX
                    formatted = input.substr(0, 8);
                    
                    if (input.length > 8) {
                        formatted += ' ' + input.substr(8, 6);
                    }
                    
                    if (input.length > 14) {
                        formatted += ' ' + input.substr(14, 1);
                    }
                    
                    if (input.length > 15) {
                        formatted += ' ' + input.substr(15);
                    }
                }
                
                $(this).val(formatted);
            });

            // Validasi sebelum submit
            $('form[action="absensi/cetak_id_card_public.php"]').on('submit', function(e) {
                const nip = $('#nipInput').val().replace(/\s/g, '');
                if (nip.length !== 18) {
                    e.preventDefault();
                    Swal.fire({
                        icon: 'error',
                        title: 'Format NIP Salah',
                        text: 'NIP harus 18 digit angka dengan format: XXXXXXXX XXXXXX X XXX',
                        confirmButtonColor: '#3085d6'
                    });
                }
            });
        });
    </script>
    <?php if(isset($_SESSION['login_error'])): ?>
        <script>
        Swal.fire({
            icon: 'error',
            title: 'Login Gagal',
            text: '<?php echo $_SESSION['login_error']; ?>',
            timer: 3000,
            timerProgressBar: true,
            showConfirmButton: false
        });
        <?php unset($_SESSION['login_error']); ?>
        </script>
    <?php endif; ?>
</body>
</html> 