<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Sistem Dalam Pemeliharaan</title>
    <!-- Favicon -->
    <link rel="icon" type="image/svg+xml" href="data:image/svg+xml;base64,PHN2ZyB4bWxucyA9ICJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgdmlld0JveD0iMCAwIDI0IDI0IiBmaWxsPSJub25lIiBzdHJva2U9IiMwZWE1ZTkiIHN0cm9rZS13aWR0aD0iMiIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIj48cGF0aCBkPSJNMTQuNyA2LjNhMSAxIDAgMCAwIDAgMS40bDEuNiAxLjZhMSAxIDAgMCAwIDEuNCAwbDMuNzctMy43N2E2IDYgMCAwIDEtNy45NCA3Ljk0bC02LjkxIDYuOTFhMi4xMiAyLjEyIDAgMCAxLTMtM2w2LjkxLTYuOTFhNiA2IDAgMCAxIDcuOTQtNy45NGwtMy43NiAzLjc2eiI+PC9wYXRoPjwvc3ZnPg==">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.8.1/font/bootstrap-icons.css">
    <style>
        body {
            height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            background: linear-gradient(135deg, rgb(245, 255, 254) 0%, rgb(153, 224, 238) 100%);
        }
        .maintenance-container {
            text-align: center;
            padding: 2rem;
            background: white;
            border-radius: 20px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
            max-width: 600px;
            width: 90%;
        }
        .maintenance-icon {
            font-size: 5rem;
            color: #0ea5e9;
            margin-bottom: 1.5rem;
            display: inline-block;
            animation: spin 8s linear infinite;
        }
        @keyframes spin {
            0% {
                transform: rotate(0deg);
            }
            100% {
                transform: rotate(360deg);
            }
        }
        .maintenance-icon:hover {
            animation-play-state: paused;
        }
        .maintenance-title {
            font-size: 2rem;
            color: #1f2937;
            margin-bottom: 1rem;
        }
        .maintenance-message {
            color: #4b5563;
            margin-bottom: 2rem;
        }
        .btn-refresh {
            background: linear-gradient(135deg, #0ea5e9 0%, #2dd4bf 100%);
            border: none;
            padding: 0.75rem 1.5rem;
            color: white;
            border-radius: 10px;
            font-weight: 500;
            text-decoration: none;
            transition: all 0.3s ease;
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
        }
        .btn-refresh:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(14, 165, 233, 0.2);
            color: white;
        }
        .btn-refresh i {
            transition: transform 0.3s ease;
        }
        .btn-refresh:hover i {
            transform: rotate(180deg);
        }
    </style>
</head>
<body>
    <?php
    require_once 'config/config.php';
    $maintenance_message = $settings['maintenance_message'] ?? 'Sistem sedang dalam pemeliharaan. Silakan coba beberapa saat lagi.';
    ?>
    
    <div class="maintenance-container">
        <i class="bi bi-gear-fill maintenance-icon"></i>
        <h1 class="maintenance-title">Sistem Dalam Pemeliharaan</h1>
        <p class="maintenance-message"><?= htmlspecialchars($maintenance_message) ?></p>
        <a href="index.php" class="btn-refresh">
            <i class="bi bi-arrow-clockwise"></i>
            <span>Muat Ulang</span>
        </a>
    </div>
</body>
</html> 