<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>404 - Page Not Found</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700&display=swap" rel="stylesheet">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Poppins', sans-serif;
            background: linear-gradient(135deg, #0f172a 0%, #1e293b 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            overflow: hidden;
            color: #e2e8f0;
        }

        .container {
            text-align: center;
            padding: 2rem;
            position: relative;
            z-index: 1;
        }

        .error-code {
            font-size: 180px;
            font-weight: bold;
            line-height: 1;
            margin-bottom: 1rem;
            position: relative;
            text-shadow: 0 0 10px #60a5fa,
                         0 0 20px #60a5fa,
                         0 0 30px #60a5fa,
                         0 0 40px #3b82f6;
            animation: float 6s ease-in-out infinite;
            color: #f8fafc;
        }

        .error-code::after {
            content: '404';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            color: rgba(59, 130, 246, 0.5);
            z-index: -1;
            transform: translateY(5px);
            filter: blur(15px);
        }

        .message {
            font-size: 28px;
            margin-bottom: 2rem;
            opacity: 0;
            animation: fadeIn 1s ease forwards;
            animation-delay: 0.5s;
            text-shadow: 0 0 8px rgba(226, 232, 240, 0.5);
        }

        .description {
            font-size: 18px;
            margin-bottom: 2rem;
            opacity: 0;
            animation: fadeIn 1s ease forwards;
            animation-delay: 0.7s;
            color: #94a3b8;
        }

        .back-button {
            display: inline-block;
            padding: 15px 30px;
            background: rgba(59, 130, 246, 0.2);
            color: #f8fafc;
            text-decoration: none;
            border-radius: 30px;
            font-weight: 500;
            transition: all 0.3s ease;
            opacity: 0;
            animation: fadeIn 1s ease forwards;
            animation-delay: 0.9s;
            backdrop-filter: blur(10px);
            border: 1px solid rgba(59, 130, 246, 0.3);
            box-shadow: 0 0 15px rgba(59, 130, 246, 0.3);
        }

        .back-button:hover {
            background: rgba(59, 130, 246, 0.4);
            transform: translateY(-2px);
            box-shadow: 0 0 25px rgba(59, 130, 246, 0.5);
        }

        .particles {
            position: absolute;
            width: 100%;
            height: 100%;
            top: 0;
            left: 0;
            overflow: hidden;
            z-index: 0;
        }

        .particle {
            position: absolute;
            width: 10px;
            height: 10px;
            background: rgba(59, 130, 246, 0.5);
            border-radius: 50%;
            animation: moveParticle 15s infinite linear;
            box-shadow: 0 0 10px rgba(59, 130, 246, 0.8);
        }

        @keyframes float {
            0%, 100% { transform: translateY(0) rotate(0deg); }
            25% { transform: translateY(-20px) rotate(2deg); }
            50% { transform: translateY(0) rotate(0deg); }
            75% { transform: translateY(20px) rotate(-2deg); }
        }

        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(20px); }
            to { opacity: 1; transform: translateY(0); }
        }

        @keyframes moveParticle {
            0% {
                transform: translate(0, 0) scale(1);
                opacity: 0;
            }
            10% { opacity: 1; }
            90% { opacity: 1; }
            100% {
                transform: translate(var(--move-x), var(--move-y)) scale(0);
                opacity: 0;
            }
        }

        .glitch {
            position: relative;
        }

        .glitch::before,
        .glitch::after {
            content: '404';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            overflow: hidden;
            background: #0f172a;
        }

        .glitch::before {
            left: 2px;
            text-shadow: -2px 0 #ff00c1;
            animation: glitch-1 2s infinite linear;
            clip-path: polygon(0 0, 100% 0, 100% 45%, 0 45%);
        }

        .glitch::after {
            left: -2px;
            text-shadow: 2px 0 #00fff9;
            animation: glitch-2 2s infinite linear;
            clip-path: polygon(0 55%, 100% 55%, 100% 100%, 0 100%);
        }

        @keyframes glitch-1 {
            0% { transform: translateX(0); }
            80% { transform: translateX(0); }
            85% { transform: translateX(2px); }
            90% { transform: translateX(-2px); }
            95% { transform: translateX(2px); }
            100% { transform: translateX(0); }
        }

        @keyframes glitch-2 {
            0% { transform: translateX(0); }
            80% { transform: translateX(0); }
            85% { transform: translateX(-2px); }
            90% { transform: translateX(2px); }
            95% { transform: translateX(-2px); }
            100% { transform: translateX(0); }
        }

        .circles {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            overflow: hidden;
            z-index: 0;
        }

        .circles li {
            position: absolute;
            display: block;
            list-style: none;
            width: 20px;
            height: 20px;
            background: rgba(59, 130, 246, 0.2);
            animation: animate 25s linear infinite;
            bottom: -150px;
            border-radius: 50%;
            box-shadow: 0 0 15px rgba(59, 130, 246, 0.5);
            backdrop-filter: blur(5px);
        }

        .circles li:nth-child(1) {
            left: 25%;
            width: 80px;
            height: 80px;
            animation-delay: 0s;
        }

        .circles li:nth-child(2) {
            left: 10%;
            width: 20px;
            height: 20px;
            animation-delay: 2s;
            animation-duration: 12s;
        }

        .circles li:nth-child(3) {
            left: 70%;
            width: 20px;
            height: 20px;
            animation-delay: 4s;
        }

        .circles li:nth-child(4) {
            left: 40%;
            width: 60px;
            height: 60px;
            animation-delay: 0s;
            animation-duration: 18s;
        }

        .circles li:nth-child(5) {
            left: 65%;
            width: 20px;
            height: 20px;
            animation-delay: 0s;
        }

        .circles li:nth-child(6) {
            left: 75%;
            width: 110px;
            height: 110px;
            animation-delay: 3s;
        }

        .circles li:nth-child(7) {
            left: 35%;
            width: 150px;
            height: 150px;
            animation-delay: 7s;
        }

        .circles li:nth-child(8) {
            left: 50%;
            width: 25px;
            height: 25px;
            animation-delay: 15s;
            animation-duration: 45s;
        }

        .circles li:nth-child(9) {
            left: 20%;
            width: 15px;
            height: 15px;
            animation-delay: 2s;
            animation-duration: 35s;
        }

        .circles li:nth-child(10) {
            left: 85%;
            width: 150px;
            height: 150px;
            animation-delay: 0s;
            animation-duration: 11s;
        }

        @keyframes animate {
            0% {
                transform: translateY(0) rotate(0deg) scale(1);
                opacity: 1;
                border-radius: 50%;
            }
            100% {
                transform: translateY(-1000px) rotate(720deg) scale(0.5);
                opacity: 0;
                border-radius: 50%;
            }
        }
    </style>
</head>
<body>
    <div class="page-wrapper">
        <ul class="circles">
            <li></li>
            <li></li>
            <li></li>
            <li></li>
            <li></li>
            <li></li>
            <li></li>
            <li></li>
            <li></li>
            <li></li>
        </ul>
        <div class="container">
            <div class="error-code glitch">404</div>
            <h1 class="message">Oops! Halaman Tidak Ditemukan</h1>
            <p class="description">Maaf, halaman yang Anda cari tidak dapat ditemukan atau telah dipindahkan.</p>
           
    </div>

    <script>
        // Create floating particles
        function createParticles() {
            const particlesContainer = document.createElement('div');
            particlesContainer.className = 'particles';
            document.body.appendChild(particlesContainer);

            for (let i = 0; i < 50; i++) {
                const particle = document.createElement('div');
                particle.className = 'particle';
                
                // Random starting position
                particle.style.left = Math.random() * 100 + '%';
                particle.style.top = Math.random() * 100 + '%';
                
                // Random movement direction
                const moveX = (Math.random() - 0.5) * 500;
                const moveY = (Math.random() - 0.5) * 500;
                particle.style.setProperty('--move-x', `${moveX}px`);
                particle.style.setProperty('--move-y', `${moveY}px`);
                
                // Random size
                const size = Math.random() * 5 + 2;
                particle.style.width = `${size}px`;
                particle.style.height = `${size}px`;
                
                // Random delay
                particle.style.animationDelay = `${Math.random() * 5}s`;
                
                particlesContainer.appendChild(particle);
            }
        }

        // Initialize particles
        createParticles();

        // Add glitch effect on hover
        const errorCode = document.querySelector('.error-code');
        errorCode.addEventListener('mouseover', () => {
            errorCode.style.animation = 'glitch 0.3s linear infinite';
        });
        errorCode.addEventListener('mouseout', () => {
            errorCode.style.animation = 'float 6s ease-in-out infinite';
        });
    </script>
</body>
</html> 