<?php
require_once '../config/config.php';

// Koneksi database
require_once '../config/koneksi.php';

// Cek koneksi
if (!$conn) {
    die("Koneksi database gagal: " . mysqli_connect_error());
}

require_once '../config/database.php';

if(isset($_POST['submit'])) {
    // Ambil data dari form
    $nama_pegawai = mysqli_real_escape_string($conn, $_POST['nama_pegawai']);
    $nip = mysqli_real_escape_string($conn, $_POST['nip']);
    $jabatan = mysqli_real_escape_string($conn, $_POST['jabatan']);
    $golongan = mysqli_real_escape_string($conn, $_POST['golongan']);
    $unit_kerja = mysqli_real_escape_string($conn, $_POST['unit_kerja']);

    // Query insert dengan prepared statement
    $query = "INSERT INTO pegawai (nama_pegawai, nip, jabatan, golongan, unit_kerja) VALUES (?, ?, ?, ?, ?)";
    $stmt = mysqli_prepare($conn, $query);
    mysqli_stmt_bind_param($stmt, "sssss", $nama_pegawai, $nip, $jabatan, $golongan, $unit_kerja);
    
    if(mysqli_stmt_execute($stmt)) {
        echo "<script>
                alert('Data berhasil ditambahkan!');
                window.location.href = '../pegawai/pegawai.php';
              </script>";
    } else {
        echo "<script>
                alert('Error: " . mysqli_error($conn) . "');
                window.location.href = '../pegawai/pegawai.php';
              </script>";
    }
    mysqli_stmt_close($stmt);
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Tambah Data Pegawai - SPPD</title>
    <link rel="icon" type="image/svg+xml" href="data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAyNCAyNCI+PHBhdGggZmlsbD0iIzRlNzNkZiIgZD0iTTIwLDhINFY2aDIwdjJIMjB6IE0xNSwxMEg0djJoMTFWMTB6IE00LDE2aDd2Mkg0VjE2eiBNMjEuNywxMy4zTDIwLjMsMTJsMS40LTEuNEMyMi4xLDEwLjIsMjIuMSw5LjgsMjEuNyw5LjRsLTEuMS0xLjFDMjAuMiw3LjksMTkuOCw3LjksMTkuNCw4LjNMMTgsMTBsLTEuNC0xLjRjLTAuNC0wLjQtMS0wLjQtMS40LDBsLTcuNSw3LjVjLTAuMiwwLjItMC4zLDAuNC0wLjMsMC43djIuOWMwLDAuNSwwLjQsMC45LDAuOSwwLjloMi45YzAuMywwLDAuNS0wLjEsMC43LTAuM2w3LjUtNy41QzIyLjEsMTQuMywyMi4xLDEzLjcsMjEuNywxMy4zeiIvPjwvc3ZnPg==">
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Bootstrap Icons -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css" rel="stylesheet">
    
    <style>
        body {
            background: linear-gradient(135deg, #2c3e50 0%, #3a4f63 100%);
            min-height: 100vh;
        }

        .container {
            padding: 30px 15px;
        }

        .card {
            background: rgba(231, 248, 185, 0.95);
            border: none;
            border-radius: 20px;
            box-shadow: 0 15px 35px rgba(0, 0, 0, 0.1);
            overflow: hidden;
        }

        .card-header {
            background: linear-gradient(135deg, #4e73df 0%, #224abe 100%);
            padding: 25px 30px;
            border: none;
        }

        .card-header h5 {
            color: #fff;
            font-size: 1.5rem;
            font-weight: 600;
            margin: 0;
            display: flex;
            align-items: center;
        }

        .card-header h5 i {
            margin-right: 10px;
            font-size: 1.8rem;
        }

        .card-body {
            padding: 40px;
        }

        /* Form Group Styling */
        .mb-4 {
            margin-bottom: 25px;
        }

        .form-label {
            color: #2c3e50;
            font-weight: 600;
            font-size: 0.95rem;
            margin-bottom: 10px;
        }

        .input-group {
            box-shadow: 0 3px 10px rgba(0, 0, 0, 0.05);
            border-radius: 12px;
            overflow: hidden;
        }

        .input-group-text {
            background-color: #f8f9fc;
            border: 1px solid #e0e3e8;
            border-right: none;
            padding: 12px 15px;
        }

        .input-group-text i {
            color: #4e73df;
            font-size: 1.2rem;
        }

        .form-control, .form-select {
            border: 1px solid #e0e3e8;
            padding: 12px 15px;
            font-size: 0.95rem;
            transition: all 0.3s ease;
        }

        .form-control:focus, .form-select:focus {
            border-color: #4e73df;
            box-shadow: 0 0 0 0.2rem rgba(78, 115, 223, 0.15);
        }

        /* Required Field Indicator */
        .required-label::after {
            content: ' *';
            color: #e74a3b;
        }

        /* Button Styling */
        .btn {
            padding: 12px 25px;
            font-weight: 600;
            border-radius: 10px;
            transition: all 0.3s ease;
        }

        .btn-primary {
            background: linear-gradient(135deg, #4e73df 0%, #224abe 100%);
            border: none;
        }

        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(78, 115, 223, 0.3);
        }

        .btn-secondary {
            background: #eaecf4;
            color: #2c3e50;
            border: none;
        }

        .btn-secondary:hover {
            background: #dde0e9;
            transform: translateY(-2px);
        }

        /* File Input Styling */
        input[type="file"].form-control {
            padding: 8px 12px;
        }

        /* Textarea Styling */
        textarea.form-control {
            min-height: 100px;
            resize: vertical;
        }

        /* Helper Text */
        .form-text {
            color: #858796;
            font-size: 0.85rem;
            margin-top: 5px;
        }

        /* Button Group */
        .d-flex.gap-2 {
            gap: 15px;
        }

        .btn i {
            margin-right: 8px;
        }

        /* Hover Effects */
        .input-group:hover {
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.08);
        }

        /* Animation */
        .card {
            animation: slideIn 0.5s ease-out;
        }

        @keyframes slideIn {
            from {
                opacity: 0;
                transform: translateY(20px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
    </style>
</head>
<body>
<?php
require_once $_SERVER['DOCUMENT_ROOT'] . '/sppd/config/config.php';
require_once '../vendor/autoload.php';
include_once ROOT_PATH . '/includes/footer.php';
?>

<div class="container"></div>
    <div class="row justify-content-center">
        <div class="col-lg-8">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0"><i class="bi bi-person-plus me-2"></i>Form Data Pegawai</h5>
                </div>
                
                <div class="card-body p-4">
                    <form action="" method="POST" class="needs-validation" novalidate>
                        

                        <!-- Status Kepegawaian - wajib diisi -->
                        <div class="mb-4">
                            <label class="form-label required-label">Status Kepegawaian</label>
                            <div class="input-group">
                                <span class="input-group-text"><i class="bi bi-person-badge"></i></span>
                                <select name="status_kepegawaian" class="form-select" required>
                                    <option value="">Pilih Status Kepegawaian</option>
                                    <option value="PNS">PNS</option>
                                    <option value="PPPK">PPPK</option>
                                    <option value="PPPK Paruh Waktu">PPPK Paruh Waktu</option>
                                    <option value="Non ASN">Non ASN</option>
                                </select>
                            </div>
                            <div class="invalid-feedback">Status kepegawaian wajib dipilih</div>
                        </div>

                        <!-- NIP/NIPPPK - tidak wajib diisi -->
                        <div class="mb-4">
                            <label class="form-label">NIP/NIPPPK (Opsional)</label>
                            <div class="input-group">
                                <span class="input-group-text"><i class="bi bi-person-vcard"></i></span>
                                <input type="text" name="nip" class="form-control" placeholder="Masukkan NIP/NIPPPK jika ada">
                            </div>
                            <div class="form-text">Kosongkan jika pegawai tidak memiliki NIP/NIPPPK</div>
                        </div>

                        <!-- Nama - wajib diisi -->
                        <div class="mb-4">
                            <label class="form-label required-label">Nama Pegawai</label>
                            <div class="input-group">
                                <span class="input-group-text"><i class="bi bi-person"></i></span>
                                <input type="text" name="nama_pegawai" class="form-control" required>
                            </div>
                            <div class="invalid-feedback">Nama pegawai wajib diisi</div>
                        </div>

                        <!-- Jabatan - wajib diisi -->
                        <div class="mb-4">
                            <label class="form-label required-label">Jabatan</label>
                            <div class="input-group">
                                <span class="input-group-text"><i class="bi bi-briefcase"></i></span>
                                <input type="text" name="jabatan" class="form-control" required>
                            </div>
                            <div class="invalid-feedback">Jabatan wajib diisi</div>
                        </div>

                        <!-- Golongan - opsional -->
                        <div class="mb-4">
                            <label class="form-label">Golongan</label>
                            <div class="input-group">
                                <span class="input-group-text"><i class="bi bi-diagram-3"></i></span>
                                <select name="golongan" class="form-select">
                                    <option value="">Pilih Golongan</option>
                                    <option value="Non ASN">Non ASN</option>
                                    <option value="IX (IX)">IX (IX)</option>
                                    <option value="Juru Muda (I/a)">Juru Muda (I/a)</option>
                                    <option value="Juru Muda Tingkat I (I/b)">Juru Muda Tingkat I (I/b)</option>
                                    <option value="Juru (I/c)">Juru (I/c)</option>
                                    <option value="Juru Tingkat I (I/d)">Juru Tingkat I (I/d)</option>
                                    <option value="Pengatur Muda (II/a)">Pengatur Muda (II/a)</option>
                                    <option value="Pengatur Muda Tingkat I (II/b)">Pengatur Muda Tingkat I (II/b)</option>
                                    <option value="Pengatur (II/c)">Pengatur (II/c)</option>
                                    <option value="Pengatur Tingkat I (II/d)">Pengatur Tingkat I (II/d)</option>
                                    <option value="Penata Muda (III/a)">Penata Muda (III/a)</option>
                                    <option value="Penata Muda Tingkat I (III/b)">Penata Muda Tingkat I (III/b)</option>
                                    <option value="Penata (III/c)">Penata (III/c)</option>
                                    <option value="Penata Tingkat I (III/d)">Penata Tingkat I (III/d)</option>
                                    <option value="Pembina (IV/a)">Pembina (IV/a)</option>
                                    <option value="Pembina Tingkat I (IV/b)">Pembina Tingkat I (IV/b)</option>
                                    <option value="Pembina Utama Muda (IV/c)">Pembina Utama Muda (IV/c)</option>
                                    <option value="Pembina Utama Madya (IV/d)">Pembina Utama Madya (IV/d)</option>
                                    <option value="Pembina Utama (IV/e)">Pembina Utama (IV/e)</option>
                                </select>
                            </div>
                        </div>
                           <!-- Unit Kerja - wajib diisi -->
                         <div class="mb-3">
                            <label class="form-label">Unit Kerja</label>
                            <input type="text" class="form-control" name="unit_kerja" required>
                        </div>
                        <!-- Alamat - opsional -->
                        <div class="mb-4">
                            <label class="form-label">Alamat</label>
                            <div class="input-group">
                                <span class="input-group-text"><i class="bi bi-geo-alt"></i></span>
                                <textarea name="alamat" class="form-control" rows="3"></textarea>
                            </div>
                        </div>
                       
                        <!-- No Telp - opsional -->
                        <div class="mb-4">
                            <label class="form-label">No. Telepon</label>
                            <div class="input-group">
                                <span class="input-group-text"><i class="bi bi-telephone"></i></span>
                                <input type="tel" name="no_telp" class="form-control">
                            </div>
                        </div>
                        <!-- Foto Pegawai - opsional -->
                        <div class="mb-4">
                            <label class="form-label">Foto Pegawai (Opsional)</label>
                            <div class="input-group">
                                <span class="input-group-text"><i class="bi bi-image"></i></span>
                                <input type="file" name="foto" class="form-control" accept="image/*">
                            </div>
                            <div class="form-text">Format yang diizinkan: JPG, JPEG, PNG. Maksimal 2MB</div>
                        </div>

                        <!-- Submit Buttons -->
                        <div class="d-flex gap-2 mt-5">
                            <button type="submit" name="submit" class="btn btn-primary">
                                <i class="bi bi-save me-2"></i>Simpan Data
                            </button>
                            <button type="reset" class="btn btn-secondary">
                                <i class="bi bi-arrow-clockwise me-2"></i>Reset
                            </button>
                            <a href="../pegawai/pegawai.php" class="btn btn-primary">
                                <i class="bi bi-arrow-left me-2"></i>Kembali
                            </a>
                        </div>
                      
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Import Modal -->
<div class="modal fade" id="importModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Import Data Pegawai</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form action="import.php" method="POST" enctype="multipart/form-data">
                <div class="modal-body">
                    <div class="mb-4">
                        <label class="form-label">File Excel</label>
                        <input type="file" class="form-control" name="file" accept=".xls,.xlsx" required>
                        <div class="form-text">
                            Format yang didukung: XLS, XLSX. 
                            <a href="../template/template_pegawai.xlsx" class="text-primary">Download Template</a>
                        </div>
                    </div>
                    
                    <div class="alert alert-info">
                        <h6 class="alert-heading mb-2">Petunjuk Import:</h6>
                        <ol class="mb-0 ps-3">
                            <li>Download template Excel yang telah disediakan</li>
                            <li>Isi data sesuai dengan format yang ada</li>
                            <li>Pastikan tidak ada kolom yang kosong untuk data wajib</li>
                            <li>Upload file yang telah diisi</li>
                        </ol>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                    <button type="submit" class="btn btn-primary">
                        <i class="bi bi-upload me-2"></i>Upload
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Bootstrap JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

<!-- Form Validation -->
<script>
(function () {
    'use strict'
    var forms = document.querySelectorAll('.needs-validation')
    Array.prototype.slice.call(forms).forEach(function (form) {
        form.addEventListener('submit', function (event) {
            if (!form.checkValidity()) {
                event.preventDefault()
                event.stopPropagation()
            }
            form.classList.add('was-validated')
        }, false)
    })
})()
</script>

<!-- Add preview image script before closing body tag -->
<script>
document.querySelector('input[type="file"]').addEventListener('change', function(e) {
    const file = e.target.files[0];
    if (file) {
        // Only validate file type
        if (!file.type.match('image.*')) {
            alert('Hanya file gambar yang diizinkan');
            this.value = '';
            return;
        }
        
        // Preview image
        const reader = new FileReader();
        reader.onload = function(e) {
            // If you have a preview element
            if(document.querySelector('#preview-image')) {
                document.querySelector('#preview-image').src = e.target.result;
            }
        }
        reader.readAsDataURL(file);
    }
});
</script>

</body>
</html> 
