<?php
session_start();
require_once '../config/database.php';
require_once '../config/config.php';

// Pastikan direktori upload ada
$upload_dir = '../assets/img/pegawai/';
if (!file_exists($upload_dir)) {
    mkdir($upload_dir, 0777, true);
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $id = $_POST['id_pegawai'];
    $nama = $_POST['nama_pegawai'];
    $nip = $_POST['nip'];
    $jabatan = $_POST['jabatan'];
    $golongan = $_POST['golongan'];
    $unit_kerja = $_POST['unit_kerja'];
    
    // Inisialisasi variabel foto
    $foto = $_POST['old_foto']; // Gunakan foto lama sebagai default
    
    // Handle file upload
    if (isset($_FILES['foto']) && $_FILES['foto']['error'] == 0) {
        $allowed = ['jpg', 'jpeg', 'png'];
        $filename = $_FILES['foto']['name'];
        $ext = strtolower(pathinfo($filename, PATHINFO_EXTENSION));
        
        if (in_array($ext, $allowed)) {
            // Generate nama file baru
            $new_filename = uniqid('pegawai_') . '.' . $ext;
            $upload_path = $upload_dir . $new_filename;
            
            // Upload file
            if (move_uploaded_file($_FILES['foto']['tmp_name'], $upload_path)) {
                // Jika berhasil upload, update nama foto di database
                $foto = $new_filename;
                
                // Hapus foto lama jika bukan foto default
                if (!empty($_POST['old_foto']) && $_POST['old_foto'] != 'default.jpg') {
                    $old_path = $upload_dir . $_POST['old_foto'];
                    if (file_exists($old_path)) {
                        unlink($old_path);
                    }
                }
            } else {
                $_SESSION['alert'] = [
                    'type' => 'error',
                    'message' => 'Gagal mengupload foto'
                ];
                header("Location: edit.php?id=" . $id);
                exit();
            }
        } else {
            $_SESSION['alert'] = [
                'type' => 'error',
                'message' => 'Format file tidak diizinkan. Gunakan JPG, JPEG, atau PNG'
            ];
            header("Location: edit.php?id=" . $id);
            exit();
        }
    }
    
    // Update data pegawai
    $query = "UPDATE pegawai SET 
              nama_pegawai = ?,
              nip = ?,
              jabatan = ?,
              golongan = ?,
              unit_kerja = ?,
              foto = ?
              WHERE id_pegawai = ?";
    
    $stmt = mysqli_prepare($conn, $query);
    mysqli_stmt_bind_param($stmt, "ssssssi", $nama, $nip, $jabatan, $golongan, $unit_kerja, $foto, $id);
    
    if (mysqli_stmt_execute($stmt)) {
        $_SESSION['alert'] = [
            'type' => 'success',
            'message' => 'Data pegawai berhasil diperbarui'
        ];
        header("Location: pegawai.php");
        exit();
    } else {
        $_SESSION['alert'] = [
            'type' => 'error',
            'message' => 'Gagal memperbarui data pegawai: ' . mysqli_error($conn)
        ];
        header("Location: edit.php?id=" . $id);
        exit();
    }
}

if (isset($_GET['id'])) {
    $id = $_GET['id'];
    $query = "SELECT * FROM pegawai WHERE id_pegawai = ?";
    $stmt = mysqli_prepare($conn, $query);
    mysqli_stmt_bind_param($stmt, "i", $id);
    mysqli_stmt_execute($stmt);
    $result = mysqli_stmt_get_result($stmt);
    $pegawai = mysqli_fetch_assoc($result);
    
    if (!$pegawai) {
        $_SESSION['alert'] = [
            'type' => 'error',
            'message' => 'Data pegawai tidak ditemukan'
        ];
        header("Location: pegawai.php");
        exit();
    }
} else {
    header("Location: pegawai.php");
    exit();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Edit Pegawai - SPPD</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css" rel="stylesheet">
    <style>
        body {
            background: linear-gradient(135deg,rgb(245, 255, 254) 0%,rgb(153, 224, 238) 100%);
        }
        .edit-card {
            background: rgba(255, 255, 255, 0.9);
            border-radius: 15px;
            box-shadow: 0 0 20px rgba(0,0,0,0.1);
            overflow: hidden;
            margin-top: 20px;
        }
        .edit-header {
            background: linear-gradient(135deg, #4e73df 0%, #224abe 100%);
            color: white;
            padding: 20px;
        }
        .edit-body {
            padding: 20px;
        }
        .preview-img {
            width: 150px;
            height: 150px;
            border-radius: 50%;
            object-fit: cover;
            border: 3px solid #4e73df;
            margin: 10px 0;
        }
        .form-control:focus {
            border-color: #4e73df;
            box-shadow: 0 0 0 0.2rem rgba(78,115,223,0.25);
        }
        .btn-primary {
            background: #4e73df;
            border: none;
        }
        .btn-primary:hover {
            background: #224abe;
            transform: translateY(-2px);
        }
    </style>
</head>
<body>
    <div class="container">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="../dashboard.php">Dashboard</a></li>
                <li class="breadcrumb-item"><a href="pegawai.php">Data Pegawai</a></li>
                <li class="breadcrumb-item active">Edit Pegawai</li>
            </ol>
        </nav>

        <div class="edit-card">
            <div class="edit-header">
                <h2 class="mb-0">Edit Data Pegawai</h2>
            </div>
            
            <div class="edit-body">
                <form method="POST" action="" enctype="multipart/form-data">
                    <input type="hidden" name="id_pegawai" value="<?= $pegawai['id_pegawai'] ?>">
                    <input type="hidden" name="old_foto" value="<?= $pegawai['foto'] ?>">
                    
                    <div class="row">
                        <div class="col-md-4 text-center">
                            <img src="../assets/img/pegawai/<?= !empty($pegawai['foto']) ? htmlspecialchars($pegawai['foto']) : 'default.jpg' ?>" 
                                 class="preview-img" 
                                 id="preview" 
                                 alt="Preview">
                            <div class="mb-3">
                                <label class="form-label">Foto Pegawai</label>
                                <input type="file" class="form-control" name="foto" accept="image/*" onchange="previewImage(this)">
                                <small class="text-muted">Upload foto baru jika ingin mengubah foto</small>
                            </div>
                        </div>
                        
                        <div class="col-md-8">
                            <div class="mb-3">
                                <label class="form-label">Nama Pegawai</label>
                                <input type="text" class="form-control" name="nama_pegawai" 
                                       value="<?= htmlspecialchars($pegawai['nama_pegawai']) ?>" required>
                            </div>
                            
                            <div class="mb-3">
                                <label class="form-label">NIP</label>
                                <input type="text" class="form-control" name="nip" 
                                       value="<?= htmlspecialchars($pegawai['nip']) ?>">
                            </div>
                            
                            <div class="mb-3">
                                <label class="form-label">Jabatan</label>
                                <input type="text" class="form-control" name="jabatan" 
                                       value="<?= htmlspecialchars($pegawai['jabatan']) ?>" required>
                            </div>
                            
                            <div class="mb-3">
                                <label class="form-label">Golongan</label>
                                <input type="text" class="form-control" name="golongan" 
                                       value="<?= htmlspecialchars($pegawai['golongan']) ?>">
                            </div>
                            
                            <div class="mb-3">
                                <label class="form-label">Unit Kerja</label>
                                <input type="text" class="form-control" name="unit_kerja" 
                                       value="<?= htmlspecialchars($pegawai['unit_kerja']) ?>" required>
                            </div>
                        </div>
                    </div>

                    <div class="text-end mt-3">
                        <a href="pegawai.php" class="btn btn-secondary me-2">Batal</a>
                        <button type="submit" class="btn btn-primary">Simpan Perubahan</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
    function previewImage(input) {
        if (input.files && input.files[0]) {
            var reader = new FileReader();
            reader.onload = function(e) {
                document.getElementById('preview').src = e.target.result;
            }
            reader.readAsDataURL(input.files[0]);
        }
    }
    </script>
</body>
</html> 