<?php
// Array data golongan PNS
$golongan = [
    'I' => [
        'I/a' => 'Juru Muda - I/a',
        'I/b' => 'Juru Muda Tingkat I - I/b',
        'I/c' => 'Juru - I/c',
        'I/d' => 'Juru Tingkat I - I/d',
        'II/a' => 'Pengatur Muda - II/a',
        'II/b' => 'Pengatur Muda Tingkat I - II/b',
        'II/c' => 'Pengatur - II/c',
        'II/d' => 'Pengatur Tingkat I - II/d',
        'III/a' => 'Penata Muda - III/a',
        'III/b' => 'Penata Muda Tingkat I - III/b',
        'III/c' => 'Penata - III/c',
        'III/d' => 'Penata Tingkat I - III/d',
        'IV/a' => 'Pembina - IV/a',
        'IV/b' => 'Pembina Tingkat I - IV/b',
        'IV/c' => 'Pembina Utama Muda - IV/c',
        'IV/d' => 'Pembina Utama Madya - IV/d',
        'IV/e' => 'Pembina Utama - IV/e'
    ],
    'II' => [
        'II/a' => 'Pengatur Muda - II/a',
        'II/b' => 'Pengatur Muda Tingkat I - II/b',
        'II/c' => 'Pengatur - II/c',
        'II/d' => 'Pengatur Tingkat I - II/d',
       
    ],
    'III' => [
        'III/a' => 'Penata Muda - III/a',
        'III/b' => 'Penata Muda Tingkat I - III/b',
        'III/c' => 'Penata - III/c',
        'III/d' => 'Penata Tingkat I - III/d',
        
    ],
    'IV' => [
        'IV/a' => 'Pembina - IV/a',
        'IV/b' => 'Pembina Tingkat I - IV/b',
        'IV/c' => 'Pembina Utama Muda - IV/c',
        'IV/d' => 'Pembina Utama Madya - IV/d',
        'IV/e' => 'Pembina Utama - IV/e'
    ]
];

// Generate HTML untuk select option dengan optgroup
function generateGolonganSelect($selected = '') {
    global $golongan;
    $html = '<select name="golongan" class="form-select" id="golongan">';
    $html .= '<option value="">Pilih Golongan</option>';
    
    foreach ($golongan as $group => $items) {
        $html .= '<optgroup label="Golongan ' . $group . '">';
        foreach ($items as $value => $label) {
            $isSelected = ($selected == $value) ? 'selected' : '';
            $html .= '<option value="' . $value . '" ' . $isSelected . '>' . $label . '</option>';
        }
        $html .= '</optgroup>';
    }
    
    $html .= '</select>';
    return $html;
}

// Jika dipanggil melalui AJAX
if (isset($_GET['get_options'])) {
    echo generateGolonganSelect(isset($_GET['selected']) ? $_GET['selected'] : '');
    exit;
}

// CSS untuk styling select
$select_style = "
<style>
.form-select {
    padding: 12px 15px;
    border: 2px solid #e0e0e0;
    border-radius: 10px;
    font-size: 14px;
    color: #566a7f;
    transition: all 0.3s ease;
}

.form-select:focus {
    border-color: #4e73df;
    box-shadow: 0 0 0 0.2rem rgba(78,115,223,0.1);
}

.form-select optgroup {
    font-weight: 600;
    color: #2c3e50;
    background-color: #f8f9fc;
}

.form-select option {
    padding: 10px;
    color: #566a7f;
}

.form-select option:hover {
    background-color: #4e73df;
    color: white;
}
</style>
";

// JavaScript untuk enhanced select
$select_script = "
<script>
document.addEventListener('DOMContentLoaded', function() {
    const golonganSelect = document.getElementById('golongan');
    
    if (golonganSelect) {
        golonganSelect.addEventListener('change', function() {
            const selectedOption = this.options[this.selectedIndex];
            const optgroup = selectedOption.closest('optgroup');
            
            if (optgroup) {
                console.log('Selected Golongan Group:', optgroup.label);
                console.log('Selected Value:', this.value);
                console.log('Selected Label:', selectedOption.text);
            }
        });
    }
});
</script>
";

// Fungsi untuk mendapatkan format golongan - pangkat
function get_golongan_pangkat($golongan) {
    $data_golongan = array(
        'I/a' => 'Juru Muda - I/a',
        'I/b' => 'Juru Muda Tingkat I - I/b',
        'I/c' => 'Juru - I/c',
        'I/d' => 'Juru Tingkat I - I/d',
        'II/a' => 'Pengatur Muda - II/a',
        'II/b' => 'Pengatur Muda Tingkat I - II/b',
        'II/c' => 'Pengatur - II/c',
        'II/d' => 'Pengatur Tingkat I - II/d',
        'III/a' => 'Penata Muda - III/a',
        'III/b' => 'Penata Muda Tingkat I - III/b',
        'III/c' => 'Penata - III/c',
        'III/d' => 'Penata Tingkat I - III/d',
        'IV/a' => 'Pembina - IV/a',
        'IV/b' => 'Pembina Tingkat I - IV/b',
        'IV/c' => 'Pembina Utama Muda - IV/c',
        'IV/d' => 'Pembina Utama Madya - IV/d',
        'IV/e' => 'Pembina Utama - IV/e'
    );
    
    // Memisahkan pangkat dan golongan
    if (isset($data_golongan[$golongan])) {
        $parts = explode(' - ', $data_golongan[$golongan]);
        // Mengembalikan format "Golongan - Pangkat"
        return $parts[1] . ' - ' . $parts[0];
    }
    
    return $golongan;
}

// Untuk menggunakan di form, ganti input golongan dengan ini:
/*
<div class="mb-4">
    <label class="form-label">Golongan</label>
    <div class="input-group">
        <span class="input-group-text"><i class="bi bi-diagram-3"></i></span>
        <?php 
        require_once 'get_golongan.php';
        echo generateGolonganSelect();
        ?>
    </div>
</div>
*/
?> 