<?php
session_start();
require_once '../config/config.php';
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Import Data Pegawai - SPPD</title>
    <link rel="icon" type="image/svg+xml" href="data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAyNCAyNCI+PHBhdGggZmlsbD0iIzRlNzNkZiIgZD0iTTIwLDhINFY2aDIwdjJIMjB6IE0xNSwxMEg0djJoMTFWMTB6IE00LDE2aDd2Mkg0VjE2eiBNMjEuNywxMy4zTDIwLjMsMTJsMS40LTEuNEMyMi4xLDEwLjIsMjIuMSw5LjgsMjEuNyw5LjRsLTEuMS0xLjFDMjAuMiw3LjksMTkuOCw3LjksMTkuNCw4LjNMMTgsMTBsLTEuNC0xLjRjLTAuNC0wLjQtMS0wLjQtMS40LDBsLTcuNSw3LjVjLTAuMiwwLjItMC4zLDAuNC0wLjMsMC43djIuOWMwLDAuNSwwLjQsMC45LDAuOSwwLjloMi45YzAuMywwLDAuNS0wLjEsMC43LTAuM2w3LjUtNy41QzIyLjEsMTQuMywyMi4xLDEzLjcsMjEuNywxMy4zeiIvPjwvc3ZnPg==">
    
    <!-- CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css" rel="stylesheet">
    
    <style>
        body{
            background: linear-gradient(135deg,rgb(245, 255, 254) 0%,rgb(153, 224, 238) 100%);
        }
        .main-content {
            margin-left: 250px;
            padding: 2rem;
        }
        .card {
            border: none;
            border-radius: 15px;
            box-shadow: 0 5px 15px rgba(0,0,0,0.05);
        }
        .card-header {
            background: #4e73df;
            color: white;
            border-radius: 15px 15px 0 0;
            padding: 1rem;
        }
        .template-info {
            background-color: #f8f9fa;
            padding: 1.5rem;
            border-radius: 10px;
            margin-bottom: 1.5rem;
        }
        .required {
            color: red;
        }
    </style>
</head>
<body>

<div class="main-content">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-8">
                <div class="card">
                    <div class="card-header">
                        <h5 class="mb-0">Import Data Pegawai</h5>
                    </div>
                    <div class="card-body">
                        <?php if(isset($_SESSION['alert'])): ?>
                            <div class="alert alert-<?= $_SESSION['alert']['type'] ?> alert-dismissible fade show">
                                <?= $_SESSION['alert']['message'] ?>
                                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                            </div>
                            <?php unset($_SESSION['alert']); ?>
                        <?php endif; ?>

                        <div class="template-info">
                            <h6 class="mb-3"><i class="bi bi-info-circle me-2"></i>Petunjuk Import:</h6>
                            <ol>
                                <li>Download template Excel terlebih dahulu</li>
                                <li>Isi data sesuai format yang ada di template</li>
                                <li>Field dengan tanda <span class="required">*</span> wajib diisi:
                                    <ul class="mt-2">
                                        <li>Status Kepegawaian (PNS/PPPK/Non ASN)</li>
                                        <li>Nama Pegawai</li>
                                        <li>Jabatan</li>
                                        <li>Unit Kerja</li>
                                    </ul>
                                </li>
                                <li>Format NIP: 18 digit angka (khusus PNS)</li>
                                <li>Format No. Telp: 10-15 digit angka</li>
                                <li>Simpan file dan upload</li>
                            </ol>
                        </div>

                        <div class="mb-4">
                            <a href="template/template_pegawai.xlsx" class="btn btn-success">
                                <i class="bi bi-file-earmark-excel me-2"></i>Download Template Excel
                            </a>
                        </div>

                        <form action="import_process.php" method="POST" enctype="multipart/form-data">
                            <div class="mb-3">
                                <label for="file" class="form-label">Pilih File Excel</label>
                                <input type="file" class="form-control" id="file" name="file" 
                                       accept=".xlsx,.xls" required>
                                <div class="form-text">Format file yang diperbolehkan: .xlsx, .xls</div>
                            </div>

                            <div class="d-flex gap-2">
                                <button type="submit" class="btn btn-primary">
                                    <i class="bi bi-upload me-2"></i>Import Data
                                </button>
                                <a href="pegawai.php" class="btn btn-secondary">
                                    <i class="bi bi-arrow-left me-2"></i>Kembali
                                </a>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

</body>
</html> 