<?php
session_start();
require_once '../config/config.php';
require '../vendor/autoload.php';

use PhpOffice\PhpSpreadsheet\IOFactory;

try {
    // Validasi file
    if (!isset($_FILES['file']['tmp_name'])) {
        throw new Exception('Pilih file Excel terlebih dahulu!');
    }

    $file = $_FILES['file']['tmp_name'];
    $spreadsheet = IOFactory::load($file);
    $worksheet = $spreadsheet->getActiveSheet();
    $highestRow = $worksheet->getHighestRow();

    // Mulai transaksi database
    mysqli_begin_transaction($conn);
    $successCount = 0;

    // Loop mulai dari baris ke-2 (setelah header)
    for ($row = 2; $row <= $highestRow; $row++) {
        // Ambil data dari Excel dan tangani nilai kosong
        $data = [
            'status_kepegawaian' => $worksheet->getCell('A' . $row)->getValue() ?? '',
            'nip' => $worksheet->getCell('B' . $row)->getValue() ?? '',
            'nama_pegawai' => $worksheet->getCell('C' . $row)->getValue() ?? '',
            'jabatan' => $worksheet->getCell('D' . $row)->getValue() ?? '',
            'golongan' => $worksheet->getCell('E' . $row)->getValue() ?? '',
            'unit_kerja' => $worksheet->getCell('F' . $row)->getValue() ?? '',
            'alamat' => $worksheet->getCell('G' . $row)->getValue() ?? '',
            'no_telp' => $worksheet->getCell('H' . $row)->getValue() ?? ''
        ];

        // Bersihkan spasi di awal dan akhir untuk semua nilai
        $data = array_map(function($value) {
            return is_string($value) ? trim($value) : $value;
        }, $data);

        // Lewati baris jika nama pegawai kosong
        if (empty($data['nama_pegawai'])) continue;

        // Validasi data wajib
        if (empty($data['status_kepegawaian']) || empty($data['nama_pegawai']) || 
            empty($data['unit_kerja'])) {
            throw new Exception("Data wajib tidak lengkap pada baris $row. Pastikan Status Kepegawaian, Nama Pegawai, dan Unit Kerja telah diisi.");
        }

        // Masukkan data ke database
        $query = "INSERT INTO pegawai (
            status_kepegawaian, 
            nip, 
            nama_pegawai, 
            jabatan, 
            golongan, 
            unit_kerja, 
            alamat, 
            no_telp
        ) VALUES (?, ?, ?, ?, ?, ?, ?, ?)";

        $stmt = mysqli_prepare($conn, $query);
        mysqli_stmt_bind_param($stmt, "ssssssss",
            $data['status_kepegawaian'],
            $data['nip'],
            $data['nama_pegawai'],
            $data['jabatan'],
            $data['golongan'],
            $data['unit_kerja'],
            $data['alamat'],
            $data['no_telp']
        );

        if (!mysqli_stmt_execute($stmt)) {
            throw new Exception("Terjadi kesalahan saat menyimpan data pada baris $row: " . mysqli_error($conn));
        }

        $successCount++;
    }

    // Commit transaksi jika berhasil
    mysqli_commit($conn);

    $_SESSION['alert'] = [
        'type' => 'success',
        'message' => "Berhasil mengimpor $successCount data pegawai"
    ];

    header('Location: import_form.php');
    exit;

} catch (Exception $e) {
    // Rollback jika terjadi kesalahan
    if (isset($conn)) mysqli_rollback($conn);

    $_SESSION['alert'] = [
        'type' => 'danger',
        'message' => 'Kesalahan: ' . $e->getMessage()
    ];

    header('Location: import_form.php');
    exit;
} 