<?php
session_start();
require_once '../config/database.php';
require_once '../config/config.php';

// Cek login
if (!isset($_SESSION['user_id'])) {
    header("Location: ../login.php");
    exit();
}

// Ambil parameter pencarian
$search = isset($_GET['search']) ? mysqli_real_escape_string($conn, $_GET['search']) : '';

// Set jumlah data per halaman dengan nilai default dan maksimum yang lebih besar
$per_page = isset($_GET['per_page']) ? (int)$_GET['per_page'] : 10;
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$start = ($page - 1) * $per_page;

// Buat kondisi WHERE untuk pencarian
$where = "";
if (!empty($search)) {
    $where = "WHERE nama_pegawai LIKE '%$search%' 
              OR nip LIKE '%$search%' 
              OR jabatan LIKE '%$search%' 
              OR unit_kerja LIKE '%$search%'";
}

// Hitung total data dengan filter pencarian dan GROUP BY untuk menghindari duplikasi
$count_query = "SELECT COUNT(DISTINCT id_pegawai) as total FROM pegawai $where";
$count_result = mysqli_query($conn, $count_query);
$total_rows = mysqli_fetch_assoc($count_result)['total'];
$total_pages = ceil($total_rows / $per_page);

// Query dengan GROUP BY untuk menghindari duplikasi
$query = "SELECT DISTINCT id_pegawai, status_kepegawaian, nip, nama_pegawai, jabatan, golongan, unit_kerja 
          FROM pegawai 
          $where 
          GROUP BY id_pegawai 
          ORDER BY nama_pegawai ASC 
          LIMIT $start, $per_page";
$result = mysqli_query($conn, $query);

if (!$result) {
    die("Query Error: " . mysqli_error($conn));
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Data Pegawai - SPPD</title>
    <link rel="icon" type="image/svg+xml" href="data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAyNCAyNCI+PHBhdGggZmlsbD0iIzRlNzNkZiIgZD0iTTIwLDhINFY2aDIwdjJIMjB6IE0xNSwxMEg0djJoMTFWMTB6IE00LDE2aDd2Mkg0VjE2eiBNMjEuNywxMy4zTDIwLjMsMTJsMS40LTEuNEMyMi4xLDEwLjIsMjIuMSw5LjgsMjEuNyw5LjRsLTEuMS0xLjFDMjAuMiw3LjksMTkuOCw3LjksMTkuNCw4LjNMMTgsMTBsLTEuNC0xLjRjLTAuNC0wLjQtMS0wLjQtMS40LDBsLTcuNSw3LjVjLTAuMiwwLjItMC4zLDAuNC0wLjMsMC43djIuOWMwLDAuNSwwLjQsMC45LDAuOSwwLjloMi45YzAuMywwLDAuNS0wLjEsMC43LTAuM2w3LjUtNy41QzIyLjEsMTQuMywyMi4xLDEzLjcsMjEuNywxMy4zeiIvPjwvc3ZnPg==">
    
    <!-- CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.datatables.net/1.13.7/css/dataTables.bootstrap5.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <link href="https://cdn.jsdelivr.net/npm/select2-bootstrap-5-theme@1.3.0/dist/select2-bootstrap-5-theme.min.css" rel="stylesheet" />
    
    <style>
        :root {
        --sidebar-width: 280px;
        --sidebar-mini-width: 70px;
            --primary-gradient: linear-gradient(135deg, #0ea5e9 0%, #2dd4bf 100%);
            --bg-gradient: linear-gradient(135deg, rgb(245, 255, 254) 0%, rgb(153, 224, 238) 100%);
            --card-bg: rgba(255, 255, 255, 0.95); /* Softer card background */
            --border-color: #e2e8f0; /* Light border color */
            --text-color: #475569; /* Darker grey text */
            --header-color: #1e293b; /* Dark header text */
        }

        body {
            margin: 0;
            padding: 0;
            min-height: 100vh;
        background: var(--bg-gradient) !important;
        padding-left: 0 !important;
        position: relative;
        z-index: 0;
    }

    /* Main Layout Structure */
    .wrapper {
        display: flex;
        min-height: 100vh;
        width: 100%;
        position: relative;
            background: transparent !important;
    }

    /* Main Content Area */
    .main-content {
            position: relative;
            margin-left: var(--sidebar-width);
        transition: all 0.3s ease;
            width: calc(100% - var(--sidebar-width));
            min-height: 100vh;
        background: transparent !important;
        box-sizing: border-box; /* Include padding and border in the element's total width and height */
    }

    .main-content.expanded {
        margin-left: var(--sidebar-mini-width);
        width: calc(100% - var(--sidebar-mini-width));
    }

    /* Container Modifications */
    .container-fluid {
        max-width: 100% !important;
        padding: 2rem; /* Consistent padding */
        margin: 0;
            transition: all 0.3s ease;
        }

    /* Mobile Responsiveness */
    @media (max-width: 768px) {
        .main-content {
            margin-left: 0 !important;
            width: 100% !important;
            padding: 1rem; /* Adjusted padding for mobile */
        }

        .container-fluid {
            padding: 1rem !important; /* Adjusted container padding for mobile */
        }
    }

    .page-header {
        background: var(--primary-gradient); /* Keep gradient, maybe adjust opacity if needed */
        border-radius: 15px;
        padding: 1.5rem; /* Consistent padding */
        margin-bottom: 2rem;
        position: relative;
        z-index: 10;
        box-shadow: 0 4px 15px rgba(14, 165, 233, 0.15); /* Subtle shadow */
    }

    .header-content {
        display: flex;
        flex-direction: column; /* Stack title and actions vertically */
        gap: 1rem; /* Reduced gap */
    }

    .header-title {
        color: white; /* White title */
        font-size: 1.75rem;
        font-weight: 600;
        margin: 0;
    }

    .header-actions {
        display: flex;
        flex-wrap: wrap;
        gap: 0.75rem; /* Consistent gap */
        justify-content: flex-end; /* Align actions to the right */
        align-items: center;
    }

    /* Button Styling */
    .action-buttons {
        display: flex;
        gap: 0.5rem;
        justify-content: center;
        align-items: center;
    }

    .btn-header { /* Buttons within header */
        background: rgba(255, 255, 255, 0.1); /* Semi-transparent white */
        border: 1px solid rgba(255, 255, 255, 0.2); /* Subtle border */
        color: white;
        padding: 0.5rem 1rem;
        border-radius: 8px;
        display: inline-flex;
        align-items: center;
        gap: 0.5rem;
        font-size: 0.875rem;
        font-weight: 500;
        transition: all 0.2s ease;
        white-space: nowrap;
        position: relative;
        z-index: 15; /* Ensure clickability */
    }

    .btn-header:hover {
        background: rgba(255, 255, 255, 0.2); /* Slightly more opaque on hover */
        color: white;
        transform: translateY(-2px); /* Subtle hover effect */
    }

    .btn-header i {
        font-size: 1rem;
    }

    /* Search and Entries Container */
    .table-tools { /* This is the container for search and per-page select */
        display: flex;
        justify-content: space-between; /* Space out search and entries select */
        align-items: center;
        gap: 1rem; /* Gap between elements */
        margin-bottom: 1.5rem; /* Space below the tools */
        flex-wrap: wrap; /* Wrap on smaller screens */
    }

    .search-box { /* Container for search form */
        flex: 1; /* Allow search box to take available space */
        min-width: 250px; /* Minimum width */
        max-width: 400px; /* Set maximum width */
    }

    .search-form { /* The actual form */
        display: flex;
        align-items: center;
        border-radius: 8px;
        overflow: hidden; /* Hide overflowing border */
        box-shadow: 0 2px 4px rgba(0, 0, 0, 0.05); /* Subtle shadow */
    }

    .search-input { /* The search input field */
        border: 1px solid var(--border-color); /* Light border */
        border-right: none; /* Remove right border to merge with button */
        padding: 0.6rem 1rem; /* Adjusted padding */
        font-size: 0.9rem; /* Adjusted font size */
        color: var(--text-color); /* Darker text color */
        flex-grow: 1; /* Allow input to grow */
        box-shadow: none; /* Remove default focus shadow */
    }

    .search-input:focus {
         border-color: #0ea5e9; /* Highlight color on focus */
         box-shadow: 0 0 0 0.25rem rgba(14, 165, 233, 0.25); /* Subtle focus ring */
         z-index: 1; /* Ensure focus outline is visible */
    }

    .btn-search { /* The search button */
        background: #f8f9fa; /* Light background */
        border: 1px solid var(--border-color); /* Light border */
        border-left: none; /* Remove left border */
        color: var(--text-color); /* Darker icon color */
        padding: 0.6rem 1rem; /* Adjusted padding */
        border-radius: 0 8px 8px 0; /* Rounded right corners */
        cursor: pointer; /* Indicate clickable */
        transition: all 0.2s ease;
    }

    .btn-search:hover {
        background: #e9ecef; /* Slightly darker on hover */
        color: #1e293b; /* Darker icon color on hover */
    }

    /* Entries Select */
    .entries-select { /* Container for select */
        width: auto; /* Auto width based on content */
        min-width: 120px; /* Minimum width */
    }

    .entries-select .form-select { /* The select element */
        border: 1px solid var(--border-color); /* Light border */
        border-radius: 8px; /* Rounded corners */
        padding: 0.6rem 2.5rem 0.6rem 1rem; /* Adjusted padding */
        font-size: 0.9rem; /* Adjusted font size */
        color: var(--text-color); /* Darker text color */
        background-color: white; /* White background */
        cursor: pointer;
        background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 16 16'%3e%3cpath fill='none' stroke='%23475569' stroke-linecap='round' stroke-linejoin='round' stroke-width='2' d='M2 5l6 6 6-6'/%3e%3c/svg%3e"); /* Darker arrow icon */
        background-repeat: no-repeat;
        background-position: right 0.75rem center;
        background-size: 16px 12px;
        box-shadow: 0 2px 4px rgba(0, 0, 0, 0.05); /* Subtle shadow */
        transition: all 0.2s ease;
    }

    .entries-select .form-select:focus {
         border-color: #0ea5e9; /* Highlight color on focus */
         box-shadow: 0 0 0 0.25rem rgba(14, 165, 233, 0.25); /* Subtle focus ring */
    }

    .entries-select .form-select option { /* Options within select */
        background: white;
        color: #333;
    }

    /* Card Styling */
    .card { /* Main card containing the table */
        background: var(--card-bg); /* Softer background */
        backdrop-filter: blur(10px); /* Keep blur effect */
        border: 1px solid var(--border-color); /* Subtle border */
        border-radius: 15px;
        box-shadow: 0 8px 32px 0 rgba(14, 165, 233, 0.05); /* Lighter shadow */
        margin-bottom: 2rem;
        width: 100%;
        overflow: hidden; /* Ensure table corners are rounded */
    }

    .card-body { /* Padding inside card */
        padding: 1.5rem; /* Consistent padding */
    }

    /* Table Styling */
    .table-responsive { /* Container for table */
        overflow-x: auto; /* Allow horizontal scrolling */
    }

    .table { /* The table element */
        margin-bottom: 0; /* Remove default table margin */
        border-collapse: separate; /* Allow border-spacing */
        border-spacing: 0 8px; /* Add vertical space between rows */
        width: 100%;
    }

    .table thead th { /* Table header cells */
        background: #f8f9fa; /* Light header background */
        border-bottom: 1px solid var(--border-color); /* Subtle bottom border */
        color: var(--header-color); /* Darker header text */
        font-weight: 600;
        padding: 12px 15px; /* Adjusted padding */
        font-size: 0.9rem;
        text-transform: uppercase;
        letter-spacing: 0.5px;
        border-top: none; /* Remove top border */
    }

    .table tbody tr { /* Table body rows */
        background: white; /* White row background */
        border-radius: 8px; /* Rounded corners for rows */
        transition: all 0.2s ease;
    }

    .table tbody tr:hover { /* Hover effect for rows */
        background: #f0f4f8; /* Subtle background on hover */
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.05); /* Subtle shadow on hover */
    }

    .table tbody td { /* Table body cells */
        padding: 12px 15px; /* Adjusted padding */
        vertical-align: middle; /* Vertically align cell content */
        border-bottom: 1px solid var(--border-color); /* Subtle bottom border */
        font-size: 0.9rem;
        color: var(--text-color); /* Darker text color */
    }

    /* Remove border-radius for middle cells if using border-spacing */
    .table tbody tr td:first-child {
        border-top-left-radius: 8px;
        border-bottom-left-radius: 8px;
    }

    .table tbody tr td:last-child {
        border-top-right-radius: 8px;
        border-bottom-right-radius: 8px;
    }

    /* Ensure consistent cell background when using border-spacing */
    .table tbody tr td {
        background-color: inherit; /* Inherit background from tr */
    }

    /* Action Buttons */
    .action-buttons {
        display: flex;
        gap: 0.5rem;
        justify-content: center;
        align-items: center;
    }

    .btn-action {
        width: 32px;
        height: 32px;
        padding: 0;
        display: inline-flex;
        align-items: center;
        justify-content: center;
        border-radius: 6px;
        border: none;
        color: white;
        transition: all 0.2s ease;
        box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
        position: relative;
        overflow: hidden;
    }

    .btn-action::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: rgba(255, 255, 255, 0.1);
        transform: translateY(100%);
        transition: transform 0.2s ease;
    }

    .btn-action:hover::before {
        transform: translateY(0);
    }

    .btn-action i {
        font-size: 0.9rem;
        position: relative;
        z-index: 1;
    }

    /* Specific Action Button Colors */
    .btn-action[title="Detail"] {
        background: linear-gradient(135deg, #0ea5e9 0%, #0284c7 100%);
    }

    .btn-action[title="Edit"] {
        background: linear-gradient(135deg, #f59e0b 0%, #d97706 100%);
    }

    .btn-action[title="Hapus"] {
        background: linear-gradient(135deg, #ef4444 0%, #dc2626 100%);
    }

    .btn-action:hover {
        transform: translateY(-2px);
        box-shadow: 0 4px 8px rgba(0, 0, 0, 0.15);
    }

    /* Tooltip styling */
    .btn-action::after {
        content: attr(title);
        position: absolute;
        bottom: -30px;
        left: 50%;
        transform: translateX(-50%);
        padding: 4px 8px;
        background: rgba(0, 0, 0, 0.8);
        color: white;
        font-size: 0.75rem;
        border-radius: 4px;
        white-space: nowrap;
        opacity: 0;
        visibility: hidden;
        transition: all 0.2s ease;
    }

    .btn-action:hover::after {
        opacity: 1;
        visibility: visible;
        bottom: -25px;
    }

    /* Pagination (assuming Bootstrap pagination is used) */
    .pagination .page-link { /* Pagination links */
        border-radius: 6px; /* Subtle rounding */
        margin: 0 2px; /* Space between items */
        border: 1px solid var(--border-color); /* Light border */
        color: var(--text-color); /* Text color */
        transition: all 0.2s ease;
    }

    .pagination .page-item.active .page-link { /* Active pagination item */
        background: var(--primary-gradient); /* Gradient background */
        border-color: #0ea5e9; /* Matching border color */
        color: white; /* White text */
    }

    .pagination .page-link:hover { /* Pagination hover effect */
        background: #f0f4f8; /* Subtle background */
        border-color: #d1d5db; /* Slightly darker border */
    }

    /* Alert Styling */
    .alert-info { /* Info alert for search results */
        background-color: rgba(14, 165, 233, 0.08); /* Very light blue background */
        border: 1px solid rgba(14, 165, 233, 0.15); /* Subtle blue border */
        color: #0369a1; /* Dark blue text */
        border-radius: 8px;
        padding: 0.75rem 1rem;
        margin-top: 1.5rem; /* Space above alert */
        margin-bottom: 1.5rem; /* Space below alert */
    }

    .alert-info i { /* Icon in alert */
        color: #0ea5e9; /* Primary blue color */
    }

    /* Empty state styling */
    .text-muted.py-4.text-center i {
        color: var(--border-color); /* Grey out icon */
    }

    /* Modal Styling (Assuming Bootstrap default modals are used, minimal changes) */
    .modal-content {
        border-radius: 15px;
        overflow: hidden; /* Ensure rounded corners */
    }

    .modal-header {
        background: #f8f9fa; /* Light header background */
        border-bottom: 1px solid var(--border-color); /* Subtle border */
    }

    .modal-title {
        color: var(--header-color); /* Dark header text */
        font-weight: 600;
    }

    .modal-footer {
        border-top: 1px solid var(--border-color); /* Subtle border */
    }

  

  

    /* SweetAlert Custom Styles (from dashboard.php, included here for completeness) */
    .swal-custom-popup {
        border-radius: 15px;
        padding: 20px;
        background: rgba(255, 255, 255, 0.98); /* Semi-transparent white */
        backdrop-filter: blur(10px);
        box-shadow: 0 8px 32px rgba(0, 0, 0, 0.1); /* Subtle shadow */
    }

    .swal-custom-title {
        color: #1e293b;
        font-size: 1.5rem;
        font-weight: 600;
        padding: 1rem 0;
    }

    .swal-custom-content {
        color: #475569;
        font-size: 1rem;
        padding: 0.5rem 0;
    }

    .swal-custom-confirm {
        background: var(--primary-gradient) !important; /* Apply primary gradient */
        border: none !important;
        border-radius: 8px !important;
        padding: 10px 24px !important;
        font-weight: 500 !important;
        letter-spacing: 0.3px !important;
        box-shadow: 0 4px 6px rgba(14, 165, 233, 0.2);
    }

    .swal-custom-confirm:hover {
        background: linear-gradient(135deg, #0284c7 0%, #14b8a6 100%) !important;
        transform: translateY(-1px);
        box-shadow: 0 6px 12px rgba(14, 165, 233, 0.3);
    }

    .swal-custom-cancel {
        background: #fff !important;
        color: #ef4444 !important; /* Red text */
        border: 1px solid #ef4444 !important; /* Red border */
        border-radius: 8px !important;
        padding: 10px 24px !important;
        font-weight: 500 !important;
        letter-spacing: 0.3px !important;
    }

    .swal-custom-cancel:hover {
        background: rgba(239, 68, 68, 0.1) !important; /* Subtle red background on hover */
        transform: translateY(-1px);
    }

    /* Responsive adjustments for table */
    @media (max-width: 768px) {
        .table thead th,
        .table tbody td {
            padding: 8px 10px; /* Reduced padding */
            font-size: 0.85rem; /* Reduced font size */
        }
        .action-buttons {
            gap: 0.35rem;
        }
        
        .btn-action {
            width: 28px;
            height: 28px;
        }
        
        .btn-action i {
            font-size: 0.8rem;
        }
        .table-tools {
             gap: 0.75rem; /* Reduced gap in tools */
             margin-bottom: 1rem; /* Reduced space below tools */
        }
        .search-box {
            min-width: auto;
        }
         .search-input,
        .btn-search,
        .entries-select .form-select {
            padding: 0.4rem 0.8rem; /* Reduced padding */
            font-size: 0.85rem; /* Reduced font size */
        }
         .entries-select .form-select {
             padding-right: 2rem; /* Maintain space for arrow */
         }
    }

    </style>
</head>
<body>
    <?php include_once ROOT_PATH . '/includes/sidebar.php'; ?>
    <div class="wrapper">
        <div class="main-content" id="mainContent">
            <div class="container-fluid">
                <div class="page-header">
                    <div class="header-content">
                        <div class="d-flex justify-content-between align-items-center">
                            <h2 class="header-title">Data Pegawai</h2>
                            <div class="global-actions">
                                <a href="create.php" class="btn btn-light" title="Tambah Data">
                                    <i class="bi bi-plus-lg"></i>
                                </a>
                                <?php if ($_SESSION['level'] === 'admin'): ?>
                                <a href="import_form.php" class="btn btn-light" title="Import Excel">
                                    <i class="bi bi-file-earmark-excel"></i>
                                </a>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="card">
                    <div class="card-body">
                        <div class="table-tools">
                            <div class="search-box">
                                <form action="" method="GET" class="search-form">
                                    <div class="input-group">
                                        <input type="text" 
                                               class="form-control" 
                                               name="search" 
                                               value="<?= isset($_GET['search']) ? htmlspecialchars($_GET['search']) : '' ?>" 
                                               placeholder="Cari nama, NIP, jabatan...">
                                        <button class="btn btn-primary" type="submit">
                                            <i class="bi bi-search"></i>
                                        </button>
                                    </div>
                                </form>
                            </div>
                            
                            <div class="entries-select">
                                <select class="form-select" id="per_page" name="per_page">
                                    <option value="10" <?= $per_page == 10 ? 'selected' : '' ?>>10 entries</option>
                                    <option value="25" <?= $per_page == 25 ? 'selected' : '' ?>>25 entries</option>
                                    <option value="50" <?= $per_page == 50 ? 'selected' : '' ?>>50 entries</option>
                                    <option value="100" <?= $per_page == 100 ? 'selected' : '' ?>>100 entries</option>
                                </select>
                            </div>
                        </div>

                        <?php if(!empty($search)): ?>
                        <div class="alert alert-info mt-3">
                            <i class="bi bi-info-circle me-2"></i>
                            Menampilkan hasil pencarian untuk: <strong><?= htmlspecialchars($search) ?></strong>
                            (<?= $total_rows ?> data ditemukan)
                        </div>
                        <?php endif; ?>

                        <div class="table-responsive mt-3">
                            <table class="table table-hover">
                                <thead>
                                    <tr>
                                        <th class="text-center" style="width: 50px">No.</th>
                                        <th>Nama Pegawai</th>
                                        <th>NIP</th>
                                        <th>Jabatan</th>
                                        <th>Golongan</th>
                                        <th>Unit Kerja</th>
                                        <th class="text-center" style="width: 120px">Aksi</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    $no = ($page - 1) * $per_page + 1;
                                    while ($row = mysqli_fetch_assoc($result)) {
                                    ?>
                                    <tr>
                                        <td class="text-center"><?= $no++ ?></td>
                                        <td><?= htmlspecialchars($row['nama_pegawai']) ?></td>
                                        <td><?= htmlspecialchars($row['nip']) ?></td>
                                        <td><?= htmlspecialchars($row['jabatan']) ?></td>
                                        <td class="text-center"><?= htmlspecialchars($row['golongan']) ?></td>
                                        <td><?= htmlspecialchars($row['unit_kerja']) ?></td>
                                        <td>
                                            <div class="action-buttons">
                                                <a href="view.php?id=<?= $row['id_pegawai'] ?>" 
                                                   class="btn btn-action" 
                                                   title="Detail">
                                                    <i class="bi bi-eye"></i>
                                                </a>
                                                <a href="edit.php?id=<?= $row['id_pegawai'] ?>" 
                                                   class="btn btn-action" 
                                                   title="Edit">
                                                    <i class="bi bi-pencil"></i>
                                                </a>
                                                <button type="button" 
                                                        onclick="konfirmasiHapus('delete.php?id=<?= $row['id_pegawai'] ?>')" 
                                                        class="btn btn-action" 
                                                        title="Hapus">
                                                    <i class="bi bi-trash"></i>
                                                </button>
                                            </div>
                                        </td>
                                    </tr>
                                    <?php
                                    }
                                    if (mysqli_num_rows($result) == 0) {
                                    ?>
                                    <tr>
                                        <td colspan="7" class="text-center py-4 text-muted">
                                            <i class="bi bi-inbox fs-2 d-block mb-2"></i>
                                            Tidak ada data tersedia
                                        </td>
                                    </tr>
                                    <?php
                                    }
                                    ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
  

    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script>
    document.addEventListener('DOMContentLoaded', function() {
        // Get elements
        const sidebarWrapper = document.querySelector('.sidebar');
        const mainContent = document.getElementById('mainContent');
        const sidebarToggle = document.querySelector('.sidebar-toggle');
        
        if (!sidebarWrapper || !mainContent || !sidebarToggle) {
            console.error('Required elements not found');
            return;
        }

        function updateLayout() {
            if (sidebarWrapper.classList.contains('collapsed')) {
                mainContent.classList.add('expanded');
            } else {
                mainContent.classList.remove('expanded');
            }
        }

        // Initial check
        updateLayout();

        // Toggle event
        sidebarToggle.addEventListener('click', function(e) {
            e.preventDefault();
            sidebarWrapper.classList.toggle('collapsed');
            updateLayout();
            localStorage.setItem('sidebarCollapsed', sidebarWrapper.classList.contains('collapsed'));
        });

        // Check saved state
        const sidebarCollapsed = localStorage.getItem('sidebarCollapsed') === 'true';
        if (sidebarCollapsed) {
            sidebarWrapper.classList.add('collapsed');
            mainContent.classList.add('expanded');
        }
    });

    // Fungsi untuk toggle aksi
    function toggleActions(button) {
        const mainRow = button.closest('tr.main-row');
        const actionRow = mainRow.nextElementSibling;
        const icon = button.querySelector('i');
        
        // Toggle active state untuk button dan row
        button.classList.toggle('active');
        mainRow.classList.toggle('active');
        
        // Toggle icon
        if (icon.classList.contains('bi-eye')) {
            icon.classList.replace('bi-eye', 'bi-eye-slash');
        } else {
            icon.classList.replace('bi-eye-slash', 'bi-eye');
        }
        
        // Show/hide action row dengan animasi
        if (actionRow.style.display === 'none' || !actionRow.style.display) {
            actionRow.style.display = 'table-row';
            actionRow.style.animation = 'fadeIn 0.3s ease-out forwards';
        } else {
            actionRow.style.animation = 'fadeOut 0.3s ease-out forwards';
            setTimeout(() => {
                actionRow.style.display = 'none';
            }, 280);
        }
    }

    // Tambahkan animasi CSS
    const style = document.createElement('style');
    style.textContent = `
    @keyframes fadeIn {
    from {
        opacity: 0;
        transform: translateY(-10px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

    @keyframes fadeOut {
        from {
            opacity: 1;
            transform: translateY(0);
        }
        to {
            opacity: 0;
            transform: translateY(-10px);
        }
    }

    .action-row {
        background-color: rgba(255, 255, 255, 0.98);
    }

    .action-container {
        padding: 0.75rem;
        display: flex;
        gap: 8px;
        justify-content: flex-start;
        align-items: center;
    }

    .btn-eye {
        width: 32px;
        height: 32px;
        padding: 0;
        display: flex;
        align-items: center;
        justify-content: center;
        border: none;
    background: rgba(14, 165, 233, 0.1);
        color: #0ea5e9;
        border-radius: 6px;
        cursor: pointer;
    transition: all 0.3s ease;
}

    .btn-eye:hover,
    .btn-eye.active {
    background: linear-gradient(135deg, #0ea5e9 0%, #2dd4bf 100%);
    color: white;
    transform: translateY(-2px);
    }

    .main-row.active {
        background-color: rgba(14, 165, 233, 0.05) !important;
    }

    .btn-soft-info,
    .btn-soft-warning,
    .btn-soft-danger {
        padding: 8px 16px;
        border-radius: 6px;
        display: inline-flex;
        align-items: center;
        gap: 6px;
        font-size: 14px;
        font-weight: 500;
        transition: all 0.3s ease;
    }

    .btn-soft-info {
    background: rgba(14, 165, 233, 0.1);
        color: #0ea5e9;
    border: 1px solid rgba(14, 165, 233, 0.2);
    }

    .btn-soft-warning {
        background: rgba(234, 179, 8, 0.1);
        color: #ca8a04;
        border: 1px solid rgba(234, 179, 8, 0.2);
}

.btn-soft-danger {
        background: rgba(239, 68, 68, 0.1);
        color: #dc2626;
        border: 1px solid rgba(239, 68, 68, 0.2);
    }

    .btn-soft-info:hover,
    .btn-soft-warning:hover,
.btn-soft-danger:hover {
    background: linear-gradient(135deg, #0ea5e9 0%, #2dd4bf 100%);
    color: white;
    transform: translateY(-2px);
    box-shadow: 0 4px 12px rgba(14, 165, 233, 0.15);
        border-color: transparent;
    }
    `;
    document.head.appendChild(style);

    // Add Bootstrap 5 Dropdown initialization
    document.addEventListener('DOMContentLoaded', function() {
        var dropdownElementList = [].slice.call(document.querySelectorAll('.dropdown-toggle'))
        var dropdownList = dropdownElementList.map(function (dropdownToggleEl) {
            return new bootstrap.Dropdown(dropdownToggleEl)
        });
    });

    function konfirmasiHapus(deleteUrl) {
        Swal.fire({
            title: 'Konfirmasi Hapus',
            text: 'Apakah Anda yakin ingin menghapus data pegawai ini?',
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#0ea5e9',
            cancelButtonColor: '#ef4444',
            confirmButtonText: 'Ya, Hapus!',
            cancelButtonText: 'Batal',
            reverseButtons: true,
            customClass: {
                popup: 'swal-custom-popup',
                title: 'swal-custom-title',
                content: 'swal-custom-content',
                confirmButton: 'swal-custom-confirm',
                cancelButton: 'swal-custom-cancel'
            }
        }).then((result) => {
            if (result.isConfirmed) {
                window.location.href = deleteUrl;
            }
        });
    }

    // Add this to ensure buttons are clickable
    document.addEventListener('DOMContentLoaded', function() {
        const actionButtons = document.querySelectorAll('.btn-action');
        actionButtons.forEach(button => {
            button.style.zIndex = '10';
            button.addEventListener('click', function(e) {
                if (this.getAttribute('onclick')) {
                    e.preventDefault();
                    const deleteFunction = this.getAttribute('onclick');
                    const deleteUrl = deleteFunction.substring(deleteFunction.indexOf("'") + 1, deleteFunction.lastIndexOf("'"));
                    konfirmasiHapus(deleteUrl);
                }
            });
        });
    });

    // Add this JavaScript code block at the end, inside the <script> tag
    document.addEventListener('DOMContentLoaded', function() {
        const perPageSelect = document.getElementById('per_page');
        if (perPageSelect) {
            perPageSelect.addEventListener('change', function() {
                const selectedValue = this.value;
                const currentUrl = new URL(window.location.href);
                currentUrl.searchParams.set('per_page', selectedValue);
                currentUrl.searchParams.set('page', 1); // Reset to page 1 when changing entries
                window.location.href = currentUrl.toString();
            });
        }
    });
</script>
</body>
</html> 