<?php
require_once '../config/koneksi.php';

// Fungsi untuk redirect dengan pesan
function redirectWithMessage($url, $type, $message) {
    $_SESSION['alert'] = [
        'type' => $type,
        'message' => $message
    ];
    header("Location: $url");
    exit();
}

// Cek jika form disubmit
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    try {
        // Ambil data dari form
        $status_kepegawaian = trim($_POST['status_kepegawaian']);
        $nip = trim($_POST['nip']);
        $nama_pegawai = trim($_POST['nama_pegawai']);
        $jabatan = trim($_POST['jabatan']);
        $golongan = trim($_POST['golongan']);
        $alamat = trim($_POST['alamat']);
        $no_telp = trim($_POST['no_telp']);

        // Validasi status kepegawaian
        if (empty($status_kepegawaian)) {
            throw new Exception("Status kepegawaian wajib dipilih!");
        }

        // Validasi input required
        if (empty($nama_pegawai) || empty($jabatan)) {
            throw new Exception("Nama Pegawai dan Jabatan wajib diisi!");
        }

        // Validasi format NIP jika diisi
        if (!empty($nip)) {
            if ($status_kepegawaian == 'PNS' && !preg_match("/^[0-9]{18}$/", $nip)) {
                throw new Exception("Format NIP tidak valid! NIP harus 18 digit angka.");
            }
            // Cek duplikasi NIP
            $check_nip = mysqli_query($conn, "SELECT nip FROM pegawai WHERE nip = '$nip'");
            if (mysqli_num_rows($check_nip) > 0) {
                throw new Exception("NIP/NIPPPK sudah terdaftar!");
            }
        }

        // Validasi nomor telepon jika diisi
        if (!empty($no_telp) && !preg_match("/^[0-9]{10,15}$/", $no_telp)) {
            throw new Exception("Format nomor telepon tidak valid!");
        }

        // Query insert data
        $query = "INSERT INTO pegawai (status_kepegawaian, nip, nama_pegawai, jabatan, golongan, alamat, no_telp) 
                  VALUES (?, ?, ?, ?, ?, ?, ?)";
                  
        // Prepare statement
        $stmt = mysqli_prepare($conn, $query);
        
        // Bind parameters
        mysqli_stmt_bind_param($stmt, "sssssss", 
            $status_kepegawaian,
            $nip,
            $nama_pegawai,
            $jabatan,
            $golongan,
            $alamat,
            $no_telp
        );

        // Eksekusi query
        if (mysqli_stmt_execute($stmt)) {
            // Jika berhasil
            redirectWithMessage("../pegawai.php", "success", "Data pegawai berhasil ditambahkan!");
        } else {
            // Jika gagal
            throw new Exception("Gagal menambahkan data: " . mysqli_error($conn));
        }

    } catch (Exception $e) {
        // Tangkap error dan redirect dengan pesan error
        redirectWithMessage("create.php", "error", $e->getMessage());
    }
} else {
    // Jika bukan POST request, redirect ke halaman create
    header("Location: create.php");
    exit();
}

// Tambahkan script untuk menampilkan alert di halaman tujuan
?>
<script>
// Script ini akan ditambahkan di file tujuan (pegawai.php atau create.php)
<?php if (isset($_SESSION['alert'])): ?>
    document.addEventListener('DOMContentLoaded', function() {
        Swal.fire({
            icon: '<?php echo $_SESSION['alert']['type'] == 'success' ? 'success' : 'error' ?>',
            title: '<?php echo $_SESSION['alert']['type'] == 'success' ? 'Berhasil!' : 'Gagal!' ?>',
            text: '<?php echo $_SESSION['alert']['message'] ?>',
            showConfirmButton: false,
            timer: 3000
        });
    });
    <?php unset($_SESSION['alert']); ?>
<?php endif; ?>
</script> 