<?php
session_start();
require_once '../config/database.php';
require_once '../config/config.php';
// Tambahkan library PHP QR Code
include '../lib/phpqrcode/qrlib.php';

if (isset($_GET['id'])) {
    $id = $_GET['id'];
    
    $query = "SELECT * FROM pegawai WHERE id_pegawai = ?";
    $stmt = mysqli_prepare($conn, $query);
    mysqli_stmt_bind_param($stmt, "i", $id);
    mysqli_stmt_execute($stmt);
    $result = mysqli_stmt_get_result($stmt);
    $pegawai = mysqli_fetch_assoc($result);
    
    if (!$pegawai) {
        $_SESSION['alert'] = [
            'type' => 'error',
            'message' => 'Data pegawai tidak ditemukan'
        ];
        header("Location: pegawai.php");
        exit();
    }

    // Generate QR Code
    $tempDir = "../temp/";
    if (!file_exists($tempDir)) {
        mkdir($tempDir);
    }
    $qrFile = $tempDir . 'qr_' . $pegawai['nip'] . '.png';
    QRcode::png($pegawai['nip'], $qrFile, QR_ECLEVEL_L, 10);
} else {
    header("Location: pegawai.php");
    exit();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Detail Pegawai - SPPD</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css" rel="stylesheet">
    <style>
        body {
            background: linear-gradient(135deg,rgb(245, 255, 254) 0%,rgb(153, 224, 238) 100%);
        }
        .profile-card {
            background: rgba(255, 255, 255, 0.9);
            border-radius: 15px;
            box-shadow: 0 0 20px rgba(0,0,0,0.1);
            overflow: hidden;
            margin-top: 20px;
        }
        .profile-header {
            background: linear-gradient(135deg, #4e73df 0%, #224abe 100%);
            color: white;
            padding: 20px;
            text-align: center;
        }
        .profile-img-container {
            position: relative;
            width: 150px;
            height: 150px;
            margin: -75px auto 20px;
        }
        .profile-img {
            width: 150px;
            height: 150px;
            border-radius: 50%;
            border: 5px solid white;
            box-shadow: 0 0 20px rgba(0,0,0,0.2);
            object-fit: cover;
        }
        .profile-body {
            padding: 20px;
        }
        .info-table {
            margin-top: 20px;
        }
        .info-table th {
            width: 30%;
            color: #4e73df;
            font-weight: 600;
        }
        .btn-back {
            background: #4e73df;
            color: white;
            border: none;
            padding: 10px 20px;
            border-radius: 5px;
            transition: all 0.3s;
        }
        .btn-back:hover {
            background: #224abe;
            transform: translateY(-2px);
        }
        .badge-status {
            font-size: 0.9em;
            padding: 8px 15px;
            border-radius: 20px;
        }
        .qr-code-container {
            text-align: center;
            margin: 20px 0;
        }
        .qr-code-container img {
            max-width: 200px;
            height: auto;
        }
    </style>
</head>
<body>
<?php include  '../includes/footer.php';
?>
<div class="page-header">
        <div class="d-flex justify-content-between align-items-center">
            <div>
                <h2></h2>
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="../dashboard.php"></a></li>
                        <li class="breadcrumb-item active"></li>
                    </ol>
                </nav>
            </div>
            
        </div>
    </div>
    <div class="container">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="../dashboard.php">Dashboard</a></li>
                <li class="breadcrumb-item"><a href="pegawai.php">Data Pegawai</a></li>
                <li class="breadcrumb-item active">Detail Pegawai</li>
            </ol>
        </nav>

        <div class="profile-card">
            <div class="profile-header">
                <h2 class="mb-0">Detail Pegawai</h2>
            </div>
            
            <div class="profile-img-container">
                <img src="../assets/img/pegawai/<?= !empty($pegawai['foto']) ? htmlspecialchars($pegawai['foto']) : 'default.jpg' ?>" 
                     class="profile-img" 
                     alt="Foto Pegawai">
            </div>

            <div class="profile-body">
                <h3 class="text-center mb-4"><?= htmlspecialchars($pegawai['nama_pegawai']) ?></h3>
                
                <div class="text-center mb-4">
                    <span class="badge bg-primary badge-status">
                        <?= htmlspecialchars($pegawai['jabatan']) ?>
                    </span>
                </div>

                <table class="table table-hover info-table">
                    <tr>
                        <th>NIP</th>
                        <td><?= htmlspecialchars($pegawai['nip']) ?></td>
                    </tr>
                    <tr>
                        <th>Jabatan</th>
                        <td><?= htmlspecialchars($pegawai['jabatan']) ?></td>
                    </tr>
                    <tr>
                        <th>Golongan</th>
                        <td><?= htmlspecialchars($pegawai['golongan']) ?></td>
                    </tr>
                    <tr>
                        <th>Unit Kerja</th>
                        <td><?= htmlspecialchars($pegawai['unit_kerja']) ?></td>
                    </tr>
                </table>

                <div class="qr-code-container">
                    <h4 class="mb-3">QR Code NIP</h4>
                    <img src="<?= $qrFile ?>" alt="QR Code NIP">
                </div>

                <div class="text-center mt-4">
                    <a href="pegawai.php" class="btn btn-back">
                        <i class="bi bi-arrow-left me-2"></i>Kembali
                    </a>
                    <a href="edit.php?id=<?= $pegawai['id_pegawai'] ?>" class="btn btn-warning">
                        <i class="bi bi-pencil me-2"></i>Edit
                    </a>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html> 