<?php
session_start();
require_once '../../config/config.php';
require_once '../../config/database.php';

if (isset($_GET['id'])) {
    $id = (int)$_GET['id'];
    
    $query = "DELETE FROM pejabat_daerah WHERE id_pejabat = ?";
    $stmt = mysqli_prepare($conn, $query);
    mysqli_stmt_bind_param($stmt, "i", $id);
    
    if (mysqli_stmt_execute($stmt)) {
        $_SESSION['alert'] = [
            'type' => 'success',
            'message' => 'Data pejabat berhasil dihapus!'
        ];
    } else {
        $_SESSION['alert'] = [
            'type' => 'danger',
            'message' => 'Gagal menghapus data pejabat!'
        ];
    }
    
    mysqli_stmt_close($stmt);
}

header("Location: ../index.php");
exit(); 