<?php
session_start();
require_once '../../config/config.php';
require_once '../../config/database.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $id = (int)$_POST['id_pejabat'];
    $nama = mysqli_real_escape_string($conn, $_POST['nama']);
    $nip = mysqli_real_escape_string($conn, $_POST['nip']);
    $jabatan = mysqli_real_escape_string($conn, $_POST['jabatan']);
    $pangkat = mysqli_real_escape_string($conn, $_POST['pangkat']);
    $golongan = mysqli_real_escape_string($conn, $_POST['golongan']);
    $unit_kerja = mysqli_real_escape_string($conn, $_POST['unit_kerja']);
    $status = mysqli_real_escape_string($conn, $_POST['status']);

    $query = "UPDATE pejabat_daerah 
              SET nama = ?, nip = ?, jabatan = ?, pangkat = ?, golongan = ?, unit_kerja = ?, status = ? 
              WHERE id_pejabat = ?";
    
    $stmt = mysqli_prepare($conn, $query);
    mysqli_stmt_bind_param($stmt, "sssssssi", $nama, $nip, $jabatan, $pangkat, $golongan, $unit_kerja, $status, $id);
    
    if (mysqli_stmt_execute($stmt)) {
        $_SESSION['alert'] = [
            'type' => 'success',
            'message' => 'Data pejabat berhasil diperbarui!'
        ];
    } else {
        $_SESSION['alert'] = [
            'type' => 'danger',
            'message' => 'Gagal memperbarui data pejabat!'
        ];
    }
    
    mysqli_stmt_close($stmt);
}

header("Location: ../index.php");
exit(); 