<?php
session_start();
require_once '../config/database.php';

// Query untuk mengambil data pejabat
$query = "SELECT * FROM pejabat_daerah 
          ORDER BY 
            CASE 
                WHEN LOWER(jabatan) LIKE '%bupati%' THEN 1
                WHEN LOWER(jabatan) LIKE '%wakil bupati%' THEN 2
                WHEN LOWER(jabatan) LIKE '%sekretaris daerah%' THEN 3
                WHEN LOWER(jabatan) LIKE '%asisten%' THEN 4
                WHEN LOWER(jabatan) LIKE '%kepala dinas%' THEN 5
                WHEN LOWER(jabatan) LIKE '%sekretaris%' THEN 6
                WHEN LOWER(jabatan) LIKE '%kepala bidang%' THEN 7
                WHEN LOWER(jabatan) LIKE '%kasubbag%' THEN 8
                ELSE 9
            END,
            nama ASC";
$result = mysqli_query($conn, $query);

// Pagination
$limit = isset($_GET['show']) ? (int)$_GET['show'] : 10;
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$offset = ($page - 1) * $limit;

// Search functionality
$search = isset($_GET['search']) ? mysqli_real_escape_string($conn, $_GET['search']) : '';
$where = '';
if (!empty($search)) {
    $where = "WHERE nama LIKE '%$search%' OR nip LIKE '%$search%' OR jabatan LIKE '%$search%'";
    $query = "SELECT * FROM pejabat_daerah 
              $where 
              ORDER BY 
                CASE 
                    WHEN LOWER(jabatan) LIKE '%bupati%' THEN 1
                    WHEN LOWER(jabatan) LIKE '%wakil bupati%' THEN 2
                    WHEN LOWER(jabatan) LIKE '%sekretaris daerah%' THEN 3
                    WHEN LOWER(jabatan) LIKE '%asisten%' THEN 4
                    WHEN LOWER(jabatan) LIKE '%kepala dinas%' THEN 5
                    WHEN LOWER(jabatan) LIKE '%sekretaris%' THEN 6
                    WHEN LOWER(jabatan) LIKE '%kepala bidang%' THEN 7
                    WHEN LOWER(jabatan) LIKE '%kasubbag%' THEN 8
                    ELSE 9
                END,
                nama ASC";
    $result = mysqli_query($conn, $query);
}

// Get total records for pagination
$total_records = mysqli_fetch_assoc(mysqli_query($conn, "SELECT COUNT(*) as total FROM pejabat_daerah $where"))['total'];
$total_pages = ceil($total_records / $limit);

?>

<!DOCTYPE html>
<html lang="en">
<head>
<link rel="icon" type="image/svg+xml" href="data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAyNCAyNCI+PHBhdGggZmlsbD0iIzRlNzNkZiIgZD0iTTIwLDhINFY2aDIwdjJIMjB6IE0xNSwxMEg0djJoMTFWMTB6IE00LDE2aDd2Mkg0VjE2eiBNMjEuNywxMy4zTDIwLjMsMTJsMS40LTEuNEMyMi4xLDEwLjIsMjIuMSw5LjgsMjEuNyw5LjRsLTEuMS0xLjFDMjAuMiw3LjksMTkuOCw3LjksMTkuNCw4LjNMMTgsMTBsLTEuNC0xLjRjLTAuNC0wLjQtMS0wLjQtMS40LDBsLTcuNSw3LjVjLTAuMiwwLjItMC4zLDAuNC0wLjMsMC43djIuOWMwLDAuNSwwLjQsMC45LDAuOSwwLjloMi45YzAuMywwLDAuNS0wLjEsMC43LTAuM2w3LjUtNy41QzIyLjEsMTQuMywyMi4xLDEzLjcsMjEuNywxMy4zeiIvPjwvc3ZnPg==">
    
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Data Pejabat</title>
    <?php include '../includes/header.php'; ?>
    <style>
        :root {
            --sidebar-width: 280px;
            --sidebar-mini-width: 70px;
            --primary-gradient: linear-gradient(135deg, #0ea5e9 0%, #2dd4bf 100%);
            --bg-gradient: linear-gradient(135deg, rgb(245, 255, 254) 0%, rgb(153, 224, 238) 100%);
        }

        body {
            background: var(--bg-gradient) !important;
            font-family: 'Segoe UI', system-ui, -apple-system, sans-serif;
            margin: 0;
            padding: 0;
            min-height: 100vh;
            overflow-x: hidden;
        }

        .container-fluid {
            background: transparent !important;
            position: relative;
            margin-left: var(--sidebar-width);
            width: calc(100% - var(--sidebar-width));
            min-height: 100vh;
            transition: all 0.3s ease;
            padding: 1rem;
        }

        body.sidebar-collapsed .container-fluid {
            margin-left: var(--sidebar-mini-width);
            width: calc(100% - var(--sidebar-mini-width));
        }

        /* Page Header Styling */
        .page-header {
            background: var(--primary-gradient);
            color: white;
            padding: 1.5rem;
            border-radius: 15px;
            margin-bottom: 1.5rem;
            box-shadow: 0 4px 15px rgba(78,115,223,0.1);
        }

        .page-header h2 {
            margin: 0;
            font-weight: 600;
        }

        .breadcrumb {
            margin: 0;
            background: transparent;
        }

        .breadcrumb-item a {
            color: rgba(255,255,255,0.8);
            text-decoration: none;
        }

        .breadcrumb-item.active {
            color: white;
        }

        /* Search and Filter Container */
        .search-filter-container {
            display: flex;
            gap: 12px;
            align-items: center;
            margin-bottom: 1rem;
        }

        .search-box {
            min-width: 300px;
        }

        .search-box .input-group {
            border-radius: 8px;
            overflow: hidden;
            background: white;
            box-shadow: 0 2px 4px rgba(14, 165, 233, 0.1);
        }

        .search-box .form-control {
            border: 1px solid rgba(14, 165, 233, 0.2);
            border-right: none;
            padding: 8px 16px;
            font-size: 14px;
        }

        .search-box .btn {
            background: var(--primary-gradient);
            border: none;
            color: white;
        }

        /* Button Styling */
        .btn-primary {
            background: var(--primary-gradient);
            border: none;
            padding: 0.8rem 1.5rem;
            border-radius: 10px;
            color: white;
            font-weight: 500;
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
            transition: all 0.3s ease;
        }

        .btn-primary:hover {
            background: linear-gradient(135deg, #0284c7 0%, #14b8a6 100%);
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(14, 165, 233, 0.2);
        }

        /* Table Styling */
        .card {
            background: white;
            border-radius: 15px;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
            margin: 0;
        }

        .card-body {
            padding: 0;
        }

        .table {
            margin-bottom: 0;
        }

        .table thead th {
            background: var(--primary-gradient) !important;
            color: white;
            font-weight: 600;
            border: none;
        }

        .table tbody td {
            padding: 12px !important;
            vertical-align: middle;
            border: 1px solid rgba(0, 0, 0, 0.1);
        }

        .table-hover tbody tr:hover {
            background-color: rgba(14, 165, 233, 0.04);
        }

        /* Per Page Select */
        .per-page-select {
            min-width: 80px;
        }

        .form-select {
            padding: 8px 12px;
            border: 1px solid rgba(14, 165, 233, 0.2);
            border-radius: 8px;
            background-color: white;
            font-size: 14px;
            cursor: pointer;
            box-shadow: 0 2px 4px rgba(14, 165, 233, 0.1);
        }

        /* Alert Styling */
        .alert-info {
            background: rgba(14, 165, 233, 0.1);
            border: 1px solid rgba(14, 165, 233, 0.2);
            color: #0ea5e9;
            border-radius: 8px;
            padding: 1rem;
        }

        /* Action Buttons */
        .action-buttons .btn {
            padding: 6px 12px;
            border-radius: 6px;
            transition: all 0.3s ease;
        }

        .action-buttons .btn-warning,
        .action-buttons .btn-danger {
            background: var(--primary-gradient);
            border: none;
            color: white;
        }

        .action-buttons .btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 15px rgba(14, 165, 233, 0.3);
        }

        /* Badge Styling */
        .badge {
            padding: 0.5em 0.75em;
            border-radius: 6px;
            font-weight: 500;
        }

        .bg-success {
            background: var(--primary-gradient) !important;
        }

        /* Eye button and actions styling */
        .btn-eye {
            background: none;
            border: none;
            color: #0ea5e9;
            padding: 0;
            width: 28px;
            height: 28px;
            display: flex;
            align-items: center;
            justify-content: center;
            cursor: pointer;
            transition: all 0.3s ease;
            border-radius: 4px;
        }

        .btn-eye:hover, .btn-eye.active {
            background: var(--primary-gradient);
            color: white;
        }

        .action-container {
            padding: 0.75rem;
            background: rgba(255, 255, 255, 0.9);
            border-radius: 6px;
            display: flex;
            gap: 8px;
            justify-content: flex-start;
            align-items: center;
            margin: 0;
            border: 1px solid rgba(14, 165, 233, 0.2);
            animation: slideDown 0.3s ease-out;
        }

        @keyframes slideDown {
            from {
                opacity: 0;
                transform: translateY(-10px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .btn-soft-info,
        .btn-soft-warning,
        .btn-soft-danger {
            color: #0ea5e9;
            background: rgba(14, 165, 233, 0.1);
            border: 1px solid rgba(14, 165, 233, 0.2);
            transition: all 0.3s ease;
            padding: 6px 12px;
            font-size: 13px;
            display: inline-flex;
            align-items: center;
            gap: 6px;
            border-radius: 6px;
        }

        .btn-soft-info:hover,
        .btn-soft-warning:hover,
        .btn-soft-danger:hover {
            background: var(--primary-gradient);
            color: white;
            transform: translateY(-2px);
            box-shadow: 0 4px 12px rgba(14, 165, 233, 0.15);
        }

        /* Table container adjustments */
        .table-responsive {
            margin: 0;
            border-radius: 15px;
            overflow: hidden;
        }

        /* Mobile Responsiveness */
        @media (max-width: 768px) {
            .container-fluid {
                margin-left: 0;
                width: 100%;
                padding: 0.75rem;
            }

            body.sidebar-collapsed .container-fluid {
                margin-left: 0;
                width: 100%;
            }
        }
    </style>
</head>
<body>
    <?php include '../includes/sidebar.php'; ?>
    <div class="container-fluid">
        <div class="page-header">
            <div class="d-flex justify-content-between align-items-center">
                <div>
                    <h2>Data Pejabat</h2>
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            
                            <li class="breadcrumb-item active">Pejabat</li>
                        </ol>
                    </nav>
                </div>
            </div>
        </div>

        <div class="d-flex justify-content-between align-items-center mb-3">
            <div class="d-flex gap-2">
                <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addPejabatModal">
                    <i class="bi bi-plus-circle"></i>
                    Tambah Data
                </button>
              
            </div>
            
            <div class="search-filter-container">
                <div class="search-box">
                    <form action="" method="GET" class="d-flex">
                        <div class="input-group">
                            <input type="text" 
                                   class="form-control" 
                                   name="search" 
                                   value="<?= isset($_GET['search']) ? htmlspecialchars($_GET['search']) : '' ?>" 
                                   placeholder="Cari nama, NIP, jabatan...">
                            <button class="btn" type="submit">
                                <i class="bi bi-search"></i>
                            </button>
                        </div>
                    </form>
                </div>
                
                <div class="per-page-select">
                    <select class="form-select" id="per_page" name="per_page">
                        <option value="10" <?= $limit == 10 ? 'selected' : '' ?>>10</option>
                        <option value="25" <?= $limit == 25 ? 'selected' : '' ?>>25</option>
                        <option value="50" <?= $limit == 50 ? 'selected' : '' ?>>50</option>
                        <option value="100" <?= $limit == 100 ? 'selected' : '' ?>>100</option>
                    </select>
                </div>
            </div>
        </div>

        <?php if(!empty($search)): ?>
        <div class="alert alert-info">
            <i class="bi bi-info-circle me-2"></i>
            Menampilkan hasil pencarian untuk: <strong><?= htmlspecialchars($search) ?></strong>
            (<?= $total_records ?> data ditemukan)
        </div>
        <?php endif; ?>

        <div class="card">
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-hover mb-0">
                        <thead>
                            <tr>
                                <th>No.</th>
                                <th>Nama Pejabat</th>
                                <th>NIP</th>
                                <th>Jabatan</th>
                                <th>Pangkat</th>
                                <th>Golongan</th>
                                <th>Unit Kerja</th>
                                <th>Status</th>
                                <th>Aksi</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php 
                            $no = $offset + 1;
                            while ($row = mysqli_fetch_assoc($result)): 
                            ?>
                            <tr>
                                <td><?= $no++ ?></td>
                                <td><?= htmlspecialchars($row['nama']) ?></td>
                                <td><?= htmlspecialchars($row['nip']) ?></td>
                                <td><?= htmlspecialchars($row['jabatan']) ?></td>
                                <td><?= htmlspecialchars($row['pangkat']) ?></td>
                                <td><?= htmlspecialchars($row['golongan']) ?></td>
                                <td><?= htmlspecialchars($row['unit_kerja']) ?></td>
                                <td>
                                    <span class="badge bg-<?= $row['status'] == 'aktif' ? 'success' : 'danger' ?>">
                                        <?= ucfirst($row['status']) ?>
                                    </span>
                                </td>
                                <td class="action-buttons">
                                    <button type="button" class="btn btn-warning btn-sm" onclick="editPejabat(<?= $row['id_pejabat'] ?>)">
                                        <i class="bi bi-pencil"></i>
                                    </button>
                                    <button type="button" class="btn btn-danger btn-sm" onclick="deletePejabat(<?= $row['id_pejabat'] ?>)">
                                        <i class="bi bi-trash"></i>
                                    </button>
                                </td>
                            </tr>
                            <?php endwhile; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <!-- Pagination -->
        <?php if ($total_pages > 1): ?>
        <div class="d-flex justify-content-between align-items-center mt-3">
            <div class="text-muted">
                Menampilkan <?= $offset + 1 ?>-<?= min($offset + $limit, $total_records) ?> 
                dari <?= $total_records ?> data
            </div>
            <nav aria-label="Page navigation">
                <ul class="pagination mb-0">
                    <?php for ($i = 1; $i <= $total_pages; $i++): ?>
                    <li class="page-item <?= $i == $page ? 'active' : '' ?>">
                        <a class="page-link" href="?page=<?= $i ?>&show=<?= $limit ?>&search=<?= urlencode($search) ?>">
                            <?= $i ?>
                        </a>
                    </li>
                    <?php endfor; ?>
                </ul>
            </nav>
        </div>
        <?php endif; ?>
    </div>

    <!-- Add Modal -->
    <?php include 'modals/add_modal.php'; ?>

    <?php include '../includes/footer.php'; ?>
    
    <script>
    document.addEventListener('DOMContentLoaded', function() {
        const body = document.body;
        const sidebarToggle = document.querySelector('.sidebar-toggle');
        
        // Check initial state
        if (localStorage.getItem('sidebarCollapsed') === 'true') {
            body.classList.add('sidebar-collapsed');
        }

        // Toggle event
        sidebarToggle.addEventListener('click', function(e) {
            e.preventDefault();
            body.classList.toggle('sidebar-collapsed');
            localStorage.setItem('sidebarCollapsed', body.classList.contains('sidebar-collapsed'));
        });
    });

    function toggleActions(button) {
        const mainRow = button.closest('tr');
        const actionRow = mainRow.nextElementSibling;
        const icon = button.querySelector('i');
        
        button.classList.toggle('active');
        mainRow.classList.toggle('active');
        
        if (actionRow.style.display === 'none') {
            actionRow.style.display = 'table-row';
            actionRow.querySelector('.action-container').style.animation = 'slideDown 0.3s ease-out';
        } else {
            const container = actionRow.querySelector('.action-container');
            container.style.animation = 'slideDown 0.3s ease-out reverse';
            setTimeout(() => {
                actionRow.style.display = 'none';
            }, 280);
        }
    }

    // Handle search input
    document.getElementById('searchInput').addEventListener('keyup', function(e) {
        if (e.key === 'Enter') {
            window.location.href = '?search=' + this.value + '&show=' + document.getElementById('showEntries').value;
        }
    });

    // Handle show entries change
    document.getElementById('showEntries').addEventListener('change', function() {
        window.location.href = '?show=' + this.value + '&search=' + document.getElementById('searchInput').value;
    });

    function editPejabat(id) {
        window.location.href = 'edit.php?id=' + id;
    }

    function deletePejabat(id) {
        if (confirm('Apakah Anda yakin ingin menghapus data ini?')) {
            window.location.href = 'actions/hapus.php?id=' + id;
        }
    }
    </script>
</body>
</html> 