<?php
session_start();
require_once 'config/database.php';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $username = mysqli_real_escape_string($conn, $_POST['username']);
    $password = $_POST['password'];

    $query = "SELECT * FROM users WHERE username = ?";
    $stmt = mysqli_prepare($conn, $query);
    mysqli_stmt_bind_param($stmt, "s", $username);
    mysqli_stmt_execute($stmt);
    $result = mysqli_stmt_get_result($stmt);

    if ($user = mysqli_fetch_assoc($result)) {
        if (password_verify($password, $user['password'])) {
            // Set session variables
            $_SESSION['user_id'] = $user['id'];
            $_SESSION['username'] = $user['username'];
            $_SESSION['nama_lengkap'] = $user['nama_lengkap'];
            $_SESSION['level'] = $user['level'];
            $_SESSION['foto'] = $user['foto'];
            
            // Tampilkan animasi loading dan success sebelum redirect
            ?>
            <!DOCTYPE html>
            <html>
            <head>
                <title>Login Success</title>
                <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="assets/img/pemkab.png">
    <link rel="shortcut icon" type="image/x-icon" href="assets/img/pemkab.png">
    
                <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
                <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.8.1/font/bootstrap-icons.css">
                <style>
                    body {
                        background-image: url('assets/img/peta.png') !important;
                        background-size: cover !important;
                        background-position: center !important;
                        background-repeat: no-repeat !important;
                        background-attachment: fixed !important;
                        height: 100vh;
                        margin: 0;
                        display: flex;
                        align-items: center;
                        justify-content: center;
                        font-family: 'Poppins', sans-serif;
                        overflow: hidden; /* Prevent scrolling */
                    }
                    .login-success {
                        text-align: center;
                        color: white;
                        animation: fadeInUp 0.20s ease-out;
                    }
                    .success-icon {
                        width: 100px;
                        height: 100px;
                        background: white;
                        border-radius: 50%;
                        display: flex;
                        align-items: center;
                        justify-content: center;
                        margin: 0 auto 20px;
                        position: relative;
                        animation: scaleIn 0.8s ease-out 0.8s both;
                        box-shadow: 0 4px 15px rgba(0,0,0,0.1);
                    }
                    .success-icon i {
                        font-size: 50px;
                        color: #4CAF50;
                        opacity: 0;
                        animation: fadeIn 0.5s ease-out 1.6s forwards;
                    }
                    @keyframes scaleIn {
                        from {
                            transform: scale(0) rotate(-180deg);
                        }
                        to {
                            transform: scale(1) rotate(0);
                        }
                    }
                    @keyframes fadeInUp {
                        from {
                            opacity: 0;
                            transform: translateY(20px);
                        }
                        to {
                            opacity: 1;
                            transform: translateY(0);
                        }
                    }
                    @keyframes fadeIn {
                        from {
                            opacity: 0;
                        }
                        to {
                            opacity: 1;
                        }
                    }
                    .welcome-text {
                        margin-top: 20px;
                        opacity: 0;
                        animation: fadeIn 0.5s ease-out 2.1s forwards;
                        font-size: 24px;
                        font-weight: 600;
                        text-shadow: 0 2px 4px rgba(0,0,0,0.1);
                    }
                    .redirect-text {
                        font-size: 16px;
                        opacity: 0;
                        animation: fadeIn 0.5s ease-out 2.6s forwards;
                        color: rgba(255,255,255,0.9);
                        margin-top: 10px;
                    }
                    .progress-bar {
                        width: 200px;
                        height: 3px;
                        background: rgba(255,255,255,0.2);
                        margin: 20px auto 0;
                        border-radius: 3px;
                        overflow: hidden;
                    }
                    .progress-fill {
                        height: 100%;
                        background: white;
                        width: 0%;
                        animation: fillProgress 4s linear forwards;
                    }
                    @keyframes fillProgress {
                        0% { width: 0%; }
                        15% { width: 15%; }
                        25% { width: 25%; }
                        50% { width: 45%; }
                        75% { width: 75%; }
                        100% { width: 100%; }
                    }
                </style>
            </head>
            <body>
                <div class="login-success">
                    <div class="success-icon">
                        <i class="bi bi-check-lg"></i>
                    </div>
                    <h3 class="welcome-text">Selamat Datang, <?= htmlspecialchars($user['username']) ?>!</h3>
                    <p class="redirect-text">Mengalihkan ke Dashboard...</p>
                    <div class="progress-bar">
                        <div class="progress-fill"></div>
                    </div>
                </div>

                <script>
                    // Redirect ke dashboard setelah 4 detik
                    setTimeout(() => {
                        window.location.href = 'dashboard.php';
                    }, 4000);
                </script>
            </body>
            </html>
            <?php
            exit;
        } else {
            $_SESSION['login_error'] = "Password yang Anda masukkan salah!";
        }
    } else {
        $_SESSION['login_error'] = "Username tidak ditemukan!";
    }
    
    header("Location: login.php");
    exit;
}

// Jika akses langsung ke file ini tanpa POST
$_SESSION['error'] = "Akses tidak sah!";
header("Location: login.php");
exit(); 