<?php

if (isset($_FILES['foto']) && $_FILES['foto']['error'] == 0) {
    $allowed = ['jpg', 'jpeg', 'png', 'gif'];
    $filename = $_FILES['foto']['name'];
    $filetype = pathinfo($filename, PATHINFO_EXTENSION);
    
    if (in_array(strtolower($filetype), $allowed)) {
        // Create unique filename
        $newname = 'user_' . $user_id . '_' . time() . '.' . $filetype;
        $upload_path = 'assets/img/users/' . $newname;
        
        // Delete old photo if exists
        if (!empty($user['foto'])) {
            $old_photo = 'assets/img/users/' . $user['foto'];
            if (file_exists($old_photo) && $old_photo != 'assets/img/users/default_avatar.jpg') {
                unlink($old_photo);
            }
        }
        
        // Upload new photo
        if (move_uploaded_file($_FILES['foto']['tmp_name'], $upload_path)) {
            // Update database
            $query = "UPDATE users SET foto = ? WHERE id = ?";
            $stmt = $conn->prepare($query);
            $stmt->bind_param("si", $newname, $user_id);
            
            if ($stmt->execute()) {
                // Update session
                $_SESSION['user_foto'] = $newname;
                $_SESSION['success'] = "Foto profil berhasil diperbarui!";
            } else {
                $_SESSION['error'] = "Gagal mengupdate foto di database!";
            }
        } else {
            $_SESSION['error'] = "Gagal mengupload foto!";
        }
    } else {
        $_SESSION['error'] = "Tipe file tidak diizinkan!";
    }
} 