<?php
session_start();
require_once 'config/koneksi.php';

header('Content-Type: application/json');

// Validasi input
if (empty($_POST['nama_lengkap']) || empty($_POST['username']) || empty($_POST['password']) || 
    empty($_POST['no_wa']) || empty($_POST['bidang']) || empty($_POST['level'])) {
    echo json_encode([
        'status' => 'error',
        'message' => 'Semua field harus diisi'
    ]);
    exit;
}

// Ambil dan bersihkan data
$nama_lengkap = htmlspecialchars(trim($_POST['nama_lengkap']));
$username = htmlspecialchars(trim($_POST['username']));
$password = trim($_POST['password']);
$no_wa = htmlspecialchars(trim($_POST['no_wa']));
$bidang = htmlspecialchars(trim($_POST['bidang']));
$level = htmlspecialchars(trim($_POST['level'])); // Mengambil level dari form
$status = 'pending'; // Set status awal sebagai pending

// Validasi level yang diperbolehkan
$allowed_levels = ['admin_sppd', 'pimpinan'];
if (!in_array($level, $allowed_levels)) {
    echo json_encode([
        'status' => 'error',
        'message' => 'Level user tidak valid'
    ]);
    exit;
}

// Validasi nomor WhatsApp
if (!preg_match("/^[0-9]{10,13}$/", $no_wa)) {
    echo json_encode([
        'status' => 'error',
        'message' => 'Format nomor WhatsApp tidak valid'
    ]);
    exit;
}

// Cek username sudah digunakan atau belum
$stmt = $conn->prepare("SELECT id FROM users WHERE username = ?");
$stmt->bind_param("s", $username);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0) {
    echo json_encode([
        'status' => 'error',
        'message' => 'Username sudah digunakan'
    ]);
    exit;
}

// Generate OTP
$otp = sprintf("%06d", mt_rand(1, 999999));

// Hash password
$hashed_password = password_hash($password, PASSWORD_DEFAULT);

// Simpan data user
$stmt = $conn->prepare("INSERT INTO users (nama_lengkap, username, password, no_wa, level, bidang, otp, status) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
$stmt->bind_param("ssssssss", $nama_lengkap, $username, $hashed_password, $no_wa, $level, $bidang, $otp, $status);

if ($stmt->execute()) {
    echo json_encode([
        'status' => 'success',
        'message' => 'Registrasi berhasil! Silahkan tunggu admin memverifikasi akun Anda.'
    ]);
} else {
    echo json_encode([
        'status' => 'error',
        'message' => 'Terjadi kesalahan saat menyimpan data: ' . $conn->error
    ]);
}

$stmt->close();
$conn->close();
?> 