<?php
session_start();
require_once 'config/database.php';

if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $user_id = $_SESSION['user_id'];
    $nama_lengkap = $_POST['nama_lengkap'];
    $new_password = $_POST['new_password'];
    
    // Handle foto upload
    if (isset($_FILES['foto']) && $_FILES['foto']['error'] == 0) {
        $allowed = ['jpg', 'jpeg', 'png', 'gif'];
        $filename = $_FILES['foto']['name'];
        $filetype = pathinfo($filename, PATHINFO_EXTENSION);
        
        if (in_array(strtolower($filetype), $allowed)) {
            // Buat nama file unik
            $newname = 'user_' . $user_id . '_' . time() . '.' . $filetype;
            $upload_path = 'assets/img/users/' . $newname;
            
            // Hapus foto lama jika bukan foto default
            $query = "SELECT foto FROM users WHERE id = ?";
            $stmt = $conn->prepare($query);
            $stmt->bind_param("i", $user_id);
            $stmt->execute();
            $old_foto = $stmt->get_result()->fetch_assoc()['foto'];
            
            if ($old_foto != 'default_avatar.png' && file_exists('assets/img/users/' . $old_foto)) {
                unlink('assets/img/users/' . $old_foto);
            }
            
            if (move_uploaded_file($_FILES['foto']['tmp_name'], $upload_path)) {
                // Update database dengan nama file baru
                $query = "UPDATE users SET foto = ? WHERE id = ?";
                $stmt = $conn->prepare($query);
                $stmt->bind_param("si", $newname, $user_id);
                $stmt->execute();
                
                // Update session
                $_SESSION['user_foto'] = $newname;
            }
        }
    }
    
    // Update nama lengkap
    $query = "UPDATE users SET nama_lengkap = ? WHERE id = ?";
    $stmt = $conn->prepare($query);
    $stmt->bind_param("si", $nama_lengkap, $user_id);
    $stmt->execute();
    
    // Update password jika diisi
    if (!empty($new_password)) {
        $hashed_password = password_hash($new_password, PASSWORD_DEFAULT);
        $query = "UPDATE users SET password = ? WHERE id = ?";
        $stmt = $conn->prepare($query);
        $stmt->bind_param("si", $hashed_password, $user_id);
        $stmt->execute();
    }
    
    $_SESSION['success'] = "Profil berhasil diperbarui!";
    header("Location: profile.php");
    exit();
} 