<?php
session_start();
require_once 'config/database.php';

if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

$user_id = $_SESSION['user_id'];
$query = "SELECT * FROM users WHERE id = ?";
$stmt = $conn->prepare($query);
$stmt->bind_param("i", $user_id);
$stmt->execute();
$user = $stmt->get_result()->fetch_assoc();
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Profile - SPPD System</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.8.1/font/bootstrap-icons.css">
    <link rel="stylesheet" href="assets/css/style.css">
    <link rel="icon" type="image/svg+xml" href="data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAyNCAyNCI+PHBhdGggZmlsbD0iIzRlNzNkZiIgZD0iTTIwLDhINFY2aDIwdjJIMjB6IE0xNSwxMEg0djJoMTFWMTB6IE00LDE2aDd2Mkg0VjE2eiBNMjEuNywxMy4zTDIwLjMsMTJsMS40LTEuNEMyMi4xLDEwLjIsMjIuMSw5LjgsMjEuNyw5LjRsLTEuMS0xLjFDMjAuMiw3LjksMTkuOCw3LjksMTkuNCw4LjNMMTgsMTBsLTEuNC0xLjRjLTAuNC0wLjQtMS0wLjQtMS40LDBsLTcuNSw3LjVjLTAuMiwwLjItMC4zLDAuNC0wLjMsMC43djIuOWMwLDAuNSwwLjQsMC45LDAuOSwwLjloMi45YzAuMywwLDAuNS0wLjEsMC43LTAuM2w3LjUtNy41QzIyLjEsMTQuMywyMi4xLDEzLjcsMjEuNywxMy4zeiIvPjwvc3ZnPg==">
    
    <style>
        :root {
            --primary-gradient: linear-gradient(135deg, #0ea5e9 0%, #2dd4bf 100%);
            --bg-gradient: linear-gradient(135deg, rgb(245, 255, 254) 0%, rgb(153, 224, 238) 100%);
        }

        body {
            background: var(--bg-gradient) !important;
            font-family: 'Segoe UI', system-ui, -apple-system, sans-serif;
            min-height: 100vh;
        }

        .container {
            padding-top: 2rem;
            padding-bottom: 2rem;
        }

        .card {
            background: white;
            backdrop-filter: blur(10px);
            border: none;
            border-radius: 15px;
            box-shadow: 0 8px 32px 0 rgba(31, 38, 135, 0.15);
            overflow: hidden;
            transition: all 0.3s ease;
        }

        .card:hover {
            transform: translateY(-5px);
        }

        .card-header {
            background: var(--primary-gradient);
            color: white;
            border: none;
            padding: 1.5rem;
        }

        .btn-primary {
            background: var(--primary-gradient);
            border: none;
            padding: 0.8rem 1.5rem;
            border-radius: 10px;
            font-weight: 500;
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
            transition: all 0.3s ease;
        }

        .btn-primary:hover {
            background: linear-gradient(135deg, #0284c7 0%, #14b8a6 100%);
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(14, 165, 233, 0.2);
        }

        .btn-outline-primary {
            color: #0ea5e9;
            border-color: #0ea5e9;
            background: transparent;
            transition: all 0.3s ease;
        }

        .btn-outline-primary:hover {
            background: var(--primary-gradient);
            border-color: transparent;
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(14, 165, 233, 0.2);
        }

        .badge {
            padding: 0.5em 0.75em;
            border-radius: 6px;
            font-weight: 500;
        }

        .bg-primary {
            background: var(--primary-gradient) !important;
        }

        .input-group-text {
            background: rgba(14, 165, 233, 0.1);
            border: 1px solid rgba(14, 165, 233, 0.2);
            color: #0ea5e9;
        }

        .form-control {
            border: 1px solid rgba(14, 165, 233, 0.2);
            padding: 0.8rem 1rem;
        }

        .form-control:focus {
            border-color: #0ea5e9;
            box-shadow: 0 0 0 0.2rem rgba(14, 165, 233, 0.15);
        }

        .text-primary {
            color: #0ea5e9 !important;
        }

        .rounded-circle {
            border: 4px solid white;
            box-shadow: 0 4px 12px rgba(14, 165, 233, 0.15);
        }

        /* Camera icon button */
        label[for="upload-foto"] {
            background: var(--primary-gradient);
            color: white;
            width: 32px;
            height: 32px;
            display: flex;
            align-items: center;
            justify-content: center;
            border-radius: 50%;
            cursor: pointer;
            transition: all 0.3s ease;
        }

        label[for="upload-foto"]:hover {
            transform: translateY(-2px) scale(1.1);
            box-shadow: 0 4px 12px rgba(14, 165, 233, 0.2);
        }

        /* Info icons */
        .bi-calendar,
        .bi-shield-check {
            color: #0ea5e9;
            font-size: 1.2rem;
        }

        /* Alert styling */
        .alert-success {
            background: rgba(16, 185, 129, 0.1);
            border: none;
            color: #10b981;
            border-radius: 10px;
        }

        /* Responsive Design */
        @media (max-width: 768px) {
            .container {
                padding-top: 1rem;
                padding-bottom: 1rem;
            }

            .card {
                margin-bottom: 1rem;
            }
        }

        /* Add these styles to the existing style section */
        .input-group .btn-outline-secondary {
            border-color: rgba(14, 165, 233, 0.2);
            color: #0ea5e9;
            background: transparent;
            padding: 0.8rem;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .input-group .btn-outline-secondary:hover {
            background: rgba(14, 165, 233, 0.1);
            color: #0ea5e9;
            border-color: rgba(14, 165, 233, 0.3);
        }

        .input-group .btn-outline-secondary:focus {
            box-shadow: none;
            border-color: #0ea5e9;
        }

        .input-group .btn-outline-secondary i {
            font-size: 1.1rem;
            transition: all 0.3s ease;
        }

        .input-group .btn-outline-secondary:active {
            background: rgba(14, 165, 233, 0.2);
        }
    </style>
</head>
<body class="bg-light">
    <!-- Navbar disini -->
    
    <div class="container py-4">
        <!-- Header dengan tombol kembali -->
        <div class="d-flex justify-content-between align-items-center mb-4">
            <a href="dashboard.php" class="btn btn-outline-primary">
                <i class="bi bi-arrow-left me-2"></i>Kembali ke Dashboard
            </a>
            <h4 class="mb-0">Pengaturan Profil</h4>
        </div>

        <div class="row justify-content-center">
            <div class="col-lg-4 col-md-6 mb-4">
                <!-- Card Profil -->
                <div class="card shadow-sm border-0">
                    <div class="card-body text-center">
                        <div class="position-relative d-inline-block mb-3">
                            <img src="assets/img/users/<?php echo $user['foto']; ?>" 
                                 class="rounded-circle shadow" 
                                 style="width: 150px; height: 150px; object-fit: cover;" 
                                 id="preview-foto">
                            <label for="upload-foto" 
                                   class="position-absolute bottom-0 end-0 bg-white rounded-circle p-2 shadow-sm" 
                                   style="cursor: pointer; transition: all 0.3s ease;">
                                <i class="bi bi-camera"></i>
                            </label>
                        </div>
                        <h5 class="mb-1"><?php echo $user['nama_lengkap']; ?></h5>
                        <span class="badge bg-primary rounded-pill mb-3"><?php echo ucfirst($user['level']); ?></span>
                        <p class="text-muted mb-0">
                            <i class="bi bi-person me-2"></i><?php echo $user['username']; ?>
                        </p>
                    </div>
                </div>

                <!-- Info Card -->
                <div class="card shadow-sm border-0 mt-4">
                    <div class="card-body">
                        <h6 class="card-title mb-3">Informasi Akun</h6>
                        <div class="d-flex align-items-center mb-3">
                            <div class="flex-shrink-0">
                                <i class="bi bi-calendar text-primary"></i>
                            </div>
                            <div class="flex-grow-1 ms-3">
                                <small class="text-muted d-block">Bergabung Sejak</small>
                                <span>March 2024</span>
                            </div>
                        </div>
                        <div class="d-flex align-items-center">
                            <div class="flex-shrink-0">
                                <i class="bi bi-shield-check text-primary"></i>
                            </div>
                            <div class="flex-grow-1 ms-3">
                                <small class="text-muted d-block">Status</small>
                                <span>Aktif</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-lg-6 col-md-8">
                <!-- Form Card -->
                <div class="card shadow-sm border-0">
                    <div class="card-header bg-white py-3">
                        <h5 class="card-title mb-0">Edit Profil</h5>
                    </div>
                    <div class="card-body">
                        <?php if(isset($_SESSION['success'])): ?>
                            <div class="alert alert-success alert-dismissible fade show" role="alert">
                                <?php echo $_SESSION['success']; unset($_SESSION['success']); ?>
                                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                            </div>
                        <?php endif; ?>

                        <form action="process_update_profile.php" method="POST" enctype="multipart/form-data">
                            <input type="file" 
                                   id="upload-foto" 
                                   name="foto" 
                                   class="d-none" 
                                   accept="image/*">
                            
                            <div class="mb-4">
                                <label class="form-label">Nama Lengkap</label>
                                <div class="input-group">
                                    <span class="input-group-text bg-light">
                                        <i class="bi bi-person"></i>
                                    </span>
                                    <input type="text" 
                                           class="form-control" 
                                           name="nama_lengkap" 
                                           value="<?php echo $user['nama_lengkap']; ?>">
                                </div>
                            </div>
                            
                            <div class="mb-4">
                                <label class="form-label">Username</label>
                                <div class="input-group">
                                    <span class="input-group-text bg-light">
                                        <i class="bi bi-at"></i>
                                    </span>
                                    <input type="text" 
                                           class="form-control bg-light" 
                                           value="<?php echo $user['username']; ?>" 
                                           readonly>
                                </div>
                            </div>
                            
                            <div class="mb-4">
                                <label class="form-label">Password Saat Ini</label>
                                <div class="input-group">
                                    <span class="input-group-text bg-light">
                                        <i class="bi bi-key"></i>
                                    </span>
                                    <input type="password" 
                                           class="form-control" 
                                           name="current_password"
                                           id="currentPassword"
                                           placeholder="Masukkan password saat ini">
                                    <button class="btn btn-outline-secondary" 
                                            type="button" 
                                            id="toggleCurrentPassword">
                                        <i class="bi bi-eye"></i>
                                    </button>
                                </div>
                            </div>

                            <div class="mb-4">
                                <label class="form-label">Password Baru</label>
                                <div class="input-group">
                                    <span class="input-group-text bg-light">
                                        <i class="bi bi-key"></i>
                                    </span>
                                    <input type="password" 
                                           class="form-control" 
                                           name="new_password"
                                           id="newPassword"
                                           placeholder="Masukkan password baru">
                                    <button class="btn btn-outline-secondary" 
                                            type="button" 
                                            id="toggleNewPassword">
                                        <i class="bi bi-eye"></i>
                                    </button>
                                </div>
                                <small class="text-muted">Kosongkan jika tidak ingin mengubah password</small>
                            </div>
                            
                            <div class="d-grid gap-2">
                                <button type="submit" class="btn btn-primary">
                                    <i class="bi bi-save me-2"></i>Simpan Perubahan
                                </button>
                                <button type="reset" class="btn btn-light">
                                    <i class="bi bi-arrow-counterclockwise me-2"></i>Reset Form
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
    document.getElementById('upload-foto').addEventListener('change', function(e) {
        const file = e.target.files[0];
        if (file) {
            const reader = new FileReader();
            reader.onload = function(e) {
                document.getElementById('preview-foto').src = e.target.result;
            }
            reader.readAsDataURL(file);
        }
    });

    document.getElementById('toggleCurrentPassword').addEventListener('click', function() {
        const input = document.getElementById('currentPassword');
        const icon = this.querySelector('i');
        
        if (input.type === 'password') {
            input.type = 'text';
            icon.classList.remove('bi-eye');
            icon.classList.add('bi-eye-slash');
        } else {
            input.type = 'password';
            icon.classList.remove('bi-eye-slash');
            icon.classList.add('bi-eye');
        }
    });

    document.getElementById('toggleNewPassword').addEventListener('click', function() {
        const input = document.getElementById('newPassword');
        const icon = this.querySelector('i');
        
        if (input.type === 'password') {
            input.type = 'text';
            icon.classList.remove('bi-eye');
            icon.classList.add('bi-eye-slash');
        } else {
            input.type = 'password';
            icon.classList.remove('bi-eye-slash');
            icon.classList.add('bi-eye');
        }
    });
    </script>
</body>
</html> 