<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Register - SPPD</title>
    
    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="assets/img/pemkab.png">
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.8.1/font/bootstrap-icons.css">
    
    <!-- SweetAlert2 CSS -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11.0.19/dist/sweetalert2.min.css">
    
    <!-- Custom fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700&display=swap" rel="stylesheet">
    
    <!-- jQuery -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <!-- jQuery Validate -->
    <script src="https://cdn.jsdelivr.net/npm/jquery-validation@1.19.3/dist/jquery.validate.min.js"></script>
    <!-- SweetAlert2 JS -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11.0.19/dist/sweetalert2.all.min.js"></script>
    <!-- Bootstrap Bundle JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    
    <style>
        body {
            font-family: 'Poppins', sans-serif;
            background: linear-gradient(135deg, #f6f9fc 0%, #edf2f7 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
        }
        
        .register-card {
            background: white;
            border-radius: 20px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.08);
            overflow: hidden;
            position: relative;
        }
        
        .register-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 5px;
            background: linear-gradient(135deg, #0ea5e9 0%, #2dd4bf 100%);
        }
        
        .form-control {
            border-radius: 10px;
            padding: 12px 16px;
            border: 1px solid #e2e8f0;
        }
        
        .form-control:focus {
            border-color: #0ea5e9;
            box-shadow: 0 0 0 3px rgba(14, 165, 233, 0.1);
        }
        
        .btn-primary {
            background: linear-gradient(135deg, #0ea5e9 0%, #2dd4bf 100%);
            border: none;
            border-radius: 10px;
            padding: 12px 24px;
            font-weight: 500;
            transition: all 0.3s ease;
        }
        
        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(14, 165, 233, 0.2);
        }
        
        .logo-container {
            text-align: center;
            margin-bottom: 2rem;
        }
        
        .logo-container img {
            width: 80px;
            height: auto;
        }
        
        .step-indicator {
            display: flex;
            justify-content: center;
            margin-bottom: 2rem;
        }
        
        .step {
            width: 30px;
            height: 30px;
            border-radius: 50%;
            background: #e2e8f0;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 10px;
            color: #64748b;
            font-weight: 600;
            position: relative;
        }
        
        .step.active {
            background: linear-gradient(135deg, #0ea5e9 0%, #2dd4bf 100%);
            color: white;
        }
        
        .step::after {
            content: '';
            position: absolute;
            right: -20px;
            top: 50%;
            width: 20px;
            height: 2px;
            background: #e2e8f0;
        }
        
        .step:last-child::after {
            display: none;
        }
        
        .alert {
            border-radius: 10px;
        }
        
        .form-group {
            position: relative;
        }
        
        .password-toggle {
            position: absolute;
            right: 10px;
            top: 50%;
            transform: translateY(-50%);
            cursor: pointer;
            color: #64748b;
            padding: 5px;
            z-index: 10;
        }
        
        .password-toggle:hover {
            color: #0ea5e9;
        }
        
        .password-field-container {
            position: relative;
        }

        input[type="password"] {
            padding-right: 40px;
        }

        .login-button-container {
            margin-top: 20px;
        }
        
        .login-button {
            background: linear-gradient(135deg, #0ea5e9 0%, #2dd4bf 100%);
            color: white;
            border: none;
            padding: 12px 24px;
            border-radius: 10px;
            font-size: 16px;
            font-weight: 500;
            cursor: pointer;
            transition: all 0.3s ease;
            display: inline-flex;
            align-items: center;
            gap: 8px;
            box-shadow: 0 4px 6px -1px rgba(14, 165, 233, 0.2);
        }
        
        .login-button:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 12px -2px rgba(14, 165, 233, 0.3);
        }
        
        .login-button:active {
            transform: translateY(0);
        }
        
        .login-button i {
            font-size: 20px;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-6">
                <div class="register-card p-4">
                    <div class="logo-container">
                        <img src="assets/img/pemkab.png" alt="Logo">
                        <h4 class="mt-3">Registrasi Akun SPPD</h4>
                        <p class="text-muted">Silakan lengkapi data untuk membuat akun</p>
                    </div>
                    
                    <!-- Step Indicator -->
                    <div class="step-indicator">
                        <div class="step active" data-step="1">1</div>
                        <div class="step" data-step="2">2</div>
                        <div class="step" data-step="3">3</div>
                    </div>
                    
                    <!-- Step 1: Form Register -->
                    <div id="step1" class="step-content">
                        <form id="registerForm">
                            <div class="mb-3">
                                <label class="form-label">Nama Lengkap</label>
                                <input type="text" class="form-control" name="nama_lengkap" required>
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Nomor WhatsApp</label>
                                <input type="tel" class="form-control" name="no_wa" required>
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Username</label>
                                <input type="text" class="form-control" name="username" required>
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Level</label>
                                <select class="form-control" name="level" required>
                                    <option value="">Pilih Level</option>
                                    <option value="admin">Admin Khusus</option>
                                    <option value="admin_sppd">Admin SPPD</option>
                                    <option value="pimpinan">Pimpinan</option>
                                </select>
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Bidang</label>
                                <select class="form-control" name="bidang" required>
                                    <option value="">Pilih Bidang</option>
                                    <option value="paud">Paud</option>
                                    <option value="dikdas">Dikdas</option>
                                    <option value="keuangan">Keuangan</option>
                                    <option value="umpeg">Umpeg</option>
                                    <option value="perencanaan">Perencanaan</option>
                                    <option value="kebudayaan">Kebudayaan</option>
                                </select>
                            </div>
                            <div class="form-group mb-3">
                                <label class="form-label">Password</label>
                                <div class="password-field-container">
                                    <input type="password" class="form-control" name="password" id="password" required>
                                    <i class="bi bi-eye-slash password-toggle" data-target="password"></i>
                                </div>
                            </div>
                            <div class="form-group mb-3">
                                <label class="form-label">Konfirmasi Password</label>
                                <div class="password-field-container">
                                    <input type="password" class="form-control" name="confirm_password" id="confirm_password" required>
                                    <i class="bi bi-eye-slash password-toggle" data-target="confirm_password"></i>
                                </div>
                            </div>
                            <div class="d-grid">
                                <button type="submit" class="btn btn-primary">Kirim OTP</button>
                            </div>
                        </form>
                    </div>
                    
                    <!-- Step 2: OTP Verification -->
                    <div id="step2" class="step-content" style="display: none;">
                        <form id="otpForm">
                            <div class="mb-4 text-center">
                                <p>Registrasi berhasil! Akun Anda sedang menunggu persetujuan admin.</p>
                                <p>Silakan masukkan kode OTP yang akan diberikan oleh admin.</p>
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Masukkan Kode OTP</label>
                                <input type="text" class="form-control text-center" name="otp" maxlength="6" required>
                            </div>
                            <div class="d-grid gap-2">
                                <button type="submit" class="btn btn-primary">Verifikasi OTP</button>
                            </div>
                        </form>
                    </div>
                    
                    <!-- Step 3: Success Message -->
                    <div id="step3" class="step-content text-center" style="display: none;">
                        <i class="bi bi-check-circle text-success" style="font-size: 4rem;"></i>
                        <h4 class="mt-3">Verifikasi Berhasil!</h4>
                        <p class="text-muted">Akun Anda telah diverifikasi dan disetujui.</p>
                        <div class="d-grid">
                            <a href="login.php" class="btn btn-primary">Login Sekarang</a>
                        </div>
                    </div>
                    
                    <div class="text-center mt-4">
                        <p class="mb-0">Sudah punya akun? <a href="login.php" class="text-primary">Login</a></p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        $(document).ready(function() {
            // Fungsi untuk mengecek status dan OTP
            function checkStatusAndOTP() {
                const username = localStorage.getItem('pendingUsername');
                if (!username) return;

                $.ajax({
                    url: 'check_status.php',
                    type: 'POST',
                    data: { username: username },
                    dataType: 'json',
                    success: function(response) {
                        if (response.status === 'approved') {
                            // Hentikan interval pengecekan
                            clearInterval(statusInterval);
                            
                            // Tampilkan loading di field OTP
                            const otpInput = $('input[name="otp"]');
                            const submitBtn = $('#otpForm button[type="submit"]');
                            submitBtn.prop('disabled', true);
                            
                            // Animasi loading
                            Swal.fire({
                                title: 'Menerima OTP',
                                html: `
                                    <div class="custom-loading">
                                        <div class="loading-icon">
                                            <i class="bi bi-shield-check"></i>
                                        </div>
                                        <div class="loading-text">
                                            Mohon tunggu sebentar
                                            <span class="loading-dots">
                                                <span class="dot">.</span>
                                                <span class="dot">.</span>
                                                <span class="dot">.</span>
                                            </span>
                                        </div>
                                    </div>
                                `,
                                timer: 2000,
                                timerProgressBar: true,
                                showConfirmButton: false,
                                allowOutsideClick: false,
                                customClass: {
                                    popup: 'animated-popup',
                                    title: 'custom-title'
                                },
                                didOpen: () => {
                                    Swal.showLoading();
                                    // Animasi dots loading
                                    const dots = document.querySelectorAll('.dot');
                                    let index = 0;
                                    setInterval(() => {
                                        dots.forEach(dot => dot.style.opacity = '0.2');
                                        dots[index].style.opacity = '1';
                                        index = (index + 1) % dots.length;
                                    }, 500);
                                }
                            }).then(() => {
                                // Tampilkan notifikasi persetujuan admin dengan animasi
                                Swal.fire({
                                    icon: 'success',
                                    title: '<span class="animate-title">Selamat!</span>',
                                    html: `
                                        <div class="success-message">
                                            <div class="success-icon">
                                                <i class="bi bi-check-circle-fill"></i>
                                            </div>
                                            <div class="success-text">
                                                Akun Anda telah disetujui oleh Admin<br>
                                                Silahkan Login
                                            </div>
                                            <div class="login-button-container">
                                                <button onclick="window.location.href='login.php'" class="login-button">
                                                    <i class="bi bi-box-arrow-in-right"></i>
                                                    Login Sekarang
                                                </button>
                                            </div>
                                        </div>
                                    `,
                                    timer: 5000,
                                    timerProgressBar: true,
                                    showConfirmButton: false,
                                    customClass: {
                                        popup: 'animated-popup success-popup',
                                        icon: 'custom-icon',
                                        title: 'custom-title'
                                    }
                                }).then(() => {
                                    // Tampilkan OTP dan submit otomatis
                                    otpInput.val(response.otp);
                                    
                                    // Langsung submit form OTP
                                    const otpValue = response.otp;
                                    $.ajax({
                                        url: 'verify_otp.php',
                                        type: 'POST',
                                        data: { otp: otpValue },
                                        dataType: 'json',
                                        success: function(response) {
                                            if (response.status === 'success') {
                                                // Pindah ke step 3
                                                $('.step').removeClass('active');
                                                $('.step[data-step="3"]').addClass('active');
                                                $('#step2').fadeOut(400, function() {
                                                    $('#step3').fadeIn(400);
                                                });
                                                
                                                // Tampilkan notifikasi sukses
                                                Swal.fire({
                                                    icon: 'success',
                                                    title: 'Verifikasi Berhasil!',
                                                    text: 'Akun Anda telah aktif dan siap digunakan',
                                                    timer: 2000,
                                                    timerProgressBar: true,
                                                    showConfirmButton: false
                                                }).then(() => {
                                                    // Redirect ke login setelah 3 detik
                                                    setTimeout(function() {
                                                        window.location.replace('login.php');
                                                    }, 3000);
                                                });
                                            }
                                        }
                                    });
                                });
                            });
                            
                            // Tambahkan style untuk animasi
                            const style = document.createElement('style');
                            style.textContent = `
                                .custom-loading {
                                    padding: 20px;
                                    text-align: center;
                                }
                                
                                .loading-icon {
                                    font-size: 48px;
                                    color: #0ea5e9;
                                    margin-bottom: 15px;
                                    animation: pulse 1.5s infinite;
                                }
                                
                                .loading-text {
                                    font-size: 18px;
                                    color: #64748b;
                                    display: flex;
                                    align-items: center;
                                    justify-content: center;
                                }
                                
                                .loading-dots {
                                    display: inline-flex;
                                    margin-left: 5px;
                                }
                                
                                .dot {
                                    font-size: 24px;
                                    line-height: 0;
                                    margin: 0 2px;
                                    color: #0ea5e9;
                                    opacity: 0.2;
                                    transition: opacity 0.3s ease;
                                }
                                
                                .animated-popup {
                                    animation: slideIn 0.3s ease-out;
                                    border-radius: 15px;
                                    box-shadow: 0 20px 40px rgba(0,0,0,0.1);
                                }
                                
                                .success-popup {
                                    background: linear-gradient(135deg, #ffffff 0%, #f8fafc 100%);
                                }
                                
                                .success-message {
                                    padding: 20px;
                                    text-align: center;
                                }
                                
                                .success-icon {
                                    font-size: 64px;
                                    color: #10b981;
                                    margin-bottom: 15px;
                                    animation: bounceIn 0.6s cubic-bezier(0.68, -0.55, 0.265, 1.55);
                                }
                                
                                .success-text {
                                    font-size: 18px;
                                    color: #1e293b;
                                    line-height: 1.6;
                                }
                                
                                .custom-title {
                                    font-size: 24px;
                                    color: #1e293b;
                                    font-weight: 600;
                                }
                                
                                .animate-title {
                                    display: inline-block;
                                    animation: slideInDown 0.5s ease-out;
                                }
                                
                                @keyframes pulse {
                                    0% { transform: scale(1); }
                                    50% { transform: scale(1.1); }
                                    100% { transform: scale(1); }
                                }
                                
                                @keyframes slideIn {
                                    from { transform: translateY(-20px); opacity: 0; }
                                    to { transform: translateY(0); opacity: 1; }
                                }
                                
                                @keyframes bounceIn {
                                    0% { transform: scale(0); }
                                    50% { transform: scale(1.2); }
                                    100% { transform: scale(1); }
                                }
                                
                                @keyframes slideInDown {
                                    from { transform: translateY(-20px); opacity: 0; }
                                    to { transform: translateY(0); opacity: 1; }
                                }
                            `;
                            document.head.appendChild(style);
                            
                            localStorage.removeItem('pendingUsername');
                        }
                    }
                });
            }

            // Cek status setiap 5 detik
            let statusInterval;

            // Password Toggle Visibility
            $('.password-toggle').on('click', function() {
                const target = $(this).data('target');
                const input = $(`#${target}`);
                const type = input.attr('type');
                
                if (type === 'password') {
                    input.attr('type', 'text');
                    $(this).removeClass('bi-eye-slash').addClass('bi-eye');
                } else {
                    input.attr('type', 'password');
                    $(this).removeClass('bi-eye').addClass('bi-eye-slash');
                }
            });

            // Form validation and submission
            $("#registerForm").validate({
                rules: {
                    nama_lengkap: "required",
                    username: {
                        required: true,
                        minlength: 3
                    },
                    password: {
                        required: true,
                        minlength: 6
                    },
                    confirm_password: {
                        required: true,
                        equalTo: "#password"
                    },
                    no_wa: {
                        required: true,
                        digits: true,
                        minlength: 10,
                        maxlength: 13
                    },
                    bidang: "required"
                },
                messages: {
                    nama_lengkap: "Mohon masukkan nama lengkap",
                    username: {
                        required: "Mohon masukkan username",
                        minlength: "Username minimal 3 karakter"
                    },
                    password: {
                        required: "Mohon masukkan password",
                        minlength: "Password minimal 6 karakter"
                    },
                    confirm_password: {
                        required: "Mohon konfirmasi password",
                        equalTo: "Password tidak sama"
                    },
                    no_wa: {
                        required: "Mohon masukkan nomor WhatsApp",
                        digits: "Hanya boleh angka",
                        minlength: "Nomor WhatsApp minimal 10 digit",
                        maxlength: "Nomor WhatsApp maksimal 13 digit"
                    },
                    bidang: "Mohon pilih bidang"
                },
                submitHandler: function(form) {
                    const submitBtn = $(form).find('button[type="submit"]');
                    const originalText = submitBtn.html();
                    submitBtn.prop('disabled', true).html('<span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span> Memproses...');

                    $.ajax({
                        url: 'process_register.php',
                        type: 'POST',
                        data: $(form).serialize(),
                        dataType: 'json',
                        success: function(response) {
                            if (response.status === 'success') {
                                // Simpan username untuk pengecekan status
                                localStorage.setItem('pendingUsername', $('input[name="username"]').val());
                                
                                // Pindah ke step 2 (OTP verification)
                                $('.step[data-step="1"]').removeClass('active');
                                $('.step[data-step="2"]').addClass('active');
                                $('#step1').hide();
                                $('#step2').fadeIn();
                                
                                // Mulai interval pengecekan status
                                statusInterval = setInterval(checkStatusAndOTP, 5000);
                                
                                Swal.fire({
                                    icon: 'success',
                                    title: 'Registrasi Berhasil!',
                                    text: response.message,
                                    confirmButtonText: 'OK'
                                });
                            } else {
                                Swal.fire({
                                    icon: 'error',
                                    title: 'Registrasi Gagal',
                                    text: response.message,
                                    confirmButtonText: 'OK'
                                });
                            }
                        },
                        error: function(xhr) {
                            let errorMessage = 'Terjadi kesalahan pada server';
                            if (xhr.responseJSON && xhr.responseJSON.message) {
                                errorMessage = xhr.responseJSON.message;
                            }
                            Swal.fire({
                                icon: 'error',
                                title: 'Error',
                                text: errorMessage,
                                confirmButtonText: 'OK'
                            });
                        },
                        complete: function() {
                            submitBtn.prop('disabled', false).html(originalText);
                        }
                    });
                }
            });

            // Ketika form OTP ditutup atau user pindah halaman
            $(window).on('beforeunload', function() {
                if (statusInterval) {
                    clearInterval(statusInterval);
                }
            });

            // OTP Form Validation and Submission
            $("#otpForm").validate({
                rules: {
                    otp: {
                        required: true,
                        digits: true,
                        minlength: 6,
                        maxlength: 6
                    }
                },
                messages: {
                    otp: {
                        required: "Mohon masukkan kode OTP",
                        digits: "OTP hanya boleh angka",
                        minlength: "OTP harus 6 digit",
                        maxlength: "OTP harus 6 digit"
                    }
                },
                submitHandler: function(form) {
                    const submitBtn = $(form).find('button[type="submit"]');
                    const originalText = submitBtn.html();
                    submitBtn.prop('disabled', true).html('<span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span> Memverifikasi...');

                    $.ajax({
                        url: 'verify_otp.php',
                        type: 'POST',
                        data: $(form).serialize(),
                        dataType: 'json',
                        success: function(response) {
                            if (response.status === 'success') {
                                // Tampilkan notifikasi verifikasi berhasil
                                Swal.fire({
                                    icon: 'success',
                                    title: 'Verifikasi Berhasil!',
                                    text: 'Akun Anda telah aktif dan siap digunakan',
                                    timer: 2000,
                                    timerProgressBar: true,
                                    showConfirmButton: false
                                }).then((result) => {
                                    // Pindah ke step 3
                                    $('.step').removeClass('active');
                                    $('.step[data-step="3"]').addClass('active');
                                    $('#step2').fadeOut(400, function() {
                                        $('#step3').fadeIn(400);
                                    });
                                    
                                    // Redirect ke login setelah 3 detik
                                    setTimeout(function() {
                                        window.location.replace('login.php');
                                    }, 3000);
                                });
                            } else {
                                Swal.fire({
                                    icon: 'error',
                                    title: 'Verifikasi Gagal',
                                    text: response.message,
                                    confirmButtonText: 'OK'
                                });
                                submitBtn.prop('disabled', false).html(originalText);
                            }
                        },
                        error: function(xhr) {
                            let errorMessage = 'Terjadi kesalahan pada server';
                            if (xhr.responseJSON && xhr.responseJSON.message) {
                                errorMessage = xhr.responseJSON.message;
                            }
                            Swal.fire({
                                icon: 'error',
                                title: 'Error',
                                text: errorMessage,
                                confirmButtonText: 'OK'
                            });
                            submitBtn.prop('disabled', false).html(originalText);
                        }
                    });
                }
            });
        });
    </script>
</body>
</html> 