<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Register - SPPD</title>
    
    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="assets/img/pemkab.png">
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.8.1/font/bootstrap-icons.css">
    
    <!-- SweetAlert2 CSS -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11.0.19/dist/sweetalert2.min.css">
    
    <!-- Custom fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700&display=swap" rel="stylesheet">
    
    <!-- jQuery -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <!-- jQuery Validate -->
    <script src="https://cdn.jsdelivr.net/npm/jquery-validation@1.19.3/dist/jquery.validate.min.js"></script>
    <!-- SweetAlert2 JS -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11.0.19/dist/sweetalert2.all.min.js"></script>
    <!-- Bootstrap Bundle JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    
    <style>
        body {
            font-family: 'Poppins', sans-serif;
            background: linear-gradient(135deg, #f6f9fc 0%, #edf2f7 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
        }
        
        .register-card {
            background: white;
            border-radius: 20px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.08);
            overflow: hidden;
            position: relative;
        }
        
        .register-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 5px;
            background: linear-gradient(135deg, #0ea5e9 0%, #2dd4bf 100%);
        }
        
        .form-control {
            border-radius: 10px;
            padding: 12px 16px;
            border: 1px solid #e2e8f0;
        }
        
        .form-control:focus {
            border-color: #0ea5e9;
            box-shadow: 0 0 0 3px rgba(14, 165, 233, 0.1);
        }
        
        .btn-primary {
            background: linear-gradient(135deg, #0ea5e9 0%, #2dd4bf 100%);
            border: none;
            border-radius: 10px;
            padding: 12px 24px;
            font-weight: 500;
            transition: all 0.3s ease;
        }
        
        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(14, 165, 233, 0.2);
        }
        
        .logo-container {
            text-align: center;
            margin-bottom: 2rem;
        }
        
        .logo-container img {
            width: 80px;
            height: auto;
        }
        
        .step-indicator {
            display: flex;
            justify-content: center;
            margin-bottom: 2rem;
        }
        
        .step {
            width: 30px;
            height: 30px;
            border-radius: 50%;
            background: #e2e8f0;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 10px;
            color: #64748b;
            font-weight: 600;
            position: relative;
        }
        
        .step.active {
            background: linear-gradient(135deg, #0ea5e9 0%, #2dd4bf 100%);
            color: white;
        }
        
        .step::after {
            content: '';
            position: absolute;
            right: -20px;
            top: 50%;
            width: 20px;
            height: 2px;
            background: #e2e8f0;
        }
        
        .step:last-child::after {
            display: none;
        }
        
        .alert {
            border-radius: 10px;
        }
        
        .form-group {
            position: relative;
        }
        
        .password-toggle {
            position: absolute;
            right: 10px;
            top: 50%;
            transform: translateY(-50%);
            cursor: pointer;
            color: #64748b;
            padding: 5px;
            z-index: 10;
        }
        
        .password-toggle:hover {
            color: #0ea5e9;
        }
        
        .password-field-container {
            position: relative;
        }

        input[type="password"] {
            padding-right: 40px;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-6">
                <div class="register-card p-4">
                    <div class="logo-container">
                        <img src="assets/img/pemkab.png" alt="Logo">
                        <h4 class="mt-3">Registrasi Akun SPPD</h4>
                        <p class="text-muted">Silakan lengkapi data untuk membuat akun</p>
                    </div>
                    
                    <!-- Step Indicator -->
                    <div class="step-indicator">
                        <div class="step active">1</div>
                        <div class="step">2</div>
                        <div class="step">3</div>
                    </div>
                    
                    <!-- Step 1: Form Register -->
                    <div id="step1" class="step-content">
                        <form id="registerForm" action="process_register.php" method="POST">
                            <div class="mb-3">
                                <label class="form-label">Nama Lengkap</label>
                                <input type="text" class="form-control" name="nama_lengkap" required>
                            </div>
                            <div class="mb-3">
                                <label class="form-label">no_wa</label>
                                <input type="no_wa" class="form-control" name="no_wa" required>
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Username</label>
                                <input type="text" class="form-control" name="username" required>
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Level</label>
                                <select class="form-control" name="level" required>
                                    <option value="">Pilih Level</option>
                                    <option value="admin_sppd">Admin SPPD</option>
                                    <option value="pimpinan">Pimpinan</option>
                                    <option value="admin">Super Admin</option>
                                </select>
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Bidang</label>
                                <select class="form-control" name="bidang" required>
                                    <option value="">Pilih Bidang</option>
                                    <option value="sekretariat">Paud</option>
                                    <option value="pemerintahan">DIkdas</option>
                                    <option value="pembangunan">Keuangan</option>
                                    <option value="kesra">Sarpras</option>
                                    <option value="perekonomian">Umpeg</option>
                                    <option value="administrasi">Kebudayaan</option>
                                </select>
                            </div>
                            <div class="form-group mb-3">
                                <label class="form-label">Password</label>
                                <div class="password-field-container">
                                    <input type="password" class="form-control" name="password" id="password" required>
                                    <i class="bi bi-eye-slash password-toggle" data-target="password"></i>
                                </div>
                            </div>
                            <div class="form-group mb-3">
                                <label class="form-label">Konfirmasi Password</label>
                                <div class="password-field-container">
                                    <input type="password" class="form-control" name="confirm_password" id="confirm_password" required>
                                    <i class="bi bi-eye-slash password-toggle" data-target="confirm_password"></i>
                                </div>
                            </div>
                            <div class="d-grid">
                                <button type="submit" class="btn btn-primary">Kirim OTP</button>
                            </div>
                        </form>
                    </div>
                    
                    <!-- Step 2: OTP Verification (Initially Hidden) -->
                    <div id="step2" class="step-content" style="display: none;">
                        <form id="otpForm" action="verify_otp.php" method="POST">
                            <div class="mb-4 text-center">
                                <p>Registrasi berhasil! Akun Anda sedang menunggu persetujuan admin.</p>
                                <p>Silakan masukkan kode OTP yang akan diberikan oleh admin.</p>
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Masukkan Kode OTP</label>
                                <input type="text" class="form-control text-center" name="otp" maxlength="6" required>
                            </div>
                            <div class="d-grid gap-2">
                                <button type="submit" class="btn btn-primary">Verifikasi OTP</button>
                            </div>
                        </form>
                    </div>
                    
                    <!-- Step 3: Success Message (Initially Hidden) -->
                    <div id="step3" class="step-content text-center" style="display: none;">
                        <i class="bi bi-check-circle text-success" style="font-size: 4rem;"></i>
                        <h4 class="mt-3">Verifikasi Berhasil!</h4>
                        <p class="text-muted">Akun Anda telah diverifikasi dan disetujui.</p>
                        <div class="d-grid">
                            <a href="login.php" class="btn btn-primary">Login Sekarang</a>
                        </div>
                    </div>
                    
                    <div class="text-center mt-4">
                        <p class="mb-0">Sudah punya akun? <a href="login.php" class="text-primary">Login</a></p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        $(document).ready(function() {
            // Password Toggle Visibility
            $('.password-toggle').on('click', function() {
                const target = $(this).data('target');
                const input = $(`#${target}`);
                const type = input.attr('type');
                
                // Toggle password visibility
                if (type === 'password') {
                    input.attr('type', 'text');
                    $(this).removeClass('bi-eye-slash').addClass('bi-eye');
                } else {
                    input.attr('type', 'password');
                    $(this).removeClass('bi-eye').addClass('bi-eye-slash');
                }
            });

            // Form validation
            $("#registerForm").validate({
                rules: {
                    nama_lengkap: "required",
                    no_wa: {
                        required: true,
                        no_wa: true
                    },
                    username: {
                        required: true,
                        minlength: 3
                    },
                    password: {
                        required: true,
                        minlength: 6
                    },
                    confirm_password: {
                        required: true,
                        equalTo: "#password"
                    },
                    level: "required",
                    bidang: "required"
                },
                messages: {
                    nama_lengkap: "Mohon masukkan nama lengkap",
                    no_wa: {
                        required: "Mohon masukkan alamat no_wa",
                        no_wa: "Mohon masukkan alamat no_wa yang valid"
                    },
                    username: {
                        required: "Mohon masukkan username",
                        minlength: "Username minimal 3 karakter"
                    },
                    password: {
                        required: "Mohon masukkan password",
                        minlength: "Password minimal 6 karakter"
                    },
                    confirm_password: {
                        required: "Mohon konfirmasi password",
                        equalTo: "Password tidak sama"
                    },
                    level: "Mohon pilih level",
                    bidang: "Mohon pilih bidang"
                },
                errorElement: 'div',
                errorPlacement: function(error, element) {
                    error.addClass('invalid-feedback');
                    element.closest('.form-group').append(error);
                },
                highlight: function(element, errorClass, validClass) {
                    $(element).addClass('is-invalid');
                },
                unhighlight: function(element, errorClass, validClass) {
                    $(element).removeClass('is-invalid');
                }
            });

            $("#registerForm").on('submit', function(e) {
                e.preventDefault();
                
                if (!$(this).valid()) {
                    return;
                }

                // Disable submit button and show loading state
                const submitBtn = $(this).find('button[type="submit"]');
                const originalBtnText = submitBtn.html();
                submitBtn.prop('disabled', true).html('<span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span> Loading...');

                $.ajax({
                    url: 'register_process.php',
                    type: 'POST',
                    data: $(this).serialize(),
                    dataType: 'json',
                    success: function(response) {
                        if (response.status === 'success') {
                            // Move to step 2 (OTP verification)
                            $('.step').eq(0).removeClass('active');
                            $('.step').eq(1).addClass('active');
                            $('#step1').hide();
                            $('#step2').show();
                            
                            Swal.fire({
                                icon: 'success',
                                title: 'Registrasi Berhasil!',
                                text: response.message,
                                confirmButtonText: 'OK'
                            });
    } else {
                            console.error('Registration error:', response);
                            Swal.fire({
                                icon: 'error',
                                title: 'Oops...',
                                text: response.message || 'Terjadi kesalahan. Silakan coba lagi.',
                                confirmButtonText: 'OK'
                            });
                        }
                    },
                    error: function(xhr, status, error) {
                        console.error('AJAX error:', {xhr, status, error});
                        let errorMessage = 'Terjadi kesalahan pada server. Silakan coba lagi.';
                        
                        try {
                            const response = JSON.parse(xhr.responseText);
                            if (response.message) {
                                errorMessage = response.message;
                            }
                        } catch (e) {
                            console.error('Error parsing response:', e);
                        }

                        Swal.fire({
                            icon: 'error',
                            title: 'Error',
                            text: errorMessage,
                            confirmButtonText: 'OK'
                        });
                    },
                    complete: function() {
                        // Re-enable submit button and restore original text
                        submitBtn.prop('disabled', false).html(originalBtnText);
                    }
                });
            });

            // Handle OTP Form Submit
            $('#otpForm').on('submit', function(e) {
                e.preventDefault();
                const submitBtn = $(this).find('button[type="submit"]');
                submitBtn.prop('disabled', true).html('<span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span> Loading...');

                $.ajax({
                    type: 'POST',
                    url: 'verify_otp.php',
                    data: $(this).serialize(),
                    dataType: 'json',
                    success: function(response) {
                        if (response.status === 'success') {
                            // Move to step 3
                            $('.step').eq(1).removeClass('active');
                            $('.step').eq(2).addClass('active');
                            $('#step2').hide();
                            $('#step3').show();
                            
                            Swal.fire({
                                icon: 'success',
                                title: 'Verifikasi Berhasil!',
                                text: response.message,
                                showConfirmButton: false,
                                timer: 2000
                            });
                        } else {
                            Swal.fire({
                                icon: 'error',
                                title: 'Verifikasi Gagal',
                                text: response.message,
                                confirmButtonText: 'OK'
                            });
                        }
                    },
                    error: function() {
                        Swal.fire({
                            icon: 'error',
                            title: 'Error',
                            text: 'Terjadi kesalahan pada server. Silakan coba lagi.',
                            confirmButtonText: 'OK'
                        });
                    },
                    complete: function() {
                        submitBtn.prop('disabled', false).html('Verifikasi OTP');
                    }
                });
            });
        });
    </script>
</body>
</html> 