<?php
require_once $_SERVER['DOCUMENT_ROOT'] . '/sppd/config/config.php';
require_once '../vendor/autoload.php';

try {
    $conn = check_connection($conn);
    
    // Get rekap ID from URL
    $id_rekap = isset($_GET['id']) ? $_GET['id'] : null;
    
    if (!$id_rekap) {
        throw new Exception("ID Rekap tidak ditemukan");
    }
    
    // Query untuk mendapatkan detail rekap
    $query_rekap = "SELECT r.*, GROUP_CONCAT(st.no_sppd) as sppd_list
                    FROM rekap_sppd r
                    LEFT JOIN detail_rekap_sppd dr ON r.id_rekap = dr.id_rekap
                    LEFT JOIN surat_tugas st ON dr.id_surat = st.id_surat
                    WHERE r.id_rekap = ?
                    GROUP BY r.id_rekap";
    
    $stmt = mysqli_prepare($conn, $query_rekap);
    mysqli_stmt_bind_param($stmt, "i", $id_rekap);
    mysqli_stmt_execute($stmt);
    $result_rekap = mysqli_stmt_get_result($stmt);
    $rekap = mysqli_fetch_assoc($result_rekap);
    
    if (!$rekap) {
        throw new Exception("Rekap tidak ditemukan");
    }
    
    // Query untuk mendapatkan detail surat tugas dalam rekap ini
    $query_surat = "SELECT 
                    st.no_sppd, 
                    COALESCE(rbp.no_sub_kegiatan, st.no_sub_kegiatan) as kode_kegiatan,
                    st.maksud, 
                    st.jenis_surat,
                    (SELECT SUM(total_biaya) FROM rincian_bimtek_perorangan WHERE id_surat = st.id_surat) as total_biaya_surat
                    FROM detail_rekap_sppd dr
                    JOIN surat_tugas st ON dr.id_surat = st.id_surat
                    LEFT JOIN rincian_bimtek_perorangan rbp ON st.id_surat = rbp.id_surat
                    WHERE dr.id_rekap = ?
                    GROUP BY st.id_surat
                    ORDER BY st.no_surat";
    
    $stmt = mysqli_prepare($conn, $query_surat);
    mysqli_stmt_bind_param($stmt, "i", $id_rekap);
    mysqli_stmt_execute($stmt);
    $result_surat = mysqli_stmt_get_result($stmt);
    
} catch (Exception $e) {
    die("Terjadi kesalahan: " . $e->getMessage());
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Cetak Rekap SPPD - <?= htmlspecialchars($rekap['no_rekap']) ?></title>
    
    <style>
        @media print {
            @page {
                size: F4 portrait;
                margin: 2cm 2cm 2cm 2cm;
            }
        }
        body {
            font-family: Arial, sans-serif;
            line-height: 1.5;
            margin: 0;
            padding: 20px;
            width: 210mm; /* Lebar F4 */
            min-height: 330mm; /* Tinggi F4 */
            margin: 0 auto;
        }
        .header {
            text-align: center;
            margin-bottom: 30px;
            padding-top: 20px;
        }
        .header h2 {
            margin: 0;
            font-size: 18px;
            text-transform: uppercase;
            font-weight: bold;
        }
        .header p {
            margin: 5px 0;
            font-size: 16px;
        }
        .meta-info {
            margin-bottom: 30px;
        }
        .meta-info p {
            margin: 5px 0;
            font-size: 14px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 30px;
            font-size: 12px;
        }
        th, td {
            border: 1px solid #000;
            padding: 10px;
            text-align: left;
        }
        th {
            background-color: #f0f0f0;
            font-weight: bold;
            text-align: center;
        }
        .text-center {
            text-align: center;
        }
        .text-end {
            text-align: right;
        }
        .total-row {
            font-weight: bold;
        }
        .footer {
            margin-top: 50px;
            text-align: right;
            font-size: 14px;
            padding-right: 50px;
        }
        .footer p {
            margin: 5px 0;
        }
        .no-print {
            display: none;
        }
        @media print {
            .no-print {
                display: none !important;
            }
            body {
                padding: 0;
            }
            table {
                page-break-inside: avoid;
            }
        }
    </style>
</head>
<body>
    <div class="header">
        <h2>REKAP SPPD</h2>
        <p>Dinas Pendidikan dan Kebudayaan Kabupaten Balangan</p>
    </div>

    <div class="meta-info">
        <p>Nomor Rekap: <?= htmlspecialchars($rekap['no_rekap']) ?></p>
        <p>Tanggal: <?= date('d-m-Y', strtotime($rekap['tanggal_rekap'])) ?></p>
    </div>

    <table>
        <thead>
            <tr>
                <th style="width: 50px">No.</th>
                <th>No. SPPD</th>
                <th>Kode Sub Kegiatan</th>
                <th>Maksud</th>
                <th class="text-end">Total Biaya</th>
            </tr>
        </thead>
        <tbody>
            <?php 
            $no = 1;
            $grand_total = 0;

            while ($row = mysqli_fetch_assoc($result_surat)): 
                $grand_total += $row['total_biaya_surat'];
            ?>
            <tr>
                <td class="text-center"><?= $no++ ?></td>
                <td><?= htmlspecialchars($row['no_sppd']) ?></td>
                <td><?= htmlspecialchars($row['kode_kegiatan']) ?></td>
                <td><?= htmlspecialchars($row['maksud']) ?></td>
                <td class="text-end">Rp <?= number_format($row['total_biaya_surat'], 0, ',', '.') ?></td>
            </tr>
            <?php endwhile; ?>
            <tr class="total-row">
                <td colspan="4" class="text-end">Total Keseluruhan:</td>
                <td class="text-end">Rp <?= number_format($grand_total, 0, ',', '.') ?></td>
            </tr>
        </tbody>
    </table>

 

    <button class="no-print" onclick="window.print()" style="position: fixed; bottom: 20px; right: 20px; padding: 10px 20px; background: #0ea5e9; color: white; border: none; border-radius: 5px; cursor: pointer;">
        Cetak Rekap
    </button>
</body>
</html> 