<?php
session_start();
require_once '../config/database.php';
require_once '../config/config.php';

header('Content-Type: application/json');

// Validasi request method
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode([
        'success' => false,
        'message' => 'Method not allowed'
    ]);
    exit;
}

// Validasi input
if (!isset($_POST['id_rekap'])) {
    echo json_encode([
        'success' => false,
        'message' => 'ID rekap tidak valid'
    ]);
    exit;
}

$id_rekap = $_POST['id_rekap'];

// Mulai transaction
mysqli_begin_transaction($conn);

try {
    // Hapus detail rekap terlebih dahulu
    $query = "DELETE FROM detail_rekap_sppd WHERE id_rekap = ?";
    $stmt = mysqli_prepare($conn, $query);
    mysqli_stmt_bind_param($stmt, 'i', $id_rekap);
    
    if (!mysqli_stmt_execute($stmt)) {
        throw new Exception('Gagal menghapus detail rekap');
    }
    
    // Hapus data rekap
    $query = "DELETE FROM rekap_sppd WHERE id_rekap = ?";
    $stmt = mysqli_prepare($conn, $query);
    mysqli_stmt_bind_param($stmt, 'i', $id_rekap);
    
    if (!mysqli_stmt_execute($stmt)) {
        throw new Exception('Gagal menghapus rekap');
    }
    
    // Commit transaction
    mysqli_commit($conn);
    
    echo json_encode([
        'success' => true,
        'message' => 'Rekap berhasil dihapus'
    ]);
    
} catch (Exception $e) {
    // Rollback jika terjadi error
    mysqli_rollback($conn);
    
    echo json_encode([
        'success' => false,
        'message' => 'Terjadi kesalahan: ' . $e->getMessage()
    ]);
}

mysqli_close($conn); 