<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Detail Rekap SPPD - SPPD System</title>
    <link rel="icon" type="image/svg+xml" href="data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAyNCAyNCI+PHBhdGggZmlsbD0iIzRlNzNkZiIgZD0iTTIwLDhINFY2aDIwdjJIMjB6IE0xNSwxMEg0djJoMTFWMTB6IE00LDE2aDd2Mkg0VjE2eiBNMjEuNywxMy4zTDIwLjMsMTJsMS40LTEuNEMyMi4xLDEwLjIsMjIuMSw5LjgsMjEuNyw5LjRsLTEuMS0xLjFDMjAuMiw3LjksMTkuOCw3LjksMTkuNCw4LjNMMTgsMTBsLTEuNC0xLjRjLTAuNC0wLjQtMS0wLjQtMS40LDBsLTcuNSw3LjVjLTAuMiwwLjItMC4zLDAuNC0wLjMsMC43djIuOWMwLDAuNSwwLjQsMC45LDAuOSwwLjloMi45YzAuMywwLDAuNS0wLjEsMC43LTAuM2w3LjUtNy41QzIyLjEsMTQuMywyMi4xLDEzLjcsMjEuNywxMy4zeiIvPjwvc3ZnPg==">
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css" rel="stylesheet">
    <!-- DataTables CSS -->
    <link href="https://cdn.datatables.net/1.10.24/css/dataTables.bootstrap5.min.css" rel="stylesheet">
</head>
<body>
<?php
require_once $_SERVER['DOCUMENT_ROOT'] . '/sppd/config/config.php';
require_once '../vendor/autoload.php';

try {
    $conn = check_connection($conn);
    
    // Get rekap ID from URL
    $id_rekap = isset($_GET['id']) ? $_GET['id'] : null;
    
    if (!$id_rekap) {
        throw new Exception("ID Rekap tidak ditemukan");
    }
    
    // Query untuk mendapatkan detail rekap
    $query_rekap = "SELECT r.*, GROUP_CONCAT(st.no_surat) as surat_list
                    FROM rekap_sppd r
                    LEFT JOIN detail_rekap_sppd dr ON r.id_rekap = dr.id_rekap
                    LEFT JOIN surat_tugas st ON dr.id_surat = st.id_surat
                    WHERE r.id_rekap = ?
                    GROUP BY r.id_rekap";
    
    $stmt = mysqli_prepare($conn, $query_rekap);
    mysqli_stmt_bind_param($stmt, "i", $id_rekap);
    mysqli_stmt_execute($stmt);
    $result_rekap = mysqli_stmt_get_result($stmt);
    $rekap = mysqli_fetch_assoc($result_rekap);
    
    if (!$rekap) {
        throw new Exception("Rekap tidak ditemukan");
    }
    
    // Query untuk mendapatkan detail surat tugas dalam rekap ini
    $query_surat = "SELECT
                    st.id_surat,
                    st.no_surat,
                    COALESCE(rbp.no_sub_kegiatan, st.no_sub_kegiatan) as kode_kegiatan,
                    st.maksud,
                    st.jenis_surat,
                    (SELECT SUM(total_biaya) FROM rincian_bimtek_perorangan WHERE id_surat = st.id_surat) as total_biaya_surat
                    FROM detail_rekap_sppd dr
                    JOIN surat_tugas st ON dr.id_surat = st.id_surat
                    LEFT JOIN rincian_bimtek_perorangan rbp ON st.id_surat = rbp.id_surat
                    WHERE dr.id_rekap = ?
                    GROUP BY st.id_surat
                    ORDER BY st.no_surat";
    
    $stmt = mysqli_prepare($conn, $query_surat);
    mysqli_stmt_bind_param($stmt, "i", $id_rekap);
    mysqli_stmt_execute($stmt);
    $result_surat = mysqli_stmt_get_result($stmt);
    
} catch (Exception $e) {
    echo "<div class='alert alert-danger'>Terjadi kesalahan: " . $e->getMessage() . "</div>";
    error_log($e->getMessage());
}
?>

<div class="wrapper">
    <div class="header-wrapper">
        <h1>Detail Rekap SPPD</h1>
        <p>Informasi lengkap rekap SPPD</p>
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb mb-0">
                <li class="breadcrumb-item"><a href="../dashboard.php">Dashboard</a></li>
                <li class="breadcrumb-item"><a href="index.php">Rekap SPPD</a></li>
                <li class="breadcrumb-item active">Detail Rekap</li>
            </ol>
        </nav>
        <div class="header-actions">
            <a href="edit.php?id=<?= $id_rekap ?>" class="btn-edit">
                <i class="bi bi-pencil"></i>
                Edit Rekap
            </a>
            <a href="cetak.php?id=<?= $id_rekap ?>" class="btn-cetak" target="_blank">
                <i class="bi bi-printer"></i>
                Cetak Rekap
            </a>
        </div>
    </div>

    <!-- Informasi Rekap -->
    <div class="card mb-4">
        <div class="card-header">
            <h5 class="card-title mb-0">Informasi Rekap</h5>
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-6">
                    <table class="table table-borderless">
                        <tr>
                            <th width="150">Nomor Rekap</th>
                            <td>: <?= htmlspecialchars($rekap['no_rekap']) ?></td>
                        </tr>
                        <tr>
                            <th>Tanggal Rekap</th>
                            <td>: <?= date('d-m-Y', strtotime($rekap['tanggal_rekap'])) ?></td>
                        </tr>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <!-- Detail Surat Tugas -->
    <div class="card mb-4">
        <div class="card-header">
            <h5 class="card-title mb-0">Detail Surat Tugas</h5>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover" id="detailTable">
                    <thead>
                        <tr>
                            <th class="text-center" style="width: 50px">No.</th>
                            <th>No. Surat</th>
                            <th>Kode Sub Kegiatan <br> <small>(kode rekening)</small></th>
                            <th>Maksud</th>
                            <th class="text-end">Total Biaya</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php 
                        $no = 1;
                        $grand_total = 0;
                        while ($row = mysqli_fetch_assoc($result_surat)): 
                            // Tambahkan total_biaya ke grand_total
                            $grand_total += $row['total_biaya_surat'] ?? 0;
                        ?>
                        <tr>
                            <td class="text-center"><?= $no++ ?></td>
                            <td><?= htmlspecialchars($row['no_surat']) ?></td>
                            <td><?php 
                                if (empty($row['kode_kegiatan'])) {
                                    echo '<a href="../rincian_biaya/detail_rincian.php?id=' . urlencode($row['id_surat']) . '" class="text-danger text-decoration-none hover-warning">';
                                    echo '<i class="bi bi-exclamation-circle me-1"></i>';
                                    echo 'Mohon isi no sub kegiatan terlebih dahulu';
                                    echo '</a>';
                                } else {
                                    echo htmlspecialchars($row['kode_kegiatan']);
                                }
                            ?></td>
                            <td><?= nl2br(htmlspecialchars($row['maksud'])) ?></td>
                            <td class="text-end">
                                <?php if($row['total_biaya_surat']): ?>
                                    Rp <?= number_format($row['total_biaya_surat'], 0, ',', '.') ?>
                                <?php else: ?>
                                    Rp 0
                                <?php endif; ?>
                            </td>
                        </tr>
                        <?php endwhile; ?>
                        <?php if (mysqli_num_rows($result_surat) == 0): ?>
                        <tr>
                            <td colspan="5" class="text-center py-4 text-muted">
                                <i class="bi bi-inbox fs-2 d-block mb-2"></i>
                                Tidak ada data surat tugas tersedia
                            </td>
                        </tr>
                        <?php else: ?>
                        <tr class="table-primary fw-bold">
                            <td colspan="4" class="text-end">Total Keseluruhan:</td>
                            <td class="text-end">Rp <?= number_format($grand_total, 0, ',', '.') ?></td>
                        </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<!-- Scripts -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.10.24/js/dataTables.bootstrap5.min.js"></script>

<script>
$(document).ready(function() {
    $('#detailTable').DataTable({
        "responsive": true,
        "lengthMenu": [[10, 25, 50, -1], [10, 25, 50, "Semua"]],
        "language": {
            "url": "//cdn.datatables.net/plug-ins/1.10.24/i18n/Indonesian.json"
        }
    });
});
</script>

<style>
/* Background dan Container */
body {
    background: linear-gradient(135deg,rgb(231, 255, 255) 0%,rgb(236, 255, 246) 100%);
    min-height: 100vh;
    margin: 0;
    padding: 0;
}

.wrapper {
    padding: 20px;
    width: 100%;
    box-sizing: border-box;
}

/* Header Section */
.header-wrapper {
    background: linear-gradient(135deg, #0ea5e9 0%, #2dd4bf 100%);
    padding: 1.2rem;
    border-radius: 12px;
    margin-bottom: 1rem;
    position: relative;
    width: 100%;
}

.header-wrapper h1 {
    font-size: 1.5rem;
    font-weight: 600;
    color: #ffffff;
    margin-bottom: 0.2rem;
}

.header-wrapper p {
    font-size: 0.9rem;
    color: rgba(255, 255, 255, 0.8);
    margin-bottom: 0.5rem;
}

.breadcrumb {
    background: rgba(255, 255, 255, 0.1);
    padding: 0.5rem 0.8rem;
    border-radius: 6px;
    margin: 0;
    font-size: 0.85rem;
}

.breadcrumb-item a {
    color: rgba(255, 255, 255, 0.8);
    text-decoration: none;
}

.breadcrumb-item.active {
    color: white;
}

/* Header Actions */
.header-actions {
    position: absolute;
    right: 1.2rem;
    top: 50%;
    transform: translateY(-50%);
    display: flex;
    gap: 0.5rem;
}

.btn-edit,
.btn-cetak {
    background: white;
    color: #0ea5e9;
    padding: 0.5rem 1rem;
    border-radius: 6px;
    font-size: 0.9rem;
    font-weight: 500;
    text-decoration: none;
    transition: all 0.2s ease;
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
}

.btn-edit:hover,
.btn-cetak:hover {
    background: rgba(255, 255, 255, 0.9);
    transform: translateX(-2px);
    color: #0891ce;
}

/* Card Styling */
.card {
    background: rgba(255, 255, 255, 0.95);
    backdrop-filter: blur(10px);
    border: none;
    border-radius: 15px;
    box-shadow: 0 8px 32px 0 rgba(14, 165, 233, 0.15);
    margin-bottom: 2rem;
    width: 100%;
}

.card-header {
    background: linear-gradient(135deg, #0ea5e9 0%, #2dd4bf 100%);
    padding: 1rem 1.5rem;
    border-radius: 15px 15px 0 0 !important;
    border: none;
}

.card-header h5 {
    color: white;
    font-weight: 600;
    margin: 0;
}

/* Table Styling */
.table {
    margin: 0;
    border-collapse: separate;
    border-spacing: 0;
}

.table thead th {
    background: linear-gradient(135deg, #0ea5e9 0%, #2dd4bf 100%) !important;
    color: white;
    font-weight: 600;
    padding: 15px !important;
    font-size: 0.9rem;
    text-transform: uppercase;
    letter-spacing: 0.5px;
    border: none;
}

.table thead th:first-child {
    border-top-left-radius: 10px;
}

.table thead th:last-child {
    border-top-right-radius: 10px;
}

.table tbody td {
    padding: 15px !important;
    vertical-align: middle;
    border-bottom: 1px solid rgba(0, 0, 0, 0.05);
    font-size: 0.9rem;
    color: #2c3e50;
}

.table-borderless td,
.table-borderless th {
    padding: 8px 0 !important;
}

/* DataTables Customization */
.dataTables_wrapper .dataTables_length select,
.dataTables_wrapper .dataTables_filter input {
    border: 1px solid rgba(0, 0, 0, 0.1);
    border-radius: 8px;
    padding: 8px 12px;
    background: #f8f9fa;
}

.dataTables_wrapper .dataTables_paginate .paginate_button.current,
.dataTables_wrapper .dataTables_paginate .paginate_button.current:hover {
    background: linear-gradient(135deg, #0ea5e9 0%, #2dd4bf 100%) !important;
    border: none;
    color: white !important;
}

/* Responsive */
@media (max-width: 768px) {
    .wrapper {
        padding: 10px;
    }

    .header-wrapper {
        padding: 1rem;
    }

    .header-wrapper h1 {
        font-size: 1.3rem;
    }

    .header-actions {
        position: relative;
        margin-top: 1rem;
        display: flex;
        justify-content: flex-start;
        gap: 0.5rem;
    }

    .btn-edit,
    .btn-cetak {
        padding: 0.4rem 0.8rem;
        font-size: 0.85rem;
    }

    .table thead th {
        font-size: 0.8rem;
        padding: 10px !important;
    }

    .table tbody td {
        font-size: 0.8rem;
        padding: 10px !important;
    }

    .card-header {
        padding: 0.8rem 1rem;
    }

    .card-header h5 {
        font-size: 1rem;
    }
}

.hover-warning:hover {
    color: #dc3545 !important;
    text-decoration: underline !important;
}

.hover-warning i {
    transition: transform 0.2s ease;
}

.hover-warning:hover i {
    transform: translateX(2px);
}
</style>

</body>
</html> 