<?php
require_once $_SERVER['DOCUMENT_ROOT'] . '/sppd/config/config.php';
require_once '../vendor/autoload.php';

// Check if ID is provided
if (!isset($_GET['id'])) {
    header('Location: index.php');
    exit;
}

try {
    $conn = check_connection($conn);
    $id_rekap = mysqli_real_escape_string($conn, $_GET['id']);
    
    // Start transaction
    mysqli_begin_transaction($conn);
    
    // Delete from detail_rekap_sppd first (foreign key constraint)
    $query_delete_detail = "DELETE FROM detail_rekap_sppd WHERE id_rekap = '$id_rekap'";
    if (!mysqli_query($conn, $query_delete_detail)) {
        throw new Exception("Error deleting rekap details");
    }
    
    // Delete from rekap_sppd
    $query_delete_rekap = "DELETE FROM rekap_sppd WHERE id_rekap = '$id_rekap'";
    if (!mysqli_query($conn, $query_delete_rekap)) {
        throw new Exception("Error deleting rekap");
    }
    
    // Commit transaction
    mysqli_commit($conn);
    
    // Redirect back with success message
    header('Location: index.php?success=delete');
    exit;
    
} catch (Exception $e) {
    mysqli_rollback($conn);
    
    // Redirect back with error message
    header('Location: index.php?error=' . urlencode($e->getMessage()));
    exit;
}