<?php
// Early AJAX handler before any output
if (isset($_GET['action']) && $_GET['action'] === 'get_sub_detail') {
    require_once $_SERVER['DOCUMENT_ROOT'] . '/sppd/config/config.php';
    require_once '../vendor/autoload.php';
    header('Content-Type: application/json');
    try {
        if (!isset($_SESSION)) { session_start(); }
        if (!isset($_SESSION['user_id'])) { echo json_encode(['error' => 'Unauthorized']); exit; }

        $conn = check_connection($conn);

        $kode = isset($_GET['kode']) ? trim($_GET['kode']) : '';
        $user_level = $_SESSION['level'];
        $user_id = $_SESSION['user_id'];
        $user_bidang = '';
        if ($user_level === 'pimpinan' || $user_level === 'admin_sppd') {
            $stmtB = mysqli_prepare($conn, "SELECT bidang FROM users WHERE id = ?");
            if ($stmtB) {
                mysqli_stmt_bind_param($stmtB, "i", $user_id);
                mysqli_stmt_execute($stmtB);
                $resB = mysqli_stmt_get_result($stmtB);
                if ($ud = mysqli_fetch_assoc($resB)) { $user_bidang = $ud['bidang']; }
                mysqli_stmt_close($stmtB);
            }
        }

        $query_detail = "SELECT 
                            st.id_surat,
                            st.no_surat,
                            st.no_sppd,
                            st.maksud,
                            SUM(COALESCE(rbp.total_biaya, 0)) AS total_biaya
                          FROM detail_rekap_sppd dr
                          JOIN surat_tugas st ON dr.id_surat = st.id_surat
                          LEFT JOIN rincian_bimtek_perorangan rbp ON st.id_surat = rbp.id_surat
                          LEFT JOIN users u ON st.created_by = u.id
                          WHERE COALESCE(rbp.no_sub_kegiatan, st.no_sub_kegiatan) = ?";

        if (($user_level === 'pimpinan' || $user_level === 'admin_sppd') && !empty($user_bidang)) {
            $query_detail .= " AND u.bidang = ?";
        }
        $query_detail .= " GROUP BY st.id_surat, st.no_surat, st.no_sppd, st.maksud ORDER BY st.no_surat";

        $stmtD = mysqli_prepare($conn, $query_detail);
        if (!$stmtD) { echo json_encode(['error' => 'Query prepare error']); exit; }

        if (($user_level === 'pimpinan' || $user_level === 'admin_sppd') && !empty($user_bidang)) {
            mysqli_stmt_bind_param($stmtD, "ss", $kode, $user_bidang);
        } else {
            mysqli_stmt_bind_param($stmtD, "s", $kode);
        }

        mysqli_stmt_execute($stmtD);
        $res = mysqli_stmt_get_result($stmtD);
        $rows = [];
        $grand = 0;
        while ($r = mysqli_fetch_assoc($res)) {
            $r['total_biaya'] = (float)$r['total_biaya'];
            $grand += $r['total_biaya'];
            $rows[] = $r;
        }
        echo json_encode(['kode' => $kode, 'total' => $grand, 'items' => $rows]);
        exit;
    } catch (Exception $e) {
        echo json_encode(['error' => $e->getMessage()]);
        exit;
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Rekap SPPD - SPPD System</title>
    <link rel="icon" type="image/svg+xml" href="data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAyNCAyNCI+PHBhdGggZmlsbD0iIzRlNzNkZiIgZD0iTTIwLDhINFY2aDIwdjJIMjB6IE0xNSwxMEg0djJoMTFWMTB6IE00LDE2aDd2Mkg0VjE2eiBNMjEuNywxMy4zTDIwLjMsMTJsMS40LTEuNEMyMi4xLDEwLjIsMjIuMSw5LjgsMjEuNyw5LjRsLTEuMS0xLjFDMjAuMiw3LjksMTkuOCw3LjksMTkuNCw4LjNMMTgsMTBsLTEuNC0xLjRjLTAuNC0wLjQtMS0wLjQtMS40LDBsLTcuNSw3LjVjLTAuMiwwLjItMC4zLDAuNC0wLjMsMC43djIuOWMwLDAuNSwwLjQsMC45LDAuOSwwLjhoMi45YzAuMywwLDAuNS0wLjEsMC43LTAuM2w3LjUtNy41QzIyLjEsMTQuMywyMi4xLDEzLjcsMjEuNywxMy4zeiIvPjwvc3ZnPg==">
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css" rel="stylesheet">
    <!-- DataTables CSS -->
    <link href="https://cdn.datatables.net/1.10.24/css/dataTables.bootstrap5.min.css" rel="stylesheet">
</head>
<body>
<?php
require_once $_SERVER['DOCUMENT_ROOT'] . '/sppd/config/config.php';
require_once '../vendor/autoload.php';

// Cek login dan level
if (!isset($_SESSION['user_id'])) {
    header("Location: ../login.php");
    exit();
}

try {
    $conn = check_connection($conn);
    
    // Get user's bidang if pimpinan
    $user_level = $_SESSION['level'];
    $user_id = $_SESSION['user_id'];
    $user_bidang = '';
    
    // Ubah untuk mengambil bidang baik untuk pimpinan maupun admin sppd
    if ($user_level === 'pimpinan' || $user_level === 'admin_sppd') {
        $stmt = mysqli_prepare($conn, "SELECT bidang FROM users WHERE id = ?");
        if ($stmt) {
            mysqli_stmt_bind_param($stmt, "i", $user_id);
            mysqli_stmt_execute($stmt);
            $result_user = mysqli_stmt_get_result($stmt);
            if ($user_data = mysqli_fetch_assoc($result_user)) {
                $user_bidang = $user_data['bidang'];
            }
            mysqli_stmt_close($stmt);
        }
    }
    
    // If requested via AJAX: detail by sub kegiatan
    if (isset($_GET['action']) && $_GET['action'] === 'get_sub_detail') {
        $kode = isset($_GET['kode']) ? trim($_GET['kode']) : '';
        $user_level = $_SESSION['level'];
        $user_id = $_SESSION['user_id'];
        $user_bidang = '';
        if ($user_level === 'pimpinan' || $user_level === 'admin_sppd') {
            $stmtB = mysqli_prepare($conn, "SELECT bidang FROM users WHERE id = ?");
            if ($stmtB) {
                mysqli_stmt_bind_param($stmtB, "i", $user_id);
                mysqli_stmt_execute($stmtB);
                $resB = mysqli_stmt_get_result($stmtB);
                if ($ud = mysqli_fetch_assoc($resB)) { $user_bidang = $ud['bidang']; }
                mysqli_stmt_close($stmtB);
            }
        }

        $query_detail = "SELECT 
                            st.id_surat,
                            st.no_surat,
                            st.no_sppd,
                            st.maksud,
                            SUM(COALESCE(rbp.total_biaya, 0)) AS total_biaya
                          FROM detail_rekap_sppd dr
                          JOIN surat_tugas st ON dr.id_surat = st.id_surat
                          LEFT JOIN rincian_bimtek_perorangan rbp ON st.id_surat = rbp.id_surat
                          LEFT JOIN users u ON st.created_by = u.id
                          WHERE COALESCE(rbp.no_sub_kegiatan, st.no_sub_kegiatan) = ?";
        $types = "s";
        $params = [$kode];
        if (($user_level === 'pimpinan' || $user_level === 'admin_sppd') && !empty($user_bidang)) {
            $query_detail .= " AND u.bidang = ?";
            $types .= "s";
            $params[] = $user_bidang;
        }
        $query_detail .= " GROUP BY st.id_surat, st.no_surat, st.no_sppd, st.maksud ORDER BY st.no_surat";

        $stmtD = mysqli_prepare($conn, $query_detail);
        if ($stmtD) {
            mysqli_stmt_bind_param($stmtD, $types, ...$params);
            mysqli_stmt_execute($stmtD);
            $res = mysqli_stmt_get_result($stmtD);
            $rows = [];
            $grand = 0;
            while ($r = mysqli_fetch_assoc($res)) {
                $r['total_biaya'] = (float)$r['total_biaya'];
                $grand += $r['total_biaya'];
                $rows[] = $r;
            }
            header('Content-Type: application/json');
            echo json_encode([
                'kode' => $kode,
                'total' => $grand,
                'items' => $rows
            ]);
            exit;
        } else {
            header('Content-Type: application/json');
            echo json_encode(['error' => 'Query error']);
            exit;
        }
    }

    // Get last rekap number
    $year = date('Y');
    $query_last_number = "SELECT MAX(CAST(SUBSTRING_INDEX(no_rekap, '/', 1) AS UNSIGNED)) as last_number 
                         FROM rekap_sppd 
                         WHERE no_rekap LIKE '%/$year'";
    $result_last_number = mysqli_query($conn, $query_last_number);
    $row_last_number = mysqli_fetch_assoc($result_last_number);
    $last_number = $row_last_number['last_number'] ?? 0;
    $next_number = str_pad($last_number + 1, 3, '0', STR_PAD_LEFT);
    $new_rekap_number = $next_number . "/SPPD-REKAP/" . $year;

    // Query untuk surat tugas yang belum direkap
    $query_unrecapped = "SELECT st.id_surat, st.no_surat, st.maksud, st.tujuan, st.no_sppd,
                         (SELECT SUM(total_biaya) FROM rincian_bimtek_perorangan WHERE id_surat = st.id_surat) as total_biaya
                         FROM surat_tugas st
                         LEFT JOIN detail_rekap_sppd dr ON st.id_surat = dr.id_surat
                         LEFT JOIN users u ON st.created_by = u.id
                         WHERE dr.id_surat IS NULL AND st.no_sppd IS NOT NULL";
    
    // Add bidang filter for pimpinan and admin sppd
    if (($user_level === 'pimpinan' || $user_level === 'admin_sppd') && !empty($user_bidang)) {
        $query_unrecapped .= " AND u.bidang = ?";
    }
    
    $query_unrecapped .= " ORDER BY st.tanggal_surat DESC";
    
    // Query untuk rekap yang sudah ada
    $query_recapped = "SELECT r.id_rekap, r.no_rekap, r.tanggal_rekap,
                       GROUP_CONCAT(
                           st.no_surat
                           ORDER BY st.no_surat ASC 
                           SEPARATOR ', '
                       ) as surat_list
                       FROM rekap_sppd r
                       LEFT JOIN detail_rekap_sppd dr ON r.id_rekap = dr.id_rekap
                       LEFT JOIN surat_tugas st ON dr.id_surat = st.id_surat
                       LEFT JOIN users u ON st.created_by = u.id";

    // Add bidang filter for pimpinan and admin sppd
    if (($user_level === 'pimpinan' || $user_level === 'admin_sppd') && !empty($user_bidang)) {
        $query_recapped .= " WHERE u.bidang = ?";
    }
    
    $query_recapped .= " GROUP BY r.id_rekap, r.no_rekap, r.tanggal_rekap
                         ORDER BY r.tanggal_rekap DESC, r.no_rekap DESC";

    // Execute queries with bidang filter if needed
    if (($user_level === 'pimpinan' || $user_level === 'admin_sppd') && !empty($user_bidang)) {
        $stmt_unrecapped = mysqli_prepare($conn, $query_unrecapped);
        mysqli_stmt_bind_param($stmt_unrecapped, "s", $user_bidang);
        mysqli_stmt_execute($stmt_unrecapped);
        $result_unrecapped = mysqli_stmt_get_result($stmt_unrecapped);

        $stmt_recapped = mysqli_prepare($conn, $query_recapped);
        mysqli_stmt_bind_param($stmt_recapped, "s", $user_bidang);
        mysqli_stmt_execute($stmt_recapped);
        $result_recapped = mysqli_stmt_get_result($stmt_recapped);
    } else {
        $result_unrecapped = mysqli_query($conn, $query_unrecapped);
        $result_recapped = mysqli_query($conn, $query_recapped);
    }
    
    if (!$result_unrecapped || !$result_recapped) {
        throw new Exception("Error executing query: " . mysqli_error($conn));
    }

    // Query total keseluruhan per sub kegiatan dari SEMUA rekap yang sudah dibuat
    $query_totals = "SELECT 
                        COALESCE(rbp.no_sub_kegiatan, st.no_sub_kegiatan) AS kode_kegiatan,
                        SUM(COALESCE(rbp.total_biaya, 0)) AS total
                     FROM detail_rekap_sppd dr
                     JOIN surat_tugas st ON dr.id_surat = st.id_surat
                     LEFT JOIN rincian_bimtek_perorangan rbp ON st.id_surat = rbp.id_surat
                     LEFT JOIN users u ON st.created_by = u.id";

    if (($user_level === 'pimpinan' || $user_level === 'admin_sppd') && !empty($user_bidang)) {
        $query_totals .= " WHERE u.bidang = ?";
    }

    $query_totals .= " GROUP BY kode_kegiatan ORDER BY kode_kegiatan";

    if (($user_level === 'pimpinan' || $user_level === 'admin_sppd') && !empty($user_bidang)) {
        $stmt_totals = mysqli_prepare($conn, $query_totals);
        mysqli_stmt_bind_param($stmt_totals, "s", $user_bidang);
        mysqli_stmt_execute($stmt_totals);
        $result_totals = mysqli_stmt_get_result($stmt_totals);
    } else {
        $result_totals = mysqli_query($conn, $query_totals);
    }

    $totals_by_kode = [];
    $grand_total_all = 0;
    if ($result_totals) {
        while ($r = mysqli_fetch_assoc($result_totals)) {
            $kode = $r['kode_kegiatan'] ?? '';
            $amount = (float)($r['total'] ?? 0);
            if (!isset($totals_by_kode[$kode])) {
                $totals_by_kode[$kode] = 0;
            }
            $totals_by_kode[$kode] += $amount;
            $grand_total_all += $amount;
        }
    }
} catch (Exception $e) {
    echo "<div class='alert alert-danger'>Terjadi kesalahan: " . $e->getMessage() . "</div>";
    error_log($e->getMessage());
}
?>

<div class="main-wrapper">
    <div class="content-header">
        <div class="header-wrapper">
            <div class="title-section">
                <h1>Rekap SPPD</h1>
                <p class="text-muted">Daftar rekap SPPD yang telah dibuat</p>
            </div>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="../dashboard.php">Dashboard</a></li>
                    <li class="breadcrumb-item active">Rekap SPPD</li>
                </ol>
            </nav>
        </div>
    </div>

    <div class="content-body">
        <!-- Surat Tugas yang Belum Direkap -->
        <div class="card">
            <div class="card-header">
                <h5 class="card-title">Surat Tugas yang Belum Direkap</h5>
            </div>
            <div class="card-body p-0">
                <form id="formPilihSurat" action="save_rekap.php" method="POST">
                    <div class="table-responsive">
                        <table class="table table-hover mb-0" id="unrecappedTable">
                            <thead>
                                <tr>
                                    <th class="text-center" style="width: 30px">
                                        <input type="checkbox" id="checkAll" class="form-check-input">
                                    </th>
                                    <th class="text-center" style="width: 30px">No.</th>
                                    <th style="width: 22%">No. Surat</th>
                                    <th style="width: 35%">Maksud</th>
                                    <th style="width: 15%" class="text-end">Total Biaya</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php 
                                $no = 1;
                                while ($row = mysqli_fetch_assoc($result_unrecapped)): 
                                ?>
                                <tr>
                                    <td class="text-center">
                                        <input type="checkbox" name="surat_ids[]" value="<?= $row['id_surat'] ?>" class="form-check-input">
                                    </td>
                                    <td class="text-center"><?= $no++ ?></td>
                                    <td><?= htmlspecialchars($row['no_surat']) ?></td>
                                    <td style="width: 40%">
                                        <div class="text-wrap"><?= nl2br(htmlspecialchars($row['maksud'])) ?></div>
                                    </td>
                                    <td class="text-end" style="width: 20%">
                                        <?php if($row['total_biaya']): ?>
                                            Rp <?= number_format($row['total_biaya'], 0, ',', '.') ?>
                                        <?php else: ?>
                                            Rp 0
                                        <?php endif; ?>
                                    </td>
                                </tr>
                                <?php endwhile; ?>
                                <?php if (mysqli_num_rows($result_unrecapped) == 0): ?>
                                <tr>
                                    <td colspan="4" class="text-center py-4 text-muted">
                                        <i class="bi bi-inbox fs-2 d-block mb-2"></i>
                                        Tidak ada surat tugas yang belum direkap
                                    </td>
                                </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                    <?php if (mysqli_num_rows($result_unrecapped) > 0): ?>
                    <div class="mt-3">
                        <button type="button" class="btn btn-primary" onclick="buatRekap()">
                            <i class="bi bi-plus-circle"></i> Buat Rekap dari Surat Terpilih
                        </button>
                    </div>
                    <?php endif; ?>
                </form>
            </div>
        </div>

        <!-- Daftar Rekap SPPD -->
        <div class="card card-equal-size">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="card-title mb-0">Daftar Rekap SPPD</h5>
                <button type="button" class="btn btn-primary btn-sm" data-bs-toggle="modal" data-bs-target="#modalTotalsAll">
                    <i class="bi bi-calculator"></i> Total Keseluruhan per Sub Kegiatan
                </button>
            </div>
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-hover mb-0" id="recappedTable">
                        <thead>
                            <tr>
                                <th class="text-center" style="width: 80px">No.</th>
                                <th>No. Rekap</th>
                                <th>No. Surat</th>
                                <th class="text-center" style="width: 100px">Aksi</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php 
                            $no = 1;
                            while ($row = mysqli_fetch_assoc($result_recapped)): 
                            ?>
                            <tr>
                                <td class="text-center"><?= $no++ ?></td>
                                <td><?= htmlspecialchars($row['no_rekap']) ?></td>
                                <td style="max-width: 500px; word-wrap: break-word;">
                                    <?= htmlspecialchars($row['surat_list']) ?>
                                </td>
                                <td class="text-center">
                                    <div class="d-flex justify-content-center gap-2">
                                        <a href="detail.php?id=<?= $row['id_rekap'] ?>" class="btn btn-soft-info btn-sm" title="Detail">
                                            <i class="bi bi-eye"></i>
                                        </a>
                                        <a href="edit.php?id=<?= $row['id_rekap'] ?>" class="btn btn-soft-warning btn-sm" title="Edit">
                                            <i class="bi bi-pencil"></i>
                                        </a>
                                        <button type="button" onclick="hapusRekap(<?= $row['id_rekap'] ?>)" class="btn btn-soft-danger btn-sm" title="Hapus">
                                            <i class="bi bi-trash"></i>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                            <?php endwhile; ?>
                            <?php if (mysqli_num_rows($result_recapped) == 0): ?>
                            <tr>
                                <td colspan="4" class="text-center py-4 text-muted">
                                    <i class="bi bi-inbox fs-2 d-block mb-2"></i>
                                    Tidak ada data rekap SPPD tersedia
                                </td>
                            </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modal Tambah Rekap -->
<div class="modal fade" id="modalTambahRekap" tabindex="-1" aria-labelledby="modalTambahRekapLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="modalTambahRekapLabel">Konfirmasi Rekap SPPD</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form id="formTambahRekap" action="save_rekap.php" method="POST">
                <div class="modal-body">
                    <div class="alert alert-info">
                        <div class="d-flex align-items-center mb-2">
                            <i class="bi bi-info-circle me-2"></i>
                            <strong>Informasi Rekap</strong>
                        </div>
                        <p class="mb-0">Nomor rekap akan dibuat secara otomatis:</p>
                        <p class="mb-0"><strong><?= $new_rekap_number ?></strong></p>
                        <p class="mb-0">Tanggal: <strong><?= date('d-m-Y') ?></strong></p>
                    </div>
                    <input type="hidden" name="no_rekap" value="<?= $new_rekap_number ?>">
                    <input type="hidden" name="tanggal_rekap" value="<?= date('Y-m-d') ?>">
                    <input type="hidden" name="surat_ids" id="modalSuratIds">
                    <p>Apakah Anda yakin ingin membuat rekap untuk surat tugas yang dipilih?</p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                    <button type="submit" class="btn btn-primary">Buat Rekap</button>
                </div>
            </form>
        </div>
    </div>
</div>

<?php include_once '../includes/footer.php'; ?>

<!-- Scripts -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.10.24/js/dataTables.bootstrap5.min.js"></script>

<script>
$(document).ready(function() {
    // Inisialisasi DataTables
    $('#unrecappedTable').DataTable({
        "responsive": true,
        "lengthMenu": [[10, 25, 50, -1], [10, 25, 50, "Semua"]],
        "language": {
            "url": "//cdn.datatables.net/plug-ins/1.10.24/i18n/Indonesian.json"
        }
    });

    $('#recappedTable').DataTable({
        "responsive": true,
        "lengthMenu": [[10, 25, 50, -1], [10, 25, 50, "Semua"]],
        "language": {
            "url": "//cdn.datatables.net/plug-ins/1.10.24/i18n/Indonesian.json"
        }
    });

    // Handle check all
    $('#checkAll').change(function() {
        $('input[name="surat_ids[]"""').prop('checked', $(this).prop('checked'));    
    });
});

function togglePegawai(button) {
    const wrapper = button.closest('.pegawai-wrapper');
    const icon = button.querySelector('i');
    wrapper.classList.toggle('pegawai-expanded');
    
    if (wrapper.classList.contains('pegawai-expanded')) {
        icon.classList.remove('bi-eye');
        icon.classList.add('bi-eye-slash');
    } else {
        icon.classList.remove('bi-eye-slash');
        icon.classList.add('bi-eye');
    }
}

function buatRekap() {
    const checkedSurat = $('input[name="surat_ids[]"]:checked');
    if (checkedSurat.length === 0) {
        alert('Pilih minimal satu surat tugas untuk direkap');
        return;
    }

    const selectedIds = Array.from(checkedSurat).map(cb => cb.value);
    $('#modalSuratIds').val(JSON.stringify(selectedIds));
    $('#formTambahRekap').submit();
}

function hapusRekap(id) {
    if(confirm('Apakah Anda yakin ingin menghapus rekap SPPD ini?')) {
        window.location.href = 'hapus.php?id=' + id;
    }
}

// Handler: klik sub kegiatan untuk melihat detail
$(document).on('click', '.link-sub-kegiatan', function(e) {
    e.preventDefault();
    const kode = $(this).data('kode');
    if (!kode) return;

    // Fetch detail via AJAX
    $.ajax({
        url: 'index.php',
        method: 'GET',
        data: { action: 'get_sub_detail', kode },
        dataType: 'json',
        success: function(resp) {
            if (!resp || resp.error) {
                alert(resp && resp.error ? resp.error : 'Gagal mengambil data');
                return;
            }
            renderDetailSubKegiatan(resp);
        },
        error: function() {
            alert('Terjadi kesalahan saat mengambil data');
        }
    });
});

function renderDetailSubKegiatan(data) {
    const rows = (data.items || []).map(function(item, idx) {
        return '<tr>' +
               '<td class="text-center">' + (idx + 1) + '</td>' +
               '<td>' + (item.no_surat ? escapeHtml(item.no_surat) : '-') + '</td>' +
               '<td>' + (item.no_sppd ? escapeHtml(item.no_sppd) : '-') + '</td>' +
               '<td>' + (item.maksud ? nl2br(escapeHtml(item.maksud)) : '-') + '</td>' +
               '<td class="text-end">Rp ' + numberFormatId(item.total_biaya || 0) + '</td>' +
               '</tr>';
    }).join('');

    const totalRow = '<tr class="table-primary fw-bold">' +
                     '<td colspan="4" class="text-end">Total</td>' +
                     '<td class="text-end">Rp ' + numberFormatId(data.total || 0) + '</td>' +
                     '</tr>';

    $('#modalSubDetailLabel').text('Detail Sub Kegiatan: ' + data.kode);
    $('#subDetailTableBody').html(rows || '<tr><td colspan="5" class="text-center text-muted py-3">Tidak ada data</td></tr>');
    $('#subDetailTableBody').append(totalRow);
    const modal = new bootstrap.Modal(document.getElementById('modalSubDetail'));
    modal.show();
}

function numberFormatId(n) {
    n = Math.round(Number(n) || 0);
    return n.toString().replace(/\B(?=(\d{3})+(?!\d))/g, '.');
}

function escapeHtml(s) {
    return String(s)
        .replace(/&/g, '&amp;')
        .replace(/</g, '&lt;')
        .replace(/>/g, '&gt;')
        .replace(/"/g, '&quot;')
        .replace(/'/g, '&#039;');
}

function nl2br(s) {
    return String(s).replace(/\n/g, '<br>');
}
</script>

<!-- Modal Total Keseluruhan per Sub Kegiatan -->
<div class="modal fade" id="modalTotalsAll" tabindex="-1" aria-labelledby="modalTotalsAllLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="modalTotalsAllLabel">Total Keseluruhan per Sub Kegiatan</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th style="width: 60%">No. Sub Kegiatan</th>
                                <th class="text-end">Total</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if (empty($totals_by_kode)): ?>
                            <tr>
                                <td colspan="2" class="text-center text-muted py-3">Tidak ada data</td>
                            </tr>
                            <?php else: ?>
                            <?php ksort($totals_by_kode); foreach ($totals_by_kode as $kode => $total): ?>
                            <tr>
                                <td>
                                    <?php if ($kode): ?>
                                        <a href="#" class="link-sub-kegiatan" data-kode="<?= htmlspecialchars($kode) ?>">
                                            <?= htmlspecialchars($kode) ?>
                                        </a>
                                    <?php else: ?>
                                        <span class="text-danger">Belum diisi</span>
                                    <?php endif; ?>
                                </td>
                                <td class="text-end">Rp <?= number_format($total, 0, ',', '.') ?></td>
                            </tr>
                            <?php endforeach; ?>
                            <tr class="table-primary fw-bold">
                                <td class="text-end">Total Keseluruhan</td>
                                <td class="text-end">Rp <?= number_format($grand_total_all, 0, ',', '.') ?></td>
                            </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Tutup</button>
            </div>
        </div>
    </div>
</div>

<!-- Modal: Detail Sub Kegiatan -->
<div class="modal fade" id="modalSubDetail" tabindex="-1" aria-labelledby="modalSubDetailLabel" aria-hidden="true">
    <div class="modal-dialog modal-xl modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="modalSubDetailLabel">Detail Sub Kegiatan</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="table-responsive">
                    <table class="table table-hover" id="subDetailTable">
                        <thead>
                            <tr>
                                <th class="text-center" style="width: 60px">No.</th>
                                <th>No. Surat</th>
                                <th>No. SPPD</th>
                                <th>Judul/Maksud</th>
                                <th class="text-end">Total Biaya</th>
                            </tr>
                        </thead>
                        <tbody id="subDetailTableBody"></tbody>
                    </table>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Tutup</button>
            </div>
        </div>
    </div>
</div>

<style>
/* Modern Layout */
.main-wrapper {
    min-height: 100vh;
    background: #f8fafc;
    padding: 0;
}

.content-header {
    background: linear-gradient(135deg, #0ea5e9 0%, #2dd4bf 100%);
    padding: 2rem 2rem 6rem;
    margin-bottom: -4rem;
}

.header-wrapper {
    max-width: 100%;
    margin: 0 auto;
}

.title-section h1 {
    color: white;
    font-size: 2rem;
    font-weight: 600;
    margin: 0;
}

.title-section p {
    color: rgba(255, 255, 255, 0.8);
    margin: 0.5rem 0 1rem;
}

.breadcrumb {
    background: rgba(255, 255, 255, 0.1);
    display: inline-flex;
    padding: 0.5rem 1rem;
    border-radius: 8px;
    margin: 0;
}

.breadcrumb-item a {
    color: rgba(255, 255, 255, 0.8);
    text-decoration: none;
}

.breadcrumb-item.active {
    color: white;
}

.content-body {
    padding: 0 2rem 2rem;
}

/* Modern Card Design */
.card {
    background: white;
    border: none;
    border-radius: 16px;
    box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06);
    margin-bottom: 2rem;
    transition: all 0.3s ease;
}

.card:hover {
    box-shadow: 0 10px 15px -3px rgba(0, 0, 0, 0.1), 0 4px 6px -2px rgba(0, 0, 0, 0.05);
}

.card-header {
    background: white;
    padding: 1.5rem;
    border-bottom: 1px solid rgba(0, 0, 0, 0.05);
}

.card-title {
    color: #1e293b;
    font-size: 1.25rem;
    font-weight: 600;
    margin: 0;
}

/* Modern Table Design */
.table {
    width: 100%;
    margin: 0;
}

.table th {
    background: #f8fafc;
    color: #475569;
    font-weight: 600;
    text-transform: uppercase;
    font-size: 0.75rem;
    letter-spacing: 0.05em;
    padding: 1rem 1.5rem;
    border: none;
}

.table td {
    padding: 1rem 1.5rem;
    vertical-align: middle;
    color: #475569;
    border-bottom: 1px solid rgba(0, 0, 0, 0.05);
}

/* Checkbox Styling */
.form-check-input {
    width: 1.2rem;
    height: 1.2rem;
    border-radius: 6px;
    border: 2px solid #cbd5e1;
    cursor: pointer;
    transition: all 0.2s ease;
}

.form-check-input:checked {
    background-color: #0ea5e9;
    border-color: #0ea5e9;
}

/* Button Styling */
.btn {
    padding: 0.75rem 1.5rem;
    border-radius: 8px;
    font-weight: 500;
    transition: all 0.2s ease;
}

.btn-primary {
    background: linear-gradient(135deg, #0ea5e9 0%, #2dd4bf 100%);
    border: none;
    color: white;
}

.btn-primary:hover {
    transform: translateY(-1px);
    box-shadow: 0 4px 6px -1px rgba(14, 165, 233, 0.2);
}

/* DataTables Customization */
.dataTables_wrapper {
    padding: 1.5rem;
}

.dataTables_length select,
.dataTables_filter input {
    border: 1px solid #e2e8f0;
    border-radius: 8px;
    padding: 0.5rem;
    font-size: 0.875rem;
}

.dataTables_paginate .paginate_button {
    padding: 0.5rem 1rem;
    border-radius: 6px;
    margin: 0 0.25rem;
}

.dataTables_paginate .paginate_button.current {
    background: linear-gradient(135deg, #0ea5e9 0%, #2dd4bf 100%) !important;
    border: none;
    color: white !important;
}
.link-sub-kegiatan {
    text-decoration: none;
}
.link-sub-kegiatan:hover {
    text-decoration: underline;
}

/* Action Buttons */
.btn-action {
    width: 2rem;
    height: 2rem;
    padding: 0;
    display: inline-flex;
    align-items: center;
    justify-content: center;
    border-radius: 8px;
    transition: all 0.2s ease;
    margin: 0 0.25rem;
}

.btn-info {
    background: rgba(14, 165, 233, 0.1);
    color: #0ea5e9;
}

.btn-warning {
    background: rgba(234, 179, 8, 0.1);
    color: #eab308;
}

.btn-danger {
    background: rgba(239, 68, 68, 0.1);
    color: #ef4444;
}

.btn-action:hover {
    transform: translateY(-1px);
}

/* Responsive Design */
@media (max-width: 768px) {
    .content-header {
        padding: 1.5rem 1.5rem 5rem;
    }

    .content-body {
        padding: 0 1rem 1rem;
    }

    .title-section h1 {
        font-size: 1.5rem;
    }

    .card-header {
        padding: 1rem;
    }

    .table th,
    .table td {
        padding: 0.75rem 1rem;
    }
}
</style>

</body>
</html> 