<?php
require_once $_SERVER['DOCUMENT_ROOT'] . '/sppd/config/config.php';
require_once '../vendor/autoload.php';

try {
    $conn = check_connection($conn);
    
    // Get form data
    $no_rekap = mysqli_real_escape_string($conn, $_POST['no_rekap']);
    $tanggal_rekap = mysqli_real_escape_string($conn, $_POST['tanggal_rekap']);
    $surat_ids = isset($_POST['surat_ids']) ? json_decode($_POST['surat_ids']) : [];
    
    if (empty($surat_ids)) {
        throw new Exception("Pilih minimal satu surat tugas");
    }
    
    // Start transaction
    mysqli_begin_transaction($conn);
    
    // Insert into rekap_sppd
    $query_insert = "INSERT INTO rekap_sppd (no_rekap, tanggal_rekap) 
                    VALUES ('$no_rekap', '$tanggal_rekap')";
    
    if (!mysqli_query($conn, $query_insert)) {
        throw new Exception("Error creating rekap SPPD");
    }
    
    $id_rekap = mysqli_insert_id($conn);
    
    // Insert detail_rekap_sppd
    foreach ($surat_ids as $surat_id) {
        $surat_id = mysqli_real_escape_string($conn, $surat_id);
        $query_detail = "INSERT INTO detail_rekap_sppd (id_rekap, id_surat)
                        VALUES ('$id_rekap', '$surat_id')";
        
        if (!mysqli_query($conn, $query_detail)) {
            throw new Exception("Error adding surat tugas to rekap");
        }
    }
    
    // Commit transaction
    mysqli_commit($conn);
    
    // Redirect to index with success message
    header('Location: index.php?success=create');
    exit;
    
} catch (Exception $e) {
    mysqli_rollback($conn);
    
    // Redirect back with error message
    header('Location: index.php?error=' . urlencode($e->getMessage()));
    exit;
} 