<?php
session_start();
require_once 'config/database.php';
require_once 'config/config.php';

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Cek apakah ada data registrasi sementara
    if (!isset($_SESSION['temp_registration'])) {
        echo json_encode(['status' => 'error', 'message' => 'Sesi registrasi tidak ditemukan']);
        exit;
    }
    
    $temp_data = $_SESSION['temp_registration'];
    
    // Generate OTP baru
    $new_otp = str_pad(rand(0, 999999), 6, '0', STR_PAD_LEFT);
    $new_otp_expiry = date('Y-m-d H:i:s', strtotime('+10 minutes'));
    
    // Update data session dengan OTP baru
    $_SESSION['temp_registration']['otp'] = $new_otp;
    $_SESSION['temp_registration']['otp_expiry'] = $new_otp_expiry;
    
    // Kirim OTP baru via email
    require 'vendor/autoload.php';
    $mail = new PHPMailer\PHPMailer\PHPMailer(true);
    
    try {
        // Server settings
        $mail->isSMTP();
        $mail->Host = SMTP_HOST;
        $mail->SMTPAuth = true;
        $mail->Username = SMTP_USERNAME;
        $mail->Password = SMTP_PASSWORD;
        $mail->SMTPSecure = PHPMailer\PHPMailer\PHPMailer::ENCRYPTION_STARTTLS;
        $mail->Port = SMTP_PORT;
        
        // Recipients
        $mail->setFrom(SMTP_USERNAME, 'SPPD System');
        $mail->addAddress($temp_data['email'], $temp_data['nama_lengkap']);
        
        // Content
        $mail->isHTML(true);
        $mail->Subject = 'Kode OTP Baru Registrasi SPPD';
        $mail->Body = "
            <div style='font-family: Arial, sans-serif; max-width: 600px; margin: 0 auto;'>
                <h2 style='color: #0ea5e9;'>Kode OTP Baru</h2>
                <p>Hai {$temp_data['nama_lengkap']},</p>
                <p>Berikut adalah kode OTP baru Anda:</p>
                <div style='background: #f8fafc; padding: 20px; text-align: center; border-radius: 10px; margin: 20px 0;'>
                    <h1 style='color: #0f172a; letter-spacing: 5px; margin: 0;'>{$new_otp}</h1>
                </div>
                <p>Kode OTP ini akan kadaluarsa dalam 10 menit.</p>
                <p>Jika Anda tidak meminta kode OTP baru, abaikan email ini.</p>
                <hr style='border: none; border-top: 1px solid #e2e8f0; margin: 20px 0;'>
                <p style='color: #64748b; font-size: 12px;'>Email ini dikirim secara otomatis, mohon tidak membalas email ini.</p>
            </div>
        ";
        
        $mail->send();
        echo json_encode(['status' => 'success', 'message' => 'OTP baru telah dikirim ke email Anda']);
    } catch (Exception $e) {
        error_log("Email sending failed: " . $mail->ErrorInfo);
        echo json_encode(['status' => 'error', 'message' => 'Gagal mengirim OTP baru. Silakan coba lagi']);
    }
} else {
    echo json_encode(['status' => 'error', 'message' => 'Method not allowed']);
} 