<?php
session_start();
require_once '../config/database.php';
require_once '../config/config.php';

if (!isset($_GET['id_surat'])) {
    die("Error: ID Surat harus disertakan");
}

$id_surat = $_GET['id_surat'];

// Query untuk mengambil data surat tugas
$query = "SELECT st.*, 
          GROUP_CONCAT(p.nama_pegawai) as nama_pegawai,
          GROUP_CONCAT(p.nip) as nip_pegawai,
          GROUP_CONCAT(rb.biaya_detail) as biaya_detail
          FROM surat_tugas st 
          JOIN detail_surat_tugas dst ON st.id_surat = dst.id_surat
          JOIN pegawai p ON dst.id_pegawai = p.id_pegawai 
          LEFT JOIN rincian_biaya rb ON st.id_surat = rb.id_surat
          WHERE st.id_surat = ?
          GROUP BY st.id_surat";

$stmt = mysqli_prepare($conn, $query);
mysqli_stmt_bind_param($stmt, "i", $id_surat);
mysqli_stmt_execute($stmt);
$result = mysqli_stmt_get_result($stmt);
$data = mysqli_fetch_assoc($result);

if (!$data) {
    die("Data tidak ditemukan");
}

$nama_pegawai = explode(',', $data['nama_pegawai']);
$nip_pegawai = explode(',', $data['nip_pegawai']);
$biaya_details = explode(',', $data['biaya_detail']);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Daftar Rincian Biaya Perjalanan Dinas</title>
    <link rel="icon" type="image/svg+xml" href="data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAyNCAyNCI+PHBhdGggZmlsbD0iIzRlNzNkZiIgZD0iTTIwLDhINFY2aDIwdjJIMjB6IE0xNSwxMEg0djJoMTFWMTB6IE00LDE2aDd2Mkg0VjE2eiBNMjEuNywxMy4zTDIwLjMsMTJsMS40LTEuNEMyMi4xLDEwLjIsMjIuMSw5LjgsMjEuNyw5LjRsLTEuMS0xLjFDMjAuMiw3LjksMTkuOCw3LjksMTkuNCw4LjNMMTgsMTBsLTEuNC0xLjRjLTAuNC0wLjQtMS0wLjQtMS40LDBsLTcuNSw3LjVjLTAuMiwwLjItMC4zLDAuNC0wLjMsMC43djIuOWMwLDAuNSwwLjQsMC45LDAuOSwwLjloMi45YzAuMywwLDAuNS0wLjEsMC43LTAuM2w3LjUtNy41QzIyLjEsMTQuMywyMi4xLDEzLjcsMjEuNywxMy4zeiIvPjwvc3ZnPg==">
    
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 30px;
        }
        .header {
            text-align: center;
            margin-bottom: 20px;
        }
        .logo {
            width: 80px;
            position: absolute;
            left: 30px;
            top: 20px;
        }
        .title {
            font-size: 12pt;
            font-weight: bold;
            margin-bottom: 5px;
        }
        .address {
            font-size: 10pt;
            margin-bottom: 20px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        table, th, td {
            border: 1px solid black;
        }
        th, td {
            padding: 5px;
            text-align: left;
            font-size: 10pt;
        }
        th {
            background-color: #f2f2f2;
        }
        .text-center {
            text-align: center;
        }
        .text-right {
            text-align: right;
        }
        .total-row {
            font-weight: bold;
        }
        @media print {
            .no-print {
                display: none;
            }
        }
    </style>
</head>
<body>
    <div class="header">
        <img src="../assets/img/logo.png" alt="Logo" class="logo">
        <div class="title">PEMERINTAH KABUPATEN BALANGAN</div>
        <div class="title">DINAS PENDIDIKAN DAN KEBUDAYAAN</div>
        <div class="address">
            Jln. A. Yani. KM. 2,5 Kelurahan Batu Piring Telp./Fax 0526 - 2612 Fax 2028/192<br>
            Paringin Selatan - 71662
        </div>
        <hr style="border-top: 3px double #000;">
    </div>

    <div class="text-center" style="margin-bottom: 20px;">
        <div class="title">DAFTAR RINCIAN BIAYA PERJALANAN DINAS DALAM DAERAH DALAM PROVINSI</div>
        <div>Kegiatan tanggal <?= date('d F Y', strtotime($data['tanggal_berangkat'])) ?> s/d <?= date('d F Y', strtotime($data['tanggal_kembali'])) ?></div>
    </div>

    <table>
        <thead>
            <tr>
                <th class="text-center">NO</th>
                <th>NAMA</th>
                <th>NIP</th>
                <th>Uang Harian (Rp.)</th>
                <th>Transport (Rp.)</th>
                <th>Jarak (KM)</th>
                <th>Biaya Jarak (Rp.)</th>
                <th>Jumlah (Rp.)</th>
                <th>Tanda Tangan</th>
            </tr>
        </thead>
        <tbody>
            <?php
            $no = 1;
            $total = 0;
            foreach ($nama_pegawai as $index => $nama):
                $biaya = json_decode($biaya_details[$index] ?? '{}', true);
                $jumlah = ($biaya['uang_harian'] ?? 0) + ($biaya['transport'] ?? 0) + ($biaya['biaya_jarak'] ?? 0);
                $total += $jumlah;
            ?>
            <tr>
                <td class="text-center"><?= $no++ ?></td>
                <td><?= htmlspecialchars($nama) ?></td>
                <td><?= htmlspecialchars($nip_pegawai[$index] ?? '') ?></td>
                <td class="text-right">Rp. <?= number_format($biaya['uang_harian'] ?? 0, 0, ',', '.') ?></td>
                <td class="text-right">Rp. <?= number_format($biaya['transport'] ?? 0, 0, ',', '.') ?></td>
                <td class="text-center"><?= $biaya['jarak'] ?? 0 ?></td>
                <td class="text-right">Rp. <?= number_format($biaya['biaya_jarak'] ?? 0, 0, ',', '.') ?></td>
                <td class="text-right">Rp. <?= number_format($jumlah, 0, ',', '.') ?></td>
                <td class="text-center"><?= $no - 1 ?></td>
            </tr>
            <?php endforeach; ?>
            <tr class="total-row">
                <td colspan="7" class="text-center">TOTAL</td>
                <td class="text-right">Rp. <?= number_format($total, 0, ',', '.') ?></td>
                <td></td>
            </tr>
        </tbody>
    </table>

    <div class="no-print" style="margin-top: 20px; text-align: center;">
        <button onclick="window.print()">Cetak</button>
        <button onclick="window.close()">Tutup</button>
    </div>
</body>
</html> 