<?php ob_start();
session_start();
require_once '../config/database.php';
require_once '../config/config.php';
require_once '../config/functions.php';

// Fungsi untuk format tanggal Indonesia
function tanggal_indo($tanggal) {
    if (empty($tanggal) || $tanggal == '0000-00-00') return '';
    
    // Jika tanggal mengandung jam, ambil hanya bagian tanggalnya
    if (strpos($tanggal, ' ') !== false) {
        $tanggal = explode(' ', $tanggal)[0];
    }
    
    $bulan = array (
        1 => 'Januari', 'Februari', 'Maret', 'April', 'Mei', 'Juni',
        'Juli', 'Agustus', 'September', 'Oktober', 'November', 'Desember'
    );
    $pecahkan = explode('-', $tanggal);
    
    return $pecahkan[2] . ' ' . $bulan[(int)$pecahkan[1]] . ' ' . $pecahkan[0];
}

// Fungsi untuk mengubah angka ke terbilang
function terbilang($angka) {
    $angka = abs($angka);
    $baca = array('', 'Satu', 'Dua', 'Tiga', 'Empat', 'Lima', 'Enam', 'Tujuh', 'Delapan', 'Sembilan', 'Sepuluh', 'Sebelas');
    $terbilang = '';

    if ($angka < 12) {
        $terbilang = ' ' . $baca[$angka];
    } elseif ($angka < 20) {
        $terbilang = terbilang($angka - 10) . ' Belas';
    } elseif ($angka < 100) {
        $terbilang = terbilang($angka/10) . ' Puluh' . terbilang($angka % 10);
    } elseif ($angka < 200) {
        $terbilang = ' Seratus' . terbilang($angka - 100);
    } elseif ($angka < 1000) {
        $terbilang = terbilang($angka/100) . ' Ratus' . terbilang($angka % 100);
    } elseif ($angka < 2000) {
        $terbilang = ' Seribu' . terbilang($angka - 1000);
    } elseif ($angka < 1000000) {
        $terbilang = terbilang($angka/1000) . ' Ribu' . terbilang($angka % 1000);
    } elseif ($angka < 1000000000) {
        $terbilang = terbilang($angka/1000000) . ' Juta' . terbilang($angka % 1000000);
    }

    return $terbilang;
}

if (isset($_GET['id_surat'])) {
    $id_surat = $_GET['id_surat'];
    
    // Query untuk data surat
    $query = "SELECT st.*, DATEDIFF(st.tanggal_kembali, st.tanggal_berangkat) + 1 as lama_perjalanan 
              FROM surat_tugas st WHERE st.id_surat = ?";
    $stmt = mysqli_prepare($conn, $query);
    mysqli_stmt_bind_param($stmt, "i", $id_surat);
    mysqli_stmt_execute($stmt);
    $result = mysqli_stmt_get_result($stmt);
    $data = mysqli_fetch_assoc($result);

    // Query untuk data pegawai dalam surat tugas
    $query_pegawai = "SELECT p.*, dst.tujuan_pegawai, 
                      rbp.uang_harian_per_hari,
                      rbp.total_uang_harian,
                      rbp.representatif_per_hari,
                      rbp.total_representatif,
                      rbp.transport_dalam_provinsi,
                      rbp.transport_luar_provinsi,
                      rbp.biaya_pesawat_berangkat,
                      rbp.biaya_pesawat_pulang,
                      rbp.akomodasi,
                      rbp.jarak,
                      rbp.biaya_jarak,
                      rbp.waktu_kedatangan_aktual,
                      rbp.waktu_kepulangan_aktual,
                      rbp.lama_perjalanan_aktual
                      FROM pegawai p 
                      JOIN detail_surat_tugas dst ON p.id_pegawai = dst.id_pegawai 
                      LEFT JOIN rincian_bimtek_perorangan rbp ON dst.id_surat = rbp.id_surat 
                      AND p.id_pegawai = rbp.id_pegawai
                      WHERE dst.id_surat = ?
                      ORDER BY p.nama_pegawai ASC";
    $stmt = mysqli_prepare($conn, $query_pegawai);
    mysqli_stmt_bind_param($stmt, "i", $id_surat);
    mysqli_stmt_execute($stmt);
    $result_pegawai = mysqli_stmt_get_result($stmt);
    $pegawai_list = [];
    while ($row = mysqli_fetch_assoc($result_pegawai)) {
        $pegawai_list[] = $row;
    }

    // Check for representatif values from the pegawai list
    $show_representatif = false;
    foreach($pegawai_list as $pegawai) {
        if (isset($pegawai['representatif_per_hari']) && (int)$pegawai['representatif_per_hari'] > 0) {
            $show_representatif = true;
            break;
        }
    }

    // Store rincian data
    $data['rincian'] = $rincian;

    // Hitung lama perjalanan dari surat tugas
    $lama_hari = $data['lama_perjalanan'];

    ob_end_clean();
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Tanda Terima Khusus - SPPD</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <!-- Tambahkan meta untuk memaksa landscape -->
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
    <link rel="icon" type="image/svg+xml" href="data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAyNCAyNCI+PHBhdGggZmlsbD0iIzRlNzNkZiIgZD0iTTIwLDhINFY2aDIwdjJIMjB6IE0xNSwxMEg0djJoMTFWMTB6IE00LDE2aDd2Mkg0VjE2eiBNMjEuNywxMy4zTDIwLjMsMTJsMS40LTEuNEMyMi4xLDEwLjIsMjIuMSw5LjgsMjEuNyw5LjRsLTEuMS0xLjFDMjAuMiw3LjksMTkuOCw3LjksMTkuNCw4LjNMMTgsMTBsLTEuNC0xLjRjLTAuNC0wLjQtMS0wLjQtMS40LDBsLTcuNSw3LjVjLTAuMiwwLjItMC4zLDAuNC0wLjMsMC43djIuOWMwLDAuNSwwLjQsMC45LDAuOSwwLjhoMi45YzAuMywwLDAuNS0wLjEsMC43LTAuM2w3LjUtNy41QzIyLjEsMTQuMywyMi4xLDEzLjcsMjEuNywxMy4zeiIvPjwvc3ZnPg==">
    
    <style>
        @page {
            size: 355.6mm 215.9mm landscape; /* Ukuran kertas F4 landscape */
            margin: 10mm 10mm 10mm 25mm; /* Margin kiri lebih besar */
        }
        
        body {
            font-family: Times New Roman, serif;
            line-height: 1.5;
            font-size: 12pt;
            margin: 0;
            padding: 0 0 0 15px; /* Tambah padding kiri */
            width: calc(100% - 15px); /* Sesuaikan lebar dengan padding */
            background: white;
        }

        .kop-container {
            display: flex;
            align-items: flex-start;
            margin-bottom: 15px;
            padding-left: 15px; /* Tambah padding kiri */
            position: relative;
            width: calc(100% - 30px); /* Sesuaikan lebar */
        }

        .logo {
            width: 70px;
            height: auto;
            position: absolute;
            left: 15px; /* Sesuaikan posisi logo */
            top: 0;
        }

        .header {
            text-align: center;
            width: 100%;
            padding-right: 70px;
        }

        .header h2 {
            font-size: 14pt;
            font-weight: bold;
            margin: 0 0 2px 0;
            line-height: 1.2;
            text-transform: uppercase;
        }

        .header h3 {
            font-size: 13pt;
            font-weight: bold;
            margin: 0 0 2px 0;
            line-height: 1.2;
            text-transform: uppercase;
        }

        .header p {
            font-size: 10pt;
            margin: 0 0 1px 0;
            line-height: 1.2;
        }

        .garis-kop {
            border: 1.5px solid black;
            margin: 8px 0;
        }

        .title {
            text-align: center;
            margin: 15px 0;
        }

        .title h3 {
            margin: 0 0 5px 0;
            text-transform: uppercase;
            font-size: 13pt;
            font-weight: bold;
        }

        .title p {
            margin: 3px 0;
            font-size: 11pt;
        }

        table {
            table-layout: fixed;
            width: calc(100% - 30px);
            margin: 10px 15px;
            font-size: 11pt !important; /* Memperbesar font default tabel */
            border-collapse: collapse;
        }

        table, th, td {
            border: 0.5px solid black;
        }

        /* Mengatur tinggi dan spacing baris tabel */
        table tr {
            height: 50px !important; /* Meningkatkan tinggi baris */
        }

        table th {
            padding: 8px 4px !important;
            text-align: center;
            background-color: #f0f0f0;
            font-weight: bold;
            vertical-align: middle;
            white-space: nowrap;
            height: 40px !important;
            font-size: 11pt !important; /* Font header */
        }

        table td {
            padding: 6px 4px !important;
            vertical-align: middle;
            height: inherit;
            font-size: 11pt !important; /* Font isi tabel */
        }

        /* Mengatur tampilan nama dan NIP */
        .nama-nip {
            display: block;
            line-height: 1.4;
            font-size: 11pt !important; /* Font nama */
            white-space: normal;
            overflow: hidden;
            text-overflow: ellipsis;
            padding: 2px 0;
            font-weight: normal;
        }

        .nip {
            display: block;
            font-size: 10pt !important; /* Font NIP */
            color: #333;
            white-space: nowrap;
            overflow: hidden;
            text-overflow: ellipsis;
            padding-top: 2px;
        }

        /* Mengatur kolom nomor */
        table th:first-child,
        table td:first-child {
            padding-top: 8px !important;
        }

        /* Mengatur kolom TTD */
        table td:last-child {
            padding-top: 15px !important; /* Memberikan ruang untuk tanda tangan */
        }

        td[align="right"] {
            text-align: right;
            padding-right: 6px;
            white-space: nowrap;
            font-size: 11pt !important;
        }

        td[align="center"] {
            text-align: center;
        }

        /* Kolom tanda tangan */
        td:last-child {
            height: 30px;
            min-width: 40px;
        }

        /* Baris total */
        tr:last-child {
            font-weight: bold;
        }

        tr:last-child td {
            padding: 8px 4px;
            background-color: #f9f9f9;
            font-size: 11pt !important;
            font-weight: bold;
        }

        /* Mengatur ulang lebar kolom */
        table th:first-child,
        table td:first-child {
            width: 40px !important;
            min-width: 40px !important;
            max-width: 40px !important;
            padding: 4px 2px !important;
            text-align: center;
        }

        /* Override style untuk kolom nomor di thead */
        thead th:first-child {
            width: 40px !important;
            min-width: 40px !important;
            padding: 6px 2px !important;
        }

        /* Menghapus style yang mungkin konflik */
        th:nth-child(1), td:nth-child(1) { 
            width: 40px !important;
        }

        /* Style khusus untuk kolom TTD */
        table td:last-child {
            text-align: left !important;
            padding-left: 15px !important;
        }

        /* Mengatur lebar kolom nama/NIP */
        table th:nth-child(2),
        table td:nth-child(2) {
            width: 140px !important;
            min-width: 140px !important;
            max-width: 140px !important;
        }

        /* Style khusus untuk kolom TTD */
        table td:last-child,
        table th:last-child {
            width: 60px !important;
            min-width: 60px !important;
            max-width: 60px !important;
        }

        @media print {
            body {
                padding: 0 0 0 15px !important;
                margin: 0 !important;
                width: calc(100% - 15px) !important;
            }

            .kop-container {
                padding-left: 15px !important;
                width: calc(100% - 30px) !important;
            }

            table {
                width: calc(100% - 30px) !important;
                margin: 10px 15px !important;
            }

            /* Memastikan orientasi landscape */
            html, body {
                height: 215.9mm;
                width: 355.6mm;
            }

            @page {
                size: landscape;
                margin: 10mm 10mm 10mm 25mm; /* Margin kiri lebih besar */
            }

            table tr {
                height: 50px !important;
                page-break-inside: avoid;
            }

            table th {
                height: 40px !important;
            }

            table, th, td {
                font-size: 11pt !important;
            }

            .nama-nip {
                font-size: 11pt !important;
            }

            .nip {
                font-size: 10pt !important;
            }
        }
    </style>
</head>
<body>
    <div class="kop-container">
        <img src="../assets/img/logo.png" alt="Logo Kabupaten Balangan" class="logo">
        <div class="header">
            <h2>PEMERINTAH KABUPATEN BALANGAN</h2>
            <h3>DINAS PENDIDIKAN DAN KEBUDAYAAN</h3>
            <p>Jln. A. Yani. KM. 2,5 Kelurahan Batu Piring Telp./Fax 0526 - 2612 Fax 2028/192</p>
            <p>Paringin Selatan - 71662</p>
        </div>
    </div>
    <hr class="garis-kop">

    <div class="title">
        <h3>TANDA TERIMA BIAYA PERJALANAN DINAS <?= strtoupper($data['jenis_surat']) ?></h3>
        
        <p><?= htmlspecialchars($data['maksud']) ?></p>
        <p>Kegiatan tanggal <?= tanggal_indo($data['tanggal_berangkat']) ?> s/d <?= tanggal_indo($data['tanggal_kembali']) ?></p>
    </div>

    <?php 
    // Cek apakah ada nilai representatif dan uang diklat yang tidak 0
    $show_representatif = false;
    $show_uang_diklat = false;
    foreach($pegawai_list as $pegawai) {
        if (isset($pegawai['representatif_per_hari']) && (int)$pegawai['representatif_per_hari'] > 0) {
            $show_representatif = true;
        }
        if (isset($pegawai['total_uang_diklat']) && (int)$pegawai['total_uang_diklat'] > 0) {
            $show_uang_diklat = true;
        }
        if ($show_representatif && $show_uang_diklat) break;
    }
    ?>
    <table>
        <thead>
            <tr>
                <th style="width: 40px !important; min-width: 40px !important; height: 40px !important; font-size: 11pt !important;">NO</th>
                <th style="width: 140px !important; height: 40px !important; font-size: 11pt !important;">NAMA / NIP</th>
                    <?php if ($data['jenis_surat'] == 'Dalam Daerah Dalam Provinsi'): ?>
                      <th style="width: 95px; font-size: 11pt !important;">Uang Harian</th>
                      <?php if ($show_representatif): ?>
                      <th style="width: 95px; font-size: 11pt !important;">Representatif</th>
                      <?php endif; ?>
                      <th style="width: 95px; font-size: 11pt !important;">Transport (Rp.)</th>
                      <th style="width: 45px; font-size: 11pt !important;">Jarak (KM)</th>
                      <th style="width: 95px; font-size: 11pt !important;">Biaya Jarak (Rp.)</th>
                      <th style="width: 95px; font-size: 11pt !important;">Jumlah (Rp.)</th>
                      <th style="width: 60px !important; text-align: center; font-size: 11pt !important;">TTD</th>
                <?php elseif ($data['jenis_surat'] == 'Luar Daerah Dalam Provinsi'): ?>
                    <th style="width: 95px; font-size: 11pt !important;">Uang Harian</th>
                    <?php if ($show_representatif): ?>
                    <th style="width: 95px; font-size: 11pt !important;">Representatif</th>
                    <?php endif; ?>
                    <th style="width: 95px; font-size: 11pt !important;">Transport (Rp.)</th>
                    <th style="width: 95px; font-size: 11pt !important;">Biaya Hotel (Rp.)</th>
                    <th style="width: 95px; font-size: 11pt !important;">Jumlah (Rp.)</th>
                    <th style="width: 60px !important; text-align: center; font-size: 11pt !important;">TTD</th>
                <?php else: ?>
                    <th style="width: 85px; font-size: 11pt !important;">Uang Harian</th>
                    <?php if ($show_representatif): ?>
                    <th style="width: 85px; font-size: 11pt !important;">Representatif</th>
                    <?php endif; ?>
                    <th style="width: 85px; font-size: 11pt !important;">Biaya Hotel (Rp.)</th>
                    <th style="width: 85px; font-size: 11pt !important;">Transport Darat (Rp.)</th>
                    <th style="width: 85px; font-size: 11pt !important;">Transport Udara (Rp.)</th>
                    <th style="width: 85px; font-size: 11pt !important;">Jumlah (Rp.)</th>
                    <th style="width: 60px !important; text-align: center; font-size: 11pt !important;">TTD</th>
                <?php endif; ?>
            </tr>
        </thead>
        <tbody>
            <?php 
            $no = 1;
            $grand_total = 0;
            $total_pegawai = count($pegawai_list);
            
            foreach($pegawai_list as $pegawai): 
                // Pastikan nilai tidak null
                $uang_harian_per_hari = isset($pegawai['uang_harian_per_hari']) ? (int)$pegawai['uang_harian_per_hari'] : 0;
                $uang_harian = isset($pegawai['total_uang_harian']) ? (int)$pegawai['total_uang_harian'] : 0;
                $representatif_per_hari = isset($pegawai['representatif_per_hari']) ? (int)$pegawai['representatif_per_hari'] : 0;
                $representatif = isset($pegawai['total_representatif']) ? (int)$pegawai['total_representatif'] : 0;
                $transport_dalam = isset($pegawai['transport_dalam_provinsi']) ? (int)$pegawai['transport_dalam_provinsi'] : 0;
                $transport_luar = isset($pegawai['transport_luar_provinsi']) ? (int)$pegawai['transport_luar_provinsi'] : 0;
                $biaya_jarak = isset($pegawai['biaya_jarak']) ? (int)$pegawai['biaya_jarak'] : 0;
                $akomodasi = isset($pegawai['akomodasi']) ? (int)$pegawai['akomodasi'] : 0;
                $pesawat_berangkat = isset($pegawai['biaya_pesawat_berangkat']) ? (int)$pegawai['biaya_pesawat_berangkat'] : 0;
                $pesawat_pulang = isset($pegawai['biaya_pesawat_pulang']) ? (int)$pegawai['biaya_pesawat_pulang'] : 0;
                $jarak = isset($pegawai['jarak']) ? (int)$pegawai['jarak'] : 0;
                
                // Cek waktu aktual
                $waktu_kedatangan = isset($pegawai['waktu_kedatangan_aktual']) && $pegawai['waktu_kedatangan_aktual'] != '0000-00-00' ? $pegawai['waktu_kedatangan_aktual'] : null;
                $waktu_kepulangan = isset($pegawai['waktu_kepulangan_aktual']) && $pegawai['waktu_kepulangan_aktual'] != '0000-00-00' ? $pegawai['waktu_kepulangan_aktual'] : null;
                $lama_perjalanan_aktual = isset($pegawai['lama_perjalanan_aktual']) && $pegawai['lama_perjalanan_aktual'] > 0 ? (int)$pegawai['lama_perjalanan_aktual'] : null;
                
                // Tentukan lama hari yang digunakan
                $lama_hari_aktual = $lama_perjalanan_aktual ?? $lama_hari;
                $jenis_durasi = $lama_perjalanan_aktual ? 'aktual' : 'surat tugas';

                if ($data['jenis_surat'] == 'Dalam Daerah Dalam Provinsi'): 
                    $total = $uang_harian + $representatif + $transport_dalam + $biaya_jarak;
                elseif ($data['jenis_surat'] == 'Luar Daerah Dalam Provinsi'):
                    $total = $uang_harian + $representatif + $transport_dalam + $akomodasi;
                else:
                    $total = $uang_harian + $representatif + $transport_dalam + $transport_luar + 
                            $pesawat_berangkat + $pesawat_pulang + $akomodasi;
                endif;
                $grand_total += $total;
            ?>
            <tr>
                <td align="center"><?= $no ?></td>
                <td>
                    <span class="nama-nip"><?= htmlspecialchars($pegawai['nama_pegawai']) ?></span>
                    <span class="nip"><?= htmlspecialchars($pegawai['nip']) ?></span>
                </td>
                <?php if ($data['jenis_surat'] == 'Dalam Daerah Dalam Provinsi'): ?>
                    <td align="right">
                        Rp. <?= number_format($uang_harian, 0, ',', '.') ?>
                        <br>
                        <small style="font-size: 9pt;">(Rp. <?= number_format($uang_harian_per_hari, 0, ',', '.') ?> × <?= $lama_hari_aktual ?> hari)</small>
                         </td>
                    <?php if ($show_representatif): ?>
                    <td align="right">
                        Rp. <?= number_format($representatif, 0, ',', '.') ?>
                        <br>
                        <small style="font-size: 9pt;">(Rp. <?= number_format($representatif_per_hari, 0, ',', '.') ?> × <?= $lama_hari_aktual ?> hari)</small>
                           </td>
                    <?php endif; ?>
                    <td align="right">Rp. <?= number_format($transport_dalam, 0, ',', '.') ?></td>
                    <td style="text-align: center"><?= $jarak ?></td>
                    <td align="right">Rp. <?= number_format($biaya_jarak, 0, ',', '.') ?></td>
                    <td align="right">Rp. <?= number_format($total, 0, ',', '.') ?></td>
                    <td style="text-align: left; padding-left: 20px; width: 60px !important;"><?= $no ?></td>
                <?php elseif ($data['jenis_surat'] == 'Luar Daerah Dalam Provinsi'): ?>
                    <td align="right">
                        Rp. <?= number_format($uang_harian, 0, ',', '.') ?>
                        <br>
                        <small style="font-size: 9pt;">(Rp. <?= number_format($uang_harian_per_hari, 0, ',', '.') ?> × <?= $lama_hari_aktual ?> hari)</small>
                             </td>
                    <?php if ($show_representatif): ?>
                    <td align="right">
                        Rp. <?= number_format($representatif, 0, ',', '.') ?>
                        <br>
                        <small style="font-size: 9pt;">(Rp. <?= number_format($representatif_per_hari, 0, ',', '.') ?> × <?= $lama_hari_aktual ?> hari)</small>
                        <small style="font-size: 9pt; font-style: italic; display: block; margin-top: -2px;"><?= tanggal_indo($waktu_kedatangan ?? $data['tanggal_berangkat']) ?> s/d <?= tanggal_indo($waktu_kepulangan ?? $data['tanggal_kembali']) ?></small>
                    </td>
                    <?php endif; ?>
                    <td align="right">Rp. <?= number_format($transport_dalam, 0, ',', '.') ?></td>
                    <td align="right">Rp. <?= number_format($akomodasi, 0, ',', '.') ?></td>
                    <td align="right">Rp. <?= number_format($total, 0, ',', '.') ?></td>
                    <td style="text-align: left; padding-left: 20px; width: 60px !important;"><?= $no ?></td>
                <?php else: ?>
                    <td align="right">
                        Rp. <?= number_format($uang_harian, 0, ',', '.') ?>
                        <br>
                        <small style="font-size: 9pt;">(Rp. <?= number_format($uang_harian_per_hari, 0, ',', '.') ?> × <?= $lama_hari_aktual ?> hari)</small>
                        <small style="font-size: 9pt; font-style: italic; display: block; margin-top: -2px;"><?= tanggal_indo($waktu_kedatangan ?? $data['tanggal_berangkat']) ?> s/d <?= tanggal_indo($waktu_kepulangan ?? $data['tanggal_kembali']) ?></small>
                    </td>
                    <?php if ($show_representatif): ?>
                    <td align="right">
                        Rp. <?= number_format($representatif, 0, ',', '.') ?>
                        <br>
                        <small style="font-size: 9pt;">(Rp. <?= number_format($representatif_per_hari, 0, ',', '.') ?> × <?= $lama_hari_aktual ?> hari)</small>
                        <small style="font-size: 9pt; font-style: italic; display: block; margin-top: -2px;"><?= tanggal_indo($waktu_kedatangan ?? $data['tanggal_berangkat']) ?> s/d <?= tanggal_indo($waktu_kepulangan ?? $data['tanggal_kembali']) ?></small>
                    </td>
                    <?php endif; ?>
                    <td align="right">Rp. <?= number_format($akomodasi, 0, ',', '.') ?></td>
                    <td align="right">Rp. <?= number_format($transport_dalam + $transport_luar, 0, ',', '.') ?></td>
                    <td align="right">Rp. <?= number_format($pesawat_berangkat + $pesawat_pulang, 0, ',', '.') ?></td>
                    <td align="right">Rp. <?= number_format($total, 0, ',', '.') ?></td>
                    <td style="text-align: left; padding-left: 20px; width: 60px !important;"><?= $no ?></td>
                <?php endif; ?>
            </tr>
            <?php 
            $no++;
            endforeach; 
            ?>
            <tr>
                <?php if ($data['jenis_surat'] == 'Dalam Daerah Dalam Provinsi'): ?>
                    <td colspan="6" align="center" style="text-align: center;"><strong>TOTAL</strong></td>
                    <td align="right"><strong>Rp. <?= number_format($grand_total, 0, ',', '.') ?></strong></td>
                    <td></td>
                <?php elseif ($data['jenis_surat'] == 'Luar Daerah Dalam Provinsi'): ?>
                    <?php 
                    $colspan = 5; // Default columns
                    if ($show_representatif) $colspan++;
                    if ($show_uang_diklat) $colspan++;
                    ?>
                    <td colspan="<?= $colspan ?>" align="center" style="text-align: center;"><strong>TOTAL</strong></td>
                    <td align="right"><strong>Rp. <?= number_format($grand_total, 0, ',', '.') ?></strong></td>
                    <td></td>
                <?php else: ?>
                    <?php 
                    $colspan = 6; // Default columns
                    if ($show_representatif) $colspan++;
                    if ($show_uang_diklat) $colspan++;
                    ?>
                    <td colspan="<?= $colspan ?>" align="center" style="text-align: center;"><strong>TOTAL</strong></td>
                    <td align="right"><strong>Rp. <?= number_format($grand_total, 0, ',', '.') ?></strong></td>
                    <td></td>
                <?php endif; ?>
            </tr>
        </tbody>
    </table>

    <script>
        window.onload = function() {
            // Fungsi untuk memaksa orientasi landscape
            function forceLandscape() {
                if (window.matchMedia) {
                    var mediaQueryList = window.matchMedia('print');
                    mediaQueryList.addListener(function(mql) {
                        if (mql.matches) {
                            document.documentElement.style.width = '355.6mm';
                            document.documentElement.style.height = '215.9mm';
                        }
                    });
                }
            }

            // Panggil fungsi
            forceLandscape();

            // Delay sebentar sebelum print untuk memastikan style sudah diterapkan
            setTimeout(function() {
                window.print();
                };
            }, 500);
        }

        // Tambahkan event listener untuk before print
        window.onbeforeprint = function() {
            document.documentElement.style.width = '355.6mm';
            document.documentElement.style.height = '215.9mm';
        };
    </script>
</body>
</html> 