<?php
session_start();
require_once '../config/database.php';
require_once '../config/config.php';

// Check if user is logged in
if (!isset($_SESSION['user_id'])) {
    echo json_encode(['success' => false, 'message' => 'Unauthorized access']);
    exit;
}

// Check if ID and type are provided
if (!isset($_POST['id']) || !isset($_POST['type'])) {
    echo json_encode(['success' => false, 'message' => 'Missing required parameters']);
    exit;
}

$id = $_POST['id'];
$type = $_POST['type'];

// Start transaction
mysqli_begin_transaction($conn);

try {
    if ($type === 'non_bimtek') {
        // Delete from rincian_biaya_riil_non_bimtek_perorangan
        $query = "DELETE FROM rincian_biaya_riil_non_bimtek_perorangan WHERE id_surat = ?";
        $stmt = mysqli_prepare($conn, $query);
        mysqli_stmt_bind_param($stmt, "i", $id);
        mysqli_stmt_execute($stmt);

        // Delete from rincian_biaya_riil_non_bimtek
        $query = "DELETE FROM rincian_biaya_riil_non_bimtek WHERE id_surat = ?";
        $stmt = mysqli_prepare($conn, $query);
        mysqli_stmt_bind_param($stmt, "i", $id);
        mysqli_stmt_execute($stmt);

        // Delete from rincian_non_bimtek_perorangan
        $query = "DELETE FROM rincian_non_bimtek_perorangan WHERE id_surat = ?";
        $stmt = mysqli_prepare($conn, $query);
        mysqli_stmt_bind_param($stmt, "i", $id);
        mysqli_stmt_execute($stmt);

        // Commit transaction
        mysqli_commit($conn);
        echo json_encode(['success' => true]);
    } else {
        throw new Exception('Invalid record type');
    }
} catch (Exception $e) {
    // Rollback transaction on error
    mysqli_rollback($conn);
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}

// Close connection
mysqli_close($conn);
?> 