<?php
session_start();
require_once '../config/database.php';
require_once '../config/config.php';

// Ambil data rincian yang akan diedit
if (isset($_GET['id']) && isset($_GET['surat'])) {
    $id_rincian = $_GET['id'];
    $id_surat = $_GET['surat'];
    
    // Query untuk mengambil data rincian dan jabatan pegawai
    $query_rincian = "SELECT r.*, p.nama_pegawai, p.jabatan, st.jenis_surat, st.tanggal_berangkat, st.tanggal_kembali,
                      DATEDIFF(st.tanggal_kembali, st.tanggal_berangkat) + 1 as lama_perjalanan 
                      FROM rincian_bimtek_perorangan r
                      JOIN pegawai p ON r.id_pegawai = p.id_pegawai
                      JOIN surat_tugas st ON r.id_surat = st.id_surat
                      WHERE r.id_rincian_perorangan = ?";
    
    $stmt = mysqli_prepare($conn, $query_rincian);
    mysqli_stmt_bind_param($stmt, "i", $id_rincian);
    mysqli_stmt_execute($stmt);
    $result = mysqli_stmt_get_result($stmt);
    $rincian = mysqli_fetch_assoc($result);

    // Fungsi untuk mengecek apakah pegawai adalah pejabat tinggi
    function isPejabatTinggi($jabatan) {
        $pejabat_tinggi = ['Kepala Dinas', 'Kepala Badan', 'Bupati', 'Sekretaris Daerah', 'Anggota DPR'];
        return in_array(trim($jabatan), $pejabat_tinggi);
    }

    // Set flag untuk menampilkan field representatif
    $show_representatif = isPejabatTinggi($rincian['jabatan']);
}

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $id_rincian = $_POST['id_rincian'];
    $uang_harian = str_replace('.', '', $_POST['uang_harian']);
    $representatif_per_hari = isset($_POST['representatif_per_hari']) ? str_replace('.', '', $_POST['representatif_per_hari']) : 0;
    $uang_diklat = isset($_POST['uang_diklat']) ? str_replace('.', '', $_POST['uang_diklat']) : 0;
    $transport_dalam_provinsi = isset($_POST['transport_dalam']) ? str_replace('.', '', $_POST['transport_dalam']) : 0;
    $transport_luar_provinsi = isset($_POST['transport_luar']) ? str_replace('.', '', $_POST['transport_luar']) : 0;
    $biaya_pesawat_berangkat = isset($_POST['pesawat_berangkat']) ? str_replace('.', '', $_POST['pesawat_berangkat']) : 0;
    $biaya_pesawat_pulang = isset($_POST['pesawat_kembali']) ? str_replace('.', '', $_POST['pesawat_kembali']) : 0;
    $akomodasi = isset($_POST['akomodasi']) ? str_replace('.', '', $_POST['akomodasi']) : 0;
    $jarak = isset($_POST['jarak']) ? $_POST['jarak'] : 0;
    $biaya_jarak = isset($_POST['biaya_jarak']) ? str_replace('.', '', $_POST['biaya_jarak']) : 0;
    
    // Get actual times
    $waktu_kedatangan_aktual = !empty($_POST['waktu_kedatangan_aktual']) ? $_POST['waktu_kedatangan_aktual'] : null;
    $waktu_kepulangan_aktual = !empty($_POST['waktu_kepulangan_aktual']) ? $_POST['waktu_kepulangan_aktual'] : null;
    $lama_perjalanan_aktual = !empty($_POST['lama_perjalanan_aktual']) ? $_POST['lama_perjalanan_aktual'] : null;
    
    // Hitung total berdasarkan lama perjalanan aktual jika ada
    $lama_perjalanan = $lama_perjalanan_aktual ?? $rincian['lama_perjalanan'];
    
    // Hitung total
    $total_uang_harian = $uang_harian * $lama_perjalanan;
    $total_representatif = $representatif_per_hari * $lama_perjalanan;
    $total_uang_diklat = $uang_diklat * $lama_perjalanan;
    
    // Hitung total biaya keseluruhan
    $total_biaya = $total_uang_harian + $total_representatif + $total_uang_diklat + 
                   $transport_dalam_provinsi + $transport_luar_provinsi + 
                   $biaya_pesawat_berangkat + $biaya_pesawat_pulang + $akomodasi + $biaya_jarak;
    
    // Update query with actual times
    $query = "UPDATE rincian_bimtek_perorangan SET 
              uang_harian_per_hari = ?,
              total_uang_harian = ?,
              representatif_per_hari = ?,
              total_representatif = ?,
              uang_diklat_per_hari = ?,
              total_uang_diklat = ?,
              transport_dalam_provinsi = ?,
              transport_luar_provinsi = ?,
              biaya_pesawat_berangkat = ?,
              biaya_pesawat_pulang = ?,
              akomodasi = ?,
              jarak = ?,
              biaya_jarak = ?,
              total_biaya = ?,
              waktu_kedatangan_aktual = ?,
              waktu_kepulangan_aktual = ?,
              lama_perjalanan_aktual = ?,
              updated_at = CURRENT_TIMESTAMP
              WHERE id_rincian_perorangan = ?";
              
    $stmt = mysqli_prepare($conn, $query);
    mysqli_stmt_bind_param($stmt, "ddddddddddddddssdi", 
        $uang_harian,
        $total_uang_harian,
        $representatif_per_hari,
        $total_representatif,
        $uang_diklat,
        $total_uang_diklat,
        $transport_dalam_provinsi,
        $transport_luar_provinsi,
        $biaya_pesawat_berangkat,
        $biaya_pesawat_pulang,
        $akomodasi,
        $jarak,
        $biaya_jarak,
        $total_biaya,
        $waktu_kedatangan_aktual,
        $waktu_kepulangan_aktual,
        $lama_perjalanan_aktual,
        $id_rincian
    );

    if (mysqli_stmt_execute($stmt)) {
        $_SESSION['alert'] = [
            'type' => 'success',
            'message' => 'Data rincian berhasil diperbarui'
        ];
        header("Location: detail_rincian.php?id=" . $id_surat);
        exit();
    } else {
        $_SESSION['alert'] = [
            'type' => 'error',
            'message' => 'Gagal memperbarui data: ' . mysqli_error($conn)
        ];
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Edit Rincian Perorangan - SPPD</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css" rel="stylesheet">
    <style>
        body {
            background: linear-gradient(135deg, #f6f9fc 0%, #eef2f7 100%);
            min-height: 100vh;
            padding-bottom: 40px;
        }

        .header-wrapper {
            background: linear-gradient(135deg, #4e73df 0%, #224abe 100%);
            padding: 2rem;
            margin-bottom: 2rem;
            color: white;
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.1);
        }

        .card {
            border: none;
            border-radius: 15px;
            box-shadow: 0 0 20px rgba(0, 0, 0, 0.05);
            background: rgba(255, 255, 255, 0.9);
            backdrop-filter: blur(10px);
            transition: transform 0.3s ease, box-shadow 0.3s ease;
        }

        .card:hover {
            transform: translateY(-5px);
            box-shadow: 0 8px 25px rgba(0, 0, 0, 0.1);
        }

        .card-header {
            background: transparent;
            border-bottom: 1px solid rgba(0, 0, 0, 0.05);
            padding: 1.5rem;
        }

        .card-header h5 {
            margin: 0;
            color: #4e73df;
            font-weight: 600;
        }

        .form-label {
            font-weight: 500;
            color: #4a5568;
            margin-bottom: 0.5rem;
        }

        .form-control, .input-group-text {
            border: 1px solid #e2e8f0;
            border-radius: 10px;
            padding: 0.75rem 1rem;
            font-size: 0.95rem;
            transition: all 0.2s ease;
        }

        .form-control:focus {
            border-color: #4e73df;
            box-shadow: 0 0 0 3px rgba(78, 115, 223, 0.1);
        }

        .input-group-text {
            background: #f8fafc;
            color: #4a5568;
        }

        .btn {
            padding: 0.75rem 1.5rem;
            border-radius: 10px;
            font-weight: 500;
            transition: all 0.3s ease;
        }

        .btn-primary {
            background: linear-gradient(135deg, #4e73df 0%, #224abe 100%);
            border: none;
        }

        .btn-primary:hover {
            background: linear-gradient(135deg, #224abe 0%, #1a3891 100%);
            transform: translateY(-2px);
        }

        .btn-secondary {
            background: #f8fafc;
            border: 1px solid #e2e8f0;
            color: #4a5568;
        }

        .btn-secondary:hover {
            background: #edf2f7;
            transform: translateY(-2px);
        }

        .alert {
            border-radius: 10px;
            border: none;
        }

        .breadcrumb {
            margin: 0;
            background: transparent;
        }

        .breadcrumb-item a {
            color: rgba(255, 255, 255, 0.8);
            text-decoration: none;
            transition: color 0.2s ease;
        }

        .breadcrumb-item a:hover {
            color: white;
        }

        .breadcrumb-item.active {
            color: white;
        }

        .info-group {
            background: #f8fafc;
            border-radius: 10px;
            padding: 1rem;
            margin-bottom: 1rem;
        }

        .info-group label {
            color: #718096;
            font-size: 0.875rem;
            margin-bottom: 0.25rem;
        }

        .info-group p {
            color: #2d3748;
            font-weight: 500;
            margin-bottom: 0;
        }
    </style>
</head>
<body>
    <div class="header-wrapper">
        <h2 class="mb-0">Edit Rincian Perorangan</h2>
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb mb-0">
                <li class="breadcrumb-item"><a href="../dashboard.php">Dashboard</a></li>
                <li class="breadcrumb-item"><a href="index.php">Rincian Biaya</a></li>
                <li class="breadcrumb-item"><a href="detail_rincian.php?id=<?= $id_surat ?>">Detail Rincian</a></li>
                <li class="breadcrumb-item active" aria-current="page">Edit Rincian</li>
            </ol>
        </nav>
    </div>

    <div class="container">
        <?php if (isset($rincian)): ?>
            <div class="row">
                <div class="col-md-4 mb-4">
                    <!-- Info Card -->
                    <div class="card">
                        <div class="card-header">
                            <h5><i class="bi bi-info-circle me-2"></i>Informasi</h5>
                        </div>
                        <div class="card-body">
                            <div class="info-group">
                                <label>Nama Pegawai</label>
                                <p><?= htmlspecialchars($rincian['nama_pegawai']) ?></p>
                            </div>
                            <div class="info-group">
                                <label>Jenis Surat</label>
                                <p><?= htmlspecialchars($rincian['jenis_surat']) ?></p>
                            </div>
                            <div class="info-group">
                                <label>Tanggal Berangkat</label>
                                <p><?= date('d/m/Y', strtotime($rincian['tanggal_berangkat'])) ?></p>
                            </div>
                            <div class="info-group">
                                <label>Tanggal Kembali</label>
                                <p><?= date('d/m/Y', strtotime($rincian['tanggal_kembali'])) ?></p>
                            </div>
                            <div class="info-group">
                                <label>Lama Perjalanan</label>
                                <p><?= $rincian['lama_perjalanan'] ?> Hari</p>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-md-8">
                    <!-- Form Card -->
                    <div class="card">
                        <div class="card-header">
                            <h5><i class="bi bi-pencil-square me-2"></i>Form Edit Rincian</h5>
                        </div>
                        <div class="card-body">
                            <form id="formEditRincian" method="POST">
                                <input type="hidden" name="id_rincian" value="<?= $id_rincian ?>">
                                
                                <?php if ($rincian['jenis_surat'] == 'Dalam Daerah Dalam Provinsi'): ?>
                                    <!-- Grup Waktu Aktual -->
                                    <div class="card mb-4">
                                        <div class="card-header bg-light">
                                            <h6 class="mb-0">Waktu Perjalanan</h6>
                                        </div>
                                        <div class="card-body">
                                            <div class="row g-3">
                                                <div class="col-md-6">
                                                    <label class="form-label">Tanggal Kedatangan</label>
                                                    <input type="date" class="form-control" 
                                                           name="waktu_kedatangan_aktual" id="waktu_kedatangan_aktual"
                                                           value="<?= $rincian['waktu_kedatangan_aktual'] ? date('Y-m-d', strtotime($rincian['waktu_kedatangan_aktual'])) : '' ?>"
                                                           min="<?= date('Y-m-d', strtotime($rincian['tanggal_berangkat'])) ?>"
                                                           max="<?= date('Y-m-d', strtotime($rincian['tanggal_kembali'])) ?>"
                                                           onchange="hitungLamaPerjalananReal()">
                                                    <div class="form-text">Sesuai surat tugas: <?= date('d/m/Y', strtotime($rincian['tanggal_berangkat'])) ?></div>
                                                </div>
                                                <div class="col-md-6">
                                                    <label class="form-label">Tanggal Kepulangan</label>
                                                    <input type="date" class="form-control" 
                                                           name="waktu_kepulangan_aktual" id="waktu_kepulangan_aktual"
                                                           value="<?= $rincian['waktu_kepulangan_aktual'] ? date('Y-m-d', strtotime($rincian['waktu_kepulangan_aktual'])) : '' ?>"
                                                           min="<?= date('Y-m-d', strtotime($rincian['tanggal_berangkat'])) ?>"
                                                           max="<?= date('Y-m-d', strtotime($rincian['tanggal_kembali'])) ?>"
                                                           onchange="hitungLamaPerjalananReal()">
                                                    <div class="form-text">Sesuai surat tugas: <?= date('d/m/Y', strtotime($rincian['tanggal_kembali'])) ?></div>
                                                </div>
                                            </div>
                                            <div id="info_perjalanan_real" class="alert alert-info mt-3" style="display:none;">
                                                <span id="lama_perjalanan_real_text"></span>
                                            </div>
                                            <input type="hidden" name="lama_perjalanan_aktual" id="lama_perjalanan_aktual">
                                        </div>
                                    </div>

                                    <!-- Grup Uang Harian/Hari/Hari -->
                                    <div class="card mb-4">
                                        <div class="card-header bg-light">
                                            <h6 class="mb-0">Uang Harian/Hari/Hari</h6>
                                        </div>
                                        <div class="card-body">
                                            <div class="mb-4">
                                                <label class="form-label">Uang Harian/Hari/Hari</label>
                                                <div class="input-group">
                                                    <span class="input-group-text">Rp</span>
                                                    <input type="text" class="form-control money" name="uang_harian" id="uang_harian"
                                                           value="<?= number_format($rincian['uang_harian_per_hari'], 0, ',', '.') ?>" 
                                                           onkeyup="hitungTotalUangHarian()" required>
                                                </div>
                                                <div class="mt-2">
                                                    <?php
                                                    $lama_perjalanan_display = $rincian['lama_perjalanan_aktual'] ?? $rincian['lama_perjalanan'];
                                                    $jenis_durasi = $rincian['lama_perjalanan_aktual'] ? 'aktual' : 'surat tugas';
                                                    ?>
                                                    <small class="text-muted">Dihitung berdasarkan lama perjalanan <?= $jenis_durasi ?>: <?= $lama_perjalanan_display ?> hari</small>
                                                    <div id="perhitungan_uang_harian" class="alert alert-info mt-2">
                                                        Perhitungan: <span id="rincian_uang_harian"></span>
                                                        <br>
                                                        Total: <strong><span id="total_uang_harian"></span></strong>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Grup Transport & Jarak -->
                                    <div class="card mb-4">
                                        <div class="card-header bg-light">
                                            <h6 class="mb-0">Transport & Jarak</h6>
                                        </div>
                                        <div class="card-body">
                                            <div class="row g-3">
                                                <div class="col-md-6">
                                                    <label class="form-label">Transport</label>
                                                    <div class="input-group">
                                                        <span class="input-group-text">Rp</span>
                                                        <input type="text" class="form-control money" name="transport_dalam" 
                                                               value="<?= number_format($rincian['transport_dalam_provinsi'], 0, ',', '.') ?>" required>
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <label class="form-label">Jarak (KM)</label>
                                                    <input type="number" class="form-control" id="jarak" name="jarak" 
                                                           value="<?= $rincian['jarak'] ?>" onchange="hitungBiayaJarak()">
                                                    <small class="text-muted">Biaya per kilometer: Rp 5.000</small>
                                                </div>
                                                <div class="col-12">
                                                    <label class="form-label">Biaya Jarak</label>
                                                    <div class="input-group">
                                                        <span class="input-group-text">Rp</span>
                                                        <input type="text" class="form-control money" id="biaya_jarak" name="biaya_jarak" 
                                                               value="<?= number_format($rincian['biaya_jarak'], 0, ',', '.') ?>" readonly>
                                                    </div>
                                                    <div id="perhitungan_jarak" class="alert alert-info mt-2" style="display:none;">
                                                        Perhitungan: <span id="rincian_jarak"></span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                <?php elseif ($rincian['jenis_surat'] == 'Luar Daerah Dalam Provinsi'): ?>
                                    <!-- Grup Waktu Aktual -->
                                    <div class="card mb-4">
                                        <div class="card-header bg-light">
                                            <h6 class="mb-0">Waktu Perjalanan</h6>
                                        </div>
                                        <div class="card-body">
                                            <div class="row g-3">
                                                <div class="col-md-6">
                                                    <label class="form-label">Tanggal Kedatangan</label>
                                                    <input type="date" class="form-control" 
                                                           name="waktu_kedatangan_aktual" id="waktu_kedatangan_aktual"
                                                           value="<?= $rincian['waktu_kedatangan_aktual'] ? date('Y-m-d', strtotime($rincian['waktu_kedatangan_aktual'])) : '' ?>"
                                                           min="<?= date('Y-m-d', strtotime($rincian['tanggal_berangkat'])) ?>"
                                                           max="<?= date('Y-m-d', strtotime($rincian['tanggal_kembali'])) ?>"
                                                           onchange="hitungLamaPerjalananReal()">
                                                    <div class="form-text">Sesuai surat tugas: <?= date('d/m/Y', strtotime($rincian['tanggal_berangkat'])) ?></div>
                                                </div>
                                                <div class="col-md-6">
                                                    <label class="form-label">Tanggal Kepulangan</label>
                                                    <input type="date" class="form-control" 
                                                           name="waktu_kepulangan_aktual" id="waktu_kepulangan_aktual"
                                                           value="<?= $rincian['waktu_kepulangan_aktual'] ? date('Y-m-d', strtotime($rincian['waktu_kepulangan_aktual'])) : '' ?>"
                                                           min="<?= date('Y-m-d', strtotime($rincian['tanggal_berangkat'])) ?>"
                                                           max="<?= date('Y-m-d', strtotime($rincian['tanggal_kembali'])) ?>"
                                                           onchange="hitungLamaPerjalananReal()">
                                                    <div class="form-text">Sesuai surat tugas: <?= date('d/m/Y', strtotime($rincian['tanggal_kembali'])) ?></div>
                                                </div>
                                            </div>
                                            <div id="info_perjalanan_real" class="alert alert-info mt-3" style="display:none;">
                                                <span id="lama_perjalanan_real_text"></span>
                                            </div>
                                            <input type="hidden" name="lama_perjalanan_aktual" id="lama_perjalanan_aktual">
                                        </div>
                                    </div>

                                    <!-- Grup Uang Harian/Hari -->
                                    <div class="card mb-4">
                                        <div class="card-header bg-light">
                                            <h6 class="mb-0">Uang Harian/Hari</h6>
                                        </div>
                                        <div class="card-body">
                                            <div class="mb-4">
                                                <label class="form-label">Uang Harian/Hari</label>
                                                <div class="input-group">
                                                    <span class="input-group-text">Rp</span>
                                                    <input type="text" class="form-control money" name="uang_harian" id="uang_harian"
                                                           value="<?= number_format($rincian['uang_harian_per_hari'], 0, ',', '.') ?>" 
                                                           onkeyup="hitungTotalUangHarian()" required>
                                                </div>
                                                <div class="mt-2">
                                                    <?php
                                                    $lama_perjalanan_display = $rincian['lama_perjalanan_aktual'] ?? $rincian['lama_perjalanan'];
                                                    $jenis_durasi = $rincian['lama_perjalanan_aktual'] ? 'aktual' : 'surat tugas';
                                                    ?>
                                                    <small class="text-muted">Dihitung berdasarkan lama perjalanan <?= $jenis_durasi ?>: <?= $lama_perjalanan_display ?> hari</small>
                                                    <div id="perhitungan_uang_harian" class="alert alert-info mt-2">
                                                        Perhitungan: <span id="rincian_uang_harian"></span>
                                                        <br>
                                                        Total: <strong><span id="total_uang_harian"></span></strong>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <?php if ($show_representatif): ?>
                                    <!-- Grup Representatif -->
                                    <div class="card mb-4">
                                        <div class="card-header bg-light">
                                            <h6 class="mb-0">Uang Representatif</h6>
                                        </div>
                                        <div class="card-body">
                                            <div class="mb-4">
                                                <label class="form-label">Representatif per Hari</label>
                                                <div class="input-group">
                                                    <span class="input-group-text">Rp</span>
                                                    <input type="text" class="form-control money" name="representatif_per_hari" id="representatif_per_hari"
                                                           value="<?= number_format($rincian['representatif_per_hari'], 0, ',', '.') ?>" 
                                                           onkeyup="hitungTotalRepresentatif()" required>
                                                </div>
                                                <div class="mt-2">
                                                    <?php
                                                    $lama_perjalanan_display = $rincian['lama_perjalanan_aktual'] ?? $rincian['lama_perjalanan'];
                                                    $jenis_durasi = $rincian['lama_perjalanan_aktual'] ? 'aktual' : 'surat tugas';
                                                    ?>
                                                    <small class="text-muted">Dihitung berdasarkan lama perjalanan <?= $jenis_durasi ?>: <?= $lama_perjalanan_display ?> hari</small>
                                                    <div id="perhitungan_representatif" class="alert alert-info mt-2">
                                                        Perhitungan: <span id="rincian_representatif"></span>
                                                        <br>
                                                        Total: <strong><span id="total_representatif"></span></strong>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <?php endif; ?>

                                    <!-- Grup Transport & Akomodasi -->
                                    <div class="card mb-4">
                                        <div class="card-header bg-light">
                                            <h6 class="mb-0">Transport & Akomodasi</h6>
                                        </div>
                                        <div class="card-body">
                                            <div class="row g-3">
                                                <div class="col-md-6">
                                                    <label class="form-label">Transport</label>
                                                    <div class="input-group">
                                                        <span class="input-group-text">Rp</span>
                                                        <input type="text" class="form-control money" name="transport_dalam" 
                                                               value="<?= number_format($rincian['transport_dalam_provinsi'], 0, ',', '.') ?>" required>
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <label class="form-label">Akomodasi Hotel</label>
                                                    <div class="input-group">
                                                        <span class="input-group-text">Rp</span>
                                                        <input type="text" class="form-control money" name="akomodasi" 
                                                               value="<?= number_format($rincian['akomodasi'], 0, ',', '.') ?>" required>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                <?php else: // Luar Daerah Luar Provinsi ?>
                                    <!-- Grup Waktu Aktual -->
                                    <div class="card mb-4">
                                        <div class="card-header bg-light">
                                            <h6 class="mb-0">Waktu Perjalanan</h6>
                                        </div>
                                        <div class="card-body">
                                            <div class="row g-3">
                                                <div class="col-md-6">
                                                    <label class="form-label">Tanggal Kedatangan</label>
                                                    <input type="date" class="form-control" 
                                                           name="waktu_kedatangan_aktual" id="waktu_kedatangan_aktual"
                                                           value="<?= $rincian['waktu_kedatangan_aktual'] ? date('Y-m-d', strtotime($rincian['waktu_kedatangan_aktual'])) : '' ?>"
                                                           min="<?= date('Y-m-d', strtotime($rincian['tanggal_berangkat'])) ?>"
                                                           max="<?= date('Y-m-d', strtotime($rincian['tanggal_kembali'])) ?>"
                                                           onchange="hitungLamaPerjalananReal()">
                                                    <div class="form-text">Sesuai surat tugas: <?= date('d/m/Y', strtotime($rincian['tanggal_berangkat'])) ?></div>
                                                </div>
                                                <div class="col-md-6">
                                                    <label class="form-label">Tanggal Kepulangan</label>
                                                    <input type="date" class="form-control" 
                                                           name="waktu_kepulangan_aktual" id="waktu_kepulangan_aktual"
                                                           value="<?= $rincian['waktu_kepulangan_aktual'] ? date('Y-m-d', strtotime($rincian['waktu_kepulangan_aktual'])) : '' ?>"
                                                           min="<?= date('Y-m-d', strtotime($rincian['tanggal_berangkat'])) ?>"
                                                           max="<?= date('Y-m-d', strtotime($rincian['tanggal_kembali'])) ?>"
                                                           onchange="hitungLamaPerjalananReal()">
                                                    <div class="form-text">Sesuai surat tugas: <?= date('d/m/Y', strtotime($rincian['tanggal_kembali'])) ?></div>
                                                </div>
                                            </div>
                                            <div id="info_perjalanan_real" class="alert alert-info mt-3" style="display:none;">
                                                <span id="lama_perjalanan_real_text"></span>
                                            </div>
                                            <input type="hidden" name="lama_perjalanan_aktual" id="lama_perjalanan_aktual">
                                        </div>
                                    </div>

                                    <!-- Grup Uang Harian/Hari -->
                                    <div class="card mb-4">
                                        <div class="card-header bg-light">
                                            <h6 class="mb-0">Uang Harian/Hari</h6>
                                        </div>
                                        <div class="card-body">
                                            <div class="mb-4">
                                                <label class="form-label">Uang Harian/Hari</label>
                                                <div class="input-group">
                                                    <span class="input-group-text">Rp</span>
                                                    <input type="text" class="form-control money" name="uang_harian" id="uang_harian"
                                                           value="<?= number_format($rincian['uang_harian_per_hari'], 0, ',', '.') ?>" 
                                                           onkeyup="hitungTotalUangHarian()" required>
                                                </div>
                                                <div class="mt-2">
                                                    <?php
                                                    $lama_perjalanan_display = $rincian['lama_perjalanan_aktual'] ?? $rincian['lama_perjalanan'];
                                                    $jenis_durasi = $rincian['lama_perjalanan_aktual'] ? 'aktual' : 'surat tugas';
                                                    ?>
                                                    <small class="text-muted">Dihitung berdasarkan lama perjalanan <?= $jenis_durasi ?>: <?= $lama_perjalanan_display ?> hari</small>
                                                    <div id="perhitungan_uang_harian" class="alert alert-info mt-2">
                                                        Perhitungan: <span id="rincian_uang_harian"></span>
                                                        <br>
                                                        Total: <strong><span id="total_uang_harian"></span></strong>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <?php if ($show_representatif): ?>
                                    <!-- Grup Representatif -->
                                    <div class="card mb-4">
                                        <div class="card-header bg-light">
                                            <h6 class="mb-0">Uang Representatif</h6>
                                        </div>
                                        <div class="card-body">
                                            <div class="mb-4">
                                                <label class="form-label">Representatif per Hari</label>
                                                <div class="input-group">
                                                    <span class="input-group-text">Rp</span>
                                                    <input type="text" class="form-control money" name="representatif_per_hari" id="representatif_per_hari"
                                                           value="<?= number_format($rincian['representatif_per_hari'], 0, ',', '.') ?>" 
                                                           onkeyup="hitungTotalRepresentatif()" required>
                                                </div>
                                                <div class="mt-2">
                                                    <?php
                                                    $lama_perjalanan_display = $rincian['lama_perjalanan_aktual'] ?? $rincian['lama_perjalanan'];
                                                    $jenis_durasi = $rincian['lama_perjalanan_aktual'] ? 'aktual' : 'surat tugas';
                                                    ?>
                                                    <small class="text-muted">Dihitung berdasarkan lama perjalanan <?= $jenis_durasi ?>: <?= $lama_perjalanan_display ?> hari</small>
                                                    <div id="perhitungan_representatif" class="alert alert-info mt-2">
                                                        Perhitungan: <span id="rincian_representatif"></span>
                                                        <br>
                                                        Total: <strong><span id="total_representatif"></span></strong>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <?php endif; ?>

                                    <!-- Grup Transport -->
                                    <div class="card mb-4">
                                        <div class="card-header bg-light">
                                            <h6 class="mb-0">Transport</h6>
                                        </div>
                                        <div class="card-body">
                                            <div class="row g-3">
                                                <div class="col-md-6">
                                                    <label class="form-label">Transport Dalam Provinsi</label>
                                                    <div class="input-group">
                                                        <span class="input-group-text">Rp</span>
                                                        <input type="text" class="form-control money" name="transport_dalam" 
                                                               value="<?= number_format($rincian['transport_dalam_provinsi'], 0, ',', '.') ?>" required>
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <label class="form-label">Transport Luar Provinsi</label>
                                                    <div class="input-group">
                                                        <span class="input-group-text">Rp</span>
                                                        <input type="text" class="form-control money" name="transport_luar" 
                                                               value="<?= number_format($rincian['transport_luar_provinsi'], 0, ',', '.') ?>" required>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Grup Pesawat -->
                                    <div class="card mb-4">
                                        <div class="card-header bg-light">
                                            <h6 class="mb-0">Biaya Pesawat</h6>
                                        </div>
                                        <div class="card-body">
                                            <div class="row g-3">
                                                <div class="col-md-6">
                                                    <label class="form-label">Pesawat Berangkat</label>
                                                    <div class="input-group">
                                                        <span class="input-group-text">Rp</span>
                                                        <input type="text" class="form-control money" name="pesawat_berangkat" 
                                                               value="<?= number_format($rincian['biaya_pesawat_berangkat'], 0, ',', '.') ?>" required>
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <label class="form-label">Pesawat Kembali</label>
                                                    <div class="input-group">
                                                        <span class="input-group-text">Rp</span>
                                                        <input type="text" class="form-control money" name="pesawat_kembali" 
                                                               value="<?= number_format($rincian['biaya_pesawat_pulang'], 0, ',', '.') ?>" required>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Grup Akomodasi -->
                                    <div class="card mb-4">
                                        <div class="card-header bg-light">
                                            <h6 class="mb-0">Akomodasi</h6>
                                        </div>
                                        <div class="card-body">
                                            <div class="mb-4">
                                                <label class="form-label">Akomodasi Hotel</label>
                                                <div class="input-group">
                                                    <span class="input-group-text">Rp</span>
                                                    <input type="text" class="form-control money" name="akomodasi" 
                                                           value="<?= number_format($rincian['akomodasi'], 0, ',', '.') ?>" required>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                <?php endif; ?>

                                <!-- Buttons -->
                                <div class="d-flex justify-content-end gap-2 mt-4">
                                    <a href="detail_rincian.php?id=<?= $id_surat ?>" class="btn btn-secondary">
                                        <i class="bi bi-arrow-left me-2"></i>Kembali
                                    </a>
                                    <button type="submit" class="btn btn-primary">
                                        <i class="bi bi-save me-2"></i>Simpan Perubahan
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        <?php else: ?>
            <div class="alert alert-danger">
                <i class="bi bi-exclamation-triangle me-2"></i>Data rincian tidak ditemukan.
            </div>
        <?php endif; ?>
    </div>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script>
    // Format input uang
    $('.money').on('input', function() {
        let value = $(this).val().replace(/[^\d]/g, '');
        $(this).val(new Intl.NumberFormat('id-ID').format(value));
    });

    // Fungsi format rupiah
    function formatRupiah(angka) {
        if (!angka) return '0';
        return new Intl.NumberFormat('id-ID').format(angka);
    }

    // Fungsi untuk menghitung lama perjalanan real
    function hitungLamaPerjalananReal() {
        const kedatangan = new Date($('#waktu_kedatangan_aktual').val());
        const kepulangan = new Date($('#waktu_kepulangan_aktual').val());
        
        if (kedatangan && kepulangan && kedatangan <= kepulangan) {
            // Tambah 1 hari karena perhitungan hari inklusif (termasuk hari kedatangan dan kepulangan)
            const diffTime = Math.abs(kepulangan - kedatangan);
            const diffDays = (diffTime / (1000 * 60 * 60 * 24)) + 1;
            
            // Pembulatan ke atas untuk hari penuh
            const lamaPerjalananReal = Math.ceil(diffDays);
            
            $('#lama_perjalanan_aktual').val(lamaPerjalananReal);
            $('#info_perjalanan_real')
                .show()
                .html(`<strong>Lama perjalanan:</strong> ${lamaPerjalananReal} hari<br>
                       <small class="text-muted">* Perhitungan uang harian dan representatif akan disesuaikan</small>`);
            
            // Hitung ulang uang harian dan representatif dengan lama perjalanan aktual
            hitungTotalUangHarian(lamaPerjalananReal);
            hitungTotalRepresentatif(lamaPerjalananReal);
            
            // Update text di bawah input uang harian
            $('.text-muted:contains("Dihitung berdasarkan")').text(`Dihitung berdasarkan lama perjalanan aktual: ${lamaPerjalananReal} hari`);
        } else {
            $('#info_perjalanan_real').hide();
            // Reset ke lama perjalanan surat tugas jika tanggal tidak valid
            const lamaSuratTugas = <?= $rincian['lama_perjalanan'] ?>;
            hitungTotalUangHarian(lamaSuratTugas);
            hitungTotalRepresentatif(lamaSuratTugas);
            $('.text-muted:contains("Dihitung berdasarkan")').text(`Dihitung berdasarkan lama perjalanan surat tugas: ${lamaSuratTugas} hari`);
        }
    }

    // Tambahkan event listener untuk perubahan tanggal
    $('#waktu_kedatangan_aktual, #waktu_kepulangan_aktual').on('change', function() {
        hitungLamaPerjalananReal();
    });

    // Fungsi untuk menghitung total uang harian
    function hitungTotalUangHarian(lamaPerjalananReal = null) {
        let perHari = parseInt($('#uang_harian').val().replace(/[^\d]/g, '') || 0);
        let lamaPerjalanan;
        
        if (lamaPerjalananReal !== null) {
            lamaPerjalanan = lamaPerjalananReal;
        } else {
            <?php if ($rincian['lama_perjalanan_aktual']): ?>
                lamaPerjalanan = <?= $rincian['lama_perjalanan_aktual'] ?>;
            <?php else: ?>
            lamaPerjalanan = <?= $rincian['lama_perjalanan'] ?>;
            <?php endif; ?>
        }
        
        let total = perHari * lamaPerjalanan;
        
        // Tampilkan perhitungan
        $('#rincian_uang_harian').html(
            `${formatRupiah(perHari)} × ${lamaPerjalanan} hari ` +
            (lamaPerjalananReal !== null ? '(berdasarkan waktu aktual)' : '')
        );
        $('#total_uang_harian').html('Rp ' + formatRupiah(total));
    }

    // Fungsi untuk menghitung total representatif
    function hitungTotalRepresentatif(lamaPerjalananReal = null) {
        let perHari = parseInt($('#representatif_per_hari').val().replace(/[^\d]/g, '') || 0);
        let lamaPerjalanan;
        
        if (lamaPerjalananReal !== null) {
            lamaPerjalanan = lamaPerjalananReal;
        } else {
            <?php if ($rincian['lama_perjalanan_aktual']): ?>
                lamaPerjalanan = <?= $rincian['lama_perjalanan_aktual'] ?>;
            <?php else: ?>
                lamaPerjalanan = <?= $rincian['lama_perjalanan'] ?>;
            <?php endif; ?>
        }
        
        let total = perHari * lamaPerjalanan;
        
        // Tampilkan perhitungan
        $('#rincian_representatif').html(
            `${formatRupiah(perHari)} × ${lamaPerjalanan} hari ` +
            (lamaPerjalananReal !== null ? '(berdasarkan waktu aktual)' : '')
        );
        $('#total_representatif').html('Rp ' + formatRupiah(total));
        $('#total_representatif_input').val(total);

        // Update text informasi lama perjalanan
        if (lamaPerjalananReal !== null) {
            $('#representatif_per_hari').closest('.card').find('.text-muted:contains("Dihitung berdasarkan")')
                .text(`Dihitung berdasarkan lama perjalanan aktual: ${lamaPerjalanan} hari`);
        }
    }

    // Tambahkan validasi tanggal
    function validateDates() {
        const kedatangan = document.getElementById('waktu_kedatangan_aktual');
        const kepulangan = document.getElementById('waktu_kepulangan_aktual');
        const minDate = '<?= date('Y-m-d', strtotime($rincian['tanggal_berangkat'])) ?>';
        const maxDate = '<?= date('Y-m-d', strtotime($rincian['tanggal_kembali'])) ?>';

        // Validasi tanggal kedatangan
        kedatangan.addEventListener('change', function() {
            if (this.value < minDate) {
                alert('Tanggal kedatangan tidak boleh sebelum tanggal berangkat surat tugas');
                this.value = minDate;
            }
            if (this.value > maxDate) {
                alert('Tanggal kedatangan tidak boleh melebihi tanggal kembali surat tugas');
                this.value = maxDate;
            }
            if (kepulangan.value && this.value > kepulangan.value) {
                alert('Tanggal kedatangan tidak boleh lebih besar dari tanggal kepulangan');
                this.value = kepulangan.value;
            }
            hitungLamaPerjalananReal();
        });

        // Validasi tanggal kepulangan
        kepulangan.addEventListener('change', function() {
            if (this.value < minDate) {
                alert('Tanggal kepulangan tidak boleh sebelum tanggal berangkat surat tugas');
                this.value = minDate;
            }
            if (this.value > maxDate) {
                alert('Tanggal kepulangan tidak boleh melebihi tanggal kembali surat tugas');
                this.value = maxDate;
            }
            if (kedatangan.value && this.value < kedatangan.value) {
                alert('Tanggal kepulangan tidak boleh lebih kecil dari tanggal kedatangan');
                this.value = kedatangan.value;
            }
            hitungLamaPerjalananReal();
        });
    }

    // Initialize on page load
    $(document).ready(function() {
        hitungTotalUangHarian();
        hitungTotalRepresentatif();
        validateDates();
        
        // Check if we have actual dates
        if ($('#waktu_kedatangan_aktual').val() && $('#waktu_kepulangan_aktual').val()) {
            hitungLamaPerjalananReal();
        }
    });

    // Fungsi untuk menghitung biaya jarak
    function hitungBiayaJarak() {
        const jarak = parseInt($('#jarak').val() || 0);
        const biayaPerKm = 5000; // Rp 5.000 per kilometer
        const totalBiaya = jarak * biayaPerKm;
        
        // Update input biaya jarak
        $('#biaya_jarak').val(new Intl.NumberFormat('id-ID').format(totalBiaya));
        
        // Tampilkan perhitungan
        $('#perhitungan_jarak').show();
        $('#rincian_jarak').html(
            jarak + ' KM × Rp ' + new Intl.NumberFormat('id-ID').format(biayaPerKm) + 
            ' = Rp ' + new Intl.NumberFormat('id-ID').format(totalBiaya)
        );
    }
    </script>
</body>
</html>