<?php
session_start();
require_once '../config/database.php';
require_once '../config/config.php';

// Cek apakah user sudah login
if (!isset($_SESSION['user_id'])) {
    header("Location: ../auth.php");
    exit();
}

// Cek apakah ada parameter id
if (!isset($_GET['id'])) {
    $_SESSION['error'] = "ID Surat tidak ditemukan.";
    header("Location: index.php");
    exit();
}

$id_surat = $_GET['id'];

try {
    // Mulai transaksi
    $conn->begin_transaction();

    // Hapus semua rincian biaya riil untuk surat ini
    $query = "DELETE FROM rincian_biaya_riil WHERE id_surat = ?";
    $stmt = $conn->prepare($query);
    $stmt->bind_param("i", $id_surat);
    $stmt->execute();

    // Commit transaksi
    $conn->commit();

    $_SESSION['success'] = "Rincian biaya riil berhasil dihapus.";
    header("Location: detail_rincian.php?id=" . $id_surat);
    exit();

} catch (Exception $e) {
    // Rollback jika terjadi error
    $conn->rollback();
    
    $_SESSION['error'] = "Terjadi kesalahan: " . $e->getMessage();
    header("Location: detail_rincian.php?id=" . $id_surat);
    exit();
}
?> 