<?php
session_start();
require_once '../config/config.php';
require_once '../config/database.php';

// Cek login
if (!isset($_SESSION['user_id'])) {
    header("Location: ../login.php");
    exit();
}

// Get user's bidang
$user_bidang = '';
// Fetch bidang for any logged-in user
if (isset($_SESSION['user_id'])) {
    $user_id = $_SESSION['user_id'];
    $query_user = "SELECT bidang FROM users WHERE id = ?";
    $stmt = mysqli_prepare($conn, $query_user);
    if ($stmt) {
        mysqli_stmt_bind_param($stmt, "i", $user_id);
        mysqli_stmt_execute($stmt);
        $result_user = mysqli_stmt_get_result($stmt);
        if ($user_data = mysqli_fetch_assoc($result_user)) {
            $user_bidang = $user_data['bidang'];
        }
        mysqli_stmt_close($stmt);
    } else {
        // Handle error if statement preparation fails
        error_log("Error preparing user bidang query: " . mysqli_error($conn));
    }
}

// Base query focusing on rincian_bimtek_perorangan
$query = "SELECT 
    p.nama_pegawai,
    p.nip,
    p.golongan,
    p.jabatan,
    st.id_surat,
    st.no_sppd,
    st.jenis_surat,
    st.no_surat,
    st.maksud,
    st.tujuan,
    st.tempat_kegiatan,
    rbp.*,
    u.username as pembuat,
    u.bidang as bidang_pembuat,
    st.created_at
FROM rincian_bimtek_perorangan rbp
JOIN pegawai p ON rbp.id_pegawai = p.id_pegawai
JOIN surat_tugas st ON rbp.id_surat = st.id_surat
JOIN users u ON st.created_by = u.id";

// Add WHERE clause based on user level
$user_level = $_SESSION['level'] ?? ''; // Get user level, default to empty if not set

if ($user_level === 'admin' || $user_level === 'bendahara') {
    // Admin and Bendahara see all data
    $query .= " ORDER BY p.nama_pegawai ASC, st.tanggal_surat DESC";
    $result = mysqli_query($conn, $query);
} else if (!empty($user_bidang)) {
    // Pimpinan, admin_sppd, and others with a specific bidang see data for their bidang
    $query .= " WHERE u.bidang = ?";
    $query .= " ORDER BY p.nama_pegawai ASC, st.tanggal_surat DESC";
    
    $stmt = mysqli_prepare($conn, $query);
    if ($stmt) {
        mysqli_stmt_bind_param($stmt, "s", $user_bidang);
        mysqli_stmt_execute($stmt);
        $result = mysqli_stmt_get_result($stmt);
        mysqli_stmt_close($stmt);
    } else {
        // Handle error if statement preparation fails
        error_log("Error preparing filtered query: " . mysqli_error($conn));
        $result = false; // Set result to false to indicate query failure
    }
} else {
    // Handle cases for other levels without a specific bidang or if $user_bidang is empty unexpectedly
    // For now, this will result in no data if no user_bidang is found for filtering levels.
    // You might want to adjust this logic based on how other levels should behave.
    $query .= " ORDER BY p.nama_pegawai ASC, st.tanggal_surat DESC"; // Still need ORDER BY even if no data
    $result = mysqli_query($conn, $query . " WHERE 1=0"); // Execute query that returns no rows
}

if (!$result) {
    die("Error in query execution or preparation: " . mysqli_error($conn) . (isset($conn) ? " " . mysqli_error($conn) : ""));
}

// Fungsi untuk membersihkan output HTML
function cleanOutput($str) {
    return str_replace(['<br />', '<b>Deprecated</b>:', 'htmlspecialchars(): Pass'], '', $str);
}

// Fungsi untuk handle NULL pada htmlspecialchars
function safeEcho($str) {
    if ($str === null || $str === '') return '-';
    $str = preg_replace('/<br \/><b>Deprecated<\/b>:.*?Pass/i', 'tidak ada data', $str);
    return htmlspecialchars($str, ENT_QUOTES, 'UTF-8');
}

// Fungsi untuk format angka ke rupiah dengan penanganan NULL
function formatRupiah($angka) {
    if ($angka === null || $angka === '') return '-';
    return 'Rp ' . number_format((float)$angka, 0, ',', '.');
}

// Fungsi untuk format tanggal Indonesia
function tanggal_indo($tanggal) {
    if (empty($tanggal) || $tanggal == '0000-00-00') return '-';
    $bulan = array(
        1 => 'Januari', 'Februari', 'Maret', 'April', 'Mei', 'Juni',
        'Juli', 'Agustus', 'September', 'Oktober', 'November', 'Desember'
    );
    $split = explode('-', $tanggal);
    return $split[2] . ' ' . $bulan[(int)$split[1]] . ' ' . $split[0];
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Rincian Biaya Perorangan - SPPD</title>
    <link rel="stylesheet" href="../assets/css/bootstrap.min.css">
    <link rel="stylesheet" href="../assets/css/bootstrap-icons.min.css">
    <style>
        body {
            padding: 0 !important;
            margin: 0 !important;
            overflow-x: hidden;
            background-color: #f8f9fc;
        }

        .main-content {
            padding: 20px;
            margin: 0;
            width: 100%;
            min-height: 100vh;
            background: #f8f9fc;
        }

        .container-fluid {
            padding: 0;
            margin: 0;
            width: 100%;
            max-width: 100%;
            position: relative;
            z-index: 1;
        }

        /* Header Navigation Styles */
        .header-nav {
            background: var(--primary-gradient, linear-gradient(135deg, #0ea5e9 0%, #2dd4bf 100%));
            padding: 1.5rem 2rem;
            margin-bottom: 2rem;
            border-radius: 15px;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
        }

        .nav-wrapper {
            display: flex;
            flex-direction: column;
            gap: 1.5rem;
        }

        .nav-title {
            color: white;
        }

        .nav-title h1 {
            font-size: 1.75rem;
            margin: 0;
            font-weight: 600;
        }

        .nav-title p {
            margin: 0.25rem 0 0 0;
            opacity: 0.8;
            font-size: 1rem;
        }

        .nav-links {
            display: flex;
            flex-wrap: wrap;
            gap: 0.5rem;
            padding-top: 1rem;
            border-top: 1px solid rgba(255, 255, 255, 0.1);
        }

        .nav-link {
            display: flex;
            align-items: center;
            gap: 0.5rem;
            padding: 0.5rem 1rem;
            color: rgba(255, 255, 255, 0.9);
            text-decoration: none;
            border-radius: 8px;
            background: rgba(255, 255, 255, 0.1);
            transition: all 0.2s ease;
            font-size: 0.9rem;
        }

        .nav-link:hover {
            background: rgba(255, 255, 255, 0.2);
            transform: translateY(-1px);
            color: white;
        }

        .nav-link.active {
            background: white;
            color: #0ea5e9;
            font-weight: 500;
        }

        .nav-link i {
            font-size: 1.1rem;
        }

        /* Responsive Adjustments */
        @media (max-width: 1200px) {
            .nav-link {
                padding: 0.4rem 0.8rem;
                font-size: 0.85rem;
            }
        }

        @media (max-width: 992px) {
            .header-nav {
                padding: 1.25rem;
            }

            .nav-title h1 {
                font-size: 1.5rem;
            }

            .nav-links {
                gap: 0.35rem;
            }
        }

        @media (max-width: 768px) {
            .nav-wrapper {
                gap: 1rem;
            }

            .nav-links {
                flex-direction: column;
                width: 100%;
            }

            .nav-link {
                width: 100%;
                justify-content: flex-start;
            }
        }

        .card {
            border: none;
            border-radius: 15px;
            box-shadow: 0 0 15px rgba(0,0,0,0.05);
            margin: 0 20px;
            overflow: hidden;
        }

        .card-header {
            background: linear-gradient(135deg, #0ea5e9 0%, #2dd4bf 100%);
            color: white;
            padding: 1.5rem;
            border-radius: 15px 15px 0 0 !important;
            border: none;
        }

        .card-header .btn-success {
            background-color: #22c55e;
            border: none;
            padding: 8px 16px;
            border-radius: 8px;
            transition: all 0.3s ease;
        }

        .card-header .btn-success:hover {
            background-color: #16a34a;
            transform: translateY(-2px);
            box-shadow: 0 4px 6px rgba(0,0,0,0.1);
        }

        .table thead th {
            background: rgba(14, 165, 233, 0.1);
            color: #0ea5e9;
            font-weight: 600;
            border: none;
            padding: 12px 8px;
            vertical-align: middle;
            white-space: nowrap;
        }

        .table tbody td {
            padding: 12px 8px;
            vertical-align: middle;
            border-bottom: 1px solid #f1f5f9;
        }

        .table tbody tr:hover {
            background-color: rgba(14, 165, 233, 0.05);
        }

        .date-badge {
            background-color: rgba(45, 212, 191, 0.1);
            color: #2dd4bf;
            padding: 4px 8px;
            border-radius: 6px;
            font-size: 0.85rem;
            white-space: nowrap;
            display: inline-block;
        }

        .hari-badge {
            background-color: rgba(14, 165, 233, 0.1);
            color: #0ea5e9;
            padding: 4px 8px;
            border-radius: 6px;
            font-size: 0.85rem;
            white-space: nowrap;
            display: inline-block;
        }

        .text-end {
            font-family: 'Roboto Mono', monospace;
            font-size: 0.9rem;
        }

        .table-total td {
            background-color: #0ea5e9 !important;
            color: white !important;
            font-weight: bold;
            padding: 15px 8px !important;
        }

        .table-total .text-end {
            color: white !important;
            font-size: 1.1rem !important;
        }

        .creator-info {
            background-color: rgba(14, 165, 233, 0.1);
            padding: 4px 8px;
            border-radius: 6px;
            font-size: 0.85rem;
        }

        .dataTables_wrapper .dataTables_filter input {
            border: 1px solid #e2e8f0;
            border-radius: 8px;
            padding: 6px 12px;
            margin-left: 8px;
        }

        .dataTables_wrapper .dataTables_length select {
            border: 1px solid #e2e8f0;
            border-radius: 8px;
            padding: 6px 12px;
        }

        .dataTables_wrapper .dataTables_paginate .paginate_button {
            border-radius: 6px;
            padding: 6px 12px;
            margin: 0 2px;
        }

        .dataTables_wrapper .dataTables_paginate .paginate_button.current {
            background: #0ea5e9 !important;
            border-color: #0ea5e9 !important;
            color: white !important;
        }

        /* Atur proporsi lebar kolom */
        .col-no { width: 3%; }
        .col-nama { width: 12%; }
        .col-nip { width: 8%; }
        .col-golongan { width: 6%; }
        .col-jabatan { width: 12%; }
        .col-surat { width: 8%; }
        .col-sppd { width: 8%; }
        .col-maksud { width: 15%; }
        .col-tujuan { width: 10%; }
        .col-tempat { width: 10%; }
        .col-tanggal { width: 8%; }
        .col-hari { width: 5%; }
        .col-keuangan { width: 100px !important; min-width: 100px !important; }
        .col-pembuat { width: 8%; }
        .col-bidang { width: 8%; }

        .text-wrap {
            white-space: normal !important;
            word-wrap: break-word !important;
            max-width: 250px;
            min-width: 200px;
            padding: 8px;
            position: relative;
        }

        .text-wrap:hover {
            background-color: rgba(14, 165, 233, 0.05);
            cursor: pointer;
        }

        /* Hapus style untuk text-truncate-2 yang membatasi tampilan */
        .text-truncate-2 {
            display: block;
            white-space: normal !important;
            word-wrap: break-word !important;
            max-width: 250px;
            min-width: 200px;
            padding: 8px;
            position: relative;
        }

        .text-truncate-2:hover {
            background-color: rgba(14, 165, 233, 0.05);
            cursor: pointer;
        }

        /* Tambahkan style untuk expanded state */
        .text-wrap.expanded,
        .text-truncate-2.expanded {
            max-width: none;
            position: relative;
            z-index: 1000;
            background: white;
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
            border-radius: 4px;
        }

        .expanded-row {
            background-color: rgba(14, 165, 233, 0.05) !important;
        }

        .expanded-cell {
            white-space: normal !important;
            word-wrap: break-word !important;
            max-width: none !important;
            width: 100% !important;
        }

        .table td, .table th {
            position: relative;
            background: #fff;
            z-index: 1;
        }

        .text-wrap:hover, .text-truncate-2:hover {
            background-color: rgba(14, 165, 233, 0.05);
        }

        .table-responsive {
            position: relative;
            z-index: 1;
            background: #fff;
            overflow-x: auto;
            -webkit-overflow-scrolling: touch;
        }

        .btn-view {
            background-color: rgba(14, 165, 233, 0.1);
            color: #0ea5e9;
            border: 1px solid rgba(14, 165, 233, 0.2);
            transition: all 0.3s ease;
            padding: 4px 8px;
            margin: 0;
        }

        .btn-view:hover {
            background-color: #0ea5e9;
            color: white;
            transform: translateY(-2px);
        }

        .creator-info {
            font-size: 0.85rem;
            color: #6b7280;
            line-height: 1.2;
        }

        /* DataTables custom styling */
        .dataTables_wrapper .dataTables_length, 
        .dataTables_wrapper .dataTables_filter {
            padding: 8px;
        }

        .dataTables_wrapper .dataTables_info, 
        .dataTables_wrapper .dataTables_paginate {
            padding: 8px;
        }

        .dataTables_wrapper .dataTables_filter input {
            border: 1px solid #e2e8f0;
            border-radius: 4px;
            padding: 4px 8px;
        }

        .dataTables_wrapper .dataTables_length select {
            border: 1px solid #e2e8f0;
            border-radius: 4px;
            padding: 4px 8px;
        }

        /* Menghilangkan border pada baris terakhir */
        .table tbody tr:last-child td {
            border-bottom: none;
        }

        /* Hapus overlay atau background yang mungkin menghalangi */
        .table-hover tbody tr:hover {
            background-color: rgba(14, 165, 233, 0.03) !important;
            position: relative;
            z-index: 2;
        }

        /* Pastikan tidak ada shadow atau overlay yang menghalangi */
        .card::before,
        .card::after,
        .table::before,
        .table::after {
            display: none !important;
        }

        /* Hapus efek hover yang mungkin menghalangi */
        .table tbody tr {
            transition: none !important;
        }

        /* Pastikan cell dapat diklik */
        .table td, 
        .table th {
            position: relative;
            z-index: 2;
        }

        .text-end {
            text-align: right !important;
        }

        /* Styling untuk angka rupiah */
        .table td.text-end {
            font-family: monospace;
            font-size: 0.9rem;
            padding-right: 10px !important;
        }

        /* Tambahkan shadow saat di-scroll */
        .table-responsive {
            background: none !important;
            background-attachment: unset !important;
            background-image: none !important;
        }

      

        .font-weight-bold {
            font-weight: bold !important;
        }
        
        .bg-light {
            background-color: rgba(14, 165, 233, 0.05) !important;
        }
        
        .table td.text-end.font-weight-bold {
            font-family: monospace;
            font-size: 1rem;
            color: #0ea5e9;
        }

        .table-total {
            border-top: 2px solid #0ea5e9 !important;
        }
        
        .table-total td {
            padding: 15px 8px !important;
            font-size: 1.1rem !important;
        }
        
        .fw-bold {
            font-weight: bold !important;
        }
        
        .bg-primary {
            background-color: #0ea5e9 !important;
        }
        
        .text-white {
            color: white !important;
        }
        
        .table-total td.text-end {
            font-family: monospace;
        }

        .text-wrap, .text-truncate-2 {
            cursor: pointer;
        }
        .text-wrap:hover, .text-truncate-2:hover {
            background-color: rgba(14, 165, 233, 0.05);
        }
        #textModal .modal-body {
            max-height: 80vh;
            overflow-y: auto;
            white-space: pre-wrap;
            word-wrap: break-word;
        }
        #fullText {
            margin: 0;
            padding: 10px;
            background: rgba(14, 165, 233, 0.05);
            border-radius: 4px;
        }

        /* Tambahkan clear fix untuk menangani overflow */
        .clearfix::after {
            content: "";
            clear: both;
            display: table;
        }

        /* Pastikan DataTables wrapper tidak menghalangi */
        .dataTables_wrapper {
            overflow: visible !important;
        }
    </style>
</head>
<body>
    <div class="main-content">
        <div class="container-fluid">
            <!-- Header Navigation -->
            <div class="header-nav">
                <div class="nav-wrapper">
                    <div class="nav-title">
                        <h1>Rincian Biaya Perorangan</h1>
                        <p>Data rincian biaya perjalanan dinas per pegawai</p>
                    </div>
                    <div class="nav-links">
                        <a href="<?= BASE_URL ?>/dashboard.php" class="nav-link">
                            <i class="bi bi-house-door"></i>
                            Dashboard
                        </a>
                        <a href="<?= BASE_URL ?>/pegawai/pegawai.php" class="nav-link">
                            <i class="bi bi-people-fill"></i>
                            Pegawai
                        </a>
                        <a href="<?= BASE_URL ?>/absensi/index.php" class="nav-link">
                            <i class="bi bi-calendar-check-fill"></i>
                            Absensi
                        </a>
                        <a href="<?= BASE_URL ?>/pejabat/index.php" class="nav-link">
                            <i class="bi bi-person-badge-fill"></i>
                            Pejabat
                        </a>
                        <a href="<?= BASE_URL ?>/surat_tugas/surat_tugas.php" class="nav-link">
                            <i class="bi bi-file-earmark-text-fill"></i>
                            Surat Tugas
                        </a>
                        <a href="<?= BASE_URL ?>/rincian_biaya_per_pegawai.php" class="nav-link active">
                            <i class="bi bi-person-lines-fill"></i>
                            Rincian Biaya
                        </a>
                        <a href="<?= BASE_URL ?>/rekap_sppd/index.php" class="nav-link">
                            <i class="bi bi-file-text-fill"></i>
                            Rekap SPPD
                        </a>
                        <a href="<?= BASE_URL ?>/laporan/laporan.php" class="nav-link">
                            <i class="bi bi-journal-text"></i>
                            Laporan
                        </a>
                        <a href="<?= BASE_URL ?>/telaah_staf/index.php" class="nav-link">
                            <i class="bi bi-file-text"></i>
                            Telaah Staf
                        </a>
                    </div>
                </div>
            </div>

            <div class="card">
                <div class="card-header">
                    <div class="d-flex justify-content-between align-items-center">
                        <h5 class="card-title mb-0">Daftar Rincian Biaya</h5>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-hover" id="rincianTable">
                            <thead>
                                <tr>
                                    <th>No</th>
                                    <th>Nama Pegawai</th>
                                    <th>NIP</th>
                                    <th>No. SPPD</th>
                                    <th>Jenis Surat</th>
                                    <th>Maksud</th>
                                    <th>Tujuan</th>
                                    <th>Uang Harian/Hari</th>
                                    <th>Total Uang Harian</th>
                                    <th>Representatif/Hari</th>
                                    <th>Total Representatif</th>
                                    <th>Uang Diklat/Hari</th>
                                    <th>Total Uang Diklat</th>
                                    <th>Transport Dalam</th>
                                    <th>Transport Luar</th>
                                    <th>Pesawat Berangkat</th>
                                    <th>Pesawat Pulang</th>
                                    <th>Akomodasi</th>
                                    <th>Jarak</th>
                                    <th>Biaya Jarak</th>
                                    <th>Akomodasi Tanpa Bill</th>
                                    <th>Total Biaya</th>
                                    <th>Tanggal Berangkat</th>
                                    <th>Tanggal Kembali</th>
                                    <th>Waktu Kedatangan</th>
                                    <th>Waktu Kepulangan</th>
                                    <th>Lama Perjalanan</th>
                                    <th>Bidang</th>
                                    <th>Dibuat Oleh</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php 
                                $no = 1;
                                $grand_total = 0;
                                while ($row = mysqli_fetch_assoc($result)): 
                                    $grand_total += $row['total_biaya'];
                                ?>
                                <tr>
                                    <td><?= $no++ ?></td>
                                    <td><?= safeEcho($row['nama_pegawai']) ?></td>
                                    <td><?= safeEcho($row['nip']) ?></td>
                                    <td><?= safeEcho($row['no_sppd']) ?></td>
                                    <td><?= safeEcho($row['jenis_surat']) ?></td>
                                    <td class="text-wrap"><?= safeEcho($row['maksud']) ?></td>
                                    <td><?= safeEcho($row['tujuan']) ?></td>
                                    <td class="text-end"><?= formatRupiah($row['uang_harian_per_hari']) ?></td>
                                    <td class="text-end"><?= formatRupiah($row['total_uang_harian']) ?></td>
                                    <td class="text-end"><?= formatRupiah($row['representatif_per_hari']) ?></td>
                                    <td class="text-end"><?= formatRupiah($row['total_representatif']) ?></td>
                                    <td class="text-end"><?= formatRupiah($row['uang_diklat_per_hari']) ?></td>
                                    <td class="text-end"><?= formatRupiah($row['total_uang_diklat']) ?></td>
                                    <td class="text-end"><?= formatRupiah($row['transport_dalam_provinsi']) ?></td>
                                    <td class="text-end"><?= formatRupiah($row['transport_luar_provinsi']) ?></td>
                                    <td class="text-end"><?= formatRupiah($row['biaya_pesawat_berangkat']) ?></td>
                                    <td class="text-end"><?= formatRupiah($row['biaya_pesawat_pulang']) ?></td>
                                    <td class="text-end"><?= formatRupiah($row['akomodasi']) ?></td>
                                    <td><?= $row['jarak'] ? $row['jarak'] . ' KM' : '-' ?></td>
                                    <td class="text-end"><?= formatRupiah($row['biaya_jarak']) ?></td>
                                    <td class="text-end"><?= formatRupiah($row['akomodasi_tanpa_bill']) ?></td>
                                    <td class="text-end font-weight-bold"><?= formatRupiah($row['total_biaya']) ?></td>
                                    <td><?= $row['tanggal_berangkat_aktual'] ? tanggal_indo($row['tanggal_berangkat_aktual']) : '-' ?></td>
                                    <td><?= $row['tanggal_kembali_aktual'] ? tanggal_indo($row['tanggal_kembali_aktual']) : '-' ?></td>
                                    <td><?= $row['waktu_kedatangan_aktual'] ? date('d/m/Y H:i', strtotime($row['waktu_kedatangan_aktual'])) : '-' ?></td>
                                    <td><?= $row['waktu_kepulangan_aktual'] ? date('d/m/Y H:i', strtotime($row['waktu_kepulangan_aktual'])) : '-' ?></td>
                                    <td><?= $row['lama_perjalanan_aktual'] ?? '-' ?> hari</td>
                                    <td><?= safeEcho($row['bidang_pembuat']) ?></td>
                                    <td>
                                        <div class="creator-info">
                                            <?= safeEcho($row['pembuat']) ?>
                                            <small class="d-block"><?= date('d/m/y', strtotime($row['created_at'])) ?></small>
                                        </div>
                                    </td>
                                </tr>
                                <?php endwhile; ?>
                                <tr class="table-total">
                                    <td colspan="21" class="text-end fw-bold">Total Keseluruhan:</td>
                                    <td class="text-end fw-bold bg-primary text-white"><?= formatRupiah($grand_total) ?></td>
                                    <td colspan="7"></td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="../assets/js/bootstrap.bundle.min.js"></script>
    <script src="../assets/js/jquery-3.6.0.min.js"></script>
    <script src="../assets/js/datatables.min.js"></script>
    <script>
        $(document).ready(function() {
            $('#rincianTable').DataTable({
                "pageLength": 25,
                "order": [[0, "asc"]],
                "language": {
                    "search": "Cari:",
                    "lengthMenu": "Tampilkan _MENU_ data per halaman",
                    "zeroRecords": "Data tidak ditemukan",
                    "info": "Menampilkan halaman _PAGE_ dari _PAGES_",
                    "infoEmpty": "Tidak ada data yang tersedia",
                    "infoFiltered": "(difilter dari _MAX_ total data)",
                    "paginate": {
                        "first": "Pertama",
                        "last": "Terakhir",
                        "next": "Selanjutnya",
                        "previous": "Sebelumnya"
                    }
                }
            });
        });
    </script>
</body>
</html> 