<?php
session_start();
require_once '../config/database.php';

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $id_surat = $_POST['id_surat'] ?? null;
    $no_sub_kegiatan = $_POST['no_sub_kegiatan'] ?? null;
    
    if (!$id_surat || !$no_sub_kegiatan) {
        echo json_encode(['success' => false, 'message' => 'Data tidak lengkap']);
        exit;
    }

    try {
        // Update record di tabel surat_tugas
        $query = "UPDATE surat_tugas SET no_sub_kegiatan = ? WHERE id_surat = ?";
        $stmt = mysqli_prepare($conn, $query);
        mysqli_stmt_bind_param($stmt, "si", $no_sub_kegiatan, $id_surat);
        
        if (mysqli_stmt_execute($stmt)) {
            echo json_encode([
                'success' => true, 
                'message' => 'Nomor Sub Kegiatan berhasil disimpan untuk semua rincian dengan ID Surat yang sama'
            ]);
        } else {
            echo json_encode([
                'success' => false, 
                'message' => 'Gagal menyimpan Nomor Sub Kegiatan'
            ]);
        }
    } catch (Exception $e) {
        echo json_encode([
            'success' => false, 
            'message' => 'Error: ' . $e->getMessage()
        ]);
    }
} else {
    echo json_encode([
        'success' => false, 
        'message' => 'Method tidak diizinkan'
    ]);
}

mysqli_close($conn);
?> 