<?php
session_start();
require_once '../config/database.php';
require_once '../config/config.php';

// Ambil data rincian yang akan diedit
if (isset($_GET['id']) && isset($_GET['surat'])) {
    $id_rincian = $_GET['id'];
    $id_surat = $_GET['surat'];
    
    // Query untuk mengambil data rincian dan jabatan pegawai
    $query_rincian = "SELECT r.*, p.nama_pegawai, p.jabatan, st.jenis_surat, st.tanggal_berangkat, st.tanggal_kembali,
                      DATEDIFF(st.tanggal_kembali, st.tanggal_berangkat) + 1 as lama_perjalanan 
                      FROM rincian_bimtek_perorangan r
                      JOIN pegawai p ON r.id_pegawai = p.id_pegawai
                      JOIN surat_tugas st ON r.id_surat = st.id_surat
                      WHERE r.id_rincian_perorangan = ?";
    
    $stmt = mysqli_prepare($conn, $query_rincian);
    mysqli_stmt_bind_param($stmt, "i", $id_rincian);
    mysqli_stmt_execute($stmt);
    $result = mysqli_stmt_get_result($stmt);
    $rincian = mysqli_fetch_assoc($result);

    // Fungsi untuk mengecek apakah pegawai adalah pejabat tinggi
    function isPejabatTinggi($jabatan) {
        $pejabat_tinggi = ['Kepala Dinas', 'Kepala Badan', 'Bupati', 'Sekretaris Daerah', 'Anggota DPR'];
        return in_array(trim($jabatan), $pejabat_tinggi);
    }

    // Set flag untuk menampilkan field representatif
    $show_representatif = isPejabatTinggi($rincian['jabatan']);
}

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $id_rincian = $_POST['id_rincian'];
    $uang_harian = str_replace('.', '', $_POST['uang_harian']);
    $representatif_per_hari = isset($_POST['representatif_per_hari']) ? str_replace('.', '', $_POST['representatif_per_hari']) : 0;
    $uang_diklat = isset($_POST['uang_diklat']) ? str_replace('.', '', $_POST['uang_diklat']) : 0;
    $transport_dalam_provinsi = isset($_POST['transport_dalam']) ? str_replace('.', '', $_POST['transport_dalam']) : 0;
    $transport_luar_provinsi = isset($_POST['transport_luar']) ? str_replace('.', '', $_POST['transport_luar']) : 0;
    $biaya_pesawat_berangkat = isset($_POST['pesawat_berangkat']) ? str_replace('.', '', $_POST['pesawat_berangkat']) : 0;
    $biaya_pesawat_pulang = isset($_POST['pesawat_kembali']) ? str_replace('.', '', $_POST['pesawat_kembali']) : 0;
    $akomodasi = isset($_POST['akomodasi']) ? str_replace('.', '', $_POST['akomodasi']) : 0;
    $jarak = isset($_POST['jarak']) ? $_POST['jarak'] : 0;
    $biaya_jarak = isset($_POST['biaya_jarak']) ? str_replace('.', '', $_POST['biaya_jarak']) : 0;
    
    // Hitung total
    $total_uang_harian = $uang_harian * $rincian['lama_perjalanan'];
    $total_representatif = $representatif_per_hari * $rincian['lama_perjalanan'];
    $total_uang_diklat = $uang_diklat * $rincian['lama_perjalanan'];
    
    // Hitung total biaya keseluruhan
    $total_biaya = $total_uang_harian + $total_representatif + $total_uang_diklat + 
                   $transport_dalam_provinsi + $transport_luar_provinsi + 
                   $biaya_pesawat_berangkat + $biaya_pesawat_pulang + $akomodasi + $biaya_jarak;
    
    // Update query
    $query = "UPDATE rincian_bimtek_perorangan SET 
              uang_harian_per_hari = ?,
              total_uang_harian = ?,
              representatif_per_hari = ?,
              total_representatif = ?,
              uang_diklat_per_hari = ?,
              total_uang_diklat = ?,
              transport_dalam_provinsi = ?,
              transport_luar_provinsi = ?,
              biaya_pesawat_berangkat = ?,
              biaya_pesawat_pulang = ?,
              akomodasi = ?,
              jarak = ?,
              biaya_jarak = ?,
              total_biaya = ?,
              updated_at = CURRENT_TIMESTAMP
              WHERE id_rincian_perorangan = ?";
              
    $stmt = mysqli_prepare($conn, $query);
    mysqli_stmt_bind_param($stmt, "dddddddddddiddi", 
        $uang_harian,
        $total_uang_harian,
        $representatif_per_hari,
        $total_representatif,
        $uang_diklat,
        $total_uang_diklat,
        $transport_dalam_provinsi,
        $transport_luar_provinsi,
        $biaya_pesawat_berangkat,
        $biaya_pesawat_pulang,
        $akomodasi,
        $jarak,
        $biaya_jarak,
        $total_biaya,
        $id_rincian
    );

    if (mysqli_stmt_execute($stmt)) {
        $_SESSION['alert'] = [
            'type' => 'success',
            'message' => 'Data rincian berhasil diperbarui'
        ];
        header("Location: detail_rincian.php?id=" . $id_surat);
        exit();
    } else {
        $_SESSION['alert'] = [
            'type' => 'error',
            'message' => 'Gagal memperbarui data: ' . mysqli_error($conn)
        ];
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Edit Rincian Perorangan - SPPD</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css" rel="stylesheet">
    <style>
        body {
            background: linear-gradient(135deg, #f6f9fc 0%, #eef2f7 100%);
            min-height: 100vh;
            padding-bottom: 40px;
        }

        .header-wrapper {
            background: linear-gradient(135deg, #4e73df 0%, #224abe 100%);
            padding: 2rem;
            margin-bottom: 2rem;
            color: white;
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.1);
        }

        .card {
            border: none;
            border-radius: 15px;
            box-shadow: 0 0 20px rgba(0, 0, 0, 0.05);
            background: rgba(255, 255, 255, 0.9);
            backdrop-filter: blur(10px);
            transition: transform 0.3s ease, box-shadow 0.3s ease;
        }

        .card:hover {
            transform: translateY(-5px);
            box-shadow: 0 8px 25px rgba(0, 0, 0, 0.1);
        }

        .card-header {
            background: transparent;
            border-bottom: 1px solid rgba(0, 0, 0, 0.05);
            padding: 1.5rem;
        }

        .card-header h5 {
            margin: 0;
            color: #4e73df;
            font-weight: 600;
        }

        .form-label {
            font-weight: 500;
            color: #4a5568;
            margin-bottom: 0.5rem;
        }

        .form-control, .input-group-text {
            border: 1px solid #e2e8f0;
            border-radius: 10px;
            padding: 0.75rem 1rem;
            font-size: 0.95rem;
            transition: all 0.2s ease;
        }

        .form-control:focus {
            border-color: #4e73df;
            box-shadow: 0 0 0 3px rgba(78, 115, 223, 0.1);
        }

        .input-group-text {
            background: #f8fafc;
            color: #4a5568;
        }

        .btn {
            padding: 0.75rem 1.5rem;
            border-radius: 10px;
            font-weight: 500;
            transition: all 0.3s ease;
        }

        .btn-primary {
            background: linear-gradient(135deg, #4e73df 0%, #224abe 100%);
            border: none;
        }

        .btn-primary:hover {
            background: linear-gradient(135deg, #224abe 0%, #1a3891 100%);
            transform: translateY(-2px);
        }

        .btn-secondary {
            background: #f8fafc;
            border: 1px solid #e2e8f0;
            color: #4a5568;
        }

        .btn-secondary:hover {
            background: #edf2f7;
            transform: translateY(-2px);
        }

        .alert {
            border-radius: 10px;
            border: none;
        }

        .breadcrumb {
            margin: 0;
            background: transparent;
        }

        .breadcrumb-item a {
            color: rgba(255, 255, 255, 0.8);
            text-decoration: none;
            transition: color 0.2s ease;
        }

        .breadcrumb-item a:hover {
            color: white;
        }

        .breadcrumb-item.active {
            color: white;
        }

        .info-group {
            background: #f8fafc;
            border-radius: 10px;
            padding: 1rem;
            margin-bottom: 1rem;
        }

        .info-group label {
            color: #718096;
            font-size: 0.875rem;
            margin-bottom: 0.25rem;
        }

        .info-group p {
            color: #2d3748;
            font-weight: 500;
            margin-bottom: 0;
        }
    </style>
</head>
<body>
    <div class="header-wrapper">
        <h2 class="mb-0">Edit Rincian Perorangan</h2>
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb mb-0">
                <li class="breadcrumb-item"><a href="../dashboard.php">Dashboard</a></li>
                <li class="breadcrumb-item"><a href="index.php">Rincian Biaya</a></li>
                <li class="breadcrumb-item"><a href="detail_rincian.php?id=<?= $id_surat ?>">Detail Rincian</a></li>
                <li class="breadcrumb-item active" aria-current="page">Edit Rincian</li>
            </ol>
        </nav>
    </div>

    <div class="container">
        <?php if (isset($rincian)): ?>
            <div class="row">
                <div class="col-md-4 mb-4">
                    <!-- Info Card -->
                    <div class="card">
                        <div class="card-header">
                            <h5><i class="bi bi-info-circle me-2"></i>Informasi</h5>
                        </div>
                        <div class="card-body">
                            <div class="info-group">
                                <label>Nama Pegawai</label>
                                <p><?= htmlspecialchars($rincian['nama_pegawai']) ?></p>
                            </div>
                            <div class="info-group">
                                <label>Jenis Surat</label>
                                <p><?= htmlspecialchars($rincian['jenis_surat']) ?></p>
                            </div>
                            <div class="info-group">
                                <label>Tanggal Berangkat</label>
                                <p><?= date('d/m/Y', strtotime($rincian['tanggal_berangkat'])) ?></p>
                            </div>
                            <div class="info-group">
                                <label>Tanggal Kembali</label>
                                <p><?= date('d/m/Y', strtotime($rincian['tanggal_kembali'])) ?></p>
                            </div>
                            <div class="info-group">
                                <label>Lama Perjalanan</label>
                                <p><?= $rincian['lama_perjalanan'] ?> Hari</p>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-md-8">
                    <!-- Form Card -->
                    <div class="card">
                        <div class="card-header">
                            <h5><i class="bi bi-pencil-square me-2"></i>Form Edit Rincian</h5>
                        </div>
                        <div class="card-body">
                            <form id="formEditRincian" method="POST">
                                <input type="hidden" name="id_rincian" value="<?= $id_rincian ?>">
                                
                                <?php if ($rincian['jenis_surat'] == 'Dalam Daerah Dalam Provinsi'): ?>
                                    <!-- Grup Uang Harian/Hari/Hari -->
                                    <div class="card mb-4">
                                        <div class="card-header bg-light">
                                            <h6 class="mb-0">Uang Harian/Hari/Hari</h6>
                                        </div>
                                        <div class="card-body">
                                            <div class="mb-4">
                                                <label class="form-label">Uang Harian/Hari/Hari</label>
                                                <div class="input-group">
                                                    <span class="input-group-text">Rp</span>
                                                    <input type="text" class="form-control money" name="uang_harian" id="uang_harian"
                                                           value="<?= number_format($rincian['uang_harian_per_hari'], 0, ',', '.') ?>" 
                                                           onkeyup="hitungTotalUangHarian()" required>
                                                </div>
                                                <div class="mt-2">
                                                    <small class="text-muted">Dihitung berdasarkan lama perjalanan: <?= $rincian['lama_perjalanan'] ?> hari</small>
                                                    <div id="perhitungan_uang_harian" class="alert alert-info mt-2">
                                                        Perhitungan: <span id="rincian_uang_harian"></span>
                                                        <br>
                                                        Total: <strong><span id="total_uang_harian"></span></strong>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Grup Transport & Jarak -->
                                    <div class="card mb-4">
                                        <div class="card-header bg-light">
                                            <h6 class="mb-0">Transport & Jarak</h6>
                                        </div>
                                        <div class="card-body">
                                            <div class="row g-3">
                                                <div class="col-md-6">
                                                    <label class="form-label">Transport</label>
                                                    <div class="input-group">
                                                        <span class="input-group-text">Rp</span>
                                                        <input type="text" class="form-control money" name="transport_dalam" 
                                                               value="<?= number_format($rincian['transport_dalam_provinsi'], 0, ',', '.') ?>" required>
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <label class="form-label">Jarak (KM)</label>
                                                    <input type="number" class="form-control" id="jarak" name="jarak" 
                                                           value="<?= $rincian['jarak'] ?>" onchange="hitungBiayaJarak()">
                                                    <small class="text-muted">Biaya per kilometer: Rp 5.000</small>
                                                </div>
                                                <div class="col-12">
                                                    <label class="form-label">Biaya Jarak</label>
                                                    <div class="input-group">
                                                        <span class="input-group-text">Rp</span>
                                                        <input type="text" class="form-control money" id="biaya_jarak" name="biaya_jarak" 
                                                               value="<?= number_format($rincian['biaya_jarak'], 0, ',', '.') ?>" readonly>
                                                    </div>
                                                    <div id="perhitungan_jarak" class="alert alert-info mt-2" style="display:none;">
                                                        Perhitungan: <span id="rincian_jarak"></span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                <?php elseif ($rincian['jenis_surat'] == 'Luar Daerah Dalam Provinsi'): ?>
                                    <!-- Grup Uang Harian/Hari -->
                                    <div class="card mb-4">
                                        <div class="card-header bg-light">
                                            <h6 class="mb-0">Uang Harian/Hari</h6>
                                        </div>
                                        <div class="card-body">
                                            <div class="mb-4">
                                                <label class="form-label">Uang Harian/Hari</label>
                                                <div class="input-group">
                                                    <span class="input-group-text">Rp</span>
                                                    <input type="text" class="form-control money" name="uang_harian" id="uang_harian"
                                                           value="<?= number_format($rincian['uang_harian_per_hari'], 0, ',', '.') ?>" 
                                                           onkeyup="hitungTotalUangHarian()" required>
                                                </div>
                                                <div class="mt-2">
                                                    <small class="text-muted">Dihitung berdasarkan lama perjalanan: <?= $rincian['lama_perjalanan'] ?> hari</small>
                                                    <div id="perhitungan_uang_harian" class="alert alert-info mt-2">
                                                        Perhitungan: <span id="rincian_uang_harian"></span>
                                                        <br>
                                                        Total: <strong><span id="total_uang_harian"></span></strong>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <?php if ($show_representatif): ?>
                                    <!-- Grup Representatif -->
                                    <div class="card mb-4">
                                        <div class="card-header bg-light">
                                            <h6 class="mb-0">Uang Representatif</h6>
                                        </div>
                                        <div class="card-body">
                                            <div class="mb-4">
                                                                                                <label class="form-label">Representatif per Hari</label>                                                <div class="input-group">                                                    <span class="input-group-text">Rp</span>                                                    <input type="text" class="form-control money" name="representatif_per_hari" id="representatif_per_hari"                                                           value="<?= number_format($rincian['representatif_per_hari'], 0, ',', '.') ?>"                                                            onkeyup="hitungTotalRepresentatif()" required>                                                </div>                                                <div class="mt-2">                                                    <small class="text-muted">Dihitung berdasarkan lama perjalanan: <?= $rincian['lama_perjalanan'] ?> hari</small>                                                    <div id="perhitungan_representatif" class="alert alert-info mt-2">                                                        Perhitungan: <span id="rincian_representatif"></span>                                                        <br>                                                        Total: <strong><span id="total_representatif"></span></strong>                                                    </div>                                                </div>                                                <input type="hidden" name="total_representatif" id="total_representatif_input"                                                        value="<?= $rincian['total_representatif'] ?>">
                                            </div>
                                        </div>
                                    </div>
                                    <?php endif; ?>

                                    <!-- Grup Transport & Akomodasi -->
                                    <div class="card mb-4">
                                        <div class="card-header bg-light">
                                            <h6 class="mb-0">Transport & Akomodasi</h6>
                                        </div>
                                        <div class="card-body">
                                            <div class="row g-3">
                                                <div class="col-md-6">
                                                    <label class="form-label">Transport</label>
                                                    <div class="input-group">
                                                        <span class="input-group-text">Rp</span>
                                                        <input type="text" class="form-control money" name="transport_dalam" 
                                                               value="<?= number_format($rincian['transport_dalam_provinsi'], 0, ',', '.') ?>" required>
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <label class="form-label">Akomodasi Hotel</label>
                                                    <div class="input-group">
                                                        <span class="input-group-text">Rp</span>
                                                        <input type="text" class="form-control money" name="akomodasi" 
                                                               value="<?= number_format($rincian['akomodasi'], 0, ',', '.') ?>" required>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                <?php else: // Luar Daerah Luar Provinsi ?>
                                    <!-- Grup Uang Harian/Hari -->
                                    <div class="card mb-4">
                                        <div class="card-header bg-light">
                                            <h6 class="mb-0">Uang Harian/Hari</h6>
                                        </div>
                                        <div class="card-body">
                                            <div class="mb-4">
                                                <label class="form-label">Uang Harian/Hari</label>
                                                <div class="input-group">
                                                    <span class="input-group-text">Rp</span>
                                                    <input type="text" class="form-control money" name="uang_harian" id="uang_harian"
                                                           value="<?= number_format($rincian['uang_harian_per_hari'], 0, ',', '.') ?>" 
                                                           onkeyup="hitungTotalUangHarian()" required>
                                                </div>
                                                <div class="mt-2">
                                                    <small class="text-muted">Dihitung berdasarkan lama perjalanan: <?= $rincian['lama_perjalanan'] ?> hari</small>
                                                    <div id="perhitungan_uang_harian" class="alert alert-info mt-2">
                                                        Perhitungan: <span id="rincian_uang_harian"></span>
                                                        <br>
                                                        Total: <strong><span id="total_uang_harian"></span></strong>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <?php if ($show_representatif): ?>
                                    <!-- Grup Representatif -->
                                    <div class="card mb-4">
                                        <div class="card-header bg-light">
                                            <h6 class="mb-0">Uang Representatif</h6>
                                        </div>
                                        <div class="card-body">
                                            <div class="mb-4">
                                                <label class="form-label">Representatif per Hari</label>
                                                <div class="input-group">
                                                    <span class="input-group-text">Rp</span>
                                                    <input type="text" class="form-control money" name="representatif_per_hari" id="representatif_per_hari"
                                                           value="<?= number_format($rincian['representatif_per_hari'], 0, ',', '.') ?>" 
                                                           onkeyup="hitungTotalRepresentatif()" required>
                                                </div>
                                                <div class="mt-2">
                                                    <small class="text-muted">Dihitung berdasarkan lama perjalanan: <?= $rincian['lama_perjalanan'] ?> hari</small>
                                                    <div id="perhitungan_representatif" class="alert alert-info mt-2">
                                                        Perhitungan: <span id="rincian_representatif"></span>
                                                        <br>
                                                        Total: <strong><span id="total_representatif"></span></strong>
                                                    </div>
                                                </div>
                                                <input type="hidden" name="total_representatif" id="total_representatif_input" 
                                                       value="<?= $rincian['total_representatif'] ?>">
                                            </div>
                                        </div>
                                    </div>
                                    <?php endif; ?>

                                    <!-- Grup Transport -->
                                    <div class="card mb-4">
                                        <div class="card-header bg-light">
                                            <h6 class="mb-0">Transport</h6>
                                        </div>
                                        <div class="card-body">
                                            <div class="row g-3">
                                                <div class="col-md-6">
                                                    <label class="form-label">Transport Dalam Provinsi</label>
                                                    <div class="input-group">
                                                        <span class="input-group-text">Rp</span>
                                                        <input type="text" class="form-control money" name="transport_dalam" 
                                                               value="<?= number_format($rincian['transport_dalam_provinsi'], 0, ',', '.') ?>" required>
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <label class="form-label">Transport Luar Provinsi</label>
                                                    <div class="input-group">
                                                        <span class="input-group-text">Rp</span>
                                                        <input type="text" class="form-control money" name="transport_luar" 
                                                               value="<?= number_format($rincian['transport_luar_provinsi'], 0, ',', '.') ?>" required>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Grup Pesawat -->
                                    <div class="card mb-4">
                                        <div class="card-header bg-light">
                                            <h6 class="mb-0">Biaya Pesawat</h6>
                                        </div>
                                        <div class="card-body">
                                            <div class="row g-3">
                                                <div class="col-md-6">
                                                    <label class="form-label">Pesawat Berangkat</label>
                                                    <div class="input-group">
                                                        <span class="input-group-text">Rp</span>
                                                        <input type="text" class="form-control money" name="pesawat_berangkat" 
                                                               value="<?= number_format($rincian['biaya_pesawat_berangkat'], 0, ',', '.') ?>" required>
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <label class="form-label">Pesawat Kembali</label>
                                                    <div class="input-group">
                                                        <span class="input-group-text">Rp</span>
                                                        <input type="text" class="form-control money" name="pesawat_kembali" 
                                                               value="<?= number_format($rincian['biaya_pesawat_pulang'], 0, ',', '.') ?>" required>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Grup Akomodasi -->
                                    <div class="card mb-4">
                                        <div class="card-header bg-light">
                                            <h6 class="mb-0">Akomodasi</h6>
                                        </div>
                                        <div class="card-body">
                                            <div class="mb-4">
                                                <label class="form-label">Akomodasi Hotel</label>
                                                <div class="input-group">
                                                    <span class="input-group-text">Rp</span>
                                                    <input type="text" class="form-control money" name="akomodasi" 
                                                           value="<?= number_format($rincian['akomodasi'], 0, ',', '.') ?>" required>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                <?php endif; ?>

                                <!-- Buttons -->
                                <div class="d-flex justify-content-end gap-2 mt-4">
                                    <a href="detail_rincian.php?id=<?= $id_surat ?>" class="btn btn-secondary">
                                        <i class="bi bi-arrow-left me-2"></i>Kembali
                                    </a>
                                    <button type="submit" class="btn btn-primary">
                                        <i class="bi bi-save me-2"></i>Simpan Perubahan
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        <?php else: ?>
            <div class="alert alert-danger">
                <i class="bi bi-exclamation-triangle me-2"></i>Data rincian tidak ditemukan.
            </div>
        <?php endif; ?>
    </div>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script>
    // Format input uang
    $('.money').on('input', function() {
        let value = $(this).val().replace(/[^\d]/g, '');
        $(this).val(new Intl.NumberFormat('id-ID').format(value));
    });

    // Fungsi format rupiah
    function formatRupiah(angka) {
        if (!angka) return '0';
        return new Intl.NumberFormat('id-ID').format(angka);
    }

    // Fungsi untuk menghitung total uang harian
    function hitungTotalUangHarian() {
        let perHari = parseInt($('#uang_harian').val().replace(/[^\d]/g, '') || 0);
        let lamaPerjalanan = <?= $rincian['lama_perjalanan'] ?>;
        let total = perHari * lamaPerjalanan;
        
        // Tampilkan perhitungan
        $('#rincian_uang_harian').html(formatRupiah(perHari) + ' × ' + lamaPerjalanan + ' hari');
        $('#total_uang_harian').html('Rp ' + formatRupiah(total));
    }

    // Fungsi untuk menghitung total representatif
    function hitungTotalRepresentatif() {
        let perHari = parseInt($('#representatif_per_hari').val().replace(/[^\d]/g, '') || 0);
        let lamaPerjalanan = <?= $rincian['lama_perjalanan'] ?>;
        let total = perHari * lamaPerjalanan;
        
        // Tampilkan perhitungan
        $('#rincian_representatif').html(formatRupiah(perHari) + ' × ' + lamaPerjalanan + ' hari');
        $('#total_representatif').html('Rp ' + formatRupiah(total));
        
        // Set nilai total ke hidden input
        $('#total_representatif_input').val(total);
    }

    // Initialize on page load
    $(document).ready(function() {
        hitungTotalUangHarian();
        hitungTotalRepresentatif();
    });

    // Fungsi untuk menghitung biaya jarak
    function hitungBiayaJarak() {
        const jarak = parseInt($('#jarak').val() || 0);
        const biayaPerKm = 5000; // Rp 5.000 per kilometer
        const totalBiaya = jarak * biayaPerKm;
        
        // Update input biaya jarak
        $('#biaya_jarak').val(new Intl.NumberFormat('id-ID').format(totalBiaya));
        
        // Tampilkan perhitungan
        $('#perhitungan_jarak').show();
        $('#rincian_jarak').html(
            jarak + ' KM × Rp ' + new Intl.NumberFormat('id-ID').format(biayaPerKm) + 
            ' = Rp ' + new Intl.NumberFormat('id-ID').format(totalBiaya)
        );
    }
    </script>
</body>
</html>