<?php
session_start();
require_once '../config/database.php';
require_once '../config/config.php';

header('Content-Type: application/json');

try {
    // Debug: Log received data
    error_log("Received POST data: " . print_r($_POST, true));
    
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        throw new Exception('Invalid request method');
    }

    // Get the document type first
    $query = "SELECT st.jenis_surat 
              FROM rincian_bimtek_perorangan r
              JOIN surat_tugas st ON r.id_surat = st.id_surat
              WHERE r.id_rincian_perorangan = ?";
    
    $stmt = mysqli_prepare($conn, $query);
    mysqli_stmt_bind_param($stmt, "i", $_POST['id_rincian']);
    mysqli_stmt_execute($stmt);
    $result = mysqli_stmt_get_result($stmt);
    $surat_data = mysqli_fetch_assoc($result);

    if (!$surat_data) {
        throw new Exception('Data surat tidak ditemukan');
    }

    // Validate required fields based on document type
    $required_fields = ['id_rincian', 'uang_harian', 'transport_dalam'];
    
    // Add additional required fields based on document type
    if ($surat_data['jenis_surat'] != 'Dalam Daerah Dalam Provinsi') {
        $required_fields[] = 'akomodasi';
    }

    foreach ($required_fields as $field) {
        if (!isset($_POST[$field]) || $_POST[$field] === '') {
            throw new Exception("Field {$field} is required");
        }
    }

    // Get form data
    $id_rincian = $_POST['id_rincian'];
    $uang_harian = (int)$_POST['uang_harian'];
    $transport_dalam = (int)$_POST['transport_dalam'];
    $transport_luar = (int)($_POST['transport_luar'] ?? 0);
    $pesawat_berangkat = (int)($_POST['pesawat_berangkat'] ?? 0);
    $pesawat_kembali = (int)($_POST['pesawat_kembali'] ?? 0);
    $akomodasi = (int)($_POST['akomodasi'] ?? 0);
    $representatif = (int)($_POST['representatif'] ?? 0);
    $jarak = (int)($_POST['jarak'] ?? 0);
    $biaya_jarak = (int)($_POST['biaya_jarak'] ?? 0);

    // Get existing data to calculate total
    $query = "SELECT st.tanggal_berangkat, st.tanggal_kembali 
              FROM rincian_bimtek_perorangan r
              JOIN surat_tugas st ON r.id_surat = st.id_surat
              WHERE r.id_rincian_perorangan = ?";
    
    $stmt = mysqli_prepare($conn, $query);
    mysqli_stmt_bind_param($stmt, "i", $id_rincian);
    mysqli_stmt_execute($stmt);
    $result = mysqli_stmt_get_result($stmt);
    $data = mysqli_fetch_assoc($result);

    if (!$data) {
        throw new Exception('Data not found');
    }

    // Calculate total days
    $date1 = new DateTime($data['tanggal_berangkat']);
    $date2 = new DateTime($data['tanggal_kembali']);
    $total_hari = $date2->diff($date1)->days + 1;

    // Calculate totals
    $total_uang_harian = $uang_harian * $total_hari;
    $total_biaya = $total_uang_harian + $transport_dalam + $transport_luar + 
                   $pesawat_berangkat + $pesawat_kembali + $akomodasi + 
                   $representatif + $biaya_jarak;

    // Begin transaction
    mysqli_begin_transaction($conn);

    // Update the database
    $update_query = "UPDATE rincian_bimtek_perorangan SET 
                    uang_harian_per_hari = ?,
                    total_uang_harian = ?,
                    transport_dalam_provinsi = ?,
                    transport_luar_provinsi = ?,
                    biaya_pesawat_berangkat = ?,
                    biaya_pesawat_pulang = ?,
                    akomodasi = ?,
                    representatif = ?,
                    jarak = ?,
                    biaya_jarak = ?,
                    total_biaya = ?
                    WHERE id_rincian_perorangan = ?";

    $stmt = mysqli_prepare($conn, $update_query);
    mysqli_stmt_bind_param($stmt, "iiiiiiiiiiii", 
        $uang_harian,
        $total_uang_harian,
        $transport_dalam,
        $transport_luar,
        $pesawat_berangkat,
        $pesawat_kembali,
        $akomodasi,
        $representatif,
        $jarak,
        $biaya_jarak,
        $total_biaya,
        $id_rincian
    );

    if (!mysqli_stmt_execute($stmt)) {
        throw new Exception(mysqli_error($conn));
    }

    // Commit transaction
    mysqli_commit($conn);

    echo json_encode([
        'success' => true,
        'message' => 'Data berhasil diperbarui'
    ]);

} catch (Exception $e) {
    // Rollback transaction if error occurs
    if (isset($conn) && mysqli_ping($conn)) {
        mysqli_rollback($conn);
    }

    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
}
?> 