<?php
session_start();
require_once '../config/config.php';
require_once '../config/koneksi.php';
require '../vendor/autoload.php';

use PhpOffice\PhpSpreadsheet\IOFactory;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

// Ambil parameter
$id_surat = isset($_GET['id']) ? $_GET['id'] : die('ID Surat tidak ditemukan');
$tipe = isset($_GET['tipe']) ? $_GET['tipe'] : 'lengkap';

try {
    // Tentukan path template
    $template_path = __DIR__ . '/templates/sppd_belakang_' . $tipe . '.xlsx';
    
    // Periksa apakah file template ada
    if (!file_exists($template_path)) {
        die('Template file tidak ditemukan di: ' . $template_path);
    }

    // Load template Excel
    $spreadsheet = IOFactory::load($template_path);
    $sheet = $spreadsheet->getActiveSheet();

    if ($tipe === 'lengkap') {
        // Query untuk mengambil data
        $query = "SELECT 
                    st.*,
                    p.nama_pegawai,
                    p.nip,
                    p.jabatan,
                    p.golongan
                  FROM surat_tugas st
                  LEFT JOIN detail_surat_tugas dst ON st.id_surat = dst.id_surat
                  LEFT JOIN pegawai p ON dst.id_pegawai = p.id_pegawai
                  WHERE st.id_surat = ?
                  LIMIT 1";

        $stmt = mysqli_prepare($conn, $query);
        mysqli_stmt_bind_param($stmt, "s", $id_surat);
        mysqli_stmt_execute($stmt);
        $result = mysqli_stmt_get_result($stmt);
        $data = mysqli_fetch_assoc($result);

        if ($data) {
            // Isi data sesuai dengan koordinat sel yang benar
            // I. Berangkat dari
            $sheet->setCellValue('I2', ' ' . $data['asal_berangkat']);
            
            // Ke
            $sheet->setCellValue('I4', ' ' . $data['tujuan']);
            $sheet->setCellValue('E16', ' ' . $data['tujuan']);
            $sheet->setCellValue('I16', ' ' . $data['tujuan']);
            $sheet->setCellValue('I17', ' ' . $data['asal_berangkat']);
            $sheet->setCellValue('E36', ' ' . $data['asal_berangkat']);
            // Pada tangga
            $tanggal_berangkat = date('d F Y', strtotime($data['tanggal_berangkat']));
            $sheet->setCellValue('I6', ' ' . $tanggal_berangkat);
            $tanggal_berangkat = date('d F Y', strtotime($data['tanggal_berangkat']));
            $sheet->setCellValue('E17', ' ' . $tanggal_berangkat);
            $tanggal_kembali = date('d F Y', strtotime($data['tanggal_kembali']));
            $sheet->setCellValue('I18', ' ' . $tanggal_kembali);
            $tanggal_kembali = date('d F Y', strtotime($data['tanggal_kembali']));
            $sheet->setCellValue('E37', ' ' . $tanggal_kembali);
            // Data lainnya sesuai kebutuhan
            // ...
        }
    }

    // Header untuk download
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header('Content-Disposition: attachment; filename="SPPD_Belakang_' . $tipe . '_' . date('Y-m-d_H-i-s') . '.xlsx"');
    header('Cache-Control: max-age=0');

    // Bersihkan output buffer
    ob_end_clean();

    // Simpan ke output
    $writer = new Xlsx($spreadsheet);
    $writer->save('php://output');
    exit;

} catch (Exception $e) {
    die('Terjadi kesalahan: ' . $e->getMessage());
}
?> 